"use strict";
(self["webpackChunk_datalayer_jupyter_rtc"] = self["webpackChunk_datalayer_jupyter_rtc"] || []).push([["vendors-node_modules_primer_react_lib-esm_TreeView_TreeView_js"],{

/***/ "../../../node_modules/@primer/react/lib-esm/TreeView/TreeView.js":
/*!************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/TreeView/TreeView.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TreeView": () => (/* binding */ TreeView)
/* harmony export */ });
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @primer/octicons-react */ "webpack/sharing/consume/default/@primer/octicons-react/@primer/octicons-react?1c16");
/* harmony import */ var _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! classnames */ "../../../node_modules/classnames/index.js");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! styled-components */ "webpack/sharing/consume/default/styled-components/styled-components");
/* harmony import */ var styled_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../constants.js */ "../../../node_modules/@primer/react/lib-esm/constants.js");
/* harmony import */ var _Dialog_ConfirmationDialog_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../Dialog/ConfirmationDialog.js */ "../../../node_modules/@primer/react/lib-esm/Dialog/ConfirmationDialog.js");
/* harmony import */ var _hooks_useControllableState_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../hooks/useControllableState.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useControllableState.js");
/* harmony import */ var _hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../hooks/useSafeTimeout.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js");
/* harmony import */ var _hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../hooks/useId.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useId.js");
/* harmony import */ var _Spinner_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../Spinner.js */ "../../../node_modules/@primer/react/lib-esm/Spinner.js");
/* harmony import */ var _sx_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../sx.js */ "../../../node_modules/@primer/react/lib-esm/sx.js");
/* harmony import */ var _Text_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../Text.js */ "../../../node_modules/@primer/react/lib-esm/Text.js");
/* harmony import */ var _utils_create_slots_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/create-slots.js */ "../../../node_modules/@primer/react/lib-esm/utils/create-slots.js");
/* harmony import */ var _VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../_VisuallyHidden.js */ "../../../node_modules/@primer/react/lib-esm/_VisuallyHidden.js");
/* harmony import */ var _shared_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./shared.js */ "../../../node_modules/@primer/react/lib-esm/TreeView/shared.js");
/* harmony import */ var _useRovingTabIndex_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./useRovingTabIndex.js */ "../../../node_modules/@primer/react/lib-esm/TreeView/useRovingTabIndex.js");
/* harmony import */ var _useTypeahead_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./useTypeahead.js */ "../../../node_modules/@primer/react/lib-esm/TreeView/useTypeahead.js");


















// ----------------------------------------------------------------------------
// Context

const RootContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createContext({
  announceUpdate: () => {},
  expandedStateCache: {
    current: new Map()
  }
});
const ItemContext = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createContext({
  itemId: '',
  level: 1,
  isSubTreeEmpty: false,
  setIsSubTreeEmpty: () => {},
  isExpanded: false,
  setIsExpanded: () => {},
  leadingVisualId: '',
  trailingVisualId: ''
});

// ----------------------------------------------------------------------------
// TreeView

const UlBox = styled_components__WEBPACK_IMPORTED_MODULE_3___default().ul.withConfig({
  displayName: "TreeView__UlBox",
  componentId: "sc-4ex6b6-0"
})(["list-style:none;padding:0;margin:0;.PRIVATE_TreeView-item{outline:none;&:focus-visible > div,&.focus-visible > div{box-shadow:inset 0 0 0 2px ", ";@media (forced-colors:active){outline:2px solid HighlightText;outline-offset:-2;}}}.PRIVATE_TreeView-item-container{--level:1;--toggle-width:1rem;position:relative;display:grid;grid-template-columns:calc(calc(var(--level) - 1) * (var(--toggle-width) / 2)) var(--toggle-width) 1fr;grid-template-areas:'spacer toggle content';width:100%;min-height:2rem;font-size:", ";color:", ";border-radius:", ";cursor:pointer;&:hover{background-color:", ";@media (forced-colors:active){outline:2px solid transparent;outline-offset:-2px;}}@media (pointer:coarse){--toggle-width:1.5rem;min-height:2.75rem;}&:has(.PRIVATE_TreeView-item-skeleton):hover{background-color:transparent;cursor:default;@media (forced-colors:active){outline:none;}}}.PRIVATE_TreeView-item[aria-current='true'] > .PRIVATE_TreeView-item-container{background-color:", ";&::after{content:'';position:absolute;top:calc(50% - 0.75rem);left:-", ";width:0.25rem;height:1.5rem;background-color:", ";border-radius:", ";@media (forced-colors:active){background-color:HighlightText;}}}.PRIVATE_TreeView-item-toggle{grid-area:toggle;display:flex;align-items:center;justify-content:center;height:100%;color:", ";}.PRIVATE_TreeView-item-toggle--hover:hover{background-color:", ";}.PRIVATE_TreeView-item-toggle--end{border-top-left-radius:", ";border-bottom-left-radius:", ";}.PRIVATE_TreeView-item-content{grid-area:content;display:flex;align-items:center;height:100%;padding:0 ", ";gap:", ";}.PRIVATE_TreeView-item-content-text{flex:1 1 auto;width:0;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;}.PRIVATE_TreeView-item-visual{display:flex;color:", ";}.PRIVATE_TreeView-item-level-line{width:100%;height:100%;border-right:1px solid;border-color:", ";}@media (hover:hover){.PRIVATE_TreeView-item-level-line{border-color:transparent;}&:hover .PRIVATE_TreeView-item-level-line,&:focus-within .PRIVATE_TreeView-item-level-line{border-color:", ";}}.PRIVATE_TreeView-directory-icon{display:grid;color:", ";}.PRIVATE_VisuallyHidden{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0,0,0,0);white-space:nowrap;border-width:0;}", ""], (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)(`colors.accent.fg`), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('fontSizes.1'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.default'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.actionListItem.default.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.actionListItem.default.selectedBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.accent.fg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.treeViewItem.chevron.hoverBg'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('radii.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('space.2'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.fg.muted'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.border.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.treeViewItem.directory.fill'), _sx_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
const Root = ({
  'aria-label': ariaLabel,
  'aria-labelledby': ariaLabelledby,
  children
}) => {
  const containerRef = react__WEBPACK_IMPORTED_MODULE_2___default().useRef(null);
  const [ariaLiveMessage, setAriaLiveMessage] = react__WEBPACK_IMPORTED_MODULE_2___default().useState('');
  const announceUpdate = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(message => {
    setAriaLiveMessage(message);
  }, []);
  (0,_useRovingTabIndex_js__WEBPACK_IMPORTED_MODULE_6__.useRovingTabIndex)({
    containerRef
  });
  (0,_useTypeahead_js__WEBPACK_IMPORTED_MODULE_7__.useTypeahead)({
    containerRef,
    onFocusChange: element => {
      if (element instanceof HTMLElement) {
        element.focus();
      }
    }
  });
  const expandedStateCache = react__WEBPACK_IMPORTED_MODULE_2___default().useRef(null);
  if (expandedStateCache.current === null) {
    expandedStateCache.current = new Map();
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(RootContext.Provider, {
    value: {
      announceUpdate,
      expandedStateCache
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_VisuallyHidden_js__WEBPACK_IMPORTED_MODULE_8__["default"], {
    role: "status",
    "aria-live": "polite",
    "aria-atomic": "true"
  }, ariaLiveMessage), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(UlBox, {
    ref: containerRef,
    role: "tree",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby
  }, children)));
};
Root.displayName = "Root";
Root.displayName = 'TreeView';

// ----------------------------------------------------------------------------
// TreeView.Item

const {
  Slots,
  Slot
} = (0,_utils_create_slots_js__WEBPACK_IMPORTED_MODULE_9__["default"])(['LeadingVisual', 'TrailingVisual']);
const Item = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef(({
  id: itemId,
  containIntrinsicSize,
  current: isCurrentItem = false,
  defaultExpanded,
  expanded,
  onExpandedChange,
  onSelect,
  children
}, ref) => {
  const {
    expandedStateCache
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(RootContext);
  const labelId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)();
  const leadingVisualId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)();
  const trailingVisualId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)();
  const [isExpanded, setIsExpanded] = (0,_hooks_useControllableState_js__WEBPACK_IMPORTED_MODULE_11__.useControllableState)({
    name: itemId,
    // If the item was previously mounted, it's expanded state might be cached.
    // We check the cache first, and then fall back to the defaultExpanded prop.
    // If defaultExpanded is not provided, we default to false unless the item
    // is the current item, in which case we default to true.
    defaultValue: () => {
      var _ref, _expandedStateCache$c, _expandedStateCache$c2;
      return (_ref = (_expandedStateCache$c = (_expandedStateCache$c2 = expandedStateCache.current) === null || _expandedStateCache$c2 === void 0 ? void 0 : _expandedStateCache$c2.get(itemId)) !== null && _expandedStateCache$c !== void 0 ? _expandedStateCache$c : defaultExpanded) !== null && _ref !== void 0 ? _ref : isCurrentItem;
    },
    value: expanded,
    onChange: onExpandedChange
  });
  const {
    level
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  const {
    hasSubTree,
    subTree,
    childrenWithoutSubTree
  } = useSubTree(children);
  const [isSubTreeEmpty, setIsSubTreeEmpty] = react__WEBPACK_IMPORTED_MODULE_2___default().useState(!hasSubTree);

  // Set the expanded state and cache it
  const setIsExpandedWithCache = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(newIsExpanded => {
    var _expandedStateCache$c3;
    setIsExpanded(newIsExpanded);
    (_expandedStateCache$c3 = expandedStateCache.current) === null || _expandedStateCache$c3 === void 0 ? void 0 : _expandedStateCache$c3.set(itemId, newIsExpanded);
  }, [itemId, setIsExpanded, expandedStateCache]);

  // Expand or collapse the subtree
  const toggle = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(event => {
    setIsExpandedWithCache(!isExpanded);
    event === null || event === void 0 ? void 0 : event.stopPropagation();
  }, [isExpanded, setIsExpandedWithCache]);
  const handleKeyDown = react__WEBPACK_IMPORTED_MODULE_2___default().useCallback(event => {
    switch (event.key) {
      case 'Enter':
        if (onSelect) {
          onSelect(event);
        } else {
          toggle(event);
        }
        break;
      case 'ArrowRight':
        event.preventDefault();
        event.stopPropagation();
        setIsExpandedWithCache(true);
        break;
      case 'ArrowLeft':
        event.preventDefault();
        event.stopPropagation();
        setIsExpandedWithCache(false);
        break;
    }
  }, [onSelect, setIsExpandedWithCache, toggle]);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(ItemContext.Provider, {
    value: {
      itemId,
      level: level + 1,
      isSubTreeEmpty,
      setIsSubTreeEmpty,
      isExpanded,
      setIsExpanded: setIsExpandedWithCache,
      leadingVisualId,
      trailingVisualId
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("li", {
    className: "PRIVATE_TreeView-item",
    ref: ref,
    tabIndex: 0,
    id: itemId,
    role: "treeitem",
    "aria-labelledby": labelId,
    "aria-describedby": `${leadingVisualId} ${trailingVisualId}`,
    "aria-level": level,
    "aria-expanded": isSubTreeEmpty ? undefined : isExpanded,
    "aria-current": isCurrentItem ? 'true' : undefined,
    onKeyDown: handleKeyDown,
    onFocus: event => {
      var _event$currentTarget$;
      // Scroll the first child into view when the item receives focus
      (_event$currentTarget$ = event.currentTarget.firstElementChild) === null || _event$currentTarget$ === void 0 ? void 0 : _event$currentTarget$.scrollIntoView({
        block: 'nearest',
        inline: 'nearest'
      });

      // Prevent focus event from bubbling up to parent items
      event.stopPropagation();
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_TreeView-item-container",
    style: {
      // @ts-ignore CSS custom property
      '--level': level,
      contentVisibility: containIntrinsicSize ? 'auto' : undefined,
      containIntrinsicSize
    },
    onClick: event => {
      if (onSelect) {
        onSelect(event);
      } else {
        toggle(event);
      }
    },
    onAuxClick: event => {
      if (onSelect && event.button === 1) {
        onSelect(event);
      }
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    style: {
      gridArea: 'spacer',
      display: 'flex'
    }
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(LevelIndicatorLines, {
    level: level
  })), hasSubTree ?
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
  react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('PRIVATE_TreeView-item-toggle', onSelect && 'PRIVATE_TreeView-item-toggle--hover', level === 1 && 'PRIVATE_TreeView-item-toggle--end'),
    onClick: event => {
      if (onSelect) {
        toggle(event);
      }
    }
  }, isExpanded ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.ChevronDownIcon, {
    size: 12
  }) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.ChevronRightIcon, {
    size: 12
  })) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    id: labelId,
    className: "PRIVATE_TreeView-item-content"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Slots, null, slots => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null, slots.LeadingVisual, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("span", {
    className: "PRIVATE_TreeView-item-content-text"
  }, childrenWithoutSubTree), slots.TrailingVisual)))), subTree));
});

/** Lines to indicate the depth of an item in a TreeView */
const LevelIndicatorLines = ({
  level
}) => {
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    style: {
      width: '100%',
      display: 'flex'
    }
  }, Array.from({
    length: level - 1
  }).map((_, index) => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    key: index,
    className: "PRIVATE_TreeView-item-level-line"
  })));
};
LevelIndicatorLines.displayName = "LevelIndicatorLines";
Item.displayName = 'TreeView.Item';

// ----------------------------------------------------------------------------
// TreeView.SubTree

const SubTree = ({
  count,
  state,
  children
}) => {
  const {
    announceUpdate
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(RootContext);
  const {
    itemId,
    isExpanded,
    isSubTreeEmpty,
    setIsSubTreeEmpty
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  const [isLoadingItemVisible, setIsLoadingItemVisible] = react__WEBPACK_IMPORTED_MODULE_2___default().useState(false);
  const {
    safeSetTimeout
  } = (0,_hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_12__["default"])();
  const loadingItemRef = react__WEBPACK_IMPORTED_MODULE_2___default().useRef(null);
  const ref = react__WEBPACK_IMPORTED_MODULE_2___default().useRef(null);
  const [isPending, setPending] = react__WEBPACK_IMPORTED_MODULE_2___default().useState(state === 'loading');
  react__WEBPACK_IMPORTED_MODULE_2___default().useEffect(() => {
    if (state === 'loading') {
      setPending(true);
    }
  }, [state]);
  react__WEBPACK_IMPORTED_MODULE_2___default().useEffect(() => {
    // If `state` is undefined, we're working in a synchronous context and need
    // to detect if the sub-tree has content. If `state === 'done` then we're
    // working in an asynchronous context and need to see if there is content
    // that has been loaded in.
    if (state === undefined || state === 'done') {
      if (!isSubTreeEmpty && !children) {
        setIsSubTreeEmpty(true);
      } else if (isSubTreeEmpty && children) {
        setIsSubTreeEmpty(false);
      }
    }
  }, [state, isSubTreeEmpty, setIsSubTreeEmpty, children]);

  // If a consumer sets state="done" without having a previous state (like `loading`),
  // then it would announce on the first render. Using isPending is to only
  // announce being "loaded" when the state has changed from `loading` --> `done`.
  react__WEBPACK_IMPORTED_MODULE_2___default().useEffect(() => {
    if (isPending && state === 'done') {
      const parentItem = document.getElementById(itemId);
      if (!parentItem) return;
      const {
        current: node
      } = ref;
      const parentName = (0,_shared_js__WEBPACK_IMPORTED_MODULE_13__.getAccessibleName)(parentItem);
      safeSetTimeout(() => {
        if (node && node.childElementCount > 0) {
          announceUpdate(`${parentName} content loaded`);
        } else {
          announceUpdate(`${parentName} is empty`);
        }
      });
      setPending(false);
    }
  }, [state, itemId, announceUpdate, safeSetTimeout, isPending]);

  // Manage loading indicator state
  react__WEBPACK_IMPORTED_MODULE_2___default().useEffect(() => {
    // If we're in the loading state, but not showing the loading indicator yet,
    // show the loading indicator
    if (state === 'loading' && !isLoadingItemVisible) {
      setIsLoadingItemVisible(true);
    }

    // If we're not in the loading state, but we're still showing a loading indicator,
    // hide the loading indicator and move focus if necessary
    if (state !== 'loading' && isLoadingItemVisible) {
      const isLoadingItemFocused = document.activeElement === loadingItemRef.current;
      setIsLoadingItemVisible(false);
      if (isLoadingItemFocused) {
        safeSetTimeout(() => {
          const parentElement = document.getElementById(itemId);
          if (!parentElement) return;
          const firstChild = (0,_useRovingTabIndex_js__WEBPACK_IMPORTED_MODULE_6__.getFirstChildElement)(parentElement);
          if (firstChild) {
            firstChild.focus();
          } else {
            parentElement.focus();
          }
        });
      }
    }
  }, [state, safeSetTimeout, isLoadingItemVisible, itemId]);
  if (!isExpanded) {
    return null;
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("ul", {
    role: "group",
    style: {
      listStyle: 'none',
      padding: 0,
      margin: 0
    }
    // @ts-ignore Box doesn't have type support for `ref` used in combination with `as`
    ,
    ref: ref
  }, isLoadingItemVisible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(LoadingItem, {
    ref: loadingItemRef,
    count: count
  }) : children);
};
SubTree.displayName = "SubTree";
SubTree.displayName = 'TreeView.SubTree';
const shimmer = (0,styled_components__WEBPACK_IMPORTED_MODULE_3__.keyframes)(["from{mask-position:200%;}to{mask-position:0%;}"]);
const SkeletonItem = styled_components__WEBPACK_IMPORTED_MODULE_3___default().span.attrs({
  className: 'PRIVATE_TreeView-item-skeleton'
}).withConfig({
  displayName: "TreeView__SkeletonItem",
  componentId: "sc-4ex6b6-1"
})(["display:flex;align-items:center;column-gap:0.5rem;height:2rem;@media (pointer:coarse){height:2.75rem;}@media (prefers-reduced-motion:no-preference){mask-image:linear-gradient(75deg,#000 30%,rgba(0,0,0,0.65) 80%);mask-size:200%;animation:", ";animation-duration:1s;animation-iteration-count:infinite;}&::before{content:'';display:block;width:1rem;height:1rem;background-color:", ";border-radius:3px;@media (forced-colors:active){outline:1px solid transparent;outline-offset:-1px;}}&::after{content:'';display:block;width:var(--tree-item-loading-width,67%);height:1rem;background-color:", ";border-radius:3px;@media (forced-colors:active){outline:1px solid transparent;outline-offset:-1px;}}&:nth-of-type(5n + 1){--tree-item-loading-width:67%;}&:nth-of-type(5n + 2){--tree-item-loading-width:47%;}&:nth-of-type(5n + 3){--tree-item-loading-width:73%;}&:nth-of-type(5n + 4){--tree-item-loading-width:64%;}&:nth-of-type(5n + 5){--tree-item-loading-width:50%;}"], shimmer, (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.neutral.subtle'), (0,_constants_js__WEBPACK_IMPORTED_MODULE_4__.get)('colors.neutral.subtle'));
const LoadingItem = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef(({
  count
}, ref) => {
  const itemId = (0,_hooks_useId_js__WEBPACK_IMPORTED_MODULE_10__.useId)();
  if (count) {
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Item, {
      id: itemId,
      ref: ref
    }, Array.from({
      length: count
    }).map((_, i) => {
      return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(SkeletonItem, {
        "aria-hidden": true,
        key: i
      });
    }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
      className: "PRIVATE_VisuallyHidden"
    }, "Loading ", count, " items"));
  }
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Item, {
    id: itemId,
    ref: ref
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(LeadingVisual, null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_Spinner_js__WEBPACK_IMPORTED_MODULE_14__["default"], {
    size: "small"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_Text_js__WEBPACK_IMPORTED_MODULE_15__["default"], {
    sx: {
      color: 'fg.muted'
    }
  }, "Loading..."));
});
function useSubTree(children) {
  return react__WEBPACK_IMPORTED_MODULE_2___default().useMemo(() => {
    const subTree = react__WEBPACK_IMPORTED_MODULE_2___default().Children.toArray(children).find(child => /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().isValidElement(child) && child.type === SubTree);
    const childrenWithoutSubTree = react__WEBPACK_IMPORTED_MODULE_2___default().Children.toArray(children).filter(child => !( /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().isValidElement(child) && child.type === SubTree));
    return {
      subTree,
      childrenWithoutSubTree,
      hasSubTree: Boolean(subTree)
    };
  }, [children]);
}

// ----------------------------------------------------------------------------
// TreeView.LeadingVisual and TreeView.TrailingVisual

const LeadingVisual = props => {
  const {
    isExpanded,
    leadingVisualId
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  const children = typeof props.children === 'function' ? props.children({
    isExpanded
  }) : props.children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Slot, {
    name: "LeadingVisual"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_VisuallyHidden",
    "aria-hidden": true,
    id: leadingVisualId
  }, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_TreeView-item-visual",
    "aria-hidden": true
  }, children));
};
LeadingVisual.displayName = "LeadingVisual";
LeadingVisual.displayName = 'TreeView.LeadingVisual';
const TrailingVisual = props => {
  const {
    isExpanded,
    trailingVisualId
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  const children = typeof props.children === 'function' ? props.children({
    isExpanded
  }) : props.children;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Slot, {
    name: "TrailingVisual"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_VisuallyHidden",
    "aria-hidden": true,
    id: trailingVisualId
  }, props.label), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_TreeView-item-visual",
    "aria-hidden": true
  }, children));
};
TrailingVisual.displayName = "TrailingVisual";
TrailingVisual.displayName = 'TreeView.TrailingVisual';

// ----------------------------------------------------------------------------
// TreeView.DirectoryIcon

const DirectoryIcon = () => {
  const {
    isExpanded
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  const Icon = isExpanded ? _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.FileDirectoryOpenFillIcon : _primer_octicons_react__WEBPACK_IMPORTED_MODULE_0__.FileDirectoryFillIcon;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
    className: "PRIVATE_TreeView-directory-icon"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Icon, null));
};
DirectoryIcon.displayName = "DirectoryIcon";
const ErrorDialog = ({
  title = 'Error',
  children,
  onRetry,
  onDismiss
}) => {
  const {
    itemId,
    setIsExpanded
  } = react__WEBPACK_IMPORTED_MODULE_2___default().useContext(ItemContext);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/no-static-element-interactions
    react__WEBPACK_IMPORTED_MODULE_2___default().createElement("div", {
      onKeyDown: event => {
        if (['Backspace', 'ArrowLeft', 'ArrowRight', 'ArrowUp', 'ArrowDown', 'Enter'].includes(event.key)) {
          // Prevent keyboard events from bubbling up to the TreeView
          // and interfering with keyboard navigation
          event.stopPropagation();
        }
      }
    }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_Dialog_ConfirmationDialog_js__WEBPACK_IMPORTED_MODULE_16__.ConfirmationDialog, {
      title: title,
      onClose: gesture => {
        // Focus parent item after the dialog is closed
        setTimeout(() => {
          const parentElement = document.getElementById(itemId);
          parentElement === null || parentElement === void 0 ? void 0 : parentElement.focus();
        });
        if (gesture === 'confirm') {
          onRetry === null || onRetry === void 0 ? void 0 : onRetry();
        } else {
          setIsExpanded(false);
          onDismiss === null || onDismiss === void 0 ? void 0 : onDismiss();
        }
      },
      confirmButtonContent: "Retry",
      cancelButtonContent: "Dismiss"
    }, children))
  );
};
ErrorDialog.displayName = "ErrorDialog";
ErrorDialog.displayName = 'TreeView.ErrorDialog';

// ----------------------------------------------------------------------------
// Export

const TreeView = Object.assign(Root, {
  Item,
  SubTree,
  LeadingVisual,
  TrailingVisual,
  DirectoryIcon,
  ErrorDialog
});




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/TreeView/shared.js":
/*!**********************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/TreeView/shared.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getAccessibleName": () => (/* binding */ getAccessibleName)
/* harmony export */ });
/**
 * Returns the accessible name of an element
 */
function getAccessibleName(element) {
  var _document$getElementB, _document$getElementB2, _element$textContent;
  const label = element.getAttribute('aria-label');
  const labelledby = element.getAttribute('aria-labelledby');
  if (label) return label;
  if (labelledby) return (_document$getElementB = (_document$getElementB2 = document.getElementById(labelledby)) === null || _document$getElementB2 === void 0 ? void 0 : _document$getElementB2.textContent) !== null && _document$getElementB !== void 0 ? _document$getElementB : '';
  return (_element$textContent = element.textContent) !== null && _element$textContent !== void 0 ? _element$textContent : '';
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/TreeView/useRovingTabIndex.js":
/*!*********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/TreeView/useRovingTabIndex.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getElementState": () => (/* binding */ getElementState),
/* harmony export */   "getFirstChildElement": () => (/* binding */ getFirstChildElement),
/* harmony export */   "getFirstElement": () => (/* binding */ getFirstElement),
/* harmony export */   "getLastElement": () => (/* binding */ getLastElement),
/* harmony export */   "getNextFocusableElement": () => (/* binding */ getNextFocusableElement),
/* harmony export */   "getParentElement": () => (/* binding */ getParentElement),
/* harmony export */   "getVisibleElement": () => (/* binding */ getVisibleElement),
/* harmony export */   "useRovingTabIndex": () => (/* binding */ useRovingTabIndex)
/* harmony export */ });
/* harmony import */ var _hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../hooks/useFocusZone.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useFocusZone.js");
/* harmony import */ var _utils_scroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/scroll.js */ "../../../node_modules/@primer/react/lib-esm/utils/scroll.js");
/* harmony import */ var _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @primer/behaviors */ "../../../node_modules/@primer/behaviors/dist/esm/focus-zone.js");




function useRovingTabIndex({
  containerRef
}) {
  // TODO: Initialize focus to the aria-current item if it exists
  (0,_hooks_useFocusZone_js__WEBPACK_IMPORTED_MODULE_0__.useFocusZone)({
    containerRef,
    bindKeys: _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys.ArrowVertical | _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys.ArrowHorizontal | _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys.HomeAndEnd | _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys.Backspace | _primer_behaviors__WEBPACK_IMPORTED_MODULE_1__.FocusKeys.PageUpDown,
    preventScroll: true,
    getNextFocusable: (direction, from, event) => {
      var _getNextFocusableElem;
      if (!(from instanceof HTMLElement)) return;
      return (_getNextFocusableElem = getNextFocusableElement(from, event)) !== null && _getNextFocusableElem !== void 0 ? _getNextFocusableElem : from;
    }
  });
}

// DOM utilities used for focus management

function getNextFocusableElement(activeElement, event) {
  const elementState = getElementState(activeElement);

  // Reference: https://www.w3.org/WAI/ARIA/apg/patterns/treeview/#keyboard-interaction-24
  switch (`${elementState} ${event.key}`) {
    case 'open ArrowRight':
      // Focus first child node
      return getFirstChildElement(activeElement);
    case 'open ArrowLeft':
      // Close node; don't change focus
      return;
    case 'closed ArrowRight':
      // Open node; don't change focus
      return;
    case 'closed ArrowLeft':
      // Focus parent element
      return getParentElement(activeElement);
    case 'end ArrowRight':
      // Do nothing
      return;
    case 'end ArrowLeft':
      // Focus parent element
      return getParentElement(activeElement);
  }

  // ArrowUp, ArrowDown, Home, and End behavior are the same regarless of element state
  switch (event.key) {
    case 'ArrowUp':
      // Focus previous visible element
      return getVisibleElement(activeElement, 'previous');
    case 'ArrowDown':
      // Focus next visible element
      return getVisibleElement(activeElement, 'next');
    case 'Backspace':
      return getParentElement(activeElement);
    case 'Home':
      // Focus first visible element
      return getFirstElement(activeElement);
    case 'End':
      // Focus last visible element
      return getLastElement(activeElement);
    case 'PageUp':
      return getPreviousPageElement(activeElement);
    case 'PageDown':
      return getNextPageElement(activeElement);
  }
}
function getElementState(element) {
  if (element.getAttribute('role') !== 'treeitem') {
    throw new Error('Element is not a treeitem');
  }
  switch (element.getAttribute('aria-expanded')) {
    case 'true':
      return 'open';
    case 'false':
      return 'closed';
    default:
      return 'end';
  }
}
function getVisibleElement(element, direction) {
  const root = element.closest('[role=tree]');
  if (!root) return;
  const walker = document.createTreeWalker(root, NodeFilter.SHOW_ELEMENT, node => {
    if (!(node instanceof HTMLElement)) return NodeFilter.FILTER_SKIP;
    return node.getAttribute('role') === 'treeitem' ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
  });
  let current = walker.firstChild();
  while (current !== element) {
    current = walker.nextNode();
  }
  let next = direction === 'next' ? walker.nextNode() : walker.previousNode();

  // If next element is nested inside a collapsed subtree, continue iterating
  while (next instanceof HTMLElement && (_next$parentElement = next.parentElement) !== null && _next$parentElement !== void 0 && _next$parentElement.closest('[role=treeitem][aria-expanded=false]')) {
    var _next$parentElement;
    next = direction === 'next' ? walker.nextNode() : walker.previousNode();
  }
  return next instanceof HTMLElement ? next : undefined;
}
function getFirstChildElement(element) {
  const firstChild = element.querySelector('[role=treeitem]');
  return firstChild instanceof HTMLElement ? firstChild : undefined;
}
function getParentElement(element) {
  const group = element.closest('[role=group]');
  const parent = group === null || group === void 0 ? void 0 : group.closest('[role=treeitem]');
  return parent instanceof HTMLElement ? parent : undefined;
}
function getFirstElement(element) {
  const root = element.closest('[role=tree]');
  const first = root === null || root === void 0 ? void 0 : root.querySelector('[role=treeitem]');
  return first instanceof HTMLElement ? first : undefined;
}
function getLastElement(element) {
  const root = element.closest('[role=tree]');
  const items = Array.from((root === null || root === void 0 ? void 0 : root.querySelectorAll('[role=treeitem]')) || []);

  // If there are no items, return undefined
  if (items.length === 0) return;
  let index = items.length - 1;
  let last = items[index];

  // If last element is nested inside a collapsed subtree, continue iterating
  while (index > 0 && last instanceof HTMLElement && (_last$parentElement = last.parentElement) !== null && _last$parentElement !== void 0 && _last$parentElement.closest('[role=treeitem][aria-expanded=false]')) {
    var _last$parentElement;
    index -= 1;
    last = items[index];
  }
  return last instanceof HTMLElement ? last : undefined;
}
const defaultSize = {
  height: 32
};

/**
 * Determine the page size for the given tree based on an item in the tree. We
 * estimate this size by trying to see how many items will fit in the given
 * tree. If the tree is within a scroll container, we will use the height of
 * that container. Otherwise, we'll use the current window height
 */
function getPageSize(root, item) {
  var _item$getBoundingClie, _scrollContainer$clie;
  const scrollContainer = (0,_utils_scroll_js__WEBPACK_IMPORTED_MODULE_2__.getScrollContainer)(root);
  const {
    height: itemHeight
  } = (_item$getBoundingClie = item === null || item === void 0 ? void 0 : item.getBoundingClientRect()) !== null && _item$getBoundingClie !== void 0 ? _item$getBoundingClie : defaultSize;
  const availableHeight = (_scrollContainer$clie = scrollContainer === null || scrollContainer === void 0 ? void 0 : scrollContainer.clientHeight) !== null && _scrollContainer$clie !== void 0 ? _scrollContainer$clie : window.innerHeight;
  return Math.floor(availableHeight / itemHeight);
}
function getNextPageElement(element) {
  const root = element.closest('[role="tree"]');
  if (!root) {
    return;
  }
  const items = Array.from(root.querySelectorAll('[role="treeitem"]'));
  if (items.length === 0) {
    return;
  }
  const itemLabel = items[0].firstElementChild;
  const pageSize = getPageSize(root, itemLabel);
  const page = Math.floor(items.indexOf(element) / pageSize);
  const offset = items.indexOf(element) - pageSize * page;
  return items[Math.min(items.length - 1, (page + 1) * pageSize + offset)];
}
function getPreviousPageElement(element) {
  const root = element.closest('[role="tree"]');
  if (!root) {
    return;
  }
  const items = Array.from(root.querySelectorAll('[role="treeitem"]'));
  if (items.length === 0) {
    return;
  }
  const itemLabel = items[0].firstElementChild;
  const pageSize = getPageSize(root, itemLabel);
  const page = Math.floor(items.indexOf(element) / pageSize);
  const offset = items.indexOf(element) - pageSize * page;
  return items[Math.max(0, (page - 1) * pageSize + offset)];
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/TreeView/useTypeahead.js":
/*!****************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/TreeView/useTypeahead.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useTypeahead": () => (/* binding */ useTypeahead)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../hooks/useSafeTimeout.js */ "../../../node_modules/@primer/react/lib-esm/hooks/useSafeTimeout.js");
/* harmony import */ var _shared_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared.js */ "../../../node_modules/@primer/react/lib-esm/TreeView/shared.js");




function useTypeahead({
  containerRef,
  onFocusChange
}) {
  const searchValue = react__WEBPACK_IMPORTED_MODULE_0___default().useRef('');
  const timeoutRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(0);
  const onFocusChangeRef = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(onFocusChange);
  const {
    safeSetTimeout,
    safeClearTimeout
  } = (0,_hooks_useSafeTimeout_js__WEBPACK_IMPORTED_MODULE_1__["default"])();

  // Update the ref when the callback changes
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    onFocusChangeRef.current = onFocusChange;
  }, [onFocusChange]);

  // Focus the closest element that matches the search value
  const focusSearchValue = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(searchValue => {
    // Don't change focus if the search value is empty
    if (!searchValue) return;
    if (!containerRef.current) return;
    const container = containerRef.current;

    // Get focusable elements
    const elements = Array.from(container.querySelectorAll('[role="treeitem"]'));

    // Get the index of active element
    const activeIndex = elements.findIndex(element => element === document.activeElement);

    // Wrap the array elements such that the active descendant is at the beginning
    let sortedElements = wrapArray(elements, activeIndex);

    // Remove the active descendant from the beginning of the array
    // when the user initiates a new search
    if (searchValue.length === 1) {
      sortedElements = sortedElements.slice(1);
    }

    // Find the first element that matches the search value
    const nextElement = sortedElements.find(element => {
      const name = (0,_shared_js__WEBPACK_IMPORTED_MODULE_2__.getAccessibleName)(element).toLowerCase();
      return name.startsWith(searchValue.toLowerCase());
    });

    // If a match is found, focus it
    if (nextElement) {
      onFocusChangeRef.current(nextElement);
    }
  }, [containerRef]);

  // Update the search value when the user types
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    if (!containerRef.current) return;
    const container = containerRef.current;
    function onKeyDown(event) {
      // Ignore key presses that don't produce a character value
      if (!event.key || event.key.length > 1) return;

      // Ignore key presses that occur with a modifier
      if (event.ctrlKey || event.altKey || event.metaKey) return;

      // Update the existing search value with the new key press
      searchValue.current += event.key;
      focusSearchValue(searchValue.current);

      // Reset the timeout
      safeClearTimeout(timeoutRef.current);
      timeoutRef.current = safeSetTimeout(() => searchValue.current = '', 300);

      // Prevent default behavior
      event.preventDefault();
      event.stopPropagation();
    }
    container.addEventListener('keydown', onKeyDown);
    return () => container.removeEventListener('keydown', onKeyDown);
  }, [containerRef, focusSearchValue, safeClearTimeout, safeSetTimeout]);
}

/**
 * Wraps an array around itself at a given start index
 *
 * @example
 * wrapArray(['a', 'b', 'c', 'd'], 2) // ['c', 'd', 'a', 'b']
 */
function wrapArray(array, startIndex) {
  return array.map((_, index) => array[(startIndex + index) % array.length]);
}




/***/ }),

/***/ "../../../node_modules/@primer/react/lib-esm/hooks/useControllableState.js":
/*!*********************************************************************************!*\
  !*** ../../../node_modules/@primer/react/lib-esm/hooks/useControllableState.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "useControllableState": () => (/* binding */ useControllableState)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * This custom hook simplifies the behavior of a component if it has state that
 * can be both controlled and uncontrolled. It functions identical to a
 * useState() hook and provides [state, setState] for you to use. You can use
 * the `onChange` argument to allow updates to the `state` to be communicated to
 * owners of controlled components.
 *
 * Note: This hook will warn if a component is switching from controlled to
 * uncontrolled, or vice-versa.
 */
function useControllableState({
  name = 'custom',
  defaultValue,
  value,
  onChange
}) {
  const [state, internalSetState] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(value !== null && value !== void 0 ? value : defaultValue);
  const controlled = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(null);
  const stableOnChange = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(onChange);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    stableOnChange.current = onChange;
  });
  if (controlled.current === null) {
    controlled.current = value !== undefined;
  }
  const setState = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(stateOrUpdater => {
    var _stableOnChange$curre;
    const value = typeof stateOrUpdater === 'function' ?
    // @ts-ignore stateOrUpdater is a function
    stateOrUpdater(state) : stateOrUpdater;
    if (controlled.current === false) {
      internalSetState(value);
    }
    (_stableOnChange$curre = stableOnChange.current) === null || _stableOnChange$curre === void 0 ? void 0 : _stableOnChange$curre.call(stableOnChange, value);
  }, [state]);
  react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
    const controlledValue = value !== undefined;

    // Uncontrolled -> Controlled
    // If the component prop is uncontrolled, the prop value should be undefined
    if (controlled.current === false && controlledValue) {
      warn('A component is changing an uncontrolled %s component to be controlled. ' + 'This is likely caused by the value changing to a defined value ' + 'from undefined. Decide between using a controlled or uncontrolled ' + 'value for the lifetime of the component. ' + 'More info: https://reactjs.org/link/controlled-components', name);
    }

    // Controlled -> Uncontrolled
    // If the component prop is controlled, the prop value should be defined
    if (controlled.current === true && !controlledValue) {
      warn('A component is changing a controlled %s component to be uncontrolled. ' + 'This is likely caused by the value changing to an undefined value ' + 'from a defined one. Decide between using a controlled or ' + 'uncontrolled value for the lifetime of the component. ' + 'More info: https://reactjs.org/link/controlled-components', name);
    }
  }, [name, value]);
  if (controlled.current === true) {
    return [value, setState];
  }
  return [state, setState];
}

/** Warn when running in a development environment */
const warn =  true ?
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function warn(format, ...args) {
  let index = 0;
  const message = format.replace(/%s/g, () => {
    return args[index++];
  });
  // eslint-disable-next-line no-console
  console.warn(`Warning: ${message}`);
} : 0;




/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_primer_react_lib-esm_TreeView_TreeView_js.c0439cd3c4adf5cfcd74.js.map