# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src/test/python'}

packages = \
['python', 'python.dev4py.utils', 'python.dev4py.utils_test']

package_data = \
{'': ['*']}

modules = \
['project']
setup_kwargs = {
    'name': 'dev4py-utils',
    'version': '3.2.1',
    'description': 'A set of Python regularly used classes/functions',
    'long_description': '# Dev4py-utils\n\nA set of Python regularly used classes/functions\n\n[![ci](https://github.com/dev4py/dev4py-utils/actions/workflows/ci.yml/badge.svg?event=push&branch=main)](https://github.com/dev4py/dev4py-utils/actions/workflows/ci.yml) <br/>\n[![Last release](https://github.com/dev4py/dev4py-utils/actions/workflows/on_release.yml/badge.svg)](https://github.com/dev4py/dev4py-utils/actions/workflows/on_release.yml) <br/>\n[![Weekly checks](https://github.com/dev4py/dev4py-utils/actions/workflows/weekly_checks.yml/badge.svg?branch=main)](https://github.com/dev4py/dev4py-utils/actions/workflows/weekly_checks.yml) <br/>\n[![Python >= 3.10.1](https://img.shields.io/badge/Python->=3.10.1-informational.svg?style=plastic&logo=python&logoColor=yellow)](https://www.python.org/) <br/>\n[![Maintainer](https://img.shields.io/badge/maintainer-St4rG00se-informational?style=plastic&logo=superuser)](https://github.com/St4rG00se) <br/>\n[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg?style=plastic&logo=github)](https://GitHub.com/Naereen/StrapDown.js/graphs/commit-activity) <br/>\n[![License: Apache-2.0](https://img.shields.io/badge/License-Apache_2.0-yellow.svg?style=plastic&logo=github)](https://opensource.org/licenses/Apache-2.0)\n\n## Table of contents\n\n- [Project template](#project-template)\n- [Project links](#project-links)\n- [Dev4py-utils modules](#dev4py-utils-modules)\n    * [dev4py.utils.AsyncJOptional](#dev4pyutilsasyncjoptional)\n    * [dev4py.utils.awaitables](#dev4pyutilsawaitables)\n    * [dev4py.utils.dicts](#dev4pyutilsdicts)\n    * [dev4py.utils.JOptional](#dev4pyutilsjoptional)\n    * [dev4py.utils.objects](#dev4pyutilsobjects)\n    * [dev4py.utils.types](#dev4pyutilstypes)\n\n## Project template\n\nThis project is based on [pymsdl_template](https://github.com/dev4py/pymsdl_template)\n\n## Project links\n\n* [Documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils.html)\n* [PyPi project](https://pypi.org/project/dev4py-utils/)\n\n## Dev4py-utils modules\n\n### dev4py.utils.AsyncJOptional\n\n[AsyncJOptional documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/AsyncJOptional.html)\n\n> ***Note:** [AsyncJOptional](src/main/python/dev4py/utils/AsyncJOptional.py) class is designed in order to simplify\n> JOptional with async mapper*\n\n> ***Note:** AsyncJOptional support T or Awaitable[T] values. That\'s why some checks are done when terminal operation is\n> called with `await`*\n\nExamples:\n\n```python\nimport asyncio\nfrom dev4py.utils import AsyncJOptional\n\ndef sync_mapper(i: int) -> int:\n  return i * 2\n\nasync def async_mapper(i: int) -> str:\n  return f"The value is {i}"\n\nasync def async_sample() -> None:\n  value: int = 1\n  await AsyncJOptional.of_noneable(value)\\\n    .map(sync_mapper)\\\n    .map(async_mapper)\\\n    .if_present(print)\n\nasyncio.run(async_sample())\n```\n\n### dev4py.utils.awaitables\n\n[Awaitables documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/awaitables.html)\n\nExamples:\n\n```python\nimport asyncio\nfrom dev4py.utils import awaitables, JOptional\n\n# is_awaitable sample\nawaitables.is_awaitable(asyncio.sleep(2))  # True\nawaitables.is_awaitable(print(\'Hello\'))  # False\n\n\n# to_sync_or_async_param_function sample\ndef mapper(s: str) -> str:\n    return s + \'_suffix\'\n\nasync def async_mapper(s: str) -> str:\n    await asyncio.sleep(1)\n    return s + \'_async_suffix\'\n\nasync def async_test():\n    # Note: mapper parameter is str and async_mapper returns an Awaitable[str] so we have to manage it\n    # Note: !WARNING! Since 3.0.0 see AsyncJOptional / JOptional to_async_joptional method\n    result: str = await JOptional.of("A value")\\\n      .map(async_mapper)\\\n      .map(awaitables.to_sync_or_async_param_function(mapper))\\\n      .get()\n    print(result)  # A value_async_suffix_suffix\n\nasyncio.run(async_test())\n````\n\n### dev4py.utils.dicts\n\n[Dicts documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/dicts.html)\n\nExamples:\n\n```python\nfrom dev4py.utils import dicts\nfrom dev4py.utils.types import Supplier\n\n# is_dict sample\ndicts.is_dict("A str")  # False\ndicts.is_dict({\'key\': \'A dict value\'})  # True\n\n\n# get_value sample\nint_supplier: Supplier[int] = lambda: 3\ndictionary: dict[str, int] = {\'key_1\': 1, \'key_2\': 2}\n\ndicts.get_value(dictionary, \'key_1\')  # 1\ndicts.get_value(dictionary, \'key_3\')  # None\ndicts.get_value(dictionary, \'key_3\', int_supplier)  # 3\n\n\n# get_value_from_path sample\nstr_supplier: Supplier[str] = lambda: "a3"\ndeep_dictionary: dict[str, dict[int, str]] = { \\\n  \'a\': {1: \'a1\', 2: \'a2\'}, \\\n  \'b\': {1: \'b1\', 2: \'b2\'} \\\n}\n\ndicts.get_value_from_path(deep_dictionary, ["a", 1])  # \'a1\'\ndicts.get_value_from_path(deep_dictionary, ["c", 1])  # None\ndicts.get_value_from_path(deep_dictionary, ["a", 3])  # None\ndicts.get_value_from_path(deep_dictionary, ["a", 3], str_supplier)  # \'a3\'\n````\n\n### dev4py.utils.JOptional\n\n[JOptional documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/JOptional.html)\n\n> ***Note:** [JOptional](src/main/python/dev4py/utils/JOptional.py) class is inspired from\n> [java.util.Optional](https://docs.oracle.com/en/java/javase/17/docs/api//java.base/java/util/Optional.html)\n> class with some adds (like `peek` method).*\n\nExamples:\n\n```python\nfrom dev4py.utils import JOptional\n\nvalue: int = 1\nJOptional.of_noneable(value)\\\n  .map(lambda v: f"The value is {v}")\\\n  .if_present(print)\n```\n\n### dev4py.utils.objects\n\n[Objects documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/objects.html)\n\n> ***Note:** The [objects](src/main/python/dev4py/utils/objects.py) module is inspired from\n> [java.util.Objects](https://docs.oracle.com/en/java/javase/17/docs/api//java.base/java/util/Objects.html)\n> class.*\n\nExamples:\n\n```python\nfrom dev4py.utils import objects\n\n# non_none sample\nvalue = None\nobjects.non_none(value)\n\n# require_non_none sample\nvalue = "A value"\nobjects.require_non_none(value)\n\n# to_string sample\nvalue = None\ndefault_value: str = "A default value"\nobjects.to_string(value, default_value)\n```\n\n### dev4py.utils.types\n\n[Types documentation](https://htmlpreview.github.io/?https://github.com/dev4py/dev4py-utils/blob/main/docs/dev4py/utils/types.html)\n\n> ***Note:** The [types](src/main/python/dev4py/utils/types.py) module is inspired from\n> [java.util.function](https://docs.oracle.com/en/java/javase/17/docs/api//java.base/java/util/function/package-summary.html)\n> package*\n\nExamples:\n\n```python\nfrom dev4py.utils.types import Function, Predicate, Consumer\n\n# Function sample\nint_to_str: Function[int, str] = lambda i: str(i)\nstr_result: str = int_to_str(1)\n\n# Predicate sample\nstr_predicate: Predicate[str] = lambda s: s == "A value"\npred_result = str_predicate("Value to test")\n\n# Consumer sample\ndef sample(consumer: Consumer[str], value: str) -> None:\n    consumer(value)\n\ndef my_consumer(arg: str) -> None:\n    print(arg)\n\nsample(my_consumer, "My value")\n```\n',
    'author': 'St4rG00se',
    'author_email': 'st4rg00se@protonmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dev4py/dev4py-utils',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
