import { ComputeType } from 'aws-cdk-lib/aws-codebuild';
import { IRepository } from 'aws-cdk-lib/aws-codecommit';
import { Rule, Schedule, OnEventOptions } from 'aws-cdk-lib/aws-events';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
import { ScanProps } from './cli';
export interface CodeCommitDependencyCheckProps {
    /**
     * The repository to be checked.
     */
    readonly repository: IRepository;
    /**
     * Schedule for dependency check.
     */
    readonly schedule: Schedule;
    /**
     * The type of compute to use for check the repositories.
     *
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link #buildImage#defaultComputeType}
     */
    readonly computeType?: ComputeType;
    /**
     * Custom command to be executed before the dependency check.
     *
     * @default `echo "No preCheckCommand!"`
     */
    readonly preCheckCommand?: string;
    /**
     * Version of the dependency check.
     *
     * @default 5.3.2
     */
    readonly version?: string;
    /**
     * The name of the project being scanned.
     *
     * * @default taken from {@link #repository#repositoryName}
     */
    readonly projectName?: ScanProps['projectName'];
    /**
     * If the score set between 0 and 10 the exit code from dependency-check will indicate if a vulnerability with a CVSS score equal to or higher was identified.
     *
     * @default 0
     */
    readonly failOnCVSS?: ScanProps['failOnCVSS'];
    /**
     * The paths to scan.
     *
     * Basedir repositoryDir
     *
     * @default the repositoryDir
     */
    readonly paths?: string[];
    /**
     * The path patterns to exclude from the scan.
     */
    readonly excludes?: string[];
    /**
     * The file paths to the suppression XML files;
     *
     * used to suppress false positives.
     */
    readonly suppressions?: string[];
    /**
     * Enable the experimental analyzers.
     *
     * If not set the analyzers marked as experimental will not be loaded or used.
     *
     * @default false
     */
    readonly enableExperimental?: boolean;
    /**
     * Bucket for uploading html reports.
     */
    readonly reportsBucket?: Bucket;
}
export declare class CodeCommitDependencyCheck extends Construct {
    private readonly checkProject;
    constructor(scope: Construct, id: string, props: CodeCommitDependencyCheckProps);
    /**
     * Defines an event rule which triggers when a check fails.
     */
    onCheckFailed(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a check starts.
     */
    onCheckStarted(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a check complets successfully.
     */
    onCheckSucceeded(id: string, options?: OnEventOptions): Rule;
}
