import json
import os
import uuid
import datetime
from urllib.parse import unquote_plus
import boto3

statemachine_arn = os.environ['SFN_ARN']
sfn_client = boto3.client('stepfunctions')


def main(event, context):
    print('## EVENT')
    print(event)

    for record in event['Records']:
        bucket = record['s3']['bucket']['name']
        key = unquote_plus(record['s3']['object']['key'])
        object_prefix = key[:key.rfind('/')+1]
        object_name = key[key.rfind('/')+1:]

        item = {
            'job_id': str(uuid.uuid4()),
            'bucket': bucket,
            'key': key,
            'object_prefix': object_prefix,
            'object_name': object_name,
        }
        print('## RecordObject')
        print(json.dumps(item))
        print('## StateMachineARN')
        print(statemachine_arn)
        sfn_client.start_execution(
            stateMachineArn=statemachine_arn,
            input=json.dumps(item)
        )
