# pylint: disable=too-many-lines
COMPILED_ACCOUNT_CONTRACT = r"""
{
    "abi": [
        {
            "members": [
                {
                    "name": "to",
                    "offset": 0,
                    "type": "felt"
                },
                {
                    "name": "selector",
                    "offset": 1,
                    "type": "felt"
                },
                {
                    "name": "data_offset",
                    "offset": 2,
                    "type": "felt"
                },
                {
                    "name": "data_len",
                    "offset": 3,
                    "type": "felt"
                }
            ],
            "name": "CallArray",
            "size": 4,
            "type": "struct"
        },
        {
            "inputs": [],
            "name": "assert_only_self",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_public_key",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [],
            "name": "get_nonce",
            "outputs": [
                {
                    "name": "res",
                    "type": "felt"
                }
            ],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "new_public_key",
                    "type": "felt"
                }
            ],
            "name": "set_public_key",
            "outputs": [],
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "_public_key",
                    "type": "felt"
                }
            ],
            "name": "constructor",
            "outputs": [],
            "type": "constructor"
        },
        {
            "inputs": [
                {
                    "name": "hash",
                    "type": "felt"
                },
                {
                    "name": "signature_len",
                    "type": "felt"
                },
                {
                    "name": "signature",
                    "type": "felt*"
                }
            ],
            "name": "is_valid_signature",
            "outputs": [],
            "stateMutability": "view",
            "type": "function"
        },
        {
            "inputs": [
                {
                    "name": "call_array_len",
                    "type": "felt"
                },
                {
                    "name": "call_array",
                    "type": "CallArray*"
                },
                {
                    "name": "calldata_len",
                    "type": "felt"
                },
                {
                    "name": "calldata",
                    "type": "felt*"
                },
                {
                    "name": "nonce",
                    "type": "felt"
                }
            ],
            "name": "__execute__",
            "outputs": [
                {
                    "name": "retdata_size",
                    "type": "felt"
                },
                {
                    "name": "retdata",
                    "type": "felt*"
                }
            ],
            "type": "function"
        }
    ],
    "entry_points_by_type": {
        "CONSTRUCTOR": [
            {
                "offset": "0x14c",
                "selector": "0x28ffe4ff0f226a9107253e17a904099aa4f63a02a5621de0576e5aa71bc5194"
            }
        ],
        "EXTERNAL": [
            {
                "offset": "0x1d1",
                "selector": "0x15d40a3d6ca2ac30f4031e42be28da9b056fef9bb7357ac5e85627ee876e5ad"
            },
            {
                "offset": "0xfa",
                "selector": "0x1a35984e05126dbecb7c3bb9929e7dd9106d460c59b1633739a5c733a5fb13b"
            },
            {
                "offset": "0x119",
                "selector": "0x1ac47721ee58ba2813c2a816bca188512839a00d3970f67c05eab986b14006d"
            },
            {
                "offset": "0x170",
                "selector": "0x28420862938116cb3bbdbedee07451ccc54d4e9412dbef71142ad1980a30941"
            },
            {
                "offset": "0xdd",
                "selector": "0x2de154d8a89be65c1724e962dc4c65637c05532a6c2825d0a7b7d774169dbba"
            },
            {
                "offset": "0x132",
                "selector": "0x2e3e21ff5952b2531241e37999d9c4c8b3034cccc89a202a6bf019bdf5294f9"
            }
        ],
        "L1_HANDLER": []
    },
    "program": {
        "attributes": [
            {
                "accessible_scopes": [
                    "__main__",
                    "__main__",
                    "__main__.__execute__"
                ],
                "end_pc": 415,
                "flow_tracking_data": {
                    "ap_tracking": {
                        "group": 37,
                        "offset": 46
                    },
                    "reference_ids": {
                        "__main__.__execute__.__fp__": 293,
                        "__main__.__execute__._current_nonce": 301,
                        "__main__.__execute__.call_array": 285,
                        "__main__.__execute__.call_array_len": 284,
                        "__main__.__execute__.calldata": 287,
                        "__main__.__execute__.calldata_len": 286,
                        "__main__.__execute__.ecdsa_ptr": 292,
                        "__main__.__execute__.nonce": 288,
                        "__main__.__execute__.pedersen_ptr": 302,
                        "__main__.__execute__.range_check_ptr": 303,
                        "__main__.__execute__.syscall_ptr": 297,
                        "__main__.__execute__.tx_info": 296
                    }
                },
                "name": "error_message",
                "start_pc": 414,
                "value": "Invalid nonce."
            }
        ],
        "builtins": [
            "pedersen",
            "range_check",
            "ecdsa"
        ],
        "data": [
            "0x40780017fff7fff",
            "0x1",
            "0x208b7fff7fff7ffe",
            "0x400380007ffb7ffc",
            "0x400380017ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x480280027ffb8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffd",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480080007fff8000",
            "0x400080007ffd7fff",
            "0x482480017ffd8001",
            "0x1",
            "0x482480017ffd8001",
            "0x1",
            "0xa0680017fff7ffe",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffb",
            "0x402a7ffc7ffd7fff",
            "0x208b7fff7fff7ffe",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x43616c6c436f6e7472616374",
            "0x400280007ff97fff",
            "0x400380017ff97ffa",
            "0x400380027ff97ffb",
            "0x400380037ff97ffc",
            "0x400380047ff97ffd",
            "0x482680017ff98000",
            "0x7",
            "0x480280057ff98000",
            "0x480280067ff98000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x47657443616c6c657241646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x476574436f6e747261637441646472657373",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f7261676552656164",
            "0x400280007ffc7fff",
            "0x400380017ffc7ffd",
            "0x482680017ffc8000",
            "0x3",
            "0x480280027ffc8000",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x53746f726167655772697465",
            "0x400280007ffb7fff",
            "0x400380017ffb7ffc",
            "0x400380027ffb7ffd",
            "0x482680017ffb8000",
            "0x3",
            "0x208b7fff7fff7ffe",
            "0x480680017fff8000",
            "0x4765745478496e666f",
            "0x400280007ffd7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffcd",
            "0x400780017fff8000",
            "0x0",
            "0x400780017fff8001",
            "0x0",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480280007ffb8000",
            "0x1104800180018000",
            "0x20",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffbd",
            "0x40137ffd7fff8000",
            "0x480280017ffb8000",
            "0x40297ffd7fff8001",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x2",
            "0x480a7ffb7fff8000",
            "0x480280007ffc8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff9b",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffae",
            "0x40137ffd7fff8000",
            "0x480280017ffc8000",
            "0x402580017fff8001",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff8d",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffc",
            "0x5",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x482680017ffc8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x40337fff7ffb8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffd7fff8000",
            "0x48317ffd80008000",
            "0x400080007ffd7ffe",
            "0x480080007ffc8000",
            "0x400080017ffc7fff",
            "0x482480017ffb8000",
            "0x1",
            "0x482480017ffb8000",
            "0x3",
            "0x480080027ffa8000",
            "0x20680017fff7ffb",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff8",
            "0x208b7fff7fff7ffe",
            "0x400380017ff97ffa",
            "0x400380007ff97ffb",
            "0x482680017ff98000",
            "0x2",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x27ae98c4d8558d514da5e6b3eca8e93ec139ddc1388d4e2e80684a991eb4452",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff91",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff8b",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x480680017fff8000",
            "0x3b28019ccfdbd30ffc65951d94bb85c9e2b8434111a000b5afd533ce65f57a4",
            "0x208b7fff7fff7ffe",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffffa",
            "0x480a7ffb7fff8000",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff73",
            "0x48127ffe7fff8000",
            "0x48127ff57fff8000",
            "0x48127ff57fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffed",
            "0x480a7ffa7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff6d",
            "0x48127ff67fff8000",
            "0x48127ff67fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff58",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff4e",
            "0x40127fff7fff7ff9",
            "0x48127ffe7fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff6",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffe7fff8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffce",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff91",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x1",
            "0x4003800080007ffc",
            "0x4826800180008000",
            "0x1",
            "0x480a7ffd7fff8000",
            "0x4828800080007ffe",
            "0x480a80007fff8000",
            "0x208b7fff7fff7ffe",
            "0x402b7ffd7ffc7ffd",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffee",
            "0x48127ffe7fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffb7fff8000",
            "0x480280037ffb8000",
            "0x48127ffa7fff8000",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffab",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff9a",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff1",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a7ffd7fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff80",
            "0x208b7fff7fff7ffe",
            "0x482680017ffd8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffff3",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x480280037ffb8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480a7ff77fff8000",
            "0x480a7ff87fff8000",
            "0x480a7ff97fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff5a",
            "0x480a7ffa7fff8000",
            "0x480a7ffb7fff8000",
            "0x48127ffd7fff8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff2b",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ff47fff8000",
            "0x48127ffc7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280017ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x2",
            "0x480280017ffd8000",
            "0x48307fff7ffe8000",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x1",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x480280017ffd8000",
            "0x482680017ffd8000",
            "0x2",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffde",
            "0x40780017fff7fff",
            "0x1",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x48127ffb7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x48127ffa7fff8000",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0xf",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe89",
            "0x480a7ff57fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeb1",
            "0x40137fff7fff8000",
            "0x48127ffe7fff8000",
            "0x480a7ff67fff8000",
            "0x480a7ff77fff8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff05",
            "0x40137fff7fff8001",
            "0x40137ffd7fff8002",
            "0x40137ffe7fff8003",
            "0x400b80017fff7ffd",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe62",
            "0x40137fff7fff8004",
            "0x48127ff97fff8000",
            "0x480a7ff97fff8000",
            "0x480a7ffa7fff8000",
            "0x480a7ffc7fff8000",
            "0x480a80047fff8000",
            "0x1104800180018000",
            "0x6f",
            "0x4003800180008005",
            "0x400b7ff97fff8006",
            "0x400b80047fff8007",
            "0x400b80017fff8008",
            "0x4003800280008009",
            "0x400380008000800a",
            "0x480a80027fff8000",
            "0x480a80037fff8000",
            "0x480a7ff87fff8000",
            "0x4802800580008000",
            "0x4802800380008000",
            "0x4802800480008000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffab",
            "0x40137fff7fff800b",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x48127ffc7fff8000",
            "0x4826800180018000",
            "0x1",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffeee",
            "0x40137ffe7fff800c",
            "0x40137fff7fff800d",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe40",
            "0x40137fff7fff800e",
            "0x48127ffa7fff8000",
            "0x480a80067fff8000",
            "0x480a80077fff8000",
            "0x480a800e7fff8000",
            "0x1104800180018000",
            "0x2c",
            "0x48127ffe7fff8000",
            "0x480a800c7fff8000",
            "0x480a800d7fff8000",
            "0x480a800b7fff8000",
            "0x48127ffb7fff8000",
            "0x480a800e7fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280027ffb8000",
            "0x480280007ffd8000",
            "0x400080007ffe7fff",
            "0x482680017ffd8000",
            "0x1",
            "0x480280007ffd8000",
            "0x484480017fff8000",
            "0x4",
            "0x48307fff7ffd8000",
            "0x480280027ffb8000",
            "0x480080007ffe8000",
            "0x400080017ffe7fff",
            "0x482480017ffd8000",
            "0x1",
            "0x480080007ffc8000",
            "0x48307fff7ffe8000",
            "0x482480017fff8000",
            "0x1",
            "0x402a7ffd7ffc7fff",
            "0x480280027ffb8000",
            "0x480280007ffb8000",
            "0x480280017ffb8000",
            "0x482480017ffd8000",
            "0x2",
            "0x480280037ffb8000",
            "0x480280007ffd8000",
            "0x482680017ffd8000",
            "0x1",
            "0x480080007ff28000",
            "0x482480017ff18000",
            "0x1",
            "0x480080007ff58000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffff9e",
            "0x208b7fff7fff7ffe",
            "0x40780017fff7fff",
            "0x3",
            "0x20780017fff7ffb",
            "0x6",
            "0x480a7ffa7fff8000",
            "0x480680017fff8000",
            "0x0",
            "0x208b7fff7fff7ffe",
            "0x480a7ffa7fff8000",
            "0x480280007ffc8000",
            "0x480280017ffc8000",
            "0x480280027ffc8000",
            "0x480280037ffc8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe19",
            "0x40137ffe7fff8000",
            "0x40137fff7fff8001",
            "0x40137ffd7fff8002",
            "0x480a7ffd7fff8000",
            "0x480a80017fff8000",
            "0x480a80007fff8000",
            "0x1104800180018000",
            "0x800000000000010fffffffffffffffffffffffffffffffffffffffffffffe01",
            "0x480a80027fff8000",
            "0x482680017ffb8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffc8000",
            "0x4",
            "0x482a80007ffd8000",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffe4",
            "0x48127ffe7fff8000",
            "0x482880007ffe8000",
            "0x208b7fff7fff7ffe",
            "0x20780017fff7ffa",
            "0x4",
            "0x480a7ff97fff8000",
            "0x208b7fff7fff7ffe",
            "0x480280007ffb8000",
            "0x400280007ffd7fff",
            "0x480280017ffb8000",
            "0x400280017ffd7fff",
            "0x480280037ffb8000",
            "0x400280027ffd7fff",
            "0x480280027ffb8000",
            "0x48327fff7ffc8000",
            "0x400280037ffd7fff",
            "0x480a7ff97fff8000",
            "0x482680017ffa8000",
            "0x800000000000011000000000000000000000000000000000000000000000000",
            "0x482680017ffb8000",
            "0x4",
            "0x480a7ffc7fff8000",
            "0x482680017ffd8000",
            "0x4",
            "0x1104800180018000",
            "0x800000000000010ffffffffffffffffffffffffffffffffffffffffffffffec",
            "0x208b7fff7fff7ffe"
        ],
        "debug_info": {
            "file_contents": {
                "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo": "assert [cast(fp + (-4), felt*)] = __calldata_actual_size\n",
                "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo": "let __calldata_arg_call_array_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/2af83e2ace09380d3be2e1d366c8649a74753b790c9d2b5e425bfdf350d70145.cairo": "let __calldata_arg_nonce = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/4f07c4ae795d22b6bc4426e596637ee88f870711dc3768dd8178092f4b2c0b65.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_calldata_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_calldata = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_calldata_len * 1\n",
                "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo": "let __calldata_actual_size =  __calldata_ptr - cast([cast(fp + (-3), felt**)], felt*)\n",
                "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo": "let __calldata_arg__public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/8799496fe2567340f6719cfd30d7db5f6b8e7aa420ca97e3a3c3ccbdfbb2e674.cairo": "let __calldata_arg_calldata_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo": "let __calldata_arg_new_public_key = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_signature_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_signature = cast(__calldata_ptr, felt*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_signature_len * 1\n",
                "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo": "# Check that the length is non-negative.\nassert [range_check_ptr] = __calldata_arg_call_array_len\nlet range_check_ptr = range_check_ptr + 1\n# Create the reference.\nlet __calldata_arg_call_array = cast(__calldata_ptr, __main__.CallArray*)\n# Use 'tempvar' instead of 'let' to avoid repeating this computation for the\n# following arguments.\ntempvar __calldata_ptr = __calldata_ptr + __calldata_arg_call_array_len * 4\n",
                "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo": "let __calldata_arg_signature_len = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo": "let __calldata_arg_hash = [__calldata_ptr]\nlet __calldata_ptr = __calldata_ptr + 1\n",
                "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo": "assert [__return_value_ptr] = ret_struct.res\nlet __return_value_ptr = __return_value_ptr + 1\n",
                "autogen/starknet/external/__execute__/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/__execute__/96615a8ea9357ac528fc65da036ae8e3b8fe749a26f2e0e28ab89b0369039712.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(call_array_len=__calldata_arg_call_array_len, call_array=__calldata_arg_call_array, calldata_len=__calldata_arg_calldata_len, calldata=__calldata_arg_calldata, nonce=__calldata_arg_nonce,)\nlet retdata_size = ret_struct.retdata_size\nlet retdata = ret_struct.retdata\n",
                "autogen/starknet/external/__execute__/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/__execute__/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/__execute__/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/__execute__/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/assert_only_self/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/assert_only_self/6629798b6d541e54a9dc778ffa54e7ef20b4f98b088671dd5070b7e0b547f0e6.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, felt*)]\n",
                "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/assert_only_self/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr}()\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/assert_only_self/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/constructor/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/constructor/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(_public_key=__calldata_arg__public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/constructor/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/constructor/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_nonce/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_nonce/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_nonce_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_nonce/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_nonce/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/get_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/get_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}()\nlet (range_check_ptr, retdata_size, retdata) = get_public_key_encode_return(ret_struct, range_check_ptr)\n",
                "autogen/starknet/external/get_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/get_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, starkware.cairo.common.cairo_builtins.SignatureBuiltin**)]\n",
                "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr, ecdsa_ptr=ecdsa_ptr}(hash=__calldata_arg_hash, signature_len=__calldata_arg_signature_len, signature=__calldata_arg_signature,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo": "func get_nonce_encode_return(ret_struct : __main__.get_nonce.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo": "func get_public_key_encode_return(ret_struct : __main__.get_public_key.Return, range_check_ptr) -> (\n        range_check_ptr, data_len : felt, data : felt*):\n    %{ memory[ap] = segments.add() %}\n    alloc_locals\n    local __return_value_ptr_start : felt*\n    let __return_value_ptr = __return_value_ptr_start\n    with range_check_ptr:\n    end\n    return (\n        range_check_ptr=range_check_ptr,\n        data_len=__return_value_ptr - __return_value_ptr_start,\n        data=__return_value_ptr_start)\nend\n",
                "autogen/starknet/external/set_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo": "let ecdsa_ptr = [cast([cast(fp + (-5), felt**)] + 3, felt*)]\n",
                "autogen/starknet/external/set_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo": "let pedersen_ptr = [cast([cast(fp + (-5), felt**)] + 1, starkware.cairo.common.cairo_builtins.HashBuiltin**)]\n",
                "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo": "let ret_struct = __wrapped_func{syscall_ptr=syscall_ptr, pedersen_ptr=pedersen_ptr, range_check_ptr=range_check_ptr}(new_public_key=__calldata_arg_new_public_key,)\n%{ memory[ap] = segments.add() %}        # Allocate memory for return value.\ntempvar retdata : felt*\nlet retdata_size = 0\n",
                "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo": "return (syscall_ptr,pedersen_ptr,range_check_ptr,ecdsa_ptr,retdata_size,retdata)\n",
                "autogen/starknet/external/set_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo": "let syscall_ptr = [cast([cast(fp + (-5), felt**)] + 0, felt**)]\n",
                "autogen/starknet/external/set_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo": "let range_check_ptr = [cast([cast(fp + (-5), felt**)] + 2, felt*)]\n",
                "autogen/starknet/storage_var/current_nonce/decl.cairo": "namespace current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/current_nonce/impl.cairo": "namespace current_nonce:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 1121792928524733500499566223253557009588599140926682212728477813437029368914\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend",
                "autogen/starknet/storage_var/public_key/decl.cairo": "namespace public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 0\n        call hash2\n        call normalize_address\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let storage_addr = 0\n        call addr\n        call storage_read\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let storage_addr = 0\n        call addr\n        call storage_write\n    end\nend",
                "autogen/starknet/storage_var/public_key/impl.cairo": "namespace public_key:\n    from starkware.starknet.common.storage import normalize_address\n    from starkware.starknet.common.syscalls import storage_read, storage_write\n    from starkware.cairo.common.cairo_builtins import HashBuiltin\n    from starkware.cairo.common.hash import hash2\n\n    func addr{pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let res = 1672321442399497129215646424919402195095307045612040218489019266998007191460\n        return (res=res)\n    end\n\n    func read{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}() -> (res : felt):\n        let (storage_addr) = addr()\n        let (__storage_var_temp0) = storage_read(address=storage_addr + 0)\n\n        tempvar syscall_ptr = syscall_ptr\n        tempvar pedersen_ptr = pedersen_ptr\n        tempvar range_check_ptr = range_check_ptr\n        tempvar __storage_var_temp0 : felt = __storage_var_temp0\n        return ([cast(&__storage_var_temp0, felt*)])\n    end\n\n    func write{syscall_ptr : felt*, pedersen_ptr : HashBuiltin*, range_check_ptr}(value : felt):\n        let (storage_addr) = addr()\n        storage_write(address=storage_addr + 0, value=[cast(&value, felt) + 0])\n        return ()\n    end\nend"
            },
            "instruction_locations": {
                "0": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/alloc.cairo"
                                },
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 12,
                        "end_line": 4,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "2": {
                    "accessible_scopes": [
                        "starkware.cairo.common.alloc",
                        "starkware.cairo.common.alloc.alloc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 0,
                            "offset": 1
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 5,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/alloc.cairo"
                        },
                        "start_col": 5,
                        "start_line": 5
                    }
                },
                "3": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "4": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 2,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 19,
                        "end_line": 15,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 15
                    }
                },
                "5": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 18
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 17
                    }
                },
                "7": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 16,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 18,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                                },
                                "start_col": 20,
                                "start_line": 18
                            },
                            "While expanding the reference 'result' in:"
                        ],
                        "start_col": 18,
                        "start_line": 16
                    }
                },
                "8": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash",
                        "starkware.cairo.common.hash.hash2"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 1,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash.hash2.hash_ptr": 4,
                            "starkware.cairo.common.hash.hash2.result": 3,
                            "starkware.cairo.common.hash.hash2.x": 0,
                            "starkware.cairo.common.hash.hash2.y": 1
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "start_col": 5,
                        "start_line": 18
                    }
                },
                "9": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 8,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 8
                    }
                },
                "11": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 9,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "12": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 41,
                                "end_line": 12,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 12
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 35,
                                "start_line": 13
                            },
                            "While expanding the reference 'dst' in:"
                        ],
                        "start_col": 13,
                        "start_line": 2
                    }
                },
                "13": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 2,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 44,
                                "start_line": 13
                            },
                            "While expanding the reference 'src' in:"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "14": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 26,
                        "start_line": 17
                    }
                },
                "15": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "16": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "18": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 23,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 23
                    }
                },
                "20": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 7,
                                "end_line": 27,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 24
                            },
                            "n_prefix_newlines": 1
                        }
                    ],
                    "inst": {
                        "end_col": 44,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 29
                    }
                },
                "22": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 31
                    }
                },
                "23": {
                    "accessible_scopes": [
                        "starkware.cairo.common.memcpy",
                        "starkware.cairo.common.memcpy.memcpy"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 2,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.memcpy.memcpy.__temp0": 10,
                            "starkware.cairo.common.memcpy.memcpy.continue_copying": 11,
                            "starkware.cairo.common.memcpy.memcpy.dst": 5,
                            "starkware.cairo.common.memcpy.memcpy.frame": 9,
                            "starkware.cairo.common.memcpy.memcpy.len": 7,
                            "starkware.cairo.common.memcpy.memcpy.next_frame": 12,
                            "starkware.cairo.common.memcpy.memcpy.src": 6
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 26,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                                },
                                "start_col": 5,
                                "start_line": 33
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 14,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/memcpy.cairo"
                        },
                        "start_col": 5,
                        "start_line": 34
                    }
                },
                "24": {
                    "accessible_scopes": [
                        "starkware.cairo.lang.compiler.lib.registers",
                        "starkware.cairo.lang.compiler.lib.registers.get_fp_and_pc"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 3,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 6,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/lang/compiler/lib/registers.cairo"
                        },
                        "start_col": 5,
                        "start_line": 6
                    }
                },
                "25": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 47,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 47
                    }
                },
                "27": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "28": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "29": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "30": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "31": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 17
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 46
                    }
                },
                "32": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 52,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 52
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 55,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 42,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 42
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 55
                    }
                },
                "34": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 26,
                        "start_line": 56
                    }
                },
                "35": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 57,
                        "start_line": 56
                    }
                },
                "36": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.call_contract"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 4,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.call_contract.__temp1": 19,
                            "starkware.starknet.common.syscalls.call_contract.calldata": 16,
                            "starkware.starknet.common.syscalls.call_contract.calldata_size": 15,
                            "starkware.starknet.common.syscalls.call_contract.contract_address": 13,
                            "starkware.starknet.common.syscalls.call_contract.function_selector": 14,
                            "starkware.starknet.common.syscalls.call_contract.response": 20,
                            "starkware.starknet.common.syscalls.call_contract.syscall": 18,
                            "starkware.starknet.common.syscalls.call_contract.syscall_ptr": 21
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 56
                    }
                },
                "37": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 22
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 90,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 63,
                        "start_line": 114
                    }
                },
                "39": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 22
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 91,
                        "end_line": 114,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 114
                    }
                },
                "40": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 93,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 115
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 58,
                        "end_line": 116,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 112,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 60,
                                        "end_line": 117,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 117
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 112
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 116
                    }
                },
                "42": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 117,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 28,
                        "start_line": 117
                    }
                },
                "43": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_caller_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 5,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_caller_address.__temp2": 24,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall": 23,
                            "starkware.starknet.common.syscalls.get_caller_address.syscall_ptr": 25
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 60,
                        "end_line": 117,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 117
                    }
                },
                "44": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 26
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 188,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 65,
                        "start_line": 188
                    }
                },
                "46": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 26
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 188,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 188
                    }
                },
                "47": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 95,
                                "end_line": 189,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 189
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 60,
                        "end_line": 190,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 191,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 191
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 186
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 190
                    }
                },
                "49": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 191,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 30,
                        "start_line": 191
                    }
                },
                "50": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_contract_address"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 6,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_contract_address.__temp3": 28,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall": 27,
                            "starkware.starknet.common.syscalls.get_contract_address.syscall_ptr": 29
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 191,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 191
                    }
                },
                "51": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 58,
                        "start_line": 266
                    }
                },
                "53": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp4": 33,
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 266
                    }
                },
                "54": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp4": 33,
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 31
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 97,
                        "end_line": 266,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 266
                    }
                },
                "55": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp4": 33,
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.response": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 87,
                                "end_line": 267,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 267
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 53,
                        "end_line": 269,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 270,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 270
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 269
                    }
                },
                "57": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp4": 33,
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.response": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 19,
                        "start_line": 270
                    }
                },
                "58": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 7,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_read.__temp4": 33,
                            "starkware.starknet.common.syscalls.storage_read.address": 30,
                            "starkware.starknet.common.syscalls.storage_read.response": 34,
                            "starkware.starknet.common.syscalls.storage_read.syscall": 32,
                            "starkware.starknet.common.syscalls.storage_read.syscall_ptr": 35
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 270,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 270
                    }
                },
                "59": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 38,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 18,
                        "start_line": 284
                    }
                },
                "61": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp5": 39,
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 38,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "62": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp5": 39,
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 38,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "63": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp5": 39,
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 38,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 284,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 283
                    }
                },
                "64": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp5": 39,
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 40,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 88,
                                "end_line": 285,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 285
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 54,
                        "end_line": 286,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 287,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 287
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 286
                    }
                },
                "66": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.storage_write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 8,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.storage_write.__temp5": 39,
                            "starkware.starknet.common.syscalls.storage_write.address": 36,
                            "starkware.starknet.common.syscalls.storage_write.syscall_ptr": 40,
                            "starkware.starknet.common.syscalls.storage_write.value": 37
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 287,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 287
                    }
                },
                "67": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 42,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 76,
                        "end_line": 353,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 56,
                        "start_line": 353
                    }
                },
                "69": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp6": 43,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 42,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 41
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 77,
                        "end_line": 353,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 353
                    }
                },
                "70": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp6": 43,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 44,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 42,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 45
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 86,
                                "end_line": 354,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "start_col": 5,
                                "start_line": 354
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 51,
                        "end_line": 356,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 351,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 357,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 357
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 351
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 356
                    }
                },
                "72": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp6": 43,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 44,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 42,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 45
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 357,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 21,
                        "start_line": 357
                    }
                },
                "73": {
                    "accessible_scopes": [
                        "starkware.starknet.common.syscalls",
                        "starkware.starknet.common.syscalls.get_tx_info"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 9,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.starknet.common.syscalls.get_tx_info.__temp6": 43,
                            "starkware.starknet.common.syscalls.get_tx_info.response": 44,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall": 42,
                            "starkware.starknet.common.syscalls.get_tx_info.syscall_ptr": 45
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 357,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "start_col": 5,
                        "start_line": 357
                    }
                },
                "74": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 0
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 17,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 17
                    }
                },
                "76": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 2
                        },
                        "reference_ids": {}
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 18,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 18
                    }
                },
                "78": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 46,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 47
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 32,
                        "end_line": 20,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 20
                    }
                },
                "80": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 46,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 47
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 21,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 21
                    }
                },
                "82": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 46,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 47
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 19,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 22,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 29,
                                "start_line": 22
                            },
                            "While expanding the reference 'hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 19
                    }
                },
                "83": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_init"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 10,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_init.__fp__": 46,
                            "starkware.cairo.common.hash_state.hash_init.hash_state": 47
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 22,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 22
                    }
                },
                "84": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 31,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 31
                    }
                },
                "86": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 41,
                        "end_line": 28,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 62,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 86,
                                        "end_line": 33,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 32
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 62
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 28
                    }
                },
                "87": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 18,
                                "start_line": 33
                            },
                            "While expanding the reference 'data_ptr' in:"
                        ],
                        "start_col": 38,
                        "start_line": 29
                    }
                },
                "88": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 29,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 51,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 40,
                                "start_line": 33
                            },
                            "While expanding the reference 'data_length' in:"
                        ],
                        "start_col": 56,
                        "start_line": 29
                    }
                },
                "89": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 58,
                        "start_line": 33
                    }
                },
                "90": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 11,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 51,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 33,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 32
                    }
                },
                "92": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 34,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 34
                    }
                },
                "94": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 36,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 36
                    }
                },
                "95": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 37
                    }
                },
                "96": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.__temp7": 56,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 37,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 37
                    }
                },
                "97": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.__temp7": 56,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 62,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 33,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 41,
                                        "end_line": 28,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 38,
                                                "input_file": {
                                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 38
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 18,
                                        "start_line": 28
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 32
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 62
                    }
                },
                "98": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.__temp7": 56,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 35,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 38,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 38
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 35
                    }
                },
                "99": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 12,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update.__fp__": 54,
                            "starkware.cairo.common.hash_state.hash_update.__temp7": 56,
                            "starkware.cairo.common.hash_state.hash_update.data_length": 50,
                            "starkware.cairo.common.hash_state.hash_update.data_ptr": 49,
                            "starkware.cairo.common.hash_state.hash_update.hash": 53,
                            "starkware.cairo.common.hash_state.hash_update.hash_ptr": 52,
                            "starkware.cairo.common.hash_state.hash_update.hash_state_ptr": 48,
                            "starkware.cairo.common.hash_state.hash_update.new_hash_state": 55
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 38,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 38
                    }
                },
                "100": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 59,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 45,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 45
                    }
                },
                "102": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 59,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 43,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 62,
                                        "end_line": 46,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 46
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 43
                    }
                },
                "103": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 59,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 46,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 26,
                        "start_line": 46
                    }
                },
                "104": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 59,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 43,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 61,
                                "end_line": 46,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 57,
                                "start_line": 46
                            },
                            "While expanding the reference 'item' in:"
                        ],
                        "start_col": 79,
                        "start_line": 43
                    }
                },
                "105": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 59,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 62,
                        "end_line": 46,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 18,
                        "start_line": 46
                    }
                },
                "107": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 47,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 23,
                        "start_line": 47
                    }
                },
                "109": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 49,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 49
                    }
                },
                "110": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 11
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 50
                    }
                },
                "111": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp8": 64,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 50,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 50
                    }
                },
                "113": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 12
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp8": 64,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 62,
                                "end_line": 46,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 43,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 51,
                                                "input_file": {
                                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 51
                                            },
                                            "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 43
                                    },
                                    "While expanding the reference 'hash_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 46
                            },
                            "While trying to update the implicit return value 'hash_ptr' in:"
                        ],
                        "start_col": 12,
                        "start_line": 13
                    }
                },
                "114": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 13
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp8": 64,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 48,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 51,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 33,
                                "start_line": 51
                            },
                            "While expanding the reference 'new_hash_state' in:"
                        ],
                        "start_col": 11,
                        "start_line": 48
                    }
                },
                "115": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_single"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 13,
                            "offset": 14
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_single.__fp__": 62,
                            "starkware.cairo.common.hash_state.hash_update_single.__temp8": 64,
                            "starkware.cairo.common.hash_state.hash_update_single.hash": 61,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_ptr": 60,
                            "starkware.cairo.common.hash_state.hash_update_single.hash_state_ptr": 57,
                            "starkware.cairo.common.hash_state.hash_update_single.item": 58,
                            "starkware.cairo.common.hash_state.hash_update_single.new_hash_state": 63
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 51,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 51
                    }
                },
                "116": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 65
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 55,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 56,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 12,
                                        "start_line": 56
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 12,
                                "start_line": 13
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 20,
                        "start_line": 55
                    }
                },
                "117": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 65
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 20,
                        "start_line": 56
                    }
                },
                "118": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 65
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 51,
                        "start_line": 56
                    }
                },
                "119": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 66,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 65
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 12,
                        "start_line": 56
                    }
                },
                "121": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_finalize"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 14,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_finalize.hash_ptr": 67,
                            "starkware.cairo.common.hash_state.hash_finalize.hash_state_ptr": 65
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 56,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 56
                    }
                },
                "122": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 7,
                        "end_line": 64,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 64
                    }
                },
                "124": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 62,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 47,
                                "end_line": 62,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 27,
                                        "end_line": 65,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 65
                                    },
                                    "While trying to retrieve the implicit argument 'hash_ptr' in:"
                                ],
                                "start_col": 24,
                                "start_line": 62
                            },
                            "While expanding the reference 'hash_ptr' in:"
                        ],
                        "start_col": 24,
                        "start_line": 62
                    }
                },
                "125": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 63,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                                },
                                "start_col": 22,
                                "start_line": 65
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 47,
                        "start_line": 63
                    }
                },
                "126": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 65,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 9,
                        "start_line": 65
                    }
                },
                "127": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 69,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 69
                    }
                },
                "129": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 70,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 35,
                        "start_line": 70
                    }
                },
                "131": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 70,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 70
                    }
                },
                "132": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 2
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 79,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 79
                    }
                },
                "133": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 3
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 80,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 80
                    }
                },
                "134": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 4
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 81,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 81
                    }
                },
                "135": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 5
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 72,
                        "end_line": 86,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 36,
                        "start_line": 86
                    }
                },
                "136": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 89,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 89
                    }
                },
                "137": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 6
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 37,
                        "start_line": 90
                    }
                },
                "138": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 90,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 90
                    }
                },
                "139": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 7
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 78,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 94,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 94
                    }
                },
                "141": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 8
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 78,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 95,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 95
                    }
                },
                "143": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 9
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 78,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 96,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 96
                    }
                },
                "144": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 71,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 78,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 47,
                        "end_line": 99,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 99
                    }
                },
                "146": {
                    "accessible_scopes": [
                        "starkware.cairo.common.hash_state",
                        "starkware.cairo.common.hash_state.hash_update_inner"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 15,
                            "offset": 10
                        },
                        "reference_ids": {
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp10": 77,
                            "starkware.cairo.common.hash_state.hash_update_inner.__temp9": 72,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_last_ptr": 73,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_length": 69,
                            "starkware.cairo.common.hash_state.hash_update_inner.data_ptr": 68,
                            "starkware.cairo.common.hash_state.hash_update_inner.final_locals": 79,
                            "starkware.cairo.common.hash_state.hash_update_inner.first_locals": 74,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash": 70,
                            "starkware.cairo.common.hash_state.hash_update_inner.hash_ptr": 80,
                            "starkware.cairo.common.hash_state.hash_update_inner.n_remaining_elements": 76,
                            "starkware.cairo.common.hash_state.hash_update_inner.next_locals": 78,
                            "starkware.cairo.common.hash_state.hash_update_inner.prev_locals": 75
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 104,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/hash_state.cairo"
                        },
                        "start_col": 5,
                        "start_line": 104
                    }
                },
                "147": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 85,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 81,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 82,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 83,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 84
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 98,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                                },
                                "start_col": 5,
                                "start_line": 9
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 39,
                        "end_line": 10,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 10
                    }
                },
                "148": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 85,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 81,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 82,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 83,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 11,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 11
                    }
                },
                "149": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 0
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 86,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 81,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 82,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 83,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 54,
                        "end_line": 13,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 14,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 13
                    }
                },
                "151": {
                    "accessible_scopes": [
                        "starkware.cairo.common.signature",
                        "starkware.cairo.common.signature.verify_ecdsa_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 16,
                            "offset": 1
                        },
                        "reference_ids": {
                            "starkware.cairo.common.signature.verify_ecdsa_signature.ecdsa_ptr": 86,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.message": 81,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.public_key": 82,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_r": 83,
                            "starkware.cairo.common.signature.verify_ecdsa_signature.signature_s": 84
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 14,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                        },
                        "start_col": 5,
                        "start_line": 14
                    }
                },
                "152": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 87,
                            "__main__.current_nonce.addr.range_check_ptr": 88,
                            "__main__.current_nonce.addr.res": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "153": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 87,
                            "__main__.current_nonce.addr.range_check_ptr": 88,
                            "__main__.current_nonce.addr.res": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "154": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 87,
                            "__main__.current_nonce.addr.range_check_ptr": 88,
                            "__main__.current_nonce.addr.res": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "156": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 17,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.current_nonce.addr.pedersen_ptr": 87,
                            "__main__.current_nonce.addr.range_check_ptr": 88,
                            "__main__.current_nonce.addr.res": 89
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "157": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 91,
                            "__main__.current_nonce.read.range_check_ptr": 92,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "158": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 91,
                            "__main__.current_nonce.read.range_check_ptr": 92,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "159": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 91,
                            "__main__.current_nonce.read.range_check_ptr": 92,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "161": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 93,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "162": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 93,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "163": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.pedersen_ptr": 93,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 90
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "165": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 97,
                            "__main__.current_nonce.read.pedersen_ptr": 93,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 96
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 264,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 264
                    }
                },
                "166": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 97,
                            "__main__.current_nonce.read.pedersen_ptr": 93,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 98
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "167": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 97,
                            "__main__.current_nonce.read.pedersen_ptr": 99,
                            "__main__.current_nonce.read.range_check_ptr": 94,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 98
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "168": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 97,
                            "__main__.current_nonce.read.pedersen_ptr": 99,
                            "__main__.current_nonce.read.range_check_ptr": 100,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 98
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "169": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 18,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.current_nonce.read.__storage_var_temp0": 101,
                            "__main__.current_nonce.read.pedersen_ptr": 99,
                            "__main__.current_nonce.read.range_check_ptr": 100,
                            "__main__.current_nonce.read.storage_addr": 95,
                            "__main__.current_nonce.read.syscall_ptr": 98
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "170": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 104,
                            "__main__.current_nonce.write.range_check_ptr": 105,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "171": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 104,
                            "__main__.current_nonce.write.range_check_ptr": 105,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "172": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 104,
                            "__main__.current_nonce.write.range_check_ptr": 105,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "174": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "175": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "176": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "177": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 103,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "179": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 109,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "180": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 109,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "181": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.current_nonce",
                        "__main__.current_nonce.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 19,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.current_nonce.write.pedersen_ptr": 106,
                            "__main__.current_nonce.write.range_check_ptr": 107,
                            "__main__.current_nonce.write.storage_addr": 108,
                            "__main__.current_nonce.write.syscall_ptr": 109,
                            "__main__.current_nonce.write.value": 102
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "182": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 110,
                            "__main__.public_key.addr.range_check_ptr": 111,
                            "__main__.public_key.addr.res": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "183": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 110,
                            "__main__.public_key.addr.range_check_ptr": 111,
                            "__main__.public_key.addr.res": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 25,
                                        "end_line": 9,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 9
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "184": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 110,
                            "__main__.public_key.addr.range_check_ptr": 111,
                            "__main__.public_key.addr.res": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 9,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 21,
                                "start_line": 9
                            },
                            "While expanding the reference 'res' in:"
                        ],
                        "start_col": 19,
                        "start_line": 8
                    }
                },
                "186": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.addr"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 20,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.public_key.addr.pedersen_ptr": 110,
                            "__main__.public_key.addr.range_check_ptr": 111,
                            "__main__.public_key.addr.res": 112
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 9,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 9
                    }
                },
                "187": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 114,
                            "__main__.public_key.read.range_check_ptr": 115,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 12
                    }
                },
                "188": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 114,
                            "__main__.public_key.read.range_check_ptr": 115,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 13
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 12
                    }
                },
                "189": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 114,
                            "__main__.public_key.read.range_check_ptr": 115,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 13
                    }
                },
                "191": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 116,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 264,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 75,
                                        "end_line": 14,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 37,
                                        "start_line": 14
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 19,
                                "start_line": 264
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 12
                    }
                },
                "192": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 116,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 70,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 58,
                                "start_line": 14
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 13
                    }
                },
                "193": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.public_key.read.pedersen_ptr": 116,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 113
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 37,
                        "start_line": 14
                    }
                },
                "195": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 120,
                            "__main__.public_key.read.pedersen_ptr": 116,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 119
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 264,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 75,
                                "end_line": 14,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 16,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 31,
                                        "start_line": 16
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 14
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 264
                    }
                },
                "196": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 120,
                            "__main__.public_key.read.pedersen_ptr": 116,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 17,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 32,
                                        "start_line": 17
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "197": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 120,
                            "__main__.public_key.read.pedersen_ptr": 122,
                            "__main__.public_key.read.range_check_ptr": 117,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 50,
                                        "end_line": 18,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 35,
                                        "start_line": 18
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 13
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "198": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 120,
                            "__main__.public_key.read.pedersen_ptr": 122,
                            "__main__.public_key.read.range_check_ptr": 123,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 33,
                        "end_line": 14,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 46,
                                "start_line": 19
                            },
                            "While expanding the reference '__storage_var_temp0' in:"
                        ],
                        "start_col": 14,
                        "start_line": 14
                    }
                },
                "199": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.read"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 21,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.public_key.read.__storage_var_temp0": 124,
                            "__main__.public_key.read.pedersen_ptr": 122,
                            "__main__.public_key.read.range_check_ptr": 123,
                            "__main__.public_key.read.storage_addr": 118,
                            "__main__.public_key.read.syscall_ptr": 121
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 20,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 20
                    }
                },
                "200": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 127,
                            "__main__.public_key.write.range_check_ptr": 128,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 7
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 23
                    }
                },
                "201": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 127,
                            "__main__.public_key.write.range_check_ptr": 128,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 59,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 24,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 30,
                                        "start_line": 24
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 44,
                                "start_line": 7
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 23
                    }
                },
                "202": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 127,
                            "__main__.public_key.write.range_check_ptr": 128,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 36,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 30,
                        "start_line": 24
                    }
                },
                "204": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 23,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 39,
                                "end_line": 282,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 25,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                        },
                                        "start_col": 9,
                                        "start_line": 25
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 282
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 23
                    }
                },
                "205": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 24,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 25,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "start_col": 31,
                                "start_line": 25
                            },
                            "While expanding the reference 'storage_addr' in:"
                        ],
                        "start_col": 14,
                        "start_line": 24
                    }
                },
                "206": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 79,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 55,
                        "start_line": 25
                    }
                },
                "207": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 126,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 25,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 25
                    }
                },
                "209": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 14
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 132,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 7
                    }
                },
                "210": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 132,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 7,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 24,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 18,
                                                "end_line": 26,
                                                "input_file": {
                                                    "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                                                },
                                                "start_col": 9,
                                                "start_line": 26
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 24
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 44,
                        "start_line": 7
                    }
                },
                "211": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__.public_key",
                        "__main__.public_key.write"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 22,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.public_key.write.pedersen_ptr": 129,
                            "__main__.public_key.write.range_check_ptr": 130,
                            "__main__.public_key.write.storage_addr": 131,
                            "__main__.public_key.write.syscall_ptr": 132,
                            "__main__.public_key.write.value": 125
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 18,
                        "end_line": 26,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/impl.cairo"
                        },
                        "start_col": 9,
                        "start_line": 26
                    }
                },
                "212": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.syscall_ptr": 133
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 63,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 46,
                                "end_line": 186,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 64,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 18,
                                        "start_line": 64
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 27,
                                "start_line": 186
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 23,
                        "start_line": 63
                    }
                },
                "213": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.syscall_ptr": 133
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 64,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 18,
                        "start_line": 64
                    }
                },
                "215": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.self": 135,
                            "__main__.assert_only_self.syscall_ptr": 134
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 46,
                        "end_line": 186,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 64,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 44,
                                        "end_line": 112,
                                        "input_file": {
                                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 40,
                                                "end_line": 65,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 20,
                                                "start_line": 65
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 25,
                                        "start_line": 112
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 64
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 27,
                        "start_line": 186
                    }
                },
                "216": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.self": 135,
                            "__main__.assert_only_self.syscall_ptr": 134
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 65,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 20,
                        "start_line": 65
                    }
                },
                "218": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 137,
                            "__main__.assert_only_self.self": 135,
                            "__main__.assert_only_self.syscall_ptr": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 25,
                        "end_line": 66,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 66
                    }
                },
                "219": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 137,
                            "__main__.assert_only_self.self": 135,
                            "__main__.assert_only_self.syscall_ptr": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 112,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 65,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 63,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 67,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 67
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 23,
                                        "start_line": 63
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 20,
                                "start_line": 65
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 25,
                        "start_line": 112
                    }
                },
                "220": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 23,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__main__.assert_only_self.caller": 137,
                            "__main__.assert_only_self.self": 135,
                            "__main__.assert_only_self.syscall_ptr": 136
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 67,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 67
                    }
                },
                "221": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.syscall_ptr": 138
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "222": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.syscall_ptr": 138
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 23,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "223": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.syscall_ptr": 138
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 63,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 63
                    }
                },
                "225": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 22,
                                        "end_line": 63,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 63
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "227": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "228": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/6629798b6d541e54a9dc778ffa54e7ef20b4f98b088671dd5070b7e0b547f0e6.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "229": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 19
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "230": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 20
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "231": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 21
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "233": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 22
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/e538c42e4fe9bc663516f047868cebc5104dc82759dbeae927bc19c814d35418.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 22,
                                                "end_line": 63,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 63
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "234": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.assert_only_self"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 24,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__wrappers__.assert_only_self.__calldata_actual_size": 143,
                            "__wrappers__.assert_only_self.__calldata_ptr": 142,
                            "__wrappers__.assert_only_self.ecdsa_ptr": 141,
                            "__wrappers__.assert_only_self.pedersen_ptr": 139,
                            "__wrappers__.assert_only_self.range_check_ptr": 140,
                            "__wrappers__.assert_only_self.ret_struct": 145,
                            "__wrappers__.assert_only_self.retdata": 146,
                            "__wrappers__.assert_only_self.retdata_size": 147,
                            "__wrappers__.assert_only_self.syscall_ptr": 144
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/assert_only_self/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 22,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 63
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "235": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 149,
                            "__main__.get_public_key.range_check_ptr": 150,
                            "__main__.get_public_key.syscall_ptr": 148
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 75,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 77,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 77
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 75
                    }
                },
                "236": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 149,
                            "__main__.get_public_key.range_check_ptr": 150,
                            "__main__.get_public_key.syscall_ptr": 148
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 69,
                        "end_line": 75,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 77,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 77
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 42,
                        "start_line": 75
                    }
                },
                "237": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 149,
                            "__main__.get_public_key.range_check_ptr": 150,
                            "__main__.get_public_key.syscall_ptr": 148
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 75,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 77,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 77
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 71,
                        "start_line": 75
                    }
                },
                "238": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 149,
                            "__main__.get_public_key.range_check_ptr": 150,
                            "__main__.get_public_key.syscall_ptr": 148
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 77,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 17,
                        "start_line": 77
                    }
                },
                "240": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 25,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.get_public_key.pedersen_ptr": 152,
                            "__main__.get_public_key.range_check_ptr": 153,
                            "__main__.get_public_key.res": 154,
                            "__main__.get_public_key.syscall_ptr": 151
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 78,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 78
                    }
                },
                "241": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 75,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 75
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "243": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 158,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 76,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 9,
                                "start_line": 76
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "244": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 19,
                                "end_line": 76,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 76
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "246": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.__temp11": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 95,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling return value of"
                        ],
                        "start_col": 80,
                        "start_line": 1
                    }
                },
                "247": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.__temp11": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "248": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.__temp11": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "249": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 26,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr": 159,
                            "__wrappers__.get_public_key_encode_return.__return_value_ptr_start": 157,
                            "__wrappers__.get_public_key_encode_return.__temp11": 160,
                            "__wrappers__.get_public_key_encode_return.range_check_ptr": 156,
                            "__wrappers__.get_public_key_encode_return.ret_struct": 155
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_public_key/9605add8cf53f954532130fb37e8434c6f1dc820b83f0220783d7316e2c52b0f.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "250": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 162,
                            "__wrappers__.get_public_key.range_check_ptr": 163,
                            "__wrappers__.get_public_key.syscall_ptr": 161
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "251": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 162,
                            "__wrappers__.get_public_key.range_check_ptr": 163,
                            "__wrappers__.get_public_key.syscall_ptr": 161
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "252": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 162,
                            "__wrappers__.get_public_key.range_check_ptr": 163,
                            "__wrappers__.get_public_key.syscall_ptr": 161
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 69,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 42,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "253": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 162,
                            "__wrappers__.get_public_key.range_check_ptr": 163,
                            "__wrappers__.get_public_key.syscall_ptr": 161
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 71,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "254": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 162,
                            "__wrappers__.get_public_key.range_check_ptr": 163,
                            "__wrappers__.get_public_key.syscall_ptr": 161
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 75,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 75
                    }
                },
                "256": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 169,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 104,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 89,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "257": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 169,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 105,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "259": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "260": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 37
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "261": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 38
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "262": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 39
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "263": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "264": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 41
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/b2849ba7bb077663e4b038ad05edb036eedd0d3d2d173b73abde9848684cee47.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 75,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 75
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "265": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 27,
                            "offset": 42
                        },
                        "reference_ids": {
                            "__wrappers__.get_public_key.__calldata_actual_size": 166,
                            "__wrappers__.get_public_key.__calldata_ptr": 165,
                            "__wrappers__.get_public_key.ecdsa_ptr": 164,
                            "__wrappers__.get_public_key.pedersen_ptr": 168,
                            "__wrappers__.get_public_key.range_check_ptr": 171,
                            "__wrappers__.get_public_key.ret_struct": 170,
                            "__wrappers__.get_public_key.retdata": 173,
                            "__wrappers__.get_public_key.retdata_size": 172,
                            "__wrappers__.get_public_key.syscall_ptr": 167
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 75,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 75
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "266": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 175,
                            "__main__.get_nonce.range_check_ptr": 176,
                            "__main__.get_nonce.syscall_ptr": 174
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 82,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 83,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 83
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 82
                    }
                },
                "267": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 175,
                            "__main__.get_nonce.range_check_ptr": 176,
                            "__main__.get_nonce.syscall_ptr": 174
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 82,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 83,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 83
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 82
                    }
                },
                "268": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 175,
                            "__main__.get_nonce.range_check_ptr": 176,
                            "__main__.get_nonce.syscall_ptr": 174
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 82,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 83,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 17,
                                        "start_line": 83
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 82
                    }
                },
                "269": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 175,
                            "__main__.get_nonce.range_check_ptr": 176,
                            "__main__.get_nonce.syscall_ptr": 174
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 83,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 17,
                        "start_line": 83
                    }
                },
                "271": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 28,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.get_nonce.pedersen_ptr": 178,
                            "__main__.get_nonce.range_check_ptr": 179,
                            "__main__.get_nonce.res": 180,
                            "__main__.get_nonce.syscall_ptr": 177
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 84,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 84
                    }
                },
                "272": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 38,
                                "end_line": 3,
                                "input_file": {
                                    "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 15,
                                        "end_line": 82,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 82
                                    },
                                    "While handling return value of"
                                ],
                                "start_col": 5,
                                "start_line": 3
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 17,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 4
                    }
                },
                "274": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 184,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 45,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 99,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 89,
                                "start_line": 82
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "275": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/fee896b6d05b2e98056b5628baa6fbee0adfb8960f3fee9d79fd2f066956cc42.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 99,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 36,
                                        "end_line": 11,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 18,
                                        "start_line": 11
                                    },
                                    "While expanding the reference '__return_value_ptr' in:"
                                ],
                                "start_col": 89,
                                "start_line": 82
                            },
                            "While handling return value 'res'"
                        ],
                        "start_col": 26,
                        "start_line": 2
                    }
                },
                "277": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.__temp12": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 85,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 10,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 25,
                                        "start_line": 10
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling return value of"
                        ],
                        "start_col": 70,
                        "start_line": 1
                    }
                },
                "278": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.__temp12": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 11,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling return value of"
                        ],
                        "start_col": 18,
                        "start_line": 11
                    }
                },
                "279": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.__temp12": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 12,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While handling return value of"
                                        ],
                                        "start_col": 14,
                                        "start_line": 12
                                    },
                                    "While expanding the reference '__return_value_ptr_start' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling return value of"
                        ],
                        "start_col": 11,
                        "start_line": 5
                    }
                },
                "280": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce_encode_return"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 29,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr": 185,
                            "__wrappers__.get_nonce_encode_return.__return_value_ptr_start": 183,
                            "__wrappers__.get_nonce_encode_return.__temp12": 186,
                            "__wrappers__.get_nonce_encode_return.range_check_ptr": 182,
                            "__wrappers__.get_nonce_encode_return.ret_struct": 181
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 39,
                        "end_line": 12,
                        "input_file": {
                            "filename": "autogen/starknet/external/return/get_nonce/b599da7e0616f5b52a9be2e1921aad249a1f0772086f536420e6a3635525f534.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling return value of"
                        ],
                        "start_col": 5,
                        "start_line": 9
                    }
                },
                "281": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 188,
                            "__wrappers__.get_nonce.range_check_ptr": 189,
                            "__wrappers__.get_nonce.syscall_ptr": 187
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "282": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 188,
                            "__wrappers__.get_nonce.range_check_ptr": 189,
                            "__wrappers__.get_nonce.syscall_ptr": 187
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "283": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 188,
                            "__wrappers__.get_nonce.range_check_ptr": 189,
                            "__wrappers__.get_nonce.syscall_ptr": 187
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "284": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 188,
                            "__wrappers__.get_nonce.range_check_ptr": 189,
                            "__wrappers__.get_nonce.syscall_ptr": 187
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "285": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 188,
                            "__wrappers__.get_nonce.range_check_ptr": 189,
                            "__wrappers__.get_nonce.syscall_ptr": 187
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 15,
                        "end_line": 82,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 82
                    }
                },
                "287": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 195,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 99,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 84,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "288": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 195,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 100,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 48,
                        "start_line": 2
                    }
                },
                "290": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "291": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 37
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "292": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 38
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 6,
                        "start_line": 2
                    }
                },
                "293": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 39
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "294": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 40
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 2
                    }
                },
                "295": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 41
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/a346d877d422c1aceb29d6c4893476b7e7d7c8e9bd59d8ccc775b8622116dd2a.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 15,
                                                "end_line": 82,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 82
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 37,
                        "start_line": 2
                    }
                },
                "296": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.get_nonce"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 30,
                            "offset": 42
                        },
                        "reference_ids": {
                            "__wrappers__.get_nonce.__calldata_actual_size": 192,
                            "__wrappers__.get_nonce.__calldata_ptr": 191,
                            "__wrappers__.get_nonce.ecdsa_ptr": 190,
                            "__wrappers__.get_nonce.pedersen_ptr": 194,
                            "__wrappers__.get_nonce.range_check_ptr": 197,
                            "__wrappers__.get_nonce.ret_struct": 196,
                            "__wrappers__.get_nonce.retdata": 199,
                            "__wrappers__.get_nonce.retdata_size": 198,
                            "__wrappers__.get_nonce.syscall_ptr": 193
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/get_nonce/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 15,
                                "end_line": 82,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 82
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "297": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 201
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 92,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 63,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 23,
                                        "end_line": 94,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 94
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 23,
                                "start_line": 63
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 21,
                        "start_line": 92
                    }
                },
                "298": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 201
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 94,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 94
                    }
                },
                "300": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 16
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 69,
                        "end_line": 92,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 95,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 95
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 42,
                        "start_line": 92
                    }
                },
                "301": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 92,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 37,
                                        "end_line": 95,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 95
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 71,
                        "start_line": 92
                    }
                },
                "302": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 93,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 36,
                                "end_line": 95,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 22,
                                "start_line": 95
                            },
                            "While expanding the reference 'new_public_key' in:"
                        ],
                        "start_col": 9,
                        "start_line": 93
                    }
                },
                "303": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 19
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 202,
                            "__main__.set_public_key.range_check_ptr": 203,
                            "__main__.set_public_key.syscall_ptr": 204
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 95,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 95
                    }
                },
                "305": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 31,
                            "offset": 37
                        },
                        "reference_ids": {
                            "__main__.set_public_key.new_public_key": 200,
                            "__main__.set_public_key.pedersen_ptr": 206,
                            "__main__.set_public_key.range_check_ptr": 207,
                            "__main__.set_public_key.syscall_ptr": 205
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 96,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 96
                    }
                },
                "306": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 93,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 20,
                                                                "end_line": 92,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 92
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 35,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 93
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "308": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "309": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 40,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "310": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 69,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 42,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "311": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 71,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "312": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/960ed0835c5fa83e7fde73a3a03f5fd9272c9b63199927c6476a8754ae40c556.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 93,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 162,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 133,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_new_public_key' in:"
                                ],
                                "start_col": 9,
                                "start_line": 93
                            },
                            "While handling calldata argument 'new_public_key'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "313": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 209,
                            "__wrappers__.set_public_key.range_check_ptr": 210,
                            "__wrappers__.set_public_key.syscall_ptr": 208
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 20,
                        "end_line": 92,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 92
                    }
                },
                "315": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 44
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 92,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 92
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "317": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 45
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "318": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "319": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 47
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "320": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 48
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "321": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 49
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "323": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/9d99191ee37b2755f349e9328582aaabeba3fa369cacff177a5b80144e6ec2c7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 20,
                                                "end_line": 92,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 92
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "324": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.set_public_key"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 32,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__wrappers__.set_public_key.__calldata_actual_size": 215,
                            "__wrappers__.set_public_key.__calldata_arg_new_public_key": 213,
                            "__wrappers__.set_public_key.__calldata_ptr": 214,
                            "__wrappers__.set_public_key.__temp13": 216,
                            "__wrappers__.set_public_key.ecdsa_ptr": 211,
                            "__wrappers__.set_public_key.pedersen_ptr": 218,
                            "__wrappers__.set_public_key.range_check_ptr": 219,
                            "__wrappers__.set_public_key.ret_struct": 220,
                            "__wrappers__.set_public_key.retdata": 221,
                            "__wrappers__.set_public_key.retdata_size": 222,
                            "__wrappers__.set_public_key.syscall_ptr": 217
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/set_public_key/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 20,
                                "end_line": 92,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 92
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "325": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 225,
                            "__main__.constructor.range_check_ptr": 226,
                            "__main__.constructor.syscall_ptr": 224
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 104,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 35,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 106,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 16,
                                "start_line": 19
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 104
                    }
                },
                "326": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 225,
                            "__main__.constructor.range_check_ptr": 226,
                            "__main__.constructor.syscall_ptr": 224
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 66,
                        "end_line": 104,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 106,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 37,
                                "start_line": 19
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 39,
                        "start_line": 104
                    }
                },
                "327": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 225,
                            "__main__.constructor.range_check_ptr": 226,
                            "__main__.constructor.syscall_ptr": 224
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 104,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 81,
                                "end_line": 19,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 106,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 106
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 66,
                                "start_line": 19
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 68,
                        "start_line": 104
                    }
                },
                "328": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 225,
                            "__main__.constructor.range_check_ptr": 226,
                            "__main__.constructor.syscall_ptr": 224
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 27,
                        "end_line": 105,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 33,
                                "end_line": 106,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 22,
                                "start_line": 106
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 9,
                        "start_line": 105
                    }
                },
                "329": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 225,
                            "__main__.constructor.range_check_ptr": 226,
                            "__main__.constructor.syscall_ptr": 224
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 106,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 106
                    }
                },
                "331": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 33,
                            "offset": 22
                        },
                        "reference_ids": {
                            "__main__.constructor._public_key": 223,
                            "__main__.constructor.pedersen_ptr": 228,
                            "__main__.constructor.range_check_ptr": 229,
                            "__main__.constructor.syscall_ptr": 227
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 107,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 107
                    }
                },
                "332": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 45,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/5e1cc73f0b484f90bb02da164d88332b40c6f698801aa4d3c603dab22157e902.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 17,
                                                                "end_line": 104,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 104
                                                            },
                                                            "While handling calldata of"
                                                        ],
                                                        "start_col": 35,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference '__calldata_actual_size' in:"
                                                ],
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While handling calldata of"
                                        ],
                                        "start_col": 31,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 105
                            },
                            "While handling calldata argument '_public_key'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "334": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "335": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "336": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 66,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 39,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "337": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 83,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 68,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "338": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 50,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/623ade4063ac6181a8cdf88ec6604929c149e47a08a1b21b110c028785e3e605.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 27,
                                "end_line": 105,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 156,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 130,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg__public_key' in:"
                                ],
                                "start_col": 9,
                                "start_line": 105
                            },
                            "While handling calldata argument '_public_key'"
                        ],
                        "start_col": 34,
                        "start_line": 1
                    }
                },
                "339": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 231,
                            "__wrappers__.constructor.range_check_ptr": 232,
                            "__wrappers__.constructor.syscall_ptr": 230
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 104,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 104
                    }
                },
                "341": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 29
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 17,
                                        "end_line": 104,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 104
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "343": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 30
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "344": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 31
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "345": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 32
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "346": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 33
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 61,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/06e2dac6fec7b0245dd168190069dcb92ed8c79c7a1ccebce7b1343c3e526229.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "347": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 34
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "349": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 35
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/65962fce79fda3ae5aa5ff0f8d357fdb1de976f3ac253367909c1e8ffb6ad335.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 17,
                                                "end_line": 104,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 104
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "350": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.constructor"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 34,
                            "offset": 36
                        },
                        "reference_ids": {
                            "__wrappers__.constructor.__calldata_actual_size": 237,
                            "__wrappers__.constructor.__calldata_arg__public_key": 235,
                            "__wrappers__.constructor.__calldata_ptr": 236,
                            "__wrappers__.constructor.__temp14": 238,
                            "__wrappers__.constructor.ecdsa_ptr": 233,
                            "__wrappers__.constructor.pedersen_ptr": 240,
                            "__wrappers__.constructor.range_check_ptr": 241,
                            "__wrappers__.constructor.ret_struct": 242,
                            "__wrappers__.constructor.retdata": 243,
                            "__wrappers__.constructor.retdata_size": 244,
                            "__wrappers__.constructor.syscall_ptr": 239
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/constructor/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 104,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 104
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "351": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 249,
                            "__main__.is_valid_signature.range_check_ptr": 250,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 248
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 15,
                                "start_line": 13
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 116
                    }
                },
                "352": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 249,
                            "__main__.is_valid_signature.range_check_ptr": 250,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 248
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 30,
                        "start_line": 116
                    }
                },
                "353": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 249,
                            "__main__.is_valid_signature.range_check_ptr": 250,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 248
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 42,
                                        "end_line": 118,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 25,
                                        "start_line": 118
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 59,
                        "start_line": 116
                    }
                },
                "354": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 249,
                            "__main__.is_valid_signature.range_check_ptr": 250,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 248
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 118,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 25,
                        "start_line": 118
                    }
                },
                "356": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 117,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 58,
                                "end_line": 7,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 84,
                                        "end_line": 127,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 126
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 29,
                                "start_line": 7
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 117
                    }
                },
                "357": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 24
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 51,
                        "end_line": 117,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 21,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 17,
                                "start_line": 127
                            },
                            "While expanding the reference 'hash' in:"
                        ],
                        "start_col": 40,
                        "start_line": 117
                    }
                },
                "358": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 25
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 118,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 45,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 34,
                                "start_line": 127
                            },
                            "While expanding the reference '_public_key' in:"
                        ],
                        "start_col": 10,
                        "start_line": 118
                    }
                },
                "359": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 26
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 123,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 64,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 59,
                                "start_line": 127
                            },
                            "While expanding the reference 'sig_r' in:"
                        ],
                        "start_col": 17,
                        "start_line": 123
                    }
                },
                "360": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 27
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 29,
                        "end_line": 124,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 83,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 78,
                                "start_line": 127
                            },
                            "While expanding the reference 'sig_s' in:"
                        ],
                        "start_col": 17,
                        "start_line": 124
                    }
                },
                "361": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 28
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 251,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 84,
                        "end_line": 127,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 126
                    }
                },
                "363": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 31
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 258,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 116,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 129
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 116
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 118
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "364": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 32
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 258,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 57,
                                        "end_line": 116,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 129
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 30,
                                        "start_line": 116
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 118
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "365": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 33
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 258,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/public_key/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 42,
                                "end_line": 118,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 74,
                                        "end_line": 116,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 129
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 59,
                                        "start_line": 116
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 25,
                                "start_line": 118
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "366": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 34
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 258,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 7,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/cairo/common/signature.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 84,
                                "end_line": 127,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 117,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 14,
                                                "end_line": 129,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 129
                                            },
                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 117
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 126
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 29,
                        "start_line": 7
                    }
                },
                "367": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 35,
                            "offset": 35
                        },
                        "reference_ids": {
                            "__main__.is_valid_signature._public_key": 255,
                            "__main__.is_valid_signature.ecdsa_ptr": 258,
                            "__main__.is_valid_signature.hash": 245,
                            "__main__.is_valid_signature.pedersen_ptr": 253,
                            "__main__.is_valid_signature.range_check_ptr": 254,
                            "__main__.is_valid_signature.sig_r": 256,
                            "__main__.is_valid_signature.sig_s": 257,
                            "__main__.is_valid_signature.signature": 247,
                            "__main__.is_valid_signature.signature_len": 246,
                            "__main__.is_valid_signature.syscall_ptr": 252
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 14,
                        "end_line": 129,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 129
                    }
                },
                "368": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 261,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 74,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 92,
                                                "end_line": 117,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 75,
                                                "start_line": 117
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 59,
                                "start_line": 116
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "369": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 261,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 73,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 92,
                                                "end_line": 117,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 75,
                                                "start_line": 117
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 53,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "370": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 261,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 92,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 75,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "371": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 73,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 92,
                                                "end_line": 117,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 75,
                                                "start_line": 117
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 53,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "373": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 73,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 71,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 92,
                                                "end_line": 117,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 75,
                                                "start_line": 117
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 43,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 53,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "374": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 267,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 8,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 92,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 75,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 26,
                        "start_line": 8
                    }
                },
                "375": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/1b562308a65653425ce06491fa4b4539466f3251a07e73e099d0afe86a48900e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While handling calldata of"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "376": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 74,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 3,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 92,
                                                "end_line": 117,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 116,
                                                        "end_line": 1,
                                                        "input_file": {
                                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 24,
                                                                "end_line": 115,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 6,
                                                                "start_line": 115
                                                            },
                                                            "While constructing the external wrapper for:"
                                                        ],
                                                        "start_col": 101,
                                                        "start_line": 1
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 75,
                                                "start_line": 117
                                            },
                                            "While handling calldata argument 'signature'"
                                        ],
                                        "start_col": 23,
                                        "start_line": 3
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 59,
                                "start_line": 116
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "377": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/c7060df96cb0acca1380ae43bf758cab727bfdf73cb5d34a93e24a9742817fda.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 28,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 45,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 116
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 19,
                        "start_line": 1
                    }
                },
                "378": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 7
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 110,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/424b26e79f70343cc02557f1fbd25745138efb26a3dc5c8b593ca765b73138b7.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 57,
                                "end_line": 116,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 83,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 71,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 30,
                                "start_line": 116
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 1
                    }
                },
                "379": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 8
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 42,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 92,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 116,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 101,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 75,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 23,
                        "start_line": 3
                    }
                },
                "381": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 9
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 112,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/9aa866da402dc1b34ae86751a3cabb224b0d9ac08fe13c58bb079af4cd281bec.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 137,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 128,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 117
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 17,
                        "start_line": 1
                    }
                },
                "382": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 10
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/f3c2d3942f0f75ba7fab7e0c13e6cee1d1be8a6d9e771412e1ff56c7484dd3f4.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 51,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 163,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 144,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_hash' in:"
                                ],
                                "start_col": 40,
                                "start_line": 117
                            },
                            "While handling calldata argument 'hash'"
                        ],
                        "start_col": 27,
                        "start_line": 1
                    }
                },
                "383": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 11
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 52,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/e1b7bcaf2f97aa307c8deca2578c63f05cf45d09bb1ecaaf9be0bb828fc5cb40.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 73,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 207,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 179,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature_len' in:"
                                ],
                                "start_col": 53,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature_len'"
                        ],
                        "start_col": 36,
                        "start_line": 1
                    }
                },
                "384": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 12
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 59,
                        "end_line": 5,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/af0e0ad1dbc5708a90b4c31e69f13c85f8b13b0ea898d09f3ae14676037400be.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 92,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 243,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 219,
                                        "start_line": 1
                                    },
                                    "While expanding the reference '__calldata_arg_signature' in:"
                                ],
                                "start_col": 75,
                                "start_line": 117
                            },
                            "While handling calldata argument 'signature'"
                        ],
                        "start_col": 32,
                        "start_line": 5
                    }
                },
                "386": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 13
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 262,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 260,
                            "__wrappers__.is_valid_signature.range_check_ptr": 270,
                            "__wrappers__.is_valid_signature.syscall_ptr": 259
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 115,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 6,
                        "start_line": 115
                    }
                },
                "388": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [
                        {
                            "location": {
                                "end_col": 34,
                                "end_line": 2,
                                "input_file": {
                                    "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 115,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 6,
                                        "start_line": 115
                                    },
                                    "While constructing the external wrapper for:"
                                ],
                                "start_col": 1,
                                "start_line": 2
                            },
                            "n_prefix_newlines": 0
                        }
                    ],
                    "inst": {
                        "end_col": 24,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 3
                    }
                },
                "390": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 56,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 20,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 45,
                        "start_line": 1
                    }
                },
                "391": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 83,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 33,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 21,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 71,
                        "start_line": 1
                    }
                },
                "392": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 116,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 34,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 101,
                        "start_line": 1
                    }
                },
                "393": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 54
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 137,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 59,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 50,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'ecdsa_ptr' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 128,
                        "start_line": 1
                    }
                },
                "394": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 55
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 21,
                        "end_line": 4,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 60,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata_size' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 20,
                        "start_line": 4
                    }
                },
                "396": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 56
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 16,
                        "end_line": 3,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/a4577150f3039c0db885ccde32bb0d5a5b36850e59d8cf7d9c3472ad9a641767.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 1,
                                        "input_file": {
                                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 24,
                                                "end_line": 115,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 6,
                                                "start_line": 115
                                            },
                                            "While constructing the external wrapper for:"
                                        ],
                                        "start_col": 73,
                                        "start_line": 1
                                    },
                                    "While expanding the reference 'retdata' in:"
                                ],
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 9,
                        "start_line": 3
                    }
                },
                "397": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.is_valid_signature"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 36,
                            "offset": 57
                        },
                        "reference_ids": {
                            "__wrappers__.is_valid_signature.__calldata_actual_size": 275,
                            "__wrappers__.is_valid_signature.__calldata_arg_hash": 264,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature": 271,
                            "__wrappers__.is_valid_signature.__calldata_arg_signature_len": 266,
                            "__wrappers__.is_valid_signature.__calldata_ptr": 274,
                            "__wrappers__.is_valid_signature.__temp15": 268,
                            "__wrappers__.is_valid_signature.__temp16": 269,
                            "__wrappers__.is_valid_signature.__temp17": 272,
                            "__wrappers__.is_valid_signature.__temp18": 273,
                            "__wrappers__.is_valid_signature.__temp19": 276,
                            "__wrappers__.is_valid_signature.ecdsa_ptr": 280,
                            "__wrappers__.is_valid_signature.pedersen_ptr": 278,
                            "__wrappers__.is_valid_signature.range_check_ptr": 279,
                            "__wrappers__.is_valid_signature.ret_struct": 281,
                            "__wrappers__.is_valid_signature.retdata": 282,
                            "__wrappers__.is_valid_signature.retdata_size": 283,
                            "__wrappers__.is_valid_signature.syscall_ptr": 277
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/is_valid_signature/aa526043a8db9187624857305b1409f029aec9f9c85f47438b55e65b3afc0639.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 115,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 6,
                                "start_line": 115
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 1,
                        "start_line": 1
                    }
                },
                "398": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 139,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 139
                    }
                },
                "400": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 15
                        },
                        "reference_ids": {
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 141,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 23,
                        "start_line": 141
                    }
                },
                "402": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 17
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 135,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 37,
                                "end_line": 351,
                                "input_file": {
                                    "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 142,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 21,
                                        "start_line": 142
                                    },
                                    "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                ],
                                "start_col": 18,
                                "start_line": 351
                            },
                            "While expanding the reference 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 135
                    }
                },
                "403": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 18
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 289
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 142,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 21,
                        "start_line": 142
                    }
                },
                "405": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 294,
                            "__main__.__execute__.tx_info": 295
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 17,
                        "end_line": 142,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 17,
                                "end_line": 142,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 10,
                                "start_line": 142
                            },
                            "While auto generating local variable for 'tx_info'."
                        ],
                        "start_col": 10,
                        "start_line": 142
                    }
                },
                "406": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 23
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 294,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 351,
                        "input_file": {
                            "filename": "/Users/arturmichalek/Coding/cairo-lang/src/starkware/starknet/common/syscalls.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 34,
                                "end_line": 142,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 34,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 143,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 143
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 15,
                                        "start_line": 13
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 21,
                                "start_line": 142
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 18,
                        "start_line": 351
                    }
                },
                "407": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 24
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 294,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 135,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 63,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 143,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 143
                                    },
                                    "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                ],
                                "start_col": 36,
                                "start_line": 13
                            },
                            "While expanding the reference 'pedersen_ptr' in:"
                        ],
                        "start_col": 30,
                        "start_line": 135
                    }
                },
                "408": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 25
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 294,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 135,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 80,
                                "end_line": 13,
                                "input_file": {
                                    "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 48,
                                        "end_line": 143,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 28,
                                        "start_line": 143
                                    },
                                    "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                ],
                                "start_col": 65,
                                "start_line": 13
                            },
                            "While expanding the reference 'range_check_ptr' in:"
                        ],
                        "start_col": 59,
                        "start_line": 135
                    }
                },
                "409": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 26
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 290,
                            "__main__.__execute__.range_check_ptr": 291,
                            "__main__.__execute__.syscall_ptr": 294,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 143,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 28,
                        "start_line": 143
                    }
                },
                "411": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 300,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 298,
                            "__main__.__execute__.range_check_ptr": 299,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 24,
                        "end_line": 143,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 24,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 10,
                                "start_line": 143
                            },
                            "While auto generating local variable for '_current_nonce'."
                        ],
                        "start_col": 10,
                        "start_line": 143
                    }
                },
                "412": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 298,
                            "__main__.__execute__.range_check_ptr": 299,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 143,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 143
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 143
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "413": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 299,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 143,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 28,
                                                "start_line": 143
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 143
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "414": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 147,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 9,
                        "start_line": 147
                    }
                },
                "415": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 151,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 27,
                        "start_line": 151
                    }
                },
                "417": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 49
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 304,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 151,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 10,
                                "start_line": 151
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 10,
                        "start_line": 151
                    }
                },
                "418": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 49
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 34,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 49,
                                        "end_line": 201,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 73,
                                                "end_line": 152,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 152
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 30,
                                        "start_line": 201
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 28,
                                "start_line": 143
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 15,
                        "start_line": 13
                    }
                },
                "419": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 50
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 30,
                        "end_line": 137,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 43,
                                "end_line": 152,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 29,
                                "start_line": 152
                            },
                            "While expanding the reference 'call_array_len' in:"
                        ],
                        "start_col": 9,
                        "start_line": 137
                    }
                },
                "420": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 51
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 55,
                        "end_line": 137,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 152,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 45,
                                "start_line": 152
                            },
                            "While expanding the reference 'call_array' in:"
                        ],
                        "start_col": 32,
                        "start_line": 137
                    }
                },
                "421": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 52
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 94,
                        "end_line": 137,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 65,
                                "end_line": 152,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 57,
                                "start_line": 152
                            },
                            "While expanding the reference 'calldata' in:"
                        ],
                        "start_col": 78,
                        "start_line": 137
                    }
                },
                "422": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 53
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 23,
                        "end_line": 151,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 23,
                                "end_line": 151,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 152,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 67,
                                        "start_line": 152
                                    },
                                    "While expanding the reference 'calls' in:"
                                ],
                                "start_col": 10,
                                "start_line": 151
                            },
                            "While auto generating local variable for 'calls'."
                        ],
                        "start_col": 10,
                        "start_line": 151
                    }
                },
                "423": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 37,
                            "offset": 54
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 297,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 73,
                        "end_line": 152,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 152
                    }
                },
                "425": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "426": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "427": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "428": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "429": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "430": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 10,
                        "end_line": 162,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 155
                    }
                },
                "431": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 63,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 63,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 143,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 116,
                                                        "input_file": {
                                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 91,
                                                                "end_line": 166,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 166
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 30,
                                                        "start_line": 116
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 143
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 36,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 143
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 36,
                        "start_line": 13
                    }
                },
                "432": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 80,
                        "end_line": 13,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 48,
                                "end_line": 143,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 80,
                                        "end_line": 13,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 48,
                                                "end_line": 143,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 74,
                                                        "end_line": 116,
                                                        "input_file": {
                                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 91,
                                                                "end_line": 166,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 166
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 59,
                                                        "start_line": 116
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 28,
                                                "start_line": 143
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 65,
                                        "start_line": 13
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 28,
                                "start_line": 143
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 65,
                        "start_line": 13
                    }
                },
                "433": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 136,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 117,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 91,
                                        "end_line": 166,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 5,
                                        "start_line": 166
                                    },
                                    "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 117
                            },
                            "While expanding the reference 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 136
                    }
                },
                "434": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 48,
                        "end_line": 166,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 24,
                        "start_line": 166
                    }
                },
                "435": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 71,
                        "end_line": 166,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 50,
                        "start_line": 166
                    }
                },
                "436": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 90,
                        "end_line": 166,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 73,
                        "start_line": 166
                    }
                },
                "437": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 292,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 302,
                            "__main__.__execute__.range_check_ptr": 303,
                            "__main__.__execute__.syscall_ptr": 306,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 91,
                        "end_line": 166,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 166
                    }
                },
                "439": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 43
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 312,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 117,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 91,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 117,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 91,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 117
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 117
                    }
                },
                "440": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 43
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 28,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 91,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 35,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 16,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 116
                    }
                },
                "441": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 44
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 91,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'pedersen_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 30,
                        "start_line": 116
                    }
                },
                "442": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 45
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 74,
                        "end_line": 116,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 91,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 59,
                        "start_line": 116
                    }
                },
                "443": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 46
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 43,
                        "end_line": 169,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 25,
                        "start_line": 169
                    }
                },
                "445": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 47
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 310,
                            "__main__.__execute__.range_check_ptr": 311,
                            "__main__.__execute__.syscall_ptr": 309,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 44,
                        "end_line": 169,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 169
                    }
                },
                "447": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 65
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 315,
                            "__main__.__execute__.range_check_ptr": 316,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "448": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 65
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 316,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "449": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 65
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 37,
                        "end_line": 172,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 30,
                        "start_line": 172
                    }
                },
                "451": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 68
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 319,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 172,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 10,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 10,
                        "start_line": 172
                    }
                },
                "452": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 68
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 35,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 178,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 86,
                                                "end_line": 173,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 26,
                                                "start_line": 173
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 19,
                                        "start_line": 178
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 5,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 16,
                        "start_line": 19
                    }
                },
                "453": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 69
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 58,
                        "end_line": 173,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 39,
                        "start_line": 173
                    }
                },
                "454": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 70
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 75,
                        "end_line": 173,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 60,
                        "start_line": 173
                    }
                },
                "455": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 71
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 172,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 85,
                                        "end_line": 173,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 77,
                                        "start_line": 173
                                    },
                                    "While expanding the reference 'response' in:"
                                ],
                                "start_col": 10,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 10,
                        "start_line": 172
                    }
                },
                "456": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 38,
                            "offset": 72
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.syscall_ptr": 314,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 86,
                        "end_line": 173,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 26,
                        "start_line": 173
                    }
                },
                "458": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 178,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 86,
                                "end_line": 173,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 28,
                                        "end_line": 135,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 57,
                                                "end_line": 175,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 5,
                                                "start_line": 175
                                            },
                                            "While trying to retrieve the implicit argument 'syscall_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 135
                                    },
                                    "While expanding the reference 'syscall_ptr' in:"
                                ],
                                "start_col": 26,
                                "start_line": 173
                            },
                            "While trying to update the implicit return value 'syscall_ptr' in:"
                        ],
                        "start_col": 19,
                        "start_line": 178
                    }
                },
                "459": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 64,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 64,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 57,
                                                        "end_line": 135,
                                                        "input_file": {
                                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 57,
                                                                "end_line": 175,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 175
                                                            },
                                                            "While trying to retrieve the implicit argument 'pedersen_ptr' in:"
                                                        ],
                                                        "start_col": 30,
                                                        "start_line": 135
                                                    },
                                                    "While expanding the reference 'pedersen_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                                        ],
                                        "start_col": 37,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'pedersen_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'pedersen_ptr' in:"
                        ],
                        "start_col": 37,
                        "start_line": 19
                    }
                },
                "460": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 81,
                        "end_line": 19,
                        "input_file": {
                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 44,
                                "end_line": 169,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 81,
                                        "end_line": 19,
                                        "input_file": {
                                            "filename": "autogen/starknet/storage_var/current_nonce/decl.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 44,
                                                "end_line": 169,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 74,
                                                        "end_line": 135,
                                                        "input_file": {
                                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 57,
                                                                "end_line": 175,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 175
                                                            },
                                                            "While trying to retrieve the implicit argument 'range_check_ptr' in:"
                                                        ],
                                                        "start_col": 59,
                                                        "start_line": 135
                                                    },
                                                    "While expanding the reference 'range_check_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 169
                                            },
                                            "While trying to update the implicit return value 'range_check_ptr' in:"
                                        ],
                                        "start_col": 66,
                                        "start_line": 19
                                    },
                                    "While auto generating local variable for 'range_check_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 169
                            },
                            "While trying to update the implicit return value 'range_check_ptr' in:"
                        ],
                        "start_col": 66,
                        "start_line": 19
                    }
                },
                "461": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 38,
                        "end_line": 117,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 91,
                                "end_line": 166,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 38,
                                        "end_line": 117,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 91,
                                                "end_line": 166,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "parent_location": [
                                                    {
                                                        "end_col": 38,
                                                        "end_line": 136,
                                                        "input_file": {
                                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                        },
                                                        "parent_location": [
                                                            {
                                                                "end_col": 57,
                                                                "end_line": 175,
                                                                "input_file": {
                                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                                },
                                                                "start_col": 5,
                                                                "start_line": 175
                                                            },
                                                            "While trying to retrieve the implicit argument 'ecdsa_ptr' in:"
                                                        ],
                                                        "start_col": 9,
                                                        "start_line": 136
                                                    },
                                                    "While expanding the reference 'ecdsa_ptr' in:"
                                                ],
                                                "start_col": 5,
                                                "start_line": 166
                                            },
                                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                                        ],
                                        "start_col": 9,
                                        "start_line": 117
                                    },
                                    "While auto generating local variable for 'ecdsa_ptr'."
                                ],
                                "start_col": 5,
                                "start_line": 166
                            },
                            "While trying to update the implicit return value 'ecdsa_ptr' in:"
                        ],
                        "start_col": 9,
                        "start_line": 117
                    }
                },
                "462": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 22,
                        "end_line": 173,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 38,
                                "end_line": 175,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 26,
                                "start_line": 175
                            },
                            "While expanding the reference 'response_len' in:"
                        ],
                        "start_col": 10,
                        "start_line": 173
                    }
                },
                "463": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 5
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 26,
                        "end_line": 172,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 26,
                                "end_line": 172,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 56,
                                        "end_line": 175,
                                        "input_file": {
                                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                        },
                                        "start_col": 48,
                                        "start_line": 175
                                    },
                                    "While expanding the reference 'response' in:"
                                ],
                                "start_col": 10,
                                "start_line": 172
                            },
                            "While auto generating local variable for 'response'."
                        ],
                        "start_col": 10,
                        "start_line": 172
                    }
                },
                "464": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__main__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 39,
                            "offset": 6
                        },
                        "reference_ids": {
                            "__main__.__execute__.__fp__": 293,
                            "__main__.__execute__._current_nonce": 301,
                            "__main__.__execute__.call_array": 285,
                            "__main__.__execute__.call_array_len": 284,
                            "__main__.__execute__.calldata": 287,
                            "__main__.__execute__.calldata_len": 286,
                            "__main__.__execute__.calls": 305,
                            "__main__.__execute__.calls_len": 307,
                            "__main__.__execute__.ecdsa_ptr": 313,
                            "__main__.__execute__.multicall": 308,
                            "__main__.__execute__.nonce": 288,
                            "__main__.__execute__.pedersen_ptr": 317,
                            "__main__.__execute__.range_check_ptr": 318,
                            "__main__.__execute__.response": 320,
                            "__main__.__execute__.response_len": 322,
                            "__main__.__execute__.syscall_ptr": 321,
                            "__main__.__execute__.tx_info": 296
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 175,
                        "input_file": {
                            "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                        },
                        "start_col": 5,
                        "start_line": 175
                    }
                },
                "465": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 0
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_ptr": 324,
                            "__wrappers__.__execute__.range_check_ptr": 325,
                            "__wrappers__.__execute__.syscall_ptr": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 67,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/external/__execute__/e651458745e7cd218121c342e0915890767e2f59ddc2e315b8844ad0f47d582e.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 74,
                                "end_line": 135,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 24,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 9,
                                        "start_line": 2
                                    },
                                    "While expanding the reference 'range_check_ptr' in:"
                                ],
                                "start_col": 59,
                                "start_line": 135
                            },
                            "While constructing the external wrapper for:"
                        ],
                        "start_col": 23,
                        "start_line": 1
                    }
                },
                "466": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 1
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.__temp20": 330,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_ptr": 324,
                            "__wrappers__.__execute__.range_check_ptr": 325,
                            "__wrappers__.__execute__.syscall_ptr": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 57,
                                        "end_line": 2,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 28,
                                        "start_line": 2
                                    },
                                    "While expanding the reference '__calldata_arg_call_array_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'call_array_len'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "467": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.__temp20": 330,
                            "__wrappers__.__execute__.__temp21": 331,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_ptr": 324,
                            "__wrappers__.__execute__.range_check_ptr": 325,
                            "__wrappers__.__execute__.syscall_ptr": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 57,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 55,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "start_col": 32,
                                "start_line": 137
                            },
                            "While handling calldata argument 'call_array'"
                        ],
                        "start_col": 1,
                        "start_line": 2
                    }
                },
                "468": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 2
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array": 333,
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.__temp20": 330,
                            "__wrappers__.__execute__.__temp21": 331,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_ptr": 324,
                            "__wrappers__.__execute__.range_check_ptr": 332,
                            "__wrappers__.__execute__.syscall_ptr": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 40,
                        "end_line": 2,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 40,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 26,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_ptr' in:"
                                ],
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'call_array_len'"
                        ],
                        "start_col": 22,
                        "start_line": 2
                    }
                },
                "470": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 3
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array": 333,
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.__temp20": 330,
                            "__wrappers__.__execute__.__temp21": 331,
                            "__wrappers__.__execute__.__temp22": 334,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_ptr": 324,
                            "__wrappers__.__execute__.range_check_ptr": 332,
                            "__wrappers__.__execute__.syscall_ptr": 323
                        }
                    },
                    "hints": [],
                    "inst": {
                        "end_col": 53,
                        "end_line": 1,
                        "input_file": {
                            "filename": "autogen/starknet/arg_processor/2311e7438f422acd27be84fafe870b01e285827c63200dabae3efa5289008fee.cairo"
                        },
                        "parent_location": [
                            {
                                "end_col": 30,
                                "end_line": 137,
                                "input_file": {
                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                },
                                "parent_location": [
                                    {
                                        "end_col": 72,
                                        "end_line": 8,
                                        "input_file": {
                                            "filename": "autogen/starknet/arg_processor/dd726a341de5b4da051d08abedecafaa804272abf1942a18ab828c4e58db489d.cairo"
                                        },
                                        "parent_location": [
                                            {
                                                "end_col": 55,
                                                "end_line": 137,
                                                "input_file": {
                                                    "filename": "starkware/starknet/third_party/open_zeppelin/Account.cairo"
                                                },
                                                "start_col": 32,
                                                "start_line": 137
                                            },
                                            "While handling calldata argument 'call_array'"
                                        ],
                                        "start_col": 43,
                                        "start_line": 8
                                    },
                                    "While expanding the reference '__calldata_arg_call_array_len' in:"
                                ],
                                "start_col": 9,
                                "start_line": 137
                            },
                            "While handling calldata argument 'call_array_len'"
                        ],
                        "start_col": 37,
                        "start_line": 1
                    }
                },
                "471": {
                    "accessible_scopes": [
                        "__main__",
                        "__main__",
                        "__wrappers__",
                        "__wrappers__.__execute__"
                    ],
                    "flow_tracking_data": {
                        "ap_tracking": {
                            "group": 40,
                            "offset": 4
                        },
                        "reference_ids": {
                            "__wrappers__.__execute__.__calldata_arg_call_array": 333,
                            "__wrappers__.__execute__.__calldata_arg_call_array_len": 328,
                            "__wrappers__.__execute__.__calldata_ptr": 329,
                            "__wrappers__.__execute__.__temp20": 330,
                            "__wrappers__.__execute__.__temp21": 331,
                            "__wrappers__.__execute__.__temp22": 334,
                            "__wrappers__.__execute__.__temp23": 335,
                            "__wrappers__.__execute__.ecdsa_ptr": 326,
                            "__wrappers__.__execute__.pedersen_