# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class AccountApplicationApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_account_application(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Account Application  # noqa: E501

        <p>Create Account Application</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_application(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountApplicationJson body: AccountApplicationJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_account_application_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_account_application_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_account_application_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Account Application  # noqa: E501

        <p>Create Account Application</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_account_application_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountApplicationJson body: AccountApplicationJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_account_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_account_application`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_account_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/account-applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountApplicationResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_application(self, account_application_id, bank_id, **kwargs):  # noqa: E501
        """Get Account Application by Id  # noqa: E501

        <p>Get the Account Application.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_application(account_application_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_application_id: the account application id  (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_application_with_http_info(account_application_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_application_with_http_info(account_application_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_account_application_with_http_info(self, account_application_id, bank_id, **kwargs):  # noqa: E501
        """Get Account Application by Id  # noqa: E501

        <p>Get the Account Application.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_application_with_http_info(account_application_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_application_id: the account application id  (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_application_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_application" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_application_id' is set
        if self.api_client.client_side_validation and ('account_application_id' not in params or
                                                       params['account_application_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_application_id` when calling `get_account_application`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_account_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_application_id' in params:
            path_params['ACCOUNT_APPLICATION_ID'] = params['account_application_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/account-applications/{ACCOUNT_APPLICATION_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountApplicationResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_account_applications(self, bank_id, **kwargs):  # noqa: E501
        """Get Account Applications  # noqa: E501

        <p>Get the Account Applications.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_applications(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AccountApplicationsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_applications_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_applications_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_account_applications_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Account Applications  # noqa: E501

        <p>Get the Account Applications.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_applications_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AccountApplicationsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_applications" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_account_applications`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/account-applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountApplicationsJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_account_application_status(self, body, account_application_id, bank_id, **kwargs):  # noqa: E501
        """Update Account Application Status  # noqa: E501

        <p>Update an Account Application status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_application_status(body, account_application_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountApplicationUpdateStatusJson body: AccountApplicationUpdateStatusJson object that needs to be added. (required)
        :param str account_application_id: the account application id  (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_account_application_status_with_http_info(body, account_application_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_account_application_status_with_http_info(body, account_application_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_account_application_status_with_http_info(self, body, account_application_id, bank_id, **kwargs):  # noqa: E501
        """Update Account Application Status  # noqa: E501

        <p>Update an Account Application status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_account_application_status_with_http_info(body, account_application_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccountApplicationUpdateStatusJson body: AccountApplicationUpdateStatusJson object that needs to be added. (required)
        :param str account_application_id: the account application id  (required)
        :param str bank_id: The bank id (required)
        :return: AccountApplicationResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_application_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_account_application_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_account_application_status`")  # noqa: E501
        # verify the required parameter 'account_application_id' is set
        if self.api_client.client_side_validation and ('account_application_id' not in params or
                                                       params['account_application_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_application_id` when calling `update_account_application_status`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_account_application_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_application_id' in params:
            path_params['ACCOUNT_APPLICATION_ID'] = params['account_application_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/account-applications/{ACCOUNT_APPLICATION_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountApplicationResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
