# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class APIApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def config(self, **kwargs):  # noqa: E501
        """Get API Configuration  # noqa: E501

        <p>Returns information about:</p><ul><li>The default bank_id</li><li>Akka configuration</li><li>Elastic Search configuration</li><li>Cached functions</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigurationJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.config_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.config_with_http_info(**kwargs)  # noqa: E501
            return data

    def config_with_http_info(self, **kwargs):  # noqa: E501
        """Get API Configuration  # noqa: E501

        <p>Returns information about:</p><ul><li>The default bank_id</li><li>Akka configuration</li><li>Elastic Search configuration</li><li>Cached functions</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConfigurationJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method config" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConfigurationJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bank_level_dynamic_endpoint(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Endpoint  # noqa: E501

        <p>Create dynamic endpoints.</p><p>Create dynamic endpoints with one json format swagger content.</p><p>If the host of swagger is <code>dynamic_entity</code>, then you need link the swagger fields to the dynamic entity fields,<br />please check <code>Endpoint Mapping</code> endpoints.</p><p>If the host of swagger is <code>obp_mock</code>, every dynamic endpoint will return example response of swagger,</p><p>when create MethodRouting for given dynamic endpoint, it will be routed to given url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_endpoint(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body body: JObject object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bank_level_dynamic_endpoint_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bank_level_dynamic_endpoint_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_bank_level_dynamic_endpoint_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Endpoint  # noqa: E501

        <p>Create dynamic endpoints.</p><p>Create dynamic endpoints with one json format swagger content.</p><p>If the host of swagger is <code>dynamic_entity</code>, then you need link the swagger fields to the dynamic entity fields,<br />please check <code>Endpoint Mapping</code> endpoints.</p><p>If the host of swagger is <code>obp_mock</code>, every dynamic endpoint will return example response of swagger,</p><p>when create MethodRouting for given dynamic endpoint, it will be routed to given url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_endpoint_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body body: JObject object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bank_level_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_bank_level_dynamic_endpoint`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_bank_level_dynamic_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse201',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bank_level_dynamic_entity(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Entity  # noqa: E501

        <p>Create a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;branchId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;atmId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;productCode=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;cardId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;transactionId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;counterpartyId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_entity(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bank_level_dynamic_entity_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bank_level_dynamic_entity_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_bank_level_dynamic_entity_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Entity  # noqa: E501

        <p>Create a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;branchId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;atmId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;productCode=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;cardId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;transactionId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;counterpartyId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_entity_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_bank_level_endpoint_tag(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Endpoint Tag  # noqa: E501

        <p>Create Bank Level Endpoint Tag</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_endpoint_tag(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bank_level_endpoint_tag_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bank_level_endpoint_tag_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_bank_level_endpoint_tag_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Endpoint Tag  # noqa: E501

        <p>Create Bank Level Endpoint Tag</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_endpoint_tag_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bank_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_bank_level_endpoint_tag`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_bank_level_endpoint_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/endpoints/OPERATION_ID/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLevelEndpointTagResponseJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_dynamic_endpoint(self, body, **kwargs):  # noqa: E501
        """Create Dynamic Endpoint  # noqa: E501

        <p>Create dynamic endpoints.</p><p>Create dynamic endpoints with one json format swagger content.</p><p>If the host of swagger is <code>dynamic_entity</code>, then you need link the swagger fields to the dynamic entity fields,<br />please check <code>Endpoint Mapping</code> endpoints.</p><p>If the host of swagger is <code>obp_mock</code>, every dynamic endpoint will return example response of swagger,</p><p>when create MethodRouting for given dynamic endpoint, it will be routed to given url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dynamic_endpoint(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body3 body: JObject object that needs to be added. (required)
        :return: InlineResponse2011
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_dynamic_endpoint_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_dynamic_endpoint_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_dynamic_endpoint_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create Dynamic Endpoint  # noqa: E501

        <p>Create dynamic endpoints.</p><p>Create dynamic endpoints with one json format swagger content.</p><p>If the host of swagger is <code>dynamic_entity</code>, then you need link the swagger fields to the dynamic entity fields,<br />please check <code>Endpoint Mapping</code> endpoints.</p><p>If the host of swagger is <code>obp_mock</code>, every dynamic endpoint will return example response of swagger,</p><p>when create MethodRouting for given dynamic endpoint, it will be routed to given url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_dynamic_endpoint_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body3 body: JObject object that needs to be added. (required)
        :return: InlineResponse2011
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_dynamic_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/dynamic-endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2011',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_method_routing(self, body, **kwargs):  # noqa: E501
        """Create MethodRouting  # noqa: E501

        <p>Create a MethodRouting.</p><p>Authentication is Mandatory</p><p>Explanation of Fields:</p><ul><li>method_name is required String value, current supported value: [mapped | internal | rest_vMar2019]</li><li>connector_name is required String value</li><li>is_bank_id_exact_match is required boolean value, if bank_id_pattern is exact bank_id value, this value is true; if bank_id_pattern is null or a regex, this value is false</li><li>bank_id_pattern is optional String value, it can be null, a exact bank_id or a regex</li><li>parameters is optional array of key value pairs. You can set some parameters for this method</li></ul><p>note and CAVEAT!:</p><ul><li>bank_id_pattern has to be empty for methods that do not take bank_id as a function parameter, otherwise might get empty result</li><li>methods that aggregate bank objects (e.g. getBankAccountsForUser) have to take any  existing method routings for these objects into consideration</li><li>so if you create e.g. a bank specific method routing for getting an account, make sure that it is also served by endpoints getting ALL accounts for ALL banks</li><li>if bank_id_pattern is regex, special characters need to do escape, for example: bank_id_pattern = &quot;some-id_pattern_\\d+&quot;</li></ul><p>If the connector name starts with rest, parameters can contain &quot;outBoundMapping&quot; and &quot;inBoundMapping&quot;, convert OutBound and InBound json structure.<br />for example:<br />outBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248007-33332e00-580e-11ea-8d2a-d1856035fa24.png\" alt=\"Snipaste_outBoundMapping\" /><br />Build OutBound json value rules:<br />1 set cId value with: outboundAdapterCallContext.correlationId value<br />2 set bankId value with: concat bankId.value value with  string helloworld<br />3 set originalJson value with: whole source json, note: the field value expression is $root</p><p>inBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248199-a9d02b80-580e-11ea-9238-e073264e9170.png\" alt=\"inBoundMapping\" /><br />Build InBound json value rules:<br />1 and 2 set inboundAdapterCallContext and status value: because field name ends with &quot;$default&quot;, remove &quot;$default&quot; from field name, not change the value<br />3 set fullName value with: concat string full: with result.name value<br />4 set bankRoutingScheme value: because source value is Array, but target value is not Array, the mapping field name must ends with [0].</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_method_routing(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MethodRoutingCommons body: MethodRoutingCommons object that needs to be added. (required)
        :return: MethodRoutingCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_method_routing_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_method_routing_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_method_routing_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create MethodRouting  # noqa: E501

        <p>Create a MethodRouting.</p><p>Authentication is Mandatory</p><p>Explanation of Fields:</p><ul><li>method_name is required String value, current supported value: [mapped | internal | rest_vMar2019]</li><li>connector_name is required String value</li><li>is_bank_id_exact_match is required boolean value, if bank_id_pattern is exact bank_id value, this value is true; if bank_id_pattern is null or a regex, this value is false</li><li>bank_id_pattern is optional String value, it can be null, a exact bank_id or a regex</li><li>parameters is optional array of key value pairs. You can set some parameters for this method</li></ul><p>note and CAVEAT!:</p><ul><li>bank_id_pattern has to be empty for methods that do not take bank_id as a function parameter, otherwise might get empty result</li><li>methods that aggregate bank objects (e.g. getBankAccountsForUser) have to take any  existing method routings for these objects into consideration</li><li>so if you create e.g. a bank specific method routing for getting an account, make sure that it is also served by endpoints getting ALL accounts for ALL banks</li><li>if bank_id_pattern is regex, special characters need to do escape, for example: bank_id_pattern = &quot;some-id_pattern_\\d+&quot;</li></ul><p>If the connector name starts with rest, parameters can contain &quot;outBoundMapping&quot; and &quot;inBoundMapping&quot;, convert OutBound and InBound json structure.<br />for example:<br />outBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248007-33332e00-580e-11ea-8d2a-d1856035fa24.png\" alt=\"Snipaste_outBoundMapping\" /><br />Build OutBound json value rules:<br />1 set cId value with: outboundAdapterCallContext.correlationId value<br />2 set bankId value with: concat bankId.value value with  string helloworld<br />3 set originalJson value with: whole source json, note: the field value expression is $root</p><p>inBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248199-a9d02b80-580e-11ea-9238-e073264e9170.png\" alt=\"inBoundMapping\" /><br />Build InBound json value rules:<br />1 and 2 set inboundAdapterCallContext and status value: because field name ends with &quot;$default&quot;, remove &quot;$default&quot; from field name, not change the value<br />3 set fullName value with: concat string full: with result.name value<br />4 set bankRoutingScheme value: because source value is Array, but target value is not Array, the mapping field name must ends with [0].</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_method_routing_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MethodRoutingCommons body: MethodRoutingCommons object that needs to be added. (required)
        :return: MethodRoutingCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_method_routing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_method_routing`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/method_routings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MethodRoutingCommons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_system_dynamic_entity(self, body, **kwargs):  # noqa: E501
        """Create System Level Dynamic Entity  # noqa: E501

        <p>Create a system level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />See the following list of currently available reference types and examples of how to construct key values correctly. Note: As more Dynamic Entities are created on this instance, this list will grow:</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;branchId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;atmId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;productCode=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;cardId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;transactionId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;counterpartyId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_dynamic_entity(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_system_dynamic_entity_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_system_dynamic_entity_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_system_dynamic_entity_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create System Level Dynamic Entity  # noqa: E501

        <p>Create a system level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />See the following list of currently available reference types and examples of how to construct key values correctly. Note: As more Dynamic Entities are created on this instance, this list will grow:</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;branchId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;atmId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;productCode=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;cardId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;transactionId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;counterpartyId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_dynamic_entity_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_system_level_endpoint_tag(self, body, **kwargs):  # noqa: E501
        """Create System Level Endpoint Tag  # noqa: E501

        <p>Create System Level Endpoint Tag</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_level_endpoint_tag(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_system_level_endpoint_tag_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_system_level_endpoint_tag_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_system_level_endpoint_tag_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create System Level Endpoint Tag  # noqa: E501

        <p>Create System Level Endpoint Tag</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_level_endpoint_tag_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_system_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_system_level_endpoint_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/endpoints/OPERATION_ID/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLevelEndpointTagResponseJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bank_level_dynamic_endpoint(self, bank_id, **kwargs):  # noqa: E501
        """ Delete Bank Level Dynamic Endpoint  # noqa: E501

        <p>Delete a Bank Level DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_endpoint(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bank_level_dynamic_endpoint_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bank_level_dynamic_endpoint_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_bank_level_dynamic_endpoint_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """ Delete Bank Level Dynamic Endpoint  # noqa: E501

        <p>Delete a Bank Level DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_endpoint_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bank_level_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_bank_level_dynamic_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-endpoints/DYNAMIC_ENDPOINT_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bank_level_dynamic_entity(self, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Dynamic Entity  # noqa: E501

        <p>Delete a Bank Level DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_entity(dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_bank_level_dynamic_entity_with_http_info(self, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Dynamic Entity  # noqa: E501

        <p>Delete a Bank Level DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bank_level_endpoint_tag(self, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Endpoint Tag  # noqa: E501

        <p>Delete Bank Level Endpoint Tag.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_endpoint_tag(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bank_level_endpoint_tag_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bank_level_endpoint_tag_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_bank_level_endpoint_tag_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Endpoint Tag  # noqa: E501

        <p>Delete Bank Level Endpoint Tag.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_endpoint_tag_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bank_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_bank_level_endpoint_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/endpoints/OPERATION_ID/tags/ENDPOINT_TAG_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_dynamic_endpoint(self, **kwargs):  # noqa: E501
        """ Delete Dynamic Endpoint  # noqa: E501

        <p>Delete a DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dynamic_endpoint(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_dynamic_endpoint_with_http_info(self, **kwargs):  # noqa: E501
        """ Delete Dynamic Endpoint  # noqa: E501

        <p>Delete a DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_dynamic_endpoint_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/dynamic-endpoints/DYNAMIC_ENDPOINT_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_method_routing(self, method_routing_id, **kwargs):  # noqa: E501
        """Delete MethodRouting  # noqa: E501

        <p>Delete a MethodRouting specified by METHOD_ROUTING_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_method_routing(method_routing_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str method_routing_id: the method routing id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_method_routing_with_http_info(method_routing_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_method_routing_with_http_info(method_routing_id, **kwargs)  # noqa: E501
            return data

    def delete_method_routing_with_http_info(self, method_routing_id, **kwargs):  # noqa: E501
        """Delete MethodRouting  # noqa: E501

        <p>Delete a MethodRouting specified by METHOD_ROUTING_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_method_routing_with_http_info(method_routing_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str method_routing_id: the method routing id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['method_routing_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_method_routing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'method_routing_id' is set
        if self.api_client.client_side_validation and ('method_routing_id' not in params or
                                                       params['method_routing_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `method_routing_id` when calling `delete_method_routing`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'method_routing_id' in params:
            path_params['METHOD_ROUTING_ID'] = params['method_routing_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/method_routings/{METHOD_ROUTING_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_dynamic_endpoint(self, **kwargs):  # noqa: E501
        """Delete My Dynamic Endpoint  # noqa: E501

        <p>Delete a DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_endpoint(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_my_dynamic_endpoint_with_http_info(self, **kwargs):  # noqa: E501
        """Delete My Dynamic Endpoint  # noqa: E501

        <p>Delete a DynamicEndpoint specified by DYNAMIC_ENDPOINT_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_endpoint_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-endpoints/DYNAMIC_ENDPOINT_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_dynamic_entity(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete My Dynamic Entity  # noqa: E501

        <p>Delete my DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_entity(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def delete_my_dynamic_entity_with_http_info(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete My Dynamic Entity  # noqa: E501

        <p>Delete my DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_my_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_system_dynamic_entity(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete System Level Dynamic Entity  # noqa: E501

        <p>Delete a DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_dynamic_entity(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def delete_system_dynamic_entity_with_http_info(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete System Level Dynamic Entity  # noqa: E501

        <p>Delete a DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_system_level_endpoint_tag(self, **kwargs):  # noqa: E501
        """Delete System Level Endpoint Tag  # noqa: E501

        <p>Delete System Level Endpoint Tag.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_level_endpoint_tag(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_system_level_endpoint_tag_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_system_level_endpoint_tag_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_system_level_endpoint_tag_with_http_info(self, **kwargs):  # noqa: E501
        """Delete System Level Endpoint Tag  # noqa: E501

        <p>Delete System Level Endpoint Tag.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_level_endpoint_tag_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_system_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/endpoints/OPERATION_ID/tags/ENDPOINT_TAG_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elastic_search_metrics(self, body, **kwargs):  # noqa: E501
        """Search API Metrics via Elasticsearch  # noqa: E501

        <p>Search the API calls made to this API instance via Elastic Search.</p><p>Login is required.</p><p>CanSearchMetrics entitlement is required to search metrics data.</p><p>parameters:</p><p>esType  - elasticsearch type</p><p>simple query:</p><p>q       - plain_text_query</p><p>df      - default field to search</p><p>sort    - field to sort on</p><p>size    - number of hits returned, default 10</p><p>from    - show hits starting from</p><p>json query:</p><p>source  - JSON_query_(URL-escaped)</p><p>example usage:</p><p>/search/metrics/q=findThis</p><p>or:</p><p>/search/metrics/source={&quot;query&quot;:{&quot;query_string&quot;:{&quot;query&quot;:&quot;findThis&quot;}}}</p><p>Note!!</p><p>The whole JSON query string MUST be URL-encoded:</p><ul><li>For {  use %7B</li><li>For }  use %7D</li><li>For : use %3A</li><li>For &quot; use %22</li></ul><p>etc..</p><p>Only q, source and esType are passed to Elastic</p><p>Elastic simple query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html</a></p><p>Elastic JSON query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elastic_search_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.elastic_search_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.elastic_search_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def elastic_search_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search API Metrics via Elasticsearch  # noqa: E501

        <p>Search the API calls made to this API instance via Elastic Search.</p><p>Login is required.</p><p>CanSearchMetrics entitlement is required to search metrics data.</p><p>parameters:</p><p>esType  - elasticsearch type</p><p>simple query:</p><p>q       - plain_text_query</p><p>df      - default field to search</p><p>sort    - field to sort on</p><p>size    - number of hits returned, default 10</p><p>from    - show hits starting from</p><p>json query:</p><p>source  - JSON_query_(URL-escaped)</p><p>example usage:</p><p>/search/metrics/q=findThis</p><p>or:</p><p>/search/metrics/source={&quot;query&quot;:{&quot;query_string&quot;:{&quot;query&quot;:&quot;findThis&quot;}}}</p><p>Note!!</p><p>The whole JSON query string MUST be URL-encoded:</p><ul><li>For {  use %7B</li><li>For }  use %7D</li><li>For : use %3A</li><li>For &quot; use %22</li></ul><p>etc..</p><p>Only q, source and esType are passed to Elastic</p><p>Elastic simple query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-uri-request.html</a></p><p>Elastic JSON query: <a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/query-filter-context.html</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elastic_search_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method elastic_search_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `elastic_search_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/search/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_adapter_info(self, **kwargs):  # noqa: E501
        """Get Adapter Info  # noqa: E501

        <p>Get basic information about the Adapter.</p><p>Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_adapter_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdapterInfoJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_adapter_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_adapter_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_adapter_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get Adapter Info  # noqa: E501

        <p>Get basic information about the Adapter.</p><p>Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_adapter_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdapterInfoJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_adapter_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/adapter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdapterInfoJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_adapter_info_for_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Adapter Info for a bank  # noqa: E501

        <p>Get basic information about the Adapter listening on behalf of this bank.</p><p>Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_adapter_info_for_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AdapterInfoJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_adapter_info_for_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_adapter_info_for_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_adapter_info_for_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Adapter Info for a bank  # noqa: E501

        <p>Get basic information about the Adapter listening on behalf of this bank.</p><p>Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_adapter_info_for_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AdapterInfoJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_adapter_info_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_adapter_info_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/adapter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdapterInfoJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_dynamic_endpoint(self, bank_id, **kwargs):  # noqa: E501
        """ Get Bank Level Dynamic Endpoint  # noqa: E501

        <p>Get a Bank Level Dynamic Endpoint.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_endpoint(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_dynamic_endpoint_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_dynamic_endpoint_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_dynamic_endpoint_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """ Get Bank Level Dynamic Endpoint  # noqa: E501

        <p>Get a Bank Level Dynamic Endpoint.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_endpoint_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse201
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_dynamic_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-endpoints/DYNAMIC_ENDPOINT_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse201',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_dynamic_endpoints(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Endpoints  # noqa: E501

        <p>Get Bank Level Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_endpoints(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2003
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_dynamic_endpoints_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_dynamic_endpoints_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_dynamic_endpoints_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Endpoints  # noqa: E501

        <p>Get Bank Level Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_endpoints_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2003
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_dynamic_endpoints" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_dynamic_endpoints`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2003',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_dynamic_entities(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Entities  # noqa: E501

        <p>Get all the bank level Dynamic Entities for one bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_entities(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_dynamic_entities_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_dynamic_entities_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_dynamic_entities_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Entities  # noqa: E501

        <p>Get all the bank level Dynamic Entities for one bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_entities_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_dynamic_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_dynamic_resource_docs_obp(self, body, api_version, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Resource Docs.  # noqa: E501

        <p>Get documentation about the RESTful resources on this server including example bodies for POST and PUT requests.</p><p>This is the native data format used to document OBP endpoints. Each endpoint has a Resource Doc (a Scala case class) defined in the source code.</p><p>This endpoint is used by OBP API Explorer to display and work with the API documentation.</p><p>Most (but not all) fields are also available in swagger format. (The Swagger endpoint is built from Resource Docs.)</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint with tags parameter e.g. ?tags=Account,Bank</p><p>You may filter this endpoint with functions parameter e.g. ?functions=enableDisableConsumers,getConnectorMetrics</p><p>For possible function values, see implemented_by.function in the JSON returned by this endpoint or the OBP source code or the footer of the API Explorer which produces a comma separated list of functions that reflect the server or filtering by API Explorer based on tags etc.</p><p>You may filter this endpoint using the 'content' url parameter, e.g. ?content=dynamic<br />if set content=dynamic, only show dynamic endpoints, if content=static, only show the static endpoints. if omit this parameter, we will show all the endpoints.</p><p>You may need some other language resource docs, now we support i18n language tag , e.g. ?locale=zh_CN</p><p>You can filter with api-collection-id, but api-collection-id can not be used with others together. If api-collection-id is used in URL, it will ignore all other parameters.</p><p>You can easily pass the cache, use different value for cache-modifier, eg: ?cache-modifier= 123</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?tags=Account,Bank\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?locale=zh_CN\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?locale=zh_CN</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?content=static,dynamic,all\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?content=static,dynamic,all</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?cache-modifier=3141592653\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?cache-modifier=3141592653</a></p><ul><li> operation_id is concatenation of \"v\", version and function and should be unique (used for DOM element IDs etc. maybe used to link to source code) </li><li> version references the version that the API call is defined in.</li><li> function is the (scala) partial function that implements this endpoint. It is unique per version of the API.</li><li> request_url is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the implemented version (the version where this endpoint was defined) e.g. /obp/v1.2.0/resource</li><li> specified_url (recommended to use) is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the version specified in the call e.g. /obp/v3.1.0/resource. In OBP, endpoints are first made available at the request_url, but the same resource (function call) is often made available under later versions (specified_url). To access the latest version of all endpoints use the latest version available on your OBP instance e.g. /obp/v3.1.0 - To get the original version use the request_url. We recommend to use the specified_url since non semantic improvements are more likely to be applied to later implementations of the call.</li><li> summary is a short description inline with the swagger terminology. </li><li> description may contain html markup (generated from markdown on the server).</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_resource_docs_obp(body, api_version, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :param str bank_id: The bank id (required)
        :return: ResourceDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_dynamic_resource_docs_obp_with_http_info(body, api_version, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_dynamic_resource_docs_obp_with_http_info(body, api_version, bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_dynamic_resource_docs_obp_with_http_info(self, body, api_version, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Resource Docs.  # noqa: E501

        <p>Get documentation about the RESTful resources on this server including example bodies for POST and PUT requests.</p><p>This is the native data format used to document OBP endpoints. Each endpoint has a Resource Doc (a Scala case class) defined in the source code.</p><p>This endpoint is used by OBP API Explorer to display and work with the API documentation.</p><p>Most (but not all) fields are also available in swagger format. (The Swagger endpoint is built from Resource Docs.)</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint with tags parameter e.g. ?tags=Account,Bank</p><p>You may filter this endpoint with functions parameter e.g. ?functions=enableDisableConsumers,getConnectorMetrics</p><p>For possible function values, see implemented_by.function in the JSON returned by this endpoint or the OBP source code or the footer of the API Explorer which produces a comma separated list of functions that reflect the server or filtering by API Explorer based on tags etc.</p><p>You may filter this endpoint using the 'content' url parameter, e.g. ?content=dynamic<br />if set content=dynamic, only show dynamic endpoints, if content=static, only show the static endpoints. if omit this parameter, we will show all the endpoints.</p><p>You may need some other language resource docs, now we support i18n language tag , e.g. ?locale=zh_CN</p><p>You can filter with api-collection-id, but api-collection-id can not be used with others together. If api-collection-id is used in URL, it will ignore all other parameters.</p><p>You can easily pass the cache, use different value for cache-modifier, eg: ?cache-modifier= 123</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?tags=Account,Bank\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?locale=zh_CN\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?locale=zh_CN</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?content=static,dynamic,all\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?content=static,dynamic,all</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?cache-modifier=3141592653\">https://test.openbankproject.com/obp/v4.0.0/banks/BANK_ID/resource-docs/v4.0.0/obp?cache-modifier=3141592653</a></p><ul><li> operation_id is concatenation of \"v\", version and function and should be unique (used for DOM element IDs etc. maybe used to link to source code) </li><li> version references the version that the API call is defined in.</li><li> function is the (scala) partial function that implements this endpoint. It is unique per version of the API.</li><li> request_url is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the implemented version (the version where this endpoint was defined) e.g. /obp/v1.2.0/resource</li><li> specified_url (recommended to use) is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the version specified in the call e.g. /obp/v3.1.0/resource. In OBP, endpoints are first made available at the request_url, but the same resource (function call) is often made available under later versions (specified_url). To access the latest version of all endpoints use the latest version available on your OBP instance e.g. /obp/v3.1.0 - To get the original version use the request_url. We recommend to use the specified_url since non semantic improvements are more likely to be applied to later implementations of the call.</li><li> summary is a short description inline with the swagger terminology. </li><li> description may contain html markup (generated from markdown on the server).</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_resource_docs_obp_with_http_info(body, api_version, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :param str bank_id: The bank id (required)
        :return: ResourceDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_dynamic_resource_docs_obp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_bank_level_dynamic_resource_docs_obp`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if self.api_client.client_side_validation and ('api_version' not in params or
                                                       params['api_version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `api_version` when calling `get_bank_level_dynamic_resource_docs_obp`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_dynamic_resource_docs_obp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'api_version' in params:
            path_params['API_VERSION'] = params['api_version']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/resource-docs/{API_VERSION}/obp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDocsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_endpoint_tags(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Endpoint Tags  # noqa: E501

        <p>Get Bank Level Endpoint Tags.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_endpoint_tags(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: NotSupportedYet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_endpoint_tags_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_endpoint_tags_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_endpoint_tags_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Endpoint Tags  # noqa: E501

        <p>Get Bank Level Endpoint Tags.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_endpoint_tags_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: NotSupportedYet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_endpoint_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_endpoint_tags`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/endpoints/OPERATION_ID/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotSupportedYet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_call_context(self, **kwargs):  # noqa: E501
        """Get the Call Context of a current call  # noqa: E501

        <p>Get the Call Context of the current call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_call_context(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_call_context_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_call_context_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_call_context_with_http_info(self, **kwargs):  # noqa: E501
        """Get the Call Context of a current call  # noqa: E501

        <p>Get the Call Context of the current call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_call_context_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_call_context" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/development/call_context', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_connector_metrics(self, body, **kwargs):  # noqa: E501
        """Get Connector Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanGetConnectorMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/connector/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 1000)  eg:limit=2000</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=100&amp;offset=300</p><p>Other filters:</p><p>5 connector_name  (if null ignore)</p><p>6 function_name (if null ignore)</p><p>7 correlation_id (if null ignore)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: ConnectorMetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_connector_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_connector_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_connector_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get Connector Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanGetConnectorMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/connector/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 1000)  eg:limit=2000</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>eg: /management/connector/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=100&amp;offset=300</p><p>Other filters:</p><p>5 connector_name  (if null ignore)</p><p>6 function_name (if null ignore)</p><p>7 correlation_id (if null ignore)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_connector_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: ConnectorMetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_connector_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_connector_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/connector/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConnectorMetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_endpoint(self, **kwargs):  # noqa: E501
        """Get Dynamic Endpoint  # noqa: E501

        <p>Get a Dynamic Endpoint.</p><p>Get one DynamicEndpoint,</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_endpoint(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2011
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_endpoint_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dynamic_endpoint_with_http_info(self, **kwargs):  # noqa: E501
        """Get Dynamic Endpoint  # noqa: E501

        <p>Get a Dynamic Endpoint.</p><p>Get one DynamicEndpoint,</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_endpoint_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2011
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_endpoint" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/dynamic-endpoints/DYNAMIC_ENDPOINT_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2011',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_dynamic_endpoints(self, **kwargs):  # noqa: E501
        """ Get Dynamic Endpoints  # noqa: E501

        <p>Get Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_dynamic_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_dynamic_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_dynamic_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """ Get Dynamic Endpoints  # noqa: E501

        <p>Get Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_dynamic_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2009
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dynamic_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/dynamic-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2009',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_mapper_database_info(self, **kwargs):  # noqa: E501
        """Get Mapper Database Info  # noqa: E501

        <p>Get basic information about the Mapper Database.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapper_database_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdapterInfoJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_mapper_database_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_mapper_database_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_mapper_database_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get Mapper Database Info  # noqa: E501

        <p>Get basic information about the Mapper Database.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_mapper_database_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: AdapterInfoJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_mapper_database_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/database/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AdapterInfoJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_message_docs(self, body, **kwargs):  # noqa: E501
        """Get Message Docs  # noqa: E501

        <p>These message docs provide example messages sent by OBP to the (Kafka) message queue for processing by the Core Banking / Payment system Adapter - together with an example expected response and possible error codes.<br />Integrators can use these messages to build Adapters that provide core banking services to OBP.</p><p>Note: API Explorer provides a Message Docs page where these messages are displayed.</p><p><code>CONNECTOR</code>: kafka_vSept2018, stored_procedure_vDec2019 ...</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_docs(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MessageDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_message_docs_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_message_docs_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_message_docs_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get Message Docs  # noqa: E501

        <p>These message docs provide example messages sent by OBP to the (Kafka) message queue for processing by the Core Banking / Payment system Adapter - together with an example expected response and possible error codes.<br />Integrators can use these messages to build Adapters that provide core banking services to OBP.</p><p>Note: API Explorer provides a Message Docs page where these messages are displayed.</p><p><code>CONNECTOR</code>: kafka_vSept2018, stored_procedure_vDec2019 ...</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_docs_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MessageDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_docs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_message_docs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/message-docs/CONNECTOR', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageDocsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_message_docs_swagger(self, **kwargs):  # noqa: E501
        """Get Message Docs Swagger  # noqa: E501

        <p>This endpoint provides example message docs in swagger format.<br />It is only relavent for REST Connectors.</p><p>This endpoint can be used by the developer building a REST Adapter that connects to the Core Banking System (CBS).<br />That is, the Adapter developer can use the Swagger surfaced here to build the REST APIs that the OBP REST connector will call to consume CBS services.</p><p>i.e.:</p><p>OBP API (Core OBP API code) -&gt; OBP REST Connector (OBP REST Connector code) -&gt; OBP REST Adapter (Adapter developer code) -&gt; CBS (Main Frame)</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_docs_swagger(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: MessageDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_message_docs_swagger_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_message_docs_swagger_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_message_docs_swagger_with_http_info(self, **kwargs):  # noqa: E501
        """Get Message Docs Swagger  # noqa: E501

        <p>This endpoint provides example message docs in swagger format.<br />It is only relavent for REST Connectors.</p><p>This endpoint can be used by the developer building a REST Adapter that connects to the Core Banking System (CBS).<br />That is, the Adapter developer can use the Swagger surfaced here to build the REST APIs that the OBP REST connector will call to consume CBS services.</p><p>i.e.:</p><p>OBP API (Core OBP API code) -&gt; OBP REST Connector (OBP REST Connector code) -&gt; OBP REST Adapter (Adapter developer code) -&gt; CBS (Main Frame)</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_message_docs_swagger_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: MessageDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_message_docs_swagger" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/message-docs/CONNECTOR/swagger2.0', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MessageDocsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_method_routings(self, **kwargs):  # noqa: E501
        """Get MethodRoutings  # noqa: E501

        <p>Get the all MethodRoutings.</p><p>Query url parameters:</p><ul><li>method_name: filter with method_name</li><li>active: if active = true, it will show all the webui_ props. Even if they are set yet, we will return all the default webui_ props</li></ul><p>eg:<br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/management/method_routings?active=true\">https://test.openbankproject.com/obp/v3.1.0/management/method_routings?active=true</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/management/method_routings?method_name=getBank\">https://test.openbankproject.com/obp/v3.1.0/management/method_routings?method_name=getBank</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_method_routings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20010
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_method_routings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_method_routings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_method_routings_with_http_info(self, **kwargs):  # noqa: E501
        """Get MethodRoutings  # noqa: E501

        <p>Get the all MethodRoutings.</p><p>Query url parameters:</p><ul><li>method_name: filter with method_name</li><li>active: if active = true, it will show all the webui_ props. Even if they are set yet, we will return all the default webui_ props</li></ul><p>eg:<br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/management/method_routings?active=true\">https://test.openbankproject.com/obp/v3.1.0/management/method_routings?active=true</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/management/method_routings?method_name=getBank\">https://test.openbankproject.com/obp/v3.1.0/management/method_routings?method_name=getBank</a></p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_method_routings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20010
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_method_routings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/method_routings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20010',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics(self, body, **kwargs):  # noqa: E501
        """Get Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"m&#97;&#x69;&#108;&#x74;&#111;:&#48;&#49;&#x2e;&#x30;&#x30;&#x30;&#x5a;&#38;&#x6c;&#105;&#x6d;&#x69;&#x74;&#x3d;&#49;&#48;&#48;0&#48;&#38;&#111;&#x66;&#102;&#115;&#101;t&#x3d;&#x30;&amp;&#x61;&#110;&#111;&#x6e;&#x3d;&#x66;a&#x6c;&#x73;&#x65;&#38;&#x61;&#x70;&#x70;&#95;&#x6e;&#x61;&#x6d;e=&#84;&#101;&#x61;&#x74;&#x41;&#112;&#x70;&#x26;&#x69;&#x6d;p&#x6c;&#101;&#x6d;&#x65;&#x6e;&#116;&#x65;&#100;_i&#x6e;&#95;&#118;e&#114;&#x73;&#105;&#x6f;&#110;&#x3d;&#x76;&#x32;&#x2e;&#x31;.&#48;&#x26;v&#101;&#x72;&#x62;&#61;&#x50;OS&#84;&amp;&#x75;&#x73;&#101;&#x72;&#x5f;&#x69;&#x64;&#x3d;&#99;&#x37;&#98;&#54;c&#x62;&#x34;&#x37;&#45;&#x63;&#98;&#57;&#54;&#x2d;&#x34;&#52;&#52;1&#45;&#x38;&#56;&#x30;1&#x2d;&#x33;&#53;&#98;&#53;&#x37;&#x34;&#x35;&#54;&#x37;&#x35;&#51;&#x61;&amp;&#x75;&#115;e&#x72;&#95;&#110;a&#109;e&#x3d;&#115;&#117;&#x73;&#x61;&#110;&#x2e;&#x75;&#x6b;&#46;&#x32;&#57;@&#x65;&#120;&#97;&#109;p&#108;&#x65;.&#99;&#x6f;&#109;\">&#x30;1&#x2e;&#x30;&#x30;&#x30;&#90;&#38;l&#x69;&#x6d;&#105;&#x74;=&#x31;&#48;&#x30;0&#48;&amp;&#111;&#x66;&#x66;&#115;&#101;t=&#48;&#x26;a&#x6e;o&#110;&#x3d;&#102;&#97;&#108;&#115;&#101;&#38;&#x61;p&#x70;&#x5f;&#110;&#x61;&#x6d;&#101;=&#84;&#101;a&#x74;&#x41;&#112;&#x70;&#38;i&#109;p&#x6c;&#x65;&#x6d;&#x65;&#110;&#116;&#x65;d&#95;i&#x6e;&#95;&#x76;&#101;&#114;s&#105;o&#x6e;=&#x76;&#x32;&#x2e;1&#46;&#48;&#x26;v&#x65;&#x72;&#98;&#x3d;&#x50;&#x4f;&#83;&#84;&#x26;&#117;&#x73;&#x65;r&#95;&#105;d=&#99;&#x37;&#x62;&#x36;&#99;&#x62;&#x34;&#x37;&#45;&#99;&#98;&#x39;&#54;-&#52;&#x34;&#52;&#x31;-&#56;&#56;&#48;1&#45;&#x33;5&#x62;5&#x37;&#x34;&#53;&#54;&#x37;&#53;&#x33;&#97;&#x26;u&#115;&#x65;&#x72;&#95;n&#x61;me&#61;&#115;&#117;s&#97;&#110;&#46;&#117;&#107;&#x2e;&#x32;9&#x40;&#x65;&#x78;&#97;&#x6d;p&#x6c;e&#x2e;co&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_metrics_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get Metrics  # noqa: E501

        <p>Get the all metrics</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"m&#97;&#x69;&#108;&#x74;&#111;:&#48;&#49;&#x2e;&#x30;&#x30;&#x30;&#x5a;&#38;&#x6c;&#105;&#x6d;&#x69;&#x74;&#x3d;&#49;&#48;&#48;0&#48;&#38;&#111;&#x66;&#102;&#115;&#101;t&#x3d;&#x30;&amp;&#x61;&#110;&#111;&#x6e;&#x3d;&#x66;a&#x6c;&#x73;&#x65;&#38;&#x61;&#x70;&#x70;&#95;&#x6e;&#x61;&#x6d;e=&#84;&#101;&#x61;&#x74;&#x41;&#112;&#x70;&#x26;&#x69;&#x6d;p&#x6c;&#101;&#x6d;&#x65;&#x6e;&#116;&#x65;&#100;_i&#x6e;&#95;&#118;e&#114;&#x73;&#105;&#x6f;&#110;&#x3d;&#x76;&#x32;&#x2e;&#x31;.&#48;&#x26;v&#101;&#x72;&#x62;&#61;&#x50;OS&#84;&amp;&#x75;&#x73;&#101;&#x72;&#x5f;&#x69;&#x64;&#x3d;&#99;&#x37;&#98;&#54;c&#x62;&#x34;&#x37;&#45;&#x63;&#98;&#57;&#54;&#x2d;&#x34;&#52;&#52;1&#45;&#x38;&#56;&#x30;1&#x2d;&#x33;&#53;&#98;&#53;&#x37;&#x34;&#x35;&#54;&#x37;&#x35;&#51;&#x61;&amp;&#x75;&#115;e&#x72;&#95;&#110;a&#109;e&#x3d;&#115;&#117;&#x73;&#x61;&#110;&#x2e;&#x75;&#x6b;&#46;&#x32;&#57;@&#x65;&#120;&#97;&#109;p&#108;&#x65;.&#99;&#x6f;&#109;\">&#x30;1&#x2e;&#x30;&#x30;&#x30;&#90;&#38;l&#x69;&#x6d;&#105;&#x74;=&#x31;&#48;&#x30;0&#48;&amp;&#111;&#x66;&#x66;&#115;&#101;t=&#48;&#x26;a&#x6e;o&#110;&#x3d;&#102;&#97;&#108;&#115;&#101;&#38;&#x61;p&#x70;&#x5f;&#110;&#x61;&#x6d;&#101;=&#84;&#101;a&#x74;&#x41;&#112;&#x70;&#38;i&#109;p&#x6c;&#x65;&#x6d;&#x65;&#110;&#116;&#x65;d&#95;i&#x6e;&#95;&#x76;&#101;&#114;s&#105;o&#x6e;=&#x76;&#x32;&#x2e;1&#46;&#48;&#x26;v&#x65;&#x72;&#98;&#x3d;&#x50;&#x4f;&#83;&#84;&#x26;&#117;&#x73;&#x65;r&#95;&#105;d=&#99;&#x37;&#x62;&#x36;&#99;&#x62;&#x34;&#x37;&#45;&#99;&#98;&#x39;&#54;-&#52;&#x34;&#52;&#x31;-&#56;&#56;&#48;1&#45;&#x33;5&#x62;5&#x37;&#x34;&#53;&#54;&#x37;&#53;&#x33;&#97;&#x26;u&#115;&#x65;&#x72;&#95;n&#x61;me&#61;&#115;&#117;s&#97;&#110;&#46;&#117;&#107;&#x2e;&#x32;9&#x40;&#x65;&#x78;&#97;&#x6d;p&#x6c;e&#x2e;co&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_metrics_at_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Metrics at Bank  # noqa: E501

        <p>Get the all metrics at the Bank specified by BANK_ID</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"&#109;&#97;&#x69;&#108;&#116;&#111;&#58;&#x30;&#x31;&#x2e;&#x30;&#48;&#x30;&#90;&amp;l&#x69;&#x6d;&#x69;&#x74;&#61;&#x31;0&#x30;&#x30;&#48;&#38;&#x6f;&#x66;&#x66;&#x73;&#101;t=0&#x26;&#97;&#110;&#111;&#x6e;&#x3d;&#102;&#x61;&#x6c;&#x73;&#101;&#38;&#x61;p&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#x54;&#x65;a&#116;&#x41;&#x70;&#x70;&#x26;&#x69;&#x6d;&#112;l&#101;&#109;e&#x6e;&#x74;&#x65;&#x64;&#x5f;i&#110;&#95;&#118;&#101;&#114;s&#x69;o&#x6e;&#61;&#x76;&#50;&#x2e;&#49;.&#x30;&amp;&#118;&#x65;r&#x62;&#61;&#x50;&#79;&#x53;&#84;&#38;&#117;&#x73;&#101;&#114;&#95;&#x69;&#x64;=&#x63;&#x37;&#98;&#54;cb&#52;7&#x2d;cb&#x39;6&#45;&#x34;&#52;&#x34;1&#x2d;&#x38;&#56;&#x30;&#x31;&#x2d;&#51;&#x35;&#x62;&#x35;&#55;&#x34;5&#54;&#55;&#x35;3&#97;&#38;&#117;&#115;&#x65;&#x72;&#95;n&#x61;&#x6d;&#101;&#61;&#x73;&#117;&#115;&#97;&#x6e;&#x2e;&#x75;&#x6b;&#46;&#x32;&#x39;&#64;&#101;&#x78;&#97;&#109;&#x70;l&#x65;&#46;c&#111;&#109;\">&#x30;&#49;.&#48;&#x30;&#x30;&#90;&#x26;&#108;&#105;&#109;&#105;&#x74;=10&#x30;&#x30;&#x30;&#38;&#x6f;&#102;&#102;&#115;e&#116;&#61;&#x30;&#38;&#97;n&#111;&#x6e;&#61;&#x66;&#97;&#x6c;&#115;&#101;&amp;&#x61;&#x70;&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#84;&#101;&#x61;&#116;&#x41;&#112;&#x70;&#x26;i&#x6d;&#x70;&#x6c;&#101;&#109;&#x65;&#110;&#x74;&#x65;&#x64;&#95;&#105;&#x6e;&#95;&#118;&#101;&#114;&#x73;&#x69;&#111;&#110;&#61;v&#50;&#x2e;&#x31;&#x2e;0&#x26;&#118;&#101;&#114;&#98;=&#80;&#x4f;S&#x54;&#x26;&#x75;&#x73;&#x65;&#x72;&#95;&#105;&#x64;&#x3d;&#99;&#55;&#x62;&#54;&#x63;&#98;&#x34;&#x37;-c&#x62;&#57;&#x36;-&#x34;44&#x31;&#45;&#56;8&#x30;&#49;&#45;&#x33;&#53;b&#53;&#x37;&#52;&#x35;&#54;&#55;5&#51;&#97;&#38;&#x75;&#115;&#101;&#x72;&#x5f;&#110;&#97;&#x6d;&#101;&#61;&#115;&#117;&#115;a&#x6e;&#46;u&#107;&#46;&#x32;&#x39;&#x40;&#101;x&#x61;&#109;&#112;&#x6c;&#101;&#46;&#99;&#x6f;&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_at_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_metrics_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_metrics_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_metrics_at_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Metrics at Bank  # noqa: E501

        <p>Get the all metrics at the Bank specified by BANK_ID</p><p>require CanReadMetrics role</p><p>Filters Part 1.<em>filtering</em> (no wilde cards etc.) parameters to GET /management/metrics</p><p>Should be able to filter on the following metrics fields</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z&amp;limit=50&amp;offset=2</p><p>1 from_date (defaults to one week before current date): eg:from_date=1100-01-01T01:01:01.000Z</p><p>2 to_date (defaults to current date) eg:to_date=1100-01-01T01:01:01.000Z</p><p>3 limit (for pagination: defaults to 50)  eg:limit=200</p><p>4 offset (for pagination: zero index, defaults to 0) eg: offset=10</p><p>5 sort_by (defaults to date field) eg: sort_by=date<br />possible values:<br />&quot;url&quot;,<br />&quot;date&quot;,<br />&quot;user_name&quot;,<br />&quot;app_name&quot;,<br />&quot;developer_email&quot;,<br />&quot;implemented_by_partial_function&quot;,<br />&quot;implemented_in_version&quot;,<br />&quot;consumer_id&quot;,<br />&quot;verb&quot;</p><p>6 direction (defaults to date desc) eg: direction=desc</p><p>eg: /management/metrics?from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:<a href=\"&#109;&#97;&#x69;&#108;&#116;&#111;&#58;&#x30;&#x31;&#x2e;&#x30;&#48;&#x30;&#90;&amp;l&#x69;&#x6d;&#x69;&#x74;&#61;&#x31;0&#x30;&#x30;&#48;&#38;&#x6f;&#x66;&#x66;&#x73;&#101;t=0&#x26;&#97;&#110;&#111;&#x6e;&#x3d;&#102;&#x61;&#x6c;&#x73;&#101;&#38;&#x61;p&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#x54;&#x65;a&#116;&#x41;&#x70;&#x70;&#x26;&#x69;&#x6d;&#112;l&#101;&#109;e&#x6e;&#x74;&#x65;&#x64;&#x5f;i&#110;&#95;&#118;&#101;&#114;s&#x69;o&#x6e;&#61;&#x76;&#50;&#x2e;&#49;.&#x30;&amp;&#118;&#x65;r&#x62;&#61;&#x50;&#79;&#x53;&#84;&#38;&#117;&#x73;&#101;&#114;&#95;&#x69;&#x64;=&#x63;&#x37;&#98;&#54;cb&#52;7&#x2d;cb&#x39;6&#45;&#x34;&#52;&#x34;1&#x2d;&#x38;&#56;&#x30;&#x31;&#x2d;&#51;&#x35;&#x62;&#x35;&#55;&#x34;5&#54;&#55;&#x35;3&#97;&#38;&#117;&#115;&#x65;&#x72;&#95;n&#x61;&#x6d;&#101;&#61;&#x73;&#117;&#115;&#97;&#x6e;&#x2e;&#x75;&#x6b;&#46;&#x32;&#x39;&#64;&#101;&#x78;&#97;&#109;&#x70;l&#x65;&#46;c&#111;&#109;\">&#x30;&#49;.&#48;&#x30;&#x30;&#90;&#x26;&#108;&#105;&#109;&#105;&#x74;=10&#x30;&#x30;&#x30;&#38;&#x6f;&#102;&#102;&#115;e&#116;&#61;&#x30;&#38;&#97;n&#111;&#x6e;&#61;&#x66;&#97;&#x6c;&#115;&#101;&amp;&#x61;&#x70;&#x70;&#x5f;&#x6e;a&#109;&#101;&#x3d;&#84;&#101;&#x61;&#116;&#x41;&#112;&#x70;&#x26;i&#x6d;&#x70;&#x6c;&#101;&#109;&#x65;&#110;&#x74;&#x65;&#x64;&#95;&#105;&#x6e;&#95;&#118;&#101;&#114;&#x73;&#x69;&#111;&#110;&#61;v&#50;&#x2e;&#x31;&#x2e;0&#x26;&#118;&#101;&#114;&#98;=&#80;&#x4f;S&#x54;&#x26;&#x75;&#x73;&#x65;&#x72;&#95;&#105;&#x64;&#x3d;&#99;&#55;&#x62;&#54;&#x63;&#98;&#x34;&#x37;-c&#x62;&#57;&#x36;-&#x34;44&#x31;&#45;&#56;8&#x30;&#49;&#45;&#x33;&#53;b&#53;&#x37;&#52;&#x35;&#54;&#55;5&#51;&#97;&#38;&#x75;&#115;&#101;&#x72;&#x5f;&#110;&#97;&#x6d;&#101;&#61;&#115;&#117;&#115;a&#x6e;&#46;u&#107;&#46;&#x32;&#x39;&#x40;&#101;x&#x61;&#109;&#112;&#x6c;&#101;&#46;&#99;&#x6f;&#109;</a>&amp;consumer_id=78</p><p>Other filters:</p><p>7 consumer_id  (if null ignore)</p><p>8 user_id (if null ignore)</p><p>9 anon (if null ignore) only support two value : true (return where user_id is null.) or false (return where user_id is not null.)</p><p>10 url (if null ignore), note: can not contain '&amp;'.</p><p>11 app_name (if null ignore)</p><p>12 implemented_by_partial_function (if null ignore),</p><p>13 implemented_in_version (if null ignore)</p><p>14 verb (if null ignore)</p><p>15 correlation_id (if null ignore)</p><p>16 duration (if null ignore) non digit chars will be silently omitted</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_metrics_at_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MetricsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_metrics_at_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_metrics_at_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/metrics/banks/{BANK_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MetricsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_dynamic_endpoints(self, **kwargs):  # noqa: E501
        """Get My Dynamic Endpoints  # noqa: E501

        <p>Get My Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20012
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_dynamic_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_dynamic_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_dynamic_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Dynamic Endpoints  # noqa: E501

        <p>Get My Dynamic Endpoints.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse20012
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_dynamic_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse20012',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_dynamic_entities(self, **kwargs):  # noqa: E501
        """Get My Dynamic Entities  # noqa: E501

        <p>Get all my Dynamic Entities.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_dynamic_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Dynamic Entities  # noqa: E501

        <p>Get all my Dynamic Entities.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_o_auth2_server_jwks_uris(self, **kwargs):  # noqa: E501
        """Get JSON Web Key (JWK) URIs  # noqa: E501

        <p>Get the OAuth2 server's public JSON Web Key (JWK) URIs.<br />It is required by client applications to validate ID tokens, self-contained access tokens and other issued objects.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_o_auth2_server_jwks_uris(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OAuth2ServerJwksUrisJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_o_auth2_server_jwks_uris_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_o_auth2_server_jwks_uris_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_o_auth2_server_jwks_uris_with_http_info(self, **kwargs):  # noqa: E501
        """Get JSON Web Key (JWK) URIs  # noqa: E501

        <p>Get the OAuth2 server's public JSON Web Key (JWK) URIs.<br />It is required by client applications to validate ID tokens, self-contained access tokens and other issued objects.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_o_auth2_server_jwks_uris_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: OAuth2ServerJwksUrisJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_o_auth2_server_jwks_uris" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/jwks-uris', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OAuth2ServerJwksUrisJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_obp_connector_loopback(self, **kwargs):  # noqa: E501
        """Get Connector Status (Loopback)  # noqa: E501

        <p>This endpoint makes a call to the Connector to check the backend transport (e.g. Kafka) is reachable.</p><p>Currently this is only implemented for Kafka based connectors.</p><p>For Kafka based connectors, this endpoint writes a message to Kafka and reads it again.</p><p>In the future, this endpoint may also return information about database connections etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_obp_connector_loopback(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ObpApiLoopbackJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_obp_connector_loopback_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_obp_connector_loopback_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_obp_connector_loopback_with_http_info(self, **kwargs):  # noqa: E501
        """Get Connector Status (Loopback)  # noqa: E501

        <p>This endpoint makes a call to the Connector to check the backend transport (e.g. Kafka) is reachable.</p><p>Currently this is only implemented for Kafka based connectors.</p><p>For Kafka based connectors, this endpoint writes a message to Kafka and reads it again.</p><p>In the future, this endpoint may also return information about database connections etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_obp_connector_loopback_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ObpApiLoopbackJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_obp_connector_loopback" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/connector/loopback', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ObpApiLoopbackJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_rate_limiting_info(self, **kwargs):  # noqa: E501
        """Get Rate Limiting Info  # noqa: E501

        <p>Get information about the Rate Limiting setup on this OBP Instance such as:</p><p>Is rate limiting enabled and active?<br />What backend is used to keep track of the API calls (e.g. REDIS).</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rate_limiting_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RateLimitingInfoV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_rate_limiting_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_rate_limiting_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_rate_limiting_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get Rate Limiting Info  # noqa: E501

        <p>Get information about the Rate Limiting setup on this OBP Instance such as:</p><p>Is rate limiting enabled and active?<br />What backend is used to keep track of the API calls (e.g. REDIS).</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_rate_limiting_info_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RateLimitingInfoV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_rate_limiting_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/rate-limiting', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RateLimitingInfoV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resource_docs_obp(self, body, api_version, **kwargs):  # noqa: E501
        """Get Resource Docs.  # noqa: E501

        <p>Get documentation about the RESTful resources on this server including example bodies for POST and PUT requests.</p><p>This is the native data format used to document OBP endpoints. Each endpoint has a Resource Doc (a Scala case class) defined in the source code.</p><p>This endpoint is used by OBP API Explorer to display and work with the API documentation.</p><p>Most (but not all) fields are also available in swagger format. (The Swagger endpoint is built from Resource Docs.)</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint with tags parameter e.g. ?tags=Account,Bank</p><p>You may filter this endpoint with functions parameter e.g. ?functions=enableDisableConsumers,getConnectorMetrics</p><p>For possible function values, see implemented_by.function in the JSON returned by this endpoint or the OBP source code or the footer of the API Explorer which produces a comma separated list of functions that reflect the server or filtering by API Explorer based on tags etc.</p><p>You may filter this endpoint using the 'content' url parameter, e.g. ?content=dynamic<br />if set content=dynamic, only show dynamic endpoints, if content=static, only show the static endpoints. if omit this parameter, we will show all the endpoints.</p><p>You may need some other language resource docs, now we support i18n language tag , e.g. ?locale=zh_CN</p><p>You can filter with api-collection-id, but api-collection-id can not be used with others together. If api-collection-id is used in URL, it will ignore all other parameters.</p><p>You can easily pass the cache, use different value for cache-modifier, eg: ?cache-modifier= 123</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?tags=Account,Bank\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?locale=zh_CN\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?locale=zh_CN</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?content=static,dynamic,all\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?content=static,dynamic,all</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?cache-modifier=3141592653\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?cache-modifier=3141592653</a></p><ul><li> operation_id is concatenation of \"v\", version and function and should be unique (used for DOM element IDs etc. maybe used to link to source code) </li><li> version references the version that the API call is defined in.</li><li> function is the (scala) partial function that implements this endpoint. It is unique per version of the API.</li><li> request_url is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the implemented version (the version where this endpoint was defined) e.g. /obp/v1.2.0/resource</li><li> specified_url (recommended to use) is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the version specified in the call e.g. /obp/v3.1.0/resource. In OBP, endpoints are first made available at the request_url, but the same resource (function call) is often made available under later versions (specified_url). To access the latest version of all endpoints use the latest version available on your OBP instance e.g. /obp/v3.1.0 - To get the original version use the request_url. We recommend to use the specified_url since non semantic improvements are more likely to be applied to later implementations of the call.</li><li> summary is a short description inline with the swagger terminology. </li><li> description may contain html markup (generated from markdown on the server).</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_docs_obp(body, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :return: ResourceDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resource_docs_obp_with_http_info(body, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_resource_docs_obp_with_http_info(body, api_version, **kwargs)  # noqa: E501
            return data

    def get_resource_docs_obp_with_http_info(self, body, api_version, **kwargs):  # noqa: E501
        """Get Resource Docs.  # noqa: E501

        <p>Get documentation about the RESTful resources on this server including example bodies for POST and PUT requests.</p><p>This is the native data format used to document OBP endpoints. Each endpoint has a Resource Doc (a Scala case class) defined in the source code.</p><p>This endpoint is used by OBP API Explorer to display and work with the API documentation.</p><p>Most (but not all) fields are also available in swagger format. (The Swagger endpoint is built from Resource Docs.)</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint with tags parameter e.g. ?tags=Account,Bank</p><p>You may filter this endpoint with functions parameter e.g. ?functions=enableDisableConsumers,getConnectorMetrics</p><p>For possible function values, see implemented_by.function in the JSON returned by this endpoint or the OBP source code or the footer of the API Explorer which produces a comma separated list of functions that reflect the server or filtering by API Explorer based on tags etc.</p><p>You may filter this endpoint using the 'content' url parameter, e.g. ?content=dynamic<br />if set content=dynamic, only show dynamic endpoints, if content=static, only show the static endpoints. if omit this parameter, we will show all the endpoints.</p><p>You may need some other language resource docs, now we support i18n language tag , e.g. ?locale=zh_CN</p><p>You can filter with api-collection-id, but api-collection-id can not be used with others together. If api-collection-id is used in URL, it will ignore all other parameters.</p><p>You can easily pass the cache, use different value for cache-modifier, eg: ?cache-modifier= 123</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?tags=Account,Bank\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?locale=zh_CN\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?locale=zh_CN</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?content=static,dynamic,all\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?content=static,dynamic,all</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?api-collection-id=4e866c86-60c3-4268-a221-cb0bbf1ad221</a><br /><a href=\"https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?cache-modifier=3141592653\">https://test.openbankproject.com/obp/v4.0.0/resource-docs/v4.0.0/obp?cache-modifier=3141592653</a></p><ul><li> operation_id is concatenation of \"v\", version and function and should be unique (used for DOM element IDs etc. maybe used to link to source code) </li><li> version references the version that the API call is defined in.</li><li> function is the (scala) partial function that implements this endpoint. It is unique per version of the API.</li><li> request_url is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the implemented version (the version where this endpoint was defined) e.g. /obp/v1.2.0/resource</li><li> specified_url (recommended to use) is empty for the root call, else the path. It contains the standard prefix (e.g. /obp) and the version specified in the call e.g. /obp/v3.1.0/resource. In OBP, endpoints are first made available at the request_url, but the same resource (function call) is often made available under later versions (specified_url). To access the latest version of all endpoints use the latest version available on your OBP instance e.g. /obp/v3.1.0 - To get the original version use the request_url. We recommend to use the specified_url since non semantic improvements are more likely to be applied to later implementations of the call.</li><li> summary is a short description inline with the swagger terminology. </li><li> description may contain html markup (generated from markdown on the server).</li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_docs_obp_with_http_info(body, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :return: ResourceDocsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resource_docs_obp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_resource_docs_obp`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if self.api_client.client_side_validation and ('api_version' not in params or
                                                       params['api_version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `api_version` when calling `get_resource_docs_obp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'api_version' in params:
            path_params['API_VERSION'] = params['api_version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/resource-docs/{API_VERSION}/obp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResourceDocsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_resource_docs_swagger(self, body, api_version, **kwargs):  # noqa: E501
        """Get Swagger documentation  # noqa: E501

        <p>Returns documentation about the RESTful resources on this server in Swagger format.</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint using the 'tags' url parameter e.g. ?tags=Account,Bank</p><p>(All endpoints are given one or more tags which for used in grouping)</p><p>You may filter this endpoint using the 'functions' url parameter e.g. ?functions=getBanks,bankById</p><p>(Each endpoint is implemented in the OBP Scala code by a 'function')</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank,PSD2&amp;functions=getBanks,bankById\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank,PSD2&amp;functions=getBanks,bankById</a></p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_docs_swagger(body, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_resource_docs_swagger_with_http_info(body, api_version, **kwargs)  # noqa: E501
        else:
            (data) = self.get_resource_docs_swagger_with_http_info(body, api_version, **kwargs)  # noqa: E501
            return data

    def get_resource_docs_swagger_with_http_info(self, body, api_version, **kwargs):  # noqa: E501
        """Get Swagger documentation  # noqa: E501

        <p>Returns documentation about the RESTful resources on this server in Swagger format.</p><p>API_VERSION is the version you want documentation about e.g. v3.0.0</p><p>You may filter this endpoint using the 'tags' url parameter e.g. ?tags=Account,Bank</p><p>(All endpoints are given one or more tags which for used in grouping)</p><p>You may filter this endpoint using the 'functions' url parameter e.g. ?functions=getBanks,bankById</p><p>(Each endpoint is implemented in the OBP Scala code by a 'function')</p><p>See the Resource Doc endpoint for more information.</p><p>Following are more examples:<br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?functions=getBanks,bankById\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?functions=getBanks,bankById</a><br /><a href=\"https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank,PSD2&amp;functions=getBanks,bankById\">https://test.openbankproject.com/obp/v3.1.0/resource-docs/v3.1.0/swagger?tags=Account,Bank,PSD2&amp;functions=getBanks,bankById</a></p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_resource_docs_swagger_with_http_info(body, api_version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str api_version: eg:v2.2.0, v3.0.0 (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_resource_docs_swagger" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_resource_docs_swagger`")  # noqa: E501
        # verify the required parameter 'api_version' is set
        if self.api_client.client_side_validation and ('api_version' not in params or
                                                       params['api_version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `api_version` when calling `get_resource_docs_swagger`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'api_version' in params:
            path_params['API_VERSION'] = params['api_version']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/resource-docs/{API_VERSION}/swagger', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scanned_api_versions(self, **kwargs):  # noqa: E501
        """Get scanned API Versions  # noqa: E501

        <p>Get all the scanned API Versions.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scanned_api_versions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scanned_api_versions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_scanned_api_versions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_scanned_api_versions_with_http_info(self, **kwargs):  # noqa: E501
        """Get scanned API Versions  # noqa: E501

        <p>Get all the scanned API Versions.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scanned_api_versions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scanned_api_versions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/api/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_server_jwk(self, **kwargs):  # noqa: E501
        """Get JSON Web Key (JWK)  # noqa: E501

        <p>Get the server's public JSON Web Key (JWK) set and certificate chain.<br />It is required by client applications to validate ID tokens, self-contained access tokens and other issued objects.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_jwk(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SeverJWK
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_server_jwk_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_server_jwk_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_server_jwk_with_http_info(self, **kwargs):  # noqa: E501
        """Get JSON Web Key (JWK)  # noqa: E501

        <p>Get the server's public JSON Web Key (JWK) set and certificate chain.<br />It is required by client applications to validate ID tokens, self-contained access tokens and other issued objects.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_server_jwk_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: SeverJWK
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_server_jwk" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/certs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SeverJWK',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_dynamic_entities(self, **kwargs):  # noqa: E501
        """Get System Dynamic Entities  # noqa: E501

        <p>Get all System Dynamic Entities</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_dynamic_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_system_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_system_dynamic_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Get System Dynamic Entities  # noqa: E501

        <p>Get all System Dynamic Entities</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_dynamic_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_level_endpoint_tags(self, **kwargs):  # noqa: E501
        """Get System Level Endpoint Tags  # noqa: E501

        <p>Get System Level Endpoint Tags.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_level_endpoint_tags(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NotSupportedYet
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_level_endpoint_tags_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_system_level_endpoint_tags_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_system_level_endpoint_tags_with_http_info(self, **kwargs):  # noqa: E501
        """Get System Level Endpoint Tags  # noqa: E501

        <p>Get System Level Endpoint Tags.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_level_endpoint_tags_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: NotSupportedYet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_level_endpoint_tags" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/endpoints/OPERATION_ID/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NotSupportedYet',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def root(self, **kwargs):  # noqa: E501
        """Get API Info (root)  # noqa: E501

        <p>Returns information about:</p><ul><li>API version</li><li>Hosted by information</li><li>Hosted at information</li><li>Energy source information</li><li>Git Commit</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.root(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIInfoJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.root_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.root_with_http_info(**kwargs)  # noqa: E501
            return data

    def root_with_http_info(self, **kwargs):  # noqa: E501
        """Get API Info (root)  # noqa: E501

        <p>Returns information about:</p><ul><li>API version</li><li>Hosted by information</li><li>Hosted at information</li><li>Energy source information</li><li>Git Commit</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.root_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: APIInfoJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method root" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/root', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIInfoJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_level_dynamic_endpoint_host(self, body, bank_id, **kwargs):  # noqa: E501
        """ Update Bank Level Dynamic Endpoint Host  # noqa: E501

        <p>Update Bank Level  dynamic endpoint Host.<br />The value can be obp_mock, dynamic_entity, or some service url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_endpoint_host(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEndpointHostJson400 body: DynamicEndpointHostJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEndpointHostJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_level_dynamic_endpoint_host_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_level_dynamic_endpoint_host_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def update_bank_level_dynamic_endpoint_host_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """ Update Bank Level Dynamic Endpoint Host  # noqa: E501

        <p>Update Bank Level  dynamic endpoint Host.<br />The value can be obp_mock, dynamic_entity, or some service url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_endpoint_host_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEndpointHostJson400 body: DynamicEndpointHostJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEndpointHostJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_level_dynamic_endpoint_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_bank_level_dynamic_endpoint_host`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_bank_level_dynamic_endpoint_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-endpoints/DYNAMIC_ENDPOINT_ID/host', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEndpointHostJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_level_dynamic_entity(self, body, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Dynamic Entity  # noqa: E501

        <p>Update a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;branchId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;atmId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;productCode=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;cardId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;transactionId=161fafb6-f008-418e-9d1b-aba419942289&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;counterpartyId=161fafb6-f008-418e-9d1b-aba419942289&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_entity(body, dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_bank_level_dynamic_entity_with_http_info(self, body, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Dynamic Entity  # noqa: E501

        <p>Update a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;branchId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;atmId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;productCode=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;cardId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;transactionId=161fafb6-f008-418e-9d1b-aba419942289&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;counterpartyId=161fafb6-f008-418e-9d1b-aba419942289&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_level_endpoint_tag(self, body, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Endpoint Tag  # noqa: E501

        <p>Update Endpoint Tag, you can only update the tag_name here, operation_id can not be updated.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_endpoint_tag(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_level_endpoint_tag_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_level_endpoint_tag_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def update_bank_level_endpoint_tag_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Endpoint Tag  # noqa: E501

        <p>Update Endpoint Tag, you can only update the tag_name here, operation_id can not be updated.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_endpoint_tag_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_bank_level_endpoint_tag`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_bank_level_endpoint_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/endpoints/OPERATION_ID/tags/ENDPOINT_TAG_ID', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLevelEndpointTagResponseJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_dynamic_endpoint_host(self, body, **kwargs):  # noqa: E501
        """ Update Dynamic Endpoint Host  # noqa: E501

        <p>Update dynamic endpoint Host.<br />The value can be obp_mock, dynamic_entity, or some service url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dynamic_endpoint_host(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEndpointHostJson400 body: DynamicEndpointHostJson400 object that needs to be added. (required)
        :return: DynamicEndpointHostJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_dynamic_endpoint_host_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_dynamic_endpoint_host_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_dynamic_endpoint_host_with_http_info(self, body, **kwargs):  # noqa: E501
        """ Update Dynamic Endpoint Host  # noqa: E501

        <p>Update dynamic endpoint Host.<br />The value can be obp_mock, dynamic_entity, or some service url.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_dynamic_endpoint_host_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEndpointHostJson400 body: DynamicEndpointHostJson400 object that needs to be added. (required)
        :return: DynamicEndpointHostJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_dynamic_endpoint_host" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_dynamic_endpoint_host`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/dynamic-endpoints/DYNAMIC_ENDPOINT_ID/host', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEndpointHostJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_method_routing(self, body, method_routing_id, **kwargs):  # noqa: E501
        """Update MethodRouting  # noqa: E501

        <p>Update a MethodRouting.</p><p>Authentication is Mandatory</p><p>Explaination of Fields:</p><ul><li>method_name is required String value, current supported value: [mapped | internal | rest_vMar2019]</li><li>connector_name is required String value</li><li>is_bank_id_exact_match is required boolean value, if bank_id_pattern is exact bank_id value, this value is true; if bank_id_pattern is null or a regex, this value is false</li><li>bank_id_pattern is optional String value, it can be null, a exact bank_id or a regex</li><li>parameters is optional array of key value pairs. You can set some paremeters for this method<br />note:</li><li><p>if bank_id_pattern is regex, special characters need to do escape, for example: bank_id_pattern = &quot;some-id_pattern_\\d+&quot;</p></li></ul><p>If connector name start with rest, parameters can contain &quot;outBoundMapping&quot; and &quot;inBoundMapping&quot;, to convert OutBound and InBound json structure.<br />for example:<br />outBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248007-33332e00-580e-11ea-8d2a-d1856035fa24.png\" alt=\"Snipaste_outBoundMapping\" /><br />Build OutBound json value rules:<br />1 set cId value with: outboundAdapterCallContext.correlationId value<br />2 set bankId value with: concat bankId.value value with  string helloworld<br />3 set originalJson value with: whole source json, note: the field value expression is $root</p><p>inBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248199-a9d02b80-580e-11ea-9238-e073264e9170.png\" alt=\"inBoundMapping\" /><br />Build InBound json value rules:<br />1 and 2 set inboundAdapterCallContext and status value: because field name ends with &quot;$default&quot;, remove &quot;$default&quot; from field name, not change the value<br />3 set fullName value with: concat string full: with result.name value<br />4 set bankRoutingScheme value: because source value is Array, but target value is not Array, the mapping field name must ends with [0].</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_method_routing(body, method_routing_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MethodRoutingCommons body: MethodRoutingCommons object that needs to be added. (required)
        :param str method_routing_id: the method routing id  (required)
        :return: MethodRoutingCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_method_routing_with_http_info(body, method_routing_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_method_routing_with_http_info(body, method_routing_id, **kwargs)  # noqa: E501
            return data

    def update_method_routing_with_http_info(self, body, method_routing_id, **kwargs):  # noqa: E501
        """Update MethodRouting  # noqa: E501

        <p>Update a MethodRouting.</p><p>Authentication is Mandatory</p><p>Explaination of Fields:</p><ul><li>method_name is required String value, current supported value: [mapped | internal | rest_vMar2019]</li><li>connector_name is required String value</li><li>is_bank_id_exact_match is required boolean value, if bank_id_pattern is exact bank_id value, this value is true; if bank_id_pattern is null or a regex, this value is false</li><li>bank_id_pattern is optional String value, it can be null, a exact bank_id or a regex</li><li>parameters is optional array of key value pairs. You can set some paremeters for this method<br />note:</li><li><p>if bank_id_pattern is regex, special characters need to do escape, for example: bank_id_pattern = &quot;some-id_pattern_\\d+&quot;</p></li></ul><p>If connector name start with rest, parameters can contain &quot;outBoundMapping&quot; and &quot;inBoundMapping&quot;, to convert OutBound and InBound json structure.<br />for example:<br />outBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248007-33332e00-580e-11ea-8d2a-d1856035fa24.png\" alt=\"Snipaste_outBoundMapping\" /><br />Build OutBound json value rules:<br />1 set cId value with: outboundAdapterCallContext.correlationId value<br />2 set bankId value with: concat bankId.value value with  string helloworld<br />3 set originalJson value with: whole source json, note: the field value expression is $root</p><p>inBoundMapping example, convert json from source to target:<br /><img src=\"https://user-images.githubusercontent.com/2577334/75248199-a9d02b80-580e-11ea-9238-e073264e9170.png\" alt=\"inBoundMapping\" /><br />Build InBound json value rules:<br />1 and 2 set inboundAdapterCallContext and status value: because field name ends with &quot;$default&quot;, remove &quot;$default&quot; from field name, not change the value<br />3 set fullName value with: concat string full: with result.name value<br />4 set bankRoutingScheme value: because source value is Array, but target value is not Array, the mapping field name must ends with [0].</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_method_routing_with_http_info(body, method_routing_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MethodRoutingCommons body: MethodRoutingCommons object that needs to be added. (required)
        :param str method_routing_id: the method routing id  (required)
        :return: MethodRoutingCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'method_routing_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_method_routing" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_method_routing`")  # noqa: E501
        # verify the required parameter 'method_routing_id' is set
        if self.api_client.client_side_validation and ('method_routing_id' not in params or
                                                       params['method_routing_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `method_routing_id` when calling `update_method_routing`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'method_routing_id' in params:
            path_params['METHOD_ROUTING_ID'] = params['method_routing_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/method_routings/{METHOD_ROUTING_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MethodRoutingCommons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_my_dynamic_entity(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update My Dynamic Entity  # noqa: E501

        <p>Update my DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one of my DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>Current support filed types as follow:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;branchId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;atmId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;productCode=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;cardId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;transactionId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;counterpartyId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_dynamic_entity(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def update_my_dynamic_entity_with_http_info(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update My Dynamic Entity  # noqa: E501

        <p>Update my DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one of my DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>Current support filed types as follow:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;branchId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;atmId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;productCode=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;cardId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;transactionId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;counterpartyId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_my_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_my_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_my_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_system_dynamic_entity(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update System Level Dynamic Entity  # noqa: E501

        <p>Update a System Level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;branchId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;atmId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;productCode=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;cardId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;transactionId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;counterpartyId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_dynamic_entity(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def update_system_dynamic_entity_with_http_info(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update System Level Dynamic Entity  # noqa: E501

        <p>Update a System Level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;branchId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;atmId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;productCode=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;cardId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;transactionId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;counterpartyId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_system_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_system_level_endpoint_tag(self, body, **kwargs):  # noqa: E501
        """Update System Level Endpoint Tag  # noqa: E501

        <p>Update System Level Endpoint Tag, you can only update the tag_name here, operation_id can not be updated.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_level_endpoint_tag(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_system_level_endpoint_tag_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_system_level_endpoint_tag_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def update_system_level_endpoint_tag_with_http_info(self, body, **kwargs):  # noqa: E501
        """Update System Level Endpoint Tag  # noqa: E501

        <p>Update System Level Endpoint Tag, you can only update the tag_name here, operation_id can not be updated.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_level_endpoint_tag_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EndpointTagJson400 body: EndpointTagJson400 object that needs to be added. (required)
        :return: BankLevelEndpointTagResponseJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_system_level_endpoint_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_system_level_endpoint_tag`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/endpoints/OPERATION_ID/tags/ENDPOINT_TAG_ID', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BankLevelEndpointTagResponseJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def verify_request_sign_response(self, **kwargs):  # noqa: E501
        """Verify Request and Sign Response of a current call  # noqa: E501

        <p>Verify Request and Sign Response of a current call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_request_sign_response(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.verify_request_sign_response_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.verify_request_sign_response_with_http_info(**kwargs)  # noqa: E501
            return data

    def verify_request_sign_response_with_http_info(self, **kwargs):  # noqa: E501
        """Verify Request and Sign Response of a current call  # noqa: E501

        <p>Verify Request and Sign Response of a current call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.verify_request_sign_response_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_request_sign_response" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/development/echo/jws-verified-request-jws-signed-response', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
