# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ApiCollectionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_my_api_collection(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection  # noqa: E501

        <p>Create Api Collection for logged in user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionJson400 body: PostApiCollectionJson400 object that needs to be added. (required)
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_my_api_collection_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_my_api_collection_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_my_api_collection_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection  # noqa: E501

        <p>Create Api Collection for logged in user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionJson400 body: PostApiCollectionJson400 object that needs to be added. (required)
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_my_api_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_my_api_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_my_api_collection_endpoint(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection Endpoint  # noqa: E501

        <p>Create Api Collection Endpoint.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection_endpoint(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionEndpointJson400 body: PostApiCollectionEndpointJson400 object that needs to be added. (required)
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_my_api_collection_endpoint_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_my_api_collection_endpoint_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_my_api_collection_endpoint_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection Endpoint  # noqa: E501

        <p>Create Api Collection Endpoint.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection_endpoint_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionEndpointJson400 body: PostApiCollectionEndpointJson400 object that needs to be added. (required)
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_my_api_collection_endpoint" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_my_api_collection_endpoint`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_NAME/api-collection-endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_my_api_collection_endpoint_by_id(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection Endpoint By Id  # noqa: E501

        <p>Create Api Collection Endpoint By Id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection_endpoint_by_id(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionEndpointJson400 body: PostApiCollectionEndpointJson400 object that needs to be added. (required)
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_my_api_collection_endpoint_by_id_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_my_api_collection_endpoint_by_id_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_my_api_collection_endpoint_by_id_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create My Api Collection Endpoint By Id  # noqa: E501

        <p>Create Api Collection Endpoint By Id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_my_api_collection_endpoint_by_id_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostApiCollectionEndpointJson400 body: PostApiCollectionEndpointJson400 object that needs to be added. (required)
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_my_api_collection_endpoint_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_my_api_collection_endpoint_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collection-ids/API_COLLECTION_ID/api-collection-endpoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_api_collection(self, **kwargs):  # noqa: E501
        """Delete My Api Collection  # noqa: E501

        <p>Delete Api Collection By API_COLLECTION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_api_collection_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_api_collection_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_my_api_collection_with_http_info(self, **kwargs):  # noqa: E501
        """Delete My Api Collection  # noqa: E501

        <p>Delete Api Collection By API_COLLECTION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_api_collection" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_api_collection_endpoint(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint  # noqa: E501

        <p>Delete Api Collection Endpoint By OPERATION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_api_collection_endpoint_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_api_collection_endpoint_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_my_api_collection_endpoint_with_http_info(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint  # noqa: E501

        <p>Delete Api Collection Endpoint By OPERATION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_api_collection_endpoint" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_NAME/api-collection-endpoints/OPERATION_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_api_collection_endpoint_by_id(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint By Id  # noqa: E501

        <p>Delete Api Collection Endpoint<br />Delete Api Collection Endpoint By Id</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint_by_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_api_collection_endpoint_by_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_api_collection_endpoint_by_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_my_api_collection_endpoint_by_id_with_http_info(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint By Id  # noqa: E501

        <p>Delete Api Collection Endpoint<br />Delete Api Collection Endpoint By Id</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint_by_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_api_collection_endpoint_by_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collection-ids/API_COLLECTION_ID/api-collection-endpoint-ids/API_COLLECTION_ENDPOINT_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_api_collection_endpoint_by_operation_id(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint By Id  # noqa: E501

        <p>Delete Api Collection Endpoint By OPERATION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint_by_operation_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_api_collection_endpoint_by_operation_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_api_collection_endpoint_by_operation_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_my_api_collection_endpoint_by_operation_id_with_http_info(self, **kwargs):  # noqa: E501
        """Delete My Api Collection Endpoint By Id  # noqa: E501

        <p>Delete Api Collection Endpoint By OPERATION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_api_collection_endpoint_by_operation_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Full
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_api_collection_endpoint_by_operation_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collection-ids/API_COLLECTION_ID/api-collection-endpoints/OPERATION_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Full',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_collection_endpoints(self, **kwargs):  # noqa: E501
        """Get Api Collection Endpoints  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_ID.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_collection_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_collection_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_api_collection_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_api_collection_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Get Api Collection Endpoints  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_ID.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_collection_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_collection_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/api-collections/API_COLLECTION_ID/api-collection-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_collections_for_user(self, user_id, **kwargs):  # noqa: E501
        """Get Api Collections for User  # noqa: E501

        <p>Get Api Collections for User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_collections_for_user(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user id (required)
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_api_collections_for_user_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_api_collections_for_user_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_api_collections_for_user_with_http_info(self, user_id, **kwargs):  # noqa: E501
        """Get Api Collections for User  # noqa: E501

        <p>Get Api Collections for User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_api_collections_for_user_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user id (required)
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_collections_for_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `get_api_collections_for_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['USER_ID'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/users/{USER_ID}/api-collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_featured_api_collections(self, **kwargs):  # noqa: E501
        """Get Featured Api Collections  # noqa: E501

        <p>Get Featured Api Collections.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_featured_api_collections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_featured_api_collections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_featured_api_collections_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_featured_api_collections_with_http_info(self, **kwargs):  # noqa: E501
        """Get Featured Api Collections  # noqa: E501

        <p>Get Featured Api Collections.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_featured_api_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_featured_api_collections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/api-collections/featured', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collection_by_id(self, **kwargs):  # noqa: E501
        """Get My Api Collection By Id  # noqa: E501

        <p>Get Api Collection By API_COLLECTION_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_by_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collection_by_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collection_by_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collection_by_id_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collection By Id  # noqa: E501

        <p>Get Api Collection By API_COLLECTION_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_by_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collection_by_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collection_by_name(self, **kwargs):  # noqa: E501
        """Get My Api Collection By Name  # noqa: E501

        <p>Get Api Collection By API_COLLECTION_NAME.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_by_name(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collection_by_name_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collection_by_name_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collection_by_name_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collection By Name  # noqa: E501

        <p>Get Api Collection By API_COLLECTION_NAME.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_by_name_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collection_by_name" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/name/API_COLLECTION_NAME', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collection_endpoint(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoint  # noqa: E501

        <p>Get Api Collection Endpoint By API_COLLECTION_NAME and OPERATION_ID.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoint(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collection_endpoint_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collection_endpoint_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collection_endpoint_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoint  # noqa: E501

        <p>Get Api Collection Endpoint By API_COLLECTION_NAME and OPERATION_ID.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoint_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collection_endpoint" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_NAME/api-collection-endpoints/OPERATION_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collection_endpoints(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoints  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_NAME.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoints(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collection_endpoints_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collection_endpoints_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collection_endpoints_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoints  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_NAME.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoints_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collection_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections/API_COLLECTION_NAME/api-collection-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collection_endpoints_by_id(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoints By Id  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoints_by_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collection_endpoints_by_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collection_endpoints_by_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collection_endpoints_by_id_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collection Endpoints By Id  # noqa: E501

        <p>Get Api Collection Endpoints By API_COLLECTION_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collection_endpoints_by_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionEndpointsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collection_endpoints_by_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collection-ids/API_COLLECTION_ID/api-collection-endpoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionEndpointsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_api_collections(self, **kwargs):  # noqa: E501
        """Get My Api Collections  # noqa: E501

        <p>Get all the apiCollections for logged in user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collections(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_api_collections_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_api_collections_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_api_collections_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Api Collections  # noqa: E501

        <p>Get all the apiCollections for logged in user.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_api_collections_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionsJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_api_collections" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/api-collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionsJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sharable_api_collection_by_id(self, **kwargs):  # noqa: E501
        """Get Sharable Api Collection By Id  # noqa: E501

        <p>Get Sharable Api Collection By Id.<br />Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sharable_api_collection_by_id(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_sharable_api_collection_by_id_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_sharable_api_collection_by_id_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_sharable_api_collection_by_id_with_http_info(self, **kwargs):  # noqa: E501
        """Get Sharable Api Collection By Id  # noqa: E501

        <p>Get Sharable Api Collection By Id.<br />Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_sharable_api_collection_by_id_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ApiCollectionJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sharable_api_collection_by_id" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/api-collections/sharable/API_COLLECTION_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiCollectionJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
