# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ATMApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_atm(self, body, bank_id, **kwargs):  # noqa: E501
        """Create ATM  # noqa: E501

        <p>Create ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_atm(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_atm_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_atm_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_atm_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create ATM  # noqa: E501

        <p>Create ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_atm_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_atm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_atm`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_atm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_atm(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Delete ATM  # noqa: E501

        <p>Delete ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_atm(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_atm_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_atm_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_atm_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Delete ATM  # noqa: E501

        <p>Delete ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_atm_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_atm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_atm`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `delete_atm`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_atm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_atm(self, atm_id, bank_id, **kwargs):  # noqa: E501
        """Get Bank ATM  # noqa: E501

        <p>Returns information about ATM for a single bank specified by BANK_ID and ATM_ID including:</p><ul><li>Address</li><li>Geo Location</li><li>License the data under this endpoint is released under<br />Authentication is Optional</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_atm(atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_atm_with_http_info(atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_atm_with_http_info(atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_atm_with_http_info(self, atm_id, bank_id, **kwargs):  # noqa: E501
        """Get Bank ATM  # noqa: E501

        <p>Returns information about ATM for a single bank specified by BANK_ID and ATM_ID including:</p><ul><li>Address</li><li>Geo Location</li><li>License the data under this endpoint is released under<br />Authentication is Optional</li></ul>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_atm_with_http_info(atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_atm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `get_atm`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_atm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_atms(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank ATMS  # noqa: E501

        <p>Get Bank ATMS.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_atms(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AtmsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_atms_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_atms_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_atms_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank ATMS  # noqa: E501

        <p>Get Bank ATMS.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_atms_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AtmsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_atms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_atms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmsJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def head_atms(self, bank_id, **kwargs):  # noqa: E501
        """Head Bank ATMS  # noqa: E501

        <p>Head Bank ATMS.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_atms(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AtmsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.head_atms_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.head_atms_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def head_atms_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Head Bank ATMS  # noqa: E501

        <p>Head Bank ATMS.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.head_atms_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AtmsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method head_atms" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `head_atms`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms', 'HEAD',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmsJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """UPDATE ATM  # noqa: E501

        <p>Update ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """UPDATE ATM  # noqa: E501

        <p>Update ATM.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmJsonV400 body: AtmJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_accessibility_features(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Accessibility Features  # noqa: E501

        <p>Update ATM Accessibility Features.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_accessibility_features(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessibilityFeaturesJson body: AccessibilityFeaturesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmAccessibilityFeaturesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_accessibility_features_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_accessibility_features_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_accessibility_features_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Accessibility Features  # noqa: E501

        <p>Update ATM Accessibility Features.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_accessibility_features_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessibilityFeaturesJson body: AccessibilityFeaturesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmAccessibilityFeaturesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_accessibility_features" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_accessibility_features`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_accessibility_features`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_accessibility_features`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/accessibility-features', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmAccessibilityFeaturesJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_location_categories(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Location Categories  # noqa: E501

        <p>Update ATM Location Categories.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_location_categories(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmLocationCategoriesJsonV400 body: AtmLocationCategoriesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmLocationCategoriesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_location_categories_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_location_categories_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_location_categories_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Location Categories  # noqa: E501

        <p>Update ATM Location Categories.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_location_categories_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmLocationCategoriesJsonV400 body: AtmLocationCategoriesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmLocationCategoriesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_location_categories" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_location_categories`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_location_categories`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_location_categories`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/location-categories', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmLocationCategoriesResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_notes(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Notes  # noqa: E501

        <p>Update ATM Notes.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_notes(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmNotesJsonV400 body: AtmNotesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmNotesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_notes_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_notes_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_notes_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Notes  # noqa: E501

        <p>Update ATM Notes.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_notes_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmNotesJsonV400 body: AtmNotesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmNotesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_notes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_notes`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_notes`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_notes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/notes', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmNotesResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_services(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Services  # noqa: E501

        <p>Update ATM Services.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_services(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmServicesJsonV400 body: AtmServicesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmServicesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_services_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_services_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_services_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Services  # noqa: E501

        <p>Update ATM Services.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_services_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AtmServicesJsonV400 body: AtmServicesJsonV400 object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmServicesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_services" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_services`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_services`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_services`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/services', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmServicesResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_supported_currencies(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Supported Currencies  # noqa: E501

        <p>Update ATM Supported Currencies.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_supported_currencies(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SupportedCurrenciesJson body: SupportedCurrenciesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmSupportedCurrenciesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_supported_currencies_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_supported_currencies_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_supported_currencies_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Supported Currencies  # noqa: E501

        <p>Update ATM Supported Currencies.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_supported_currencies_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SupportedCurrenciesJson body: SupportedCurrenciesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmSupportedCurrenciesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_supported_currencies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_supported_currencies`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_supported_currencies`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_supported_currencies`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/supported-currencies', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmSupportedCurrenciesJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_atm_supported_languages(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Supported Languages  # noqa: E501

        <p>Update ATM Supported Languages.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_supported_languages(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SupportedLanguagesJson body: SupportedLanguagesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmSupportedLanguagesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_atm_supported_languages_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_atm_supported_languages_with_http_info(body, atm_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_atm_supported_languages_with_http_info(self, body, atm_id, bank_id, **kwargs):  # noqa: E501
        """Update ATM Supported Languages  # noqa: E501

        <p>Update ATM Supported Languages.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_atm_supported_languages_with_http_info(body, atm_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SupportedLanguagesJson body: SupportedLanguagesJson object that needs to be added. (required)
        :param str atm_id: the atm id (required)
        :param str bank_id: The bank id (required)
        :return: AtmSupportedLanguagesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'atm_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_atm_supported_languages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_atm_supported_languages`")  # noqa: E501
        # verify the required parameter 'atm_id' is set
        if self.api_client.client_side_validation and ('atm_id' not in params or
                                                       params['atm_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `atm_id` when calling `update_atm_supported_languages`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_atm_supported_languages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'atm_id' in params:
            path_params['ATM_ID'] = params['atm_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/atms/{ATM_ID}/supported-languages', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AtmSupportedLanguagesJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
