# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class CardApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_card_for_bank(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Card  # noqa: E501

        <p>Create Card at bank specified by BANK_ID .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_card_for_bank(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePhysicalCardJsonV500 body: CreatePhysicalCardJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_card_for_bank_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_card_for_bank_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def add_card_for_bank_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Card  # noqa: E501

        <p>Create Card at bank specified by BANK_ID .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_card_for_bank_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreatePhysicalCardJsonV500 body: CreatePhysicalCardJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_card_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_card_for_bank`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_card_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhysicalCardJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_card_attribute(self, body, card_id, bank_id, **kwargs):  # noqa: E501
        """Create Card Attribute  # noqa: E501

        <p>Create Card Attribute</p><p>Card Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Card Attribute is linked to its Card by CARD_ID</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_attribute(body, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardAttributeJson body: CardAttributeJson object that needs to be added. (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: CardAttributeCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_card_attribute_with_http_info(body, card_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_card_attribute_with_http_info(body, card_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_card_attribute_with_http_info(self, body, card_id, bank_id, **kwargs):  # noqa: E501
        """Create Card Attribute  # noqa: E501

        <p>Create Card Attribute</p><p>Card Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Card Attribute is linked to its Card by CARD_ID</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_card_attribute_with_http_info(body, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardAttributeJson body: CardAttributeJson object that needs to be added. (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: CardAttributeCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'card_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_card_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_card_attribute`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if self.api_client.client_side_validation and ('card_id' not in params or
                                                       params['card_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_id` when calling `create_card_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_card_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['CARD_ID'] = params['card_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards/{CARD_ID}/attribute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CardAttributeCommons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_card_attribute_definition(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Card Attribute Definition  # noqa: E501

        <p>Create or Update Card Attribute Definition</p><p>The category field must be Card</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_card_attribute_definition(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_card_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_card_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_or_update_card_attribute_definition_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Card Attribute Definition  # noqa: E501

        <p>Create or Update Card Attribute Definition</p><p>The category field must be Card</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_card_attribute_definition_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_card_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_card_attribute_definition`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_or_update_card_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/card', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_card_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Delete Card Attribute Definition  # noqa: E501

        <p>Delete Card Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_card_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_card_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_card_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete Card Attribute Definition  # noqa: E501

        <p>Delete Card Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_card_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_card_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/ATTRIBUTE_DEFINITION_ID/card', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_card_for_bank(self, card_id, bank_id, **kwargs):  # noqa: E501
        """Delete Card  # noqa: E501

        <p>Delete a Card at bank specified by CARD_ID .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_for_bank(card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_card_for_bank_with_http_info(card_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_card_for_bank_with_http_info(card_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_card_for_bank_with_http_info(self, card_id, bank_id, **kwargs):  # noqa: E501
        """Delete Card  # noqa: E501

        <p>Delete a Card at bank specified by CARD_ID .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_card_for_bank_with_http_info(card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_card_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if self.api_client.client_side_validation and ('card_id' not in params or
                                                       params['card_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_id` when calling `delete_card_for_bank`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_card_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['CARD_ID'] = params['card_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards/{CARD_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Get Card Attribute Definition  # noqa: E501

        <p>Get Card Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_card_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Card Attribute Definition  # noqa: E501

        <p>Get Card Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_card_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/card', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionsResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_card_for_bank(self, card_id, bank_id, **kwargs):  # noqa: E501
        """Get Card By Id  # noqa: E501

        <p>This will the datails of the card.<br />It shows the account infomation which linked the the card.<br />Also shows the card attributes of the card.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_for_bank(card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_card_for_bank_with_http_info(card_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_card_for_bank_with_http_info(card_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_card_for_bank_with_http_info(self, card_id, bank_id, **kwargs):  # noqa: E501
        """Get Card By Id  # noqa: E501

        <p>This will the datails of the card.<br />It shows the account infomation which linked the the card.<br />Also shows the card attributes of the card.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_card_for_bank_with_http_info(card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['card_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_card_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'card_id' is set
        if self.api_client.client_side_validation and ('card_id' not in params or
                                                       params['card_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_id` when calling `get_card_for_bank`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_card_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['CARD_ID'] = params['card_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards/{CARD_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhysicalCardWithAttributesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cards(self, body, **kwargs):  # noqa: E501
        """Get cards for the current user  # noqa: E501

        <p>Returns data about all the physical cards a user has been issued. These could be debit cards, credit cards, etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cards(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: PhysicalCardsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cards_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cards_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def get_cards_with_http_info(self, body, **kwargs):  # noqa: E501
        """Get cards for the current user  # noqa: E501

        <p>Returns data about all the physical cards a user has been issued. These could be debit cards, credit cards, etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cards_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :return: PhysicalCardsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cards" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_cards`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/cards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhysicalCardsJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cards_for_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Cards for the specified bank  # noqa: E501

        <p>Should be able to filter on the following fields</p><p>eg:/management/banks/BANK_ID/cards?customer_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;account_id=8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0</p><p>1 customer_id should be valid customer_id, otherwise, it will return an empty card list.</p><p>2 account_id should be valid account_id , otherwise, it will return an empty card list.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cards_for_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: PhysicalCardsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_cards_for_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_cards_for_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_cards_for_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Cards for the specified bank  # noqa: E501

        <p>Should be able to filter on the following fields</p><p>eg:/management/banks/BANK_ID/cards?customer_id=66214b8e-259e-44ad-8868-3eb47be70646&amp;account_id=8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0</p><p>1 customer_id should be valid customer_id, otherwise, it will return an empty card list.</p><p>2 account_id should be valid account_id , otherwise, it will return an empty card list.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cards_for_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: PhysicalCardsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cards_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_cards_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhysicalCardsJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_status_of_credit_card_order(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get status of Credit Card order   # noqa: E501

        <pre><code>  Get status of Credit Card orders</code></pre><p>Get all orders</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_of_credit_card_order(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CreditCardOrderStatusResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_status_of_credit_card_order_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_status_of_credit_card_order_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_status_of_credit_card_order_with_http_info(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get status of Credit Card order   # noqa: E501

        <pre><code>  Get status of Credit Card orders</code></pre><p>Get all orders</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_status_of_credit_card_order_with_http_info(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CreditCardOrderStatusResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_status_of_credit_card_order" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_status_of_credit_card_order`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_status_of_credit_card_order`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_status_of_credit_card_order`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/credit_cards/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreditCardOrderStatusResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_card_attribute(self, body, card_attribute_id, card_id, bank_id, **kwargs):  # noqa: E501
        """Update Card Attribute  # noqa: E501

        <p>Update Card Attribute</p><p>Card Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Card Attribute is linked to its Card by CARD_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_attribute(body, card_attribute_id, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardAttributeJson body: CardAttributeJson object that needs to be added. (required)
        :param str card_attribute_id: the card attribute id (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: CardAttributeCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_card_attribute_with_http_info(body, card_attribute_id, card_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_card_attribute_with_http_info(body, card_attribute_id, card_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_card_attribute_with_http_info(self, body, card_attribute_id, card_id, bank_id, **kwargs):  # noqa: E501
        """Update Card Attribute  # noqa: E501

        <p>Update Card Attribute</p><p>Card Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Card Attribute is linked to its Card by CARD_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_card_attribute_with_http_info(body, card_attribute_id, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CardAttributeJson body: CardAttributeJson object that needs to be added. (required)
        :param str card_attribute_id: the card attribute id (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: CardAttributeCommons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'card_attribute_id', 'card_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_card_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_card_attribute`")  # noqa: E501
        # verify the required parameter 'card_attribute_id' is set
        if self.api_client.client_side_validation and ('card_attribute_id' not in params or
                                                       params['card_attribute_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_attribute_id` when calling `update_card_attribute`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if self.api_client.client_side_validation and ('card_id' not in params or
                                                       params['card_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_id` when calling `update_card_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_card_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_attribute_id' in params:
            path_params['CARD_ATTRIBUTE_ID'] = params['card_attribute_id']  # noqa: E501
        if 'card_id' in params:
            path_params['CARD_ID'] = params['card_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards/{CARD_ID}/attributes/{CARD_ATTRIBUTE_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CardAttributeCommons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def updated_card_for_bank(self, body, card_id, bank_id, **kwargs):  # noqa: E501
        """Update Card  # noqa: E501

        <p>Update Card at bank specified by CARD_ID .<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.updated_card_for_bank(body, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdatePhysicalCardJsonV310 body: UpdatePhysicalCardJsonV310 object that needs to be added. (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.updated_card_for_bank_with_http_info(body, card_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.updated_card_for_bank_with_http_info(body, card_id, bank_id, **kwargs)  # noqa: E501
            return data

    def updated_card_for_bank_with_http_info(self, body, card_id, bank_id, **kwargs):  # noqa: E501
        """Update Card  # noqa: E501

        <p>Update Card at bank specified by CARD_ID .<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.updated_card_for_bank_with_http_info(body, card_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdatePhysicalCardJsonV310 body: UpdatePhysicalCardJsonV310 object that needs to be added. (required)
        :param str card_id: the card id (required)
        :param str bank_id: The bank id (required)
        :return: PhysicalCardJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'card_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method updated_card_for_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `updated_card_for_bank`")  # noqa: E501
        # verify the required parameter 'card_id' is set
        if self.api_client.client_side_validation and ('card_id' not in params or
                                                       params['card_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `card_id` when calling `updated_card_for_bank`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `updated_card_for_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'card_id' in params:
            path_params['CARD_ID'] = params['card_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/cards/{CARD_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PhysicalCardJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
