# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ConsumerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_scope(self, body, consumer_id, **kwargs):  # noqa: E501
        """Create Scope for a Consumer  # noqa: E501

        <p>Create Scope. Grant Role to Consumer.</p><p>Scopes are used to grant System or Bank level roles to the Consumer (App). (For Account level privileges, see Views)</p><p>For a System level Role (.e.g CanGetAnyUser), set bank_id to an empty string i.e. &quot;bank_id&quot;:&quot;&quot;</p><p>For a Bank level Role (e.g. CanCreateAccount), set bank_id to a valid value e.g. &quot;bank_id&quot;:&quot;my-bank-id&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_scope(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateScopeJson body: CreateScopeJson object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ScopeJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_scope_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_scope_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
            return data

    def add_scope_with_http_info(self, body, consumer_id, **kwargs):  # noqa: E501
        """Create Scope for a Consumer  # noqa: E501

        <p>Create Scope. Grant Role to Consumer.</p><p>Scopes are used to grant System or Bank level roles to the Consumer (App). (For Account level privileges, see Views)</p><p>For a System level Role (.e.g CanGetAnyUser), set bank_id to an empty string i.e. &quot;bank_id&quot;:&quot;&quot;</p><p>For a Bank level Role (e.g. CanCreateAccount), set bank_id to a valid value e.g. &quot;bank_id&quot;:&quot;my-bank-id&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_scope_with_http_info(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateScopeJson body: CreateScopeJson object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ScopeJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_scope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_scope`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `add_scope`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scopes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScopeJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def calls_limit(self, body, consumer_id, **kwargs):  # noqa: E501
        """Set Calls Limit for a Consumer  # noqa: E501

        <p>Set the API call limits for a Consumer:</p><p>Per Second<br />Per Minute<br />Per Hour<br />Per Week<br />Per Month</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calls_limit(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CallLimitPostJsonV400 body: CallLimitPostJsonV400 object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: CallLimitPostJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calls_limit_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.calls_limit_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
            return data

    def calls_limit_with_http_info(self, body, consumer_id, **kwargs):  # noqa: E501
        """Set Calls Limit for a Consumer  # noqa: E501

        <p>Set the API call limits for a Consumer:</p><p>Per Second<br />Per Minute<br />Per Hour<br />Per Week<br />Per Month</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calls_limit_with_http_info(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CallLimitPostJsonV400 body: CallLimitPostJsonV400 object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: CallLimitPostJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calls_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `calls_limit`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `calls_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers/{CONSUMER_ID}/consumer/call-limits', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CallLimitPostJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_consumer(self, body, **kwargs):  # noqa: E501
        """Post a Consumer  # noqa: E501

        <p>Create a Consumer (Authenticated access).</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_consumer(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConsumerPostJSON body: ConsumerPostJSON object that needs to be added. (required)
        :return: ConsumerJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_consumer_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_consumer_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_consumer_with_http_info(self, body, **kwargs):  # noqa: E501
        """Post a Consumer  # noqa: E501

        <p>Create a Consumer (Authenticated access).</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_consumer_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConsumerPostJSON body: ConsumerPostJSON object that needs to be added. (required)
        :return: ConsumerJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_consumer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_consumer`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsumerJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_scope(self, scope_id, consumer_id, **kwargs):  # noqa: E501
        """Delete Consumer Scope  # noqa: E501

        <p>Delete Consumer Scope specified by SCOPE_ID for an consumer specified by CONSUMER_ID</p><p>Authentication is required and the user needs to be a Super Admin.<br />Super Admins are listed in the Props file.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scope(scope_id, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope_id: the scope id (required)
        :param str consumer_id: new consumer id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_scope_with_http_info(scope_id, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_scope_with_http_info(scope_id, consumer_id, **kwargs)  # noqa: E501
            return data

    def delete_scope_with_http_info(self, scope_id, consumer_id, **kwargs):  # noqa: E501
        """Delete Consumer Scope  # noqa: E501

        <p>Delete Consumer Scope specified by SCOPE_ID for an consumer specified by CONSUMER_ID</p><p>Authentication is required and the user needs to be a Super Admin.<br />Super Admins are listed in the Props file.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_scope_with_http_info(scope_id, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str scope_id: the scope id (required)
        :param str consumer_id: new consumer id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scope_id', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_scope" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scope_id' is set
        if self.api_client.client_side_validation and ('scope_id' not in params or
                                                       params['scope_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `scope_id` when calling `delete_scope`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `delete_scope`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scope_id' in params:
            path_params['SCOPE_ID'] = params['scope_id']  # noqa: E501
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scope/{SCOPE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def enable_disable_consumers(self, body, consumer_id, **kwargs):  # noqa: E501
        """Enable or Disable Consumers  # noqa: E501

        <p>Enable/Disable a Consumer specified by CONSUMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_disable_consumers(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutEnabledJSON body: PutEnabledJSON object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: PutEnabledJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.enable_disable_consumers_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.enable_disable_consumers_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
            return data

    def enable_disable_consumers_with_http_info(self, body, consumer_id, **kwargs):  # noqa: E501
        """Enable or Disable Consumers  # noqa: E501

        <p>Enable/Disable a Consumer specified by CONSUMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.enable_disable_consumers_with_http_info(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutEnabledJSON body: PutEnabledJSON object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: PutEnabledJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method enable_disable_consumers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `enable_disable_consumers`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `enable_disable_consumers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers/{CONSUMER_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PutEnabledJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_calls_limit(self, consumer_id, **kwargs):  # noqa: E501
        """Get Call Limits for a Consumer  # noqa: E501

        <p>Get Calls limits per Consumer.<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_calls_limit(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: CallLimitJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_calls_limit_with_http_info(consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_calls_limit_with_http_info(consumer_id, **kwargs)  # noqa: E501
            return data

    def get_calls_limit_with_http_info(self, consumer_id, **kwargs):  # noqa: E501
        """Get Call Limits for a Consumer  # noqa: E501

        <p>Get Calls limits per Consumer.<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_calls_limit_with_http_info(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: CallLimitJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_calls_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `get_calls_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers/{CONSUMER_ID}/consumer/call-limits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CallLimitJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_consumer(self, consumer_id, **kwargs):  # noqa: E501
        """Get Consumer  # noqa: E501

        <p>Get the Consumer specified by CONSUMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumer(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ConsumerJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_consumer_with_http_info(consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_consumer_with_http_info(consumer_id, **kwargs)  # noqa: E501
            return data

    def get_consumer_with_http_info(self, consumer_id, **kwargs):  # noqa: E501
        """Get Consumer  # noqa: E501

        <p>Get the Consumer specified by CONSUMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumer_with_http_info(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ConsumerJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_consumer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `get_consumer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers/{CONSUMER_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsumerJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_consumers(self, **kwargs):  # noqa: E501
        """Get Consumers  # noqa: E501

        <p>Get the all Consumers.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConsumersJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_consumers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_consumers_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_consumers_with_http_info(self, **kwargs):  # noqa: E501
        """Get Consumers  # noqa: E501

        <p>Get the all Consumers.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConsumersJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_consumers" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsumersJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_consumers_for_current_user(self, **kwargs):  # noqa: E501
        """Get Consumers (logged in User)  # noqa: E501

        <p>Get the Consumers for logged in User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumers_for_current_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConsumersJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_consumers_for_current_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_consumers_for_current_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_consumers_for_current_user_with_http_info(self, **kwargs):  # noqa: E501
        """Get Consumers (logged in User)  # noqa: E501

        <p>Get the Consumers for logged in User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_consumers_for_current_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: ConsumersJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_consumers_for_current_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/users/current/consumers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsumersJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_scopes(self, consumer_id, **kwargs):  # noqa: E501
        """Get Scopes for Consumer  # noqa: E501

        <p>Get all the scopes for an consumer specified by CONSUMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scopes(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ScopeJsons
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_scopes_with_http_info(consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_scopes_with_http_info(consumer_id, **kwargs)  # noqa: E501
            return data

    def get_scopes_with_http_info(self, consumer_id, **kwargs):  # noqa: E501
        """Get Scopes for Consumer  # noqa: E501

        <p>Get all the scopes for an consumer specified by CONSUMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_scopes_with_http_info(consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str consumer_id: new consumer id (required)
        :return: ScopeJsons
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_scopes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `get_scopes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/consumers/{CONSUMER_ID}/scopes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScopeJsons',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_consumer_redirect_url(self, body, consumer_id, **kwargs):  # noqa: E501
        """Update Consumer RedirectUrl  # noqa: E501

        <p>Update an existing redirectUrl for a Consumer specified by CONSUMER_ID.</p><p>CONSUMER_ID can be obtained after you register the application.</p><p>Or use the endpoint 'Get Consumers' to get it</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_consumer_redirect_url(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConsumerRedirectUrlJSON body: ConsumerRedirectUrlJSON object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ConsumerJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_consumer_redirect_url_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_consumer_redirect_url_with_http_info(body, consumer_id, **kwargs)  # noqa: E501
            return data

    def update_consumer_redirect_url_with_http_info(self, body, consumer_id, **kwargs):  # noqa: E501
        """Update Consumer RedirectUrl  # noqa: E501

        <p>Update an existing redirectUrl for a Consumer specified by CONSUMER_ID.</p><p>CONSUMER_ID can be obtained after you register the application.</p><p>Or use the endpoint 'Get Consumers' to get it</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_consumer_redirect_url_with_http_info(body, consumer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ConsumerRedirectUrlJSON body: ConsumerRedirectUrlJSON object that needs to be added. (required)
        :param str consumer_id: new consumer id (required)
        :return: ConsumerJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'consumer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_consumer_redirect_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_consumer_redirect_url`")  # noqa: E501
        # verify the required parameter 'consumer_id' is set
        if self.api_client.client_side_validation and ('consumer_id' not in params or
                                                       params['consumer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `consumer_id` when calling `update_consumer_redirect_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'consumer_id' in params:
            path_params['CONSUMER_ID'] = params['consumer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/consumers/{CONSUMER_ID}/consumer/redirect_url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConsumerJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
