# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class CounterpartyApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Corporate Location to Counterparty  # noqa: E501

        <p>Add the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Corporate Location to Counterparty  # noqa: E501

        <p>Add the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add image url to other bank account  # noqa: E501

        <p>Add a url that points to the logo of the counterparty</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add image url to other bank account  # noqa: E501

        <p>Add a url that points to the logo of the counterparty</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Counterparty More Info  # noqa: E501

        <p>Add a description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Counterparty More Info  # noqa: E501

        <p>Add a description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Open Corporates URL to Counterparty  # noqa: E501

        <p>Add open corporates url to other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Open Corporates URL to Counterparty  # noqa: E501

        <p>Add open corporates url to other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add physical location to other bank account  # noqa: E501

        <p>Add geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add physical location to other bank account  # noqa: E501

        <p>Add geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add public alias to other bank account  # noqa: E501

        <p>Creates the public alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p><p>Note: Public aliases are automatically generated for new 'other accounts / counterparties', so this call should only be used if<br />the public alias was deleted.</p><p>The VIEW_ID parameter should be a view the caller is permitted to access to and that has permission to create public aliases.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add public alias to other bank account  # noqa: E501

        <p>Creates the public alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p><p>Note: Public aliases are automatically generated for new 'other accounts / counterparties', so this call should only be used if<br />the public alias was deleted.</p><p>The VIEW_ID parameter should be a view the caller is permitted to access to and that has permission to create public aliases.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add url to other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add url to other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_other_account_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Other Account Private Alias  # noqa: E501

        <p>Creates a private alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_other_account_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_other_account_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Other Account Private Alias  # noqa: E501

        <p>Creates a private alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_other_account_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_other_account_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_counterparty(self, body, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Counterparty (Explicit)  # noqa: E501

        <p>Create Counterparty (Explicit) for an Account.</p><p>In OBP, there are two types of Counterparty.</p><ul><li><p>Explicit Counterparties (those here) which we create explicitly and are used in COUNTERPARTY Transaction Requests</p></li><li><p>Implicit Counterparties (AKA Other Accounts) which are generated automatically from the other sides of Transactions.</p></li></ul><p>Explicit Counterparties are created for the account / view<br />They are how the user of the view (e.g. account owner) refers to the other side of the transaction</p><p>name : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>description : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>currency : counterparty account currency (e.g. EUR, GBP, USD, ...)</p><p>bank_routing_scheme : eg: bankId or bankCode or any other strings</p><p>bank_routing_address : eg: <code>gh.29.uk</code>, must be valid sandbox bankIds</p><p>account_routing_scheme : eg: AccountId or AccountNumber or any other strings</p><p>account_routing_address : eg: <code>1d65db7c-a7b2-4839-af41-95</code>, must be valid accountIds</p><p>other_account_secondary_routing_scheme : eg: IBan or any other strings</p><p>other_account_secondary_routing_address : if it is an IBAN, it should be unique for each counterparty.</p><p>other_branch_routing_scheme : eg: branchId or any other strings or you can leave it empty, not useful in sandbox mode.</p><p>other_branch_routing_address : eg: <code>branch-id-123</code> or you can leave it empty, not useful in sandbox mode.</p><p>is_beneficiary : must be set to <code>true</code> in order to send payments to this counterparty</p><p>bespoke: It supports a list of key-value, you can add it to the counterparty.</p><p>bespoke.key : any info-key you want to add to this counterparty</p><p>bespoke.value : any info-value you want to add to this counterparty</p><p>The view specified by VIEW_ID must have the canAddCounterparty permission</p><p>A minimal example for TransactionRequestType == COUNTERPARTY<br />{<br />&quot;name&quot;: &quot;Tesobe1&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;&quot;,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>A minimal example for TransactionRequestType == SEPA</p><p>{<br />&quot;name&quot;: &quot;Tesobe2&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;IBAN&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;DE89 3704 0044 0532 0130 00&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_counterparty(body, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCounterpartyJson400 body: PostCounterpartyJson400 object that needs to be added. (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_counterparty_with_http_info(body, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_counterparty_with_http_info(body, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_counterparty_with_http_info(self, body, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Counterparty (Explicit)  # noqa: E501

        <p>Create Counterparty (Explicit) for an Account.</p><p>In OBP, there are two types of Counterparty.</p><ul><li><p>Explicit Counterparties (those here) which we create explicitly and are used in COUNTERPARTY Transaction Requests</p></li><li><p>Implicit Counterparties (AKA Other Accounts) which are generated automatically from the other sides of Transactions.</p></li></ul><p>Explicit Counterparties are created for the account / view<br />They are how the user of the view (e.g. account owner) refers to the other side of the transaction</p><p>name : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>description : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>currency : counterparty account currency (e.g. EUR, GBP, USD, ...)</p><p>bank_routing_scheme : eg: bankId or bankCode or any other strings</p><p>bank_routing_address : eg: <code>gh.29.uk</code>, must be valid sandbox bankIds</p><p>account_routing_scheme : eg: AccountId or AccountNumber or any other strings</p><p>account_routing_address : eg: <code>1d65db7c-a7b2-4839-af41-95</code>, must be valid accountIds</p><p>other_account_secondary_routing_scheme : eg: IBan or any other strings</p><p>other_account_secondary_routing_address : if it is an IBAN, it should be unique for each counterparty.</p><p>other_branch_routing_scheme : eg: branchId or any other strings or you can leave it empty, not useful in sandbox mode.</p><p>other_branch_routing_address : eg: <code>branch-id-123</code> or you can leave it empty, not useful in sandbox mode.</p><p>is_beneficiary : must be set to <code>true</code> in order to send payments to this counterparty</p><p>bespoke: It supports a list of key-value, you can add it to the counterparty.</p><p>bespoke.key : any info-key you want to add to this counterparty</p><p>bespoke.value : any info-value you want to add to this counterparty</p><p>The view specified by VIEW_ID must have the canAddCounterparty permission</p><p>A minimal example for TransactionRequestType == COUNTERPARTY<br />{<br />&quot;name&quot;: &quot;Tesobe1&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;&quot;,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>A minimal example for TransactionRequestType == SEPA</p><p>{<br />&quot;name&quot;: &quot;Tesobe2&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;IBAN&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;DE89 3704 0044 0532 0130 00&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_counterparty_with_http_info(body, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCounterpartyJson400 body: PostCounterpartyJson400 object that needs to be added. (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_counterparty" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_counterparty`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `create_counterparty`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_counterparty`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_counterparty`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_counterparty_for_any_account(self, body, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Counterparty for any account (Explicit)  # noqa: E501

        <p>Create Counterparty for any Account. (Explicit)</p><p>In OBP, there are two types of Counterparty.</p><ul><li><p>Explicit Counterparties (those here) which we create explicitly and are used in COUNTERPARTY Transaction Requests</p></li><li><p>Implicit Counterparties (AKA Other Accounts) which are generated automatically from the other sides of Transactions.</p></li></ul><p>Explicit Counterparties are created for the account / view<br />They are how the user of the view (e.g. account owner) refers to the other side of the transaction</p><p>name : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>description : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>currency : counterparty account currency (e.g. EUR, GBP, USD, ...)</p><p>bank_routing_scheme : eg: bankId or bankCode or any other strings</p><p>bank_routing_address : eg: <code>gh.29.uk</code>, must be valid sandbox bankIds</p><p>account_routing_scheme : eg: AccountId or AccountNumber or any other strings</p><p>account_routing_address : eg: <code>1d65db7c-a7b2-4839-af41-95</code>, must be valid accountIds</p><p>other_account_secondary_routing_scheme : eg: IBan or any other strings</p><p>other_account_secondary_routing_address : if it is an IBAN, it should be unique for each counterparty.</p><p>other_branch_routing_scheme : eg: branchId or any other strings or you can leave it empty, not useful in sandbox mode.</p><p>other_branch_routing_address : eg: <code>branch-id-123</code> or you can leave it empty, not useful in sandbox mode.</p><p>is_beneficiary : must be set to <code>true</code> in order to send payments to this counterparty</p><p>bespoke: It supports a list of key-value, you can add it to the counterparty.</p><p>bespoke.key : any info-key you want to add to this counterparty</p><p>bespoke.value : any info-value you want to add to this counterparty</p><p>The view specified by VIEW_ID must have the canAddCounterparty permission</p><p>A minimal example for TransactionRequestType == COUNTERPARTY<br />{<br />&quot;name&quot;: &quot;Tesobe1&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;&quot;,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>A minimal example for TransactionRequestType == SEPA</p><p>{<br />&quot;name&quot;: &quot;Tesobe2&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;IBAN&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;DE89 3704 0044 0532 0130 00&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_counterparty_for_any_account(body, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCounterpartyJson400 body: PostCounterpartyJson400 object that needs to be added. (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_counterparty_for_any_account_with_http_info(body, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_counterparty_for_any_account_with_http_info(body, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_counterparty_for_any_account_with_http_info(self, body, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Counterparty for any account (Explicit)  # noqa: E501

        <p>Create Counterparty for any Account. (Explicit)</p><p>In OBP, there are two types of Counterparty.</p><ul><li><p>Explicit Counterparties (those here) which we create explicitly and are used in COUNTERPARTY Transaction Requests</p></li><li><p>Implicit Counterparties (AKA Other Accounts) which are generated automatically from the other sides of Transactions.</p></li></ul><p>Explicit Counterparties are created for the account / view<br />They are how the user of the view (e.g. account owner) refers to the other side of the transaction</p><p>name : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>description : the human readable name (e.g. Piano teacher, Miss Nipa)</p><p>currency : counterparty account currency (e.g. EUR, GBP, USD, ...)</p><p>bank_routing_scheme : eg: bankId or bankCode or any other strings</p><p>bank_routing_address : eg: <code>gh.29.uk</code>, must be valid sandbox bankIds</p><p>account_routing_scheme : eg: AccountId or AccountNumber or any other strings</p><p>account_routing_address : eg: <code>1d65db7c-a7b2-4839-af41-95</code>, must be valid accountIds</p><p>other_account_secondary_routing_scheme : eg: IBan or any other strings</p><p>other_account_secondary_routing_address : if it is an IBAN, it should be unique for each counterparty.</p><p>other_branch_routing_scheme : eg: branchId or any other strings or you can leave it empty, not useful in sandbox mode.</p><p>other_branch_routing_address : eg: <code>branch-id-123</code> or you can leave it empty, not useful in sandbox mode.</p><p>is_beneficiary : must be set to <code>true</code> in order to send payments to this counterparty</p><p>bespoke: It supports a list of key-value, you can add it to the counterparty.</p><p>bespoke.key : any info-key you want to add to this counterparty</p><p>bespoke.value : any info-value you want to add to this counterparty</p><p>The view specified by VIEW_ID must have the canAddCounterparty permission</p><p>A minimal example for TransactionRequestType == COUNTERPARTY<br />{<br />&quot;name&quot;: &quot;Tesobe1&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;&quot;,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>A minimal example for TransactionRequestType == SEPA</p><p>{<br />&quot;name&quot;: &quot;Tesobe2&quot;,<br />&quot;description&quot;: &quot;Good Company&quot;,<br />&quot;currency&quot;: &quot;EUR&quot;,<br />&quot;other_bank_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_bank_routing_address&quot;: &quot;gh.29.uk&quot;,<br />&quot;other_account_routing_scheme&quot;: &quot;OBP&quot;,<br />&quot;other_account_routing_address&quot;: &quot;8ca8a7e4-6d02-48e3-a029-0b2bf89de9f0&quot;,<br />&quot;other_account_secondary_routing_scheme&quot;: &quot;IBAN&quot;,<br />&quot;other_account_secondary_routing_address&quot;: &quot;DE89 3704 0044 0532 0130 00&quot;,<br />&quot;is_beneficiary&quot;: true,<br />&quot;other_branch_routing_scheme&quot;: &quot;&quot;,<br />&quot;other_branch_routing_address&quot;: &quot;&quot;,<br />&quot;bespoke&quot;: []<br />}</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_counterparty_for_any_account_with_http_info(body, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCounterpartyJson400 body: PostCounterpartyJson400 object that needs to be added. (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_counterparty_for_any_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `create_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `create_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_counterparty_for_any_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Corporate Location  # noqa: E501

        <p>Delete corporate location of other bank account. Delete the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Corporate Location  # noqa: E501

        <p>Delete corporate location of other bank account. Delete the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_for_any_account(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty for any account (Explicit)  # noqa: E501

        <p>Delete Counterparty (Explicit) for any account<br />and also delete the Metadata for its counterparty.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_for_any_account(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_for_any_account_with_http_info(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty for any account (Explicit)  # noqa: E501

        <p>Delete Counterparty (Explicit) for any account<br />and also delete the Metadata for its counterparty.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_for_any_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_id' is set
        if self.api_client.client_side_validation and ('counterparty_id' not in params or
                                                       params['counterparty_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_id` when calling `delete_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_for_any_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_for_any_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_id' in params:
            path_params['COUNTERPARTY_ID'] = params['counterparty_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties/{COUNTERPARTY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Image URL  # noqa: E501

        <p>Delete image url of other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Image URL  # noqa: E501

        <p>Delete image url of other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete more info of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete more info of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Open Corporates URL  # noqa: E501

        <p>Delete open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Open Corporates URL  # noqa: E501

        <p>Delete open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Physical Location  # noqa: E501

        <p>Delete physical location of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Physical Location  # noqa: E501

        <p>Delete physical location of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Private Alias  # noqa: E501

        <p>Deletes the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Private Alias  # noqa: E501

        <p>Deletes the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Public Alias  # noqa: E501

        <p>Deletes the public alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Public Alias  # noqa: E501

        <p>Deletes the public alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete url of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete url of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_explicit_counterparty(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty (Explicit)  # noqa: E501

        <p>Delete Counterparty (Explicit) for an Account.<br />and also delete the Metadata for its counterparty.</p><p>need the view permission <code>can_delete_counterparty</code><br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_explicit_counterparty(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_explicit_counterparty_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_explicit_counterparty_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_explicit_counterparty_with_http_info(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty (Explicit)  # noqa: E501

        <p>Delete Counterparty (Explicit) for an Account.<br />and also delete the Metadata for its counterparty.</p><p>need the view permission <code>can_delete_counterparty</code><br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_explicit_counterparty_with_http_info(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_explicit_counterparty" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_id' is set
        if self.api_client.client_side_validation and ('counterparty_id' not in params or
                                                       params['counterparty_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_id` when calling `delete_explicit_counterparty`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_explicit_counterparty`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_explicit_counterparty`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_explicit_counterparty`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_id' in params:
            path_params['COUNTERPARTY_ID'] = params['counterparty_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties/{COUNTERPARTY_ID}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_counterparties_for_any_account(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparties for any account (Explicit)  # noqa: E501

        <p>Get the Counterparties (Explicit) for any account .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparties_for_any_account(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartiesJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_counterparties_for_any_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_counterparties_for_any_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_counterparties_for_any_account_with_http_info(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparties for any account (Explicit)  # noqa: E501

        <p>Get the Counterparties (Explicit) for any account .</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparties_for_any_account_with_http_info(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartiesJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparties_for_any_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_counterparties_for_any_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_counterparties_for_any_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_counterparties_for_any_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartiesJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_counterparty_by_id_for_any_account(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id for any account (Explicit)   # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_by_id_for_any_account(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_counterparty_by_id_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_counterparty_by_id_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_counterparty_by_id_for_any_account_with_http_info(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id for any account (Explicit)   # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_by_id_for_any_account_with_http_info(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparty_by_id_for_any_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_id' is set
        if self.api_client.client_side_validation and ('counterparty_id' not in params or
                                                       params['counterparty_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_id` when calling `get_counterparty_by_id_for_any_account`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_counterparty_by_id_for_any_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_counterparty_by_id_for_any_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_counterparty_by_id_for_any_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_id' in params:
            path_params['COUNTERPARTY_ID'] = params['counterparty_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties/{COUNTERPARTY_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_counterparty_by_name_for_any_account(self, counterparty_name, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by name for any account (Explicit)   # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_by_name_for_any_account(counterparty_name, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_name: the counterparty name (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_counterparty_by_name_for_any_account_with_http_info(counterparty_name, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_counterparty_by_name_for_any_account_with_http_info(counterparty_name, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_counterparty_by_name_for_any_account_with_http_info(self, counterparty_name, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by name for any account (Explicit)   # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_by_name_for_any_account_with_http_info(counterparty_name, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_name: the counterparty name (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_name', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparty_by_name_for_any_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_name' is set
        if self.api_client.client_side_validation and ('counterparty_name' not in params or
                                                       params['counterparty_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_name` when calling `get_counterparty_by_name_for_any_account`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_counterparty_by_name_for_any_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_counterparty_by_name_for_any_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_counterparty_by_name_for_any_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_name' in params:
            path_params['COUNTERPARTY_NAME'] = params['counterparty_name']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparty-names/{COUNTERPARTY_NAME}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get public alias of other bank account  # noqa: E501

        <p>Returns the public alias of the other account OTHER_ACCOUNT_ID.<br />Authentication is Optional<br />Authentication is Mandatory if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get public alias of other bank account  # noqa: E501

        <p>Returns the public alias of the other account OTHER_ACCOUNT_ID.<br />Authentication is Optional<br />Authentication is Mandatory if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_explict_counterparties_for_account(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparties (Explicit)  # noqa: E501

        <p>Get the Counterparties (Explicit) for the account / view.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparties_for_account(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartiesJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_explict_counterparties_for_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_explict_counterparties_for_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_explict_counterparties_for_account_with_http_info(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparties (Explicit)  # noqa: E501

        <p>Get the Counterparties (Explicit) for the account / view.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparties_for_account_with_http_info(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartiesJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_explict_counterparties_for_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_explict_counterparties_for_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_explict_counterparties_for_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_explict_counterparties_for_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartiesJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_explict_counterparty_by_id(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id (Explicit)  # noqa: E501

        <p>Information returned about the Counterparty specified by COUNTERPARTY_ID:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparty_by_id(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_explict_counterparty_by_id_with_http_info(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id (Explicit)  # noqa: E501

        <p>Information returned about the Counterparty specified by COUNTERPARTY_ID:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_explict_counterparty_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_id' is set
        if self.api_client.client_side_validation and ('counterparty_id' not in params or
                                                       params['counterparty_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_id' in params:
            path_params['COUNTERPARTY_ID'] = params['counterparty_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties/{COUNTERPARTY_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_by_id_for_bank_account(self, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account by Id  # noqa: E501

        <p>Returns data about the Other Account that has shared at least one transaction with ACCOUNT_ID at BANK_ID.<br />Authentication is Optional</p><p>Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_by_id_for_bank_account(other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_by_id_for_bank_account_with_http_info(other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_by_id_for_bank_account_with_http_info(other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_by_id_for_bank_account_with_http_info(self, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account by Id  # noqa: E501

        <p>Returns data about the Other Account that has shared at least one transaction with ACCOUNT_ID at BANK_ID.<br />Authentication is Optional</p><p>Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_by_id_for_bank_account_with_http_info(other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_by_id_for_bank_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_other_account_by_id_for_bank_account`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_by_id_for_bank_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_by_id_for_bank_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_by_id_for_bank_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtherAccountJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_for_transaction(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account of Transaction  # noqa: E501

        <p>Get other account of a transaction.<br />Returns details of the other party involved in the transaction, moderated by the <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_for_transaction(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_for_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_for_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_for_transaction_with_http_info(self, body, transaction_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account of Transaction  # noqa: E501

        <p>Get other account of a transaction.<br />Returns details of the other party involved in the transaction, moderated by the <a href=\"#1_2_1-getViewsForBankAccount\">view</a> (VIEW_ID).<br />Authentication via OAuth is required if the view is not public.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_for_transaction_with_http_info(body, transaction_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str transaction_id: The transaction id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'transaction_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_for_transaction" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_other_account_for_transaction`")  # noqa: E501
        # verify the required parameter 'transaction_id' is set
        if self.api_client.client_side_validation and ('transaction_id' not in params or
                                                       params['transaction_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `transaction_id` when calling `get_other_account_for_transaction`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_for_transaction`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_for_transaction`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_for_transaction`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transaction_id' in params:
            path_params['TRANSACTION_ID'] = params['transaction_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/transactions/{TRANSACTION_ID}/other_account', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtherAccountJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_metadata(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Metadata  # noqa: E501

        <p>Get metadata of one other account.<br />Returns only the metadata about one other bank account (OTHER_ACCOUNT_ID) that had shared at least one transaction with ACCOUNT_ID at BANK_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_metadata(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountMetadataJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_metadata_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Metadata  # noqa: E501

        <p>Get metadata of one other account.<br />Returns only the metadata about one other bank account (OTHER_ACCOUNT_ID) that had shared at least one transaction with ACCOUNT_ID at BANK_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountMetadataJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtherAccountMetadataJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Private Alias  # noqa: E501

        <p>Returns the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Private Alias  # noqa: E501

        <p>Returns the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_accounts_for_bank_account(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Accounts of one Account  # noqa: E501

        <p>Returns data about all the other accounts that have shared at least one transaction with the ACCOUNT_ID at BANK_ID.<br />Authentication is Optional</p><p>Authentication is required if the view VIEW_ID is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_accounts_for_bank_account(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountsJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_accounts_for_bank_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_accounts_for_bank_account_with_http_info(view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_accounts_for_bank_account_with_http_info(self, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Accounts of one Account  # noqa: E501

        <p>Returns data about all the other accounts that have shared at least one transaction with the ACCOUNT_ID at BANK_ID.<br />Authentication is Optional</p><p>Authentication is required if the view VIEW_ID is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_accounts_for_bank_account_with_http_info(view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountsJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_accounts_for_bank_account" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_accounts_for_bank_account`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_accounts_for_bank_account`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_accounts_for_bank_account`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtherAccountsJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Corporate Location  # noqa: E501

        <p>Update the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Corporate Location  # noqa: E501

        <p>Update the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Image Url  # noqa: E501

        <p>Update the url that points to the logo of the counterparty</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Image Url  # noqa: E501

        <p>Update the url that points to the logo of the counterparty</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty More Info  # noqa: E501

        <p>Update the more info description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty More Info  # noqa: E501

        <p>Update the more info description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Open Corporates Url of Counterparty  # noqa: E501

        <p>Update open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Open Corporates Url of Counterparty  # noqa: E501

        <p>Update open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Physical Location  # noqa: E501

        <p>Update geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Physical Location  # noqa: E501

        <p>Update geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Private Alias  # noqa: E501

        <p>Updates the private alias of the counterparty (AKA other account) OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Private Alias  # noqa: E501

        <p>Updates the private alias of the counterparty (AKA other account) OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update public alias of other bank account  # noqa: E501

        <p>Updates the public alias of the other account / counterparty OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update public alias of other bank account  # noqa: E501

        <p>Updates the public alias of the other account / counterparty OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update url of other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update url of other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
