# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class CounterpartyMetadataApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Corporate Location to Counterparty  # noqa: E501

        <p>Add the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Corporate Location to Counterparty  # noqa: E501

        <p>Add the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add image url to other bank account  # noqa: E501

        <p>Add a url that points to the logo of the counterparty</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add image url to other bank account  # noqa: E501

        <p>Add a url that points to the logo of the counterparty</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Counterparty More Info  # noqa: E501

        <p>Add a description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Counterparty More Info  # noqa: E501

        <p>Add a description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Open Corporates URL to Counterparty  # noqa: E501

        <p>Add open corporates url to other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add Open Corporates URL to Counterparty  # noqa: E501

        <p>Add open corporates url to other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add physical location to other bank account  # noqa: E501

        <p>Add geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add physical location to other bank account  # noqa: E501

        <p>Add geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add public alias to other bank account  # noqa: E501

        <p>Creates the public alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p><p>Note: Public aliases are automatically generated for new 'other accounts / counterparties', so this call should only be used if<br />the public alias was deleted.</p><p>The VIEW_ID parameter should be a view the caller is permitted to access to and that has permission to create public aliases.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add public alias to other bank account  # noqa: E501

        <p>Creates the public alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p><p>Note: Public aliases are automatically generated for new 'other accounts / counterparties', so this call should only be used if<br />the public alias was deleted.</p><p>The VIEW_ID parameter should be a view the caller is permitted to access to and that has permission to create public aliases.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add url to other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Add url to other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_other_account_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Other Account Private Alias  # noqa: E501

        <p>Creates a private alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_other_account_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_other_account_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Create Other Account Private Alias  # noqa: E501

        <p>Creates a private alias for the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_other_account_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `add_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_other_account_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Corporate Location  # noqa: E501

        <p>Delete corporate location of other bank account. Delete the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Corporate Location  # noqa: E501

        <p>Delete corporate location of other bank account. Delete the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Image URL  # noqa: E501

        <p>Delete image url of other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Image URL  # noqa: E501

        <p>Delete image url of other bank account</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete more info of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete more info of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Open Corporates URL  # noqa: E501

        <p>Delete open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Open Corporates URL  # noqa: E501

        <p>Delete open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Physical Location  # noqa: E501

        <p>Delete physical location of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Physical Location  # noqa: E501

        <p>Delete physical location of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Private Alias  # noqa: E501

        <p>Deletes the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Private Alias  # noqa: E501

        <p>Deletes the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Public Alias  # noqa: E501

        <p>Deletes the public alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete Counterparty Public Alias  # noqa: E501

        <p>Deletes the public alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete url of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Delete url of other bank account  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `delete_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get public alias of other bank account  # noqa: E501

        <p>Returns the public alias of the other account OTHER_ACCOUNT_ID.<br />Authentication is Optional<br />Authentication is Mandatory if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get public alias of other bank account  # noqa: E501

        <p>Returns the public alias of the other account OTHER_ACCOUNT_ID.<br />Authentication is Optional<br />Authentication is Mandatory if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_explict_counterparty_by_id(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id (Explicit)  # noqa: E501

        <p>Information returned about the Counterparty specified by COUNTERPARTY_ID:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparty_by_id(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_explict_counterparty_by_id_with_http_info(self, counterparty_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Counterparty by Id (Explicit)  # noqa: E501

        <p>Information returned about the Counterparty specified by COUNTERPARTY_ID:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_explict_counterparty_by_id_with_http_info(counterparty_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str counterparty_id: the counterparty id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CounterpartyWithMetadataJson400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['counterparty_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_explict_counterparty_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'counterparty_id' is set
        if self.api_client.client_side_validation and ('counterparty_id' not in params or
                                                       params['counterparty_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `counterparty_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_explict_counterparty_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'counterparty_id' in params:
            path_params['COUNTERPARTY_ID'] = params['counterparty_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/counterparties/{COUNTERPARTY_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CounterpartyWithMetadataJson400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_metadata(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Metadata  # noqa: E501

        <p>Get metadata of one other account.<br />Returns only the metadata about one other bank account (OTHER_ACCOUNT_ID) that had shared at least one transaction with ACCOUNT_ID at BANK_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_metadata(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountMetadataJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_metadata_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Metadata  # noqa: E501

        <p>Get metadata of one other account.<br />Returns only the metadata about one other bank account (OTHER_ACCOUNT_ID) that had shared at least one transaction with ACCOUNT_ID at BANK_ID.</p><p>Authentication via OAuth is required if the view is not public.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_metadata_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: OtherAccountMetadataJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_metadata" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_metadata`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_metadata`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OtherAccountMetadataJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_other_account_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Private Alias  # noqa: E501

        <p>Returns the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_other_account_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Other Account Private Alias  # noqa: E501

        <p>Returns the private alias of the other account OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_other_account_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: AliasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_other_account_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_other_account_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_other_account_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AliasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_corporate_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Corporate Location  # noqa: E501

        <p>Update the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_corporate_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_corporate_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Corporate Location  # noqa: E501

        <p>Update the geolocation of the counterparty's registered address</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_corporate_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CorporateLocationJSON body: CorporateLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_corporate_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_corporate_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_corporate_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/corporate_location', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_image_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Image Url  # noqa: E501

        <p>Update the url that points to the logo of the counterparty</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_image_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_image_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Image Url  # noqa: E501

        <p>Update the url that points to the logo of the counterparty</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_image_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ImageUrlJSON body: ImageUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_image_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_image_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_image_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/image_url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_more_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty More Info  # noqa: E501

        <p>Update the more info description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_more_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_more_info_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty More Info  # noqa: E501

        <p>Update the more info description of the counter party from the perpestive of the account e.g. My dentist</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_more_info_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MoreInfoJSON body: MoreInfoJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_more_info" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_more_info`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_more_info`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/more_info', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_open_corporates_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Open Corporates Url of Counterparty  # noqa: E501

        <p>Update open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_open_corporates_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_open_corporates_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Open Corporates Url of Counterparty  # noqa: E501

        <p>Update open corporate url of other bank account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_open_corporates_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OpenCorporateUrlJSON body: OpenCorporateUrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_open_corporates_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_open_corporates_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/open_corporates_url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_physical_location(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Physical Location  # noqa: E501

        <p>Update geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_physical_location(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_physical_location_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Physical Location  # noqa: E501

        <p>Update geocoordinates of the counterparty's main location</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_physical_location_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PhysicalLocationJSON body: PhysicalLocationJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_physical_location" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_physical_location`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_physical_location`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/physical_location', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_private_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Private Alias  # noqa: E501

        <p>Updates the private alias of the counterparty (AKA other account) OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_private_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_private_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update Counterparty Private Alias  # noqa: E501

        <p>Updates the private alias of the counterparty (AKA other account) OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_private_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_private_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_private_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_private_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/private_alias', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_public_alias(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update public alias of other bank account  # noqa: E501

        <p>Updates the public alias of the other account / counterparty OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_public_alias(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_public_alias_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update public alias of other bank account  # noqa: E501

        <p>Updates the public alias of the other account / counterparty OTHER_ACCOUNT_ID.</p><p>Authentication is Optional<br />Authentication is required if the view is not public.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_public_alias_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AliasJSON body: AliasJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_public_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_public_alias`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_public_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/public_alias', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_counterparty_url(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update url of other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_url(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_counterparty_url_with_http_info(self, body, other_account_id, view_id, account_id, bank_id, **kwargs):  # noqa: E501
        """Update url of other bank account  # noqa: E501

        <p>A url which represents the counterparty (home page url etc.)</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_counterparty_url_with_http_info(body, other_account_id, view_id, account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UrlJSON body: UrlJSON object that needs to be added. (required)
        :param str other_account_id: The other account id (required)
        :param str view_id: The view id (required)
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'other_account_id', 'view_id', 'account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_counterparty_url" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'other_account_id' is set
        if self.api_client.client_side_validation and ('other_account_id' not in params or
                                                       params['other_account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `other_account_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'view_id' is set
        if self.api_client.client_side_validation and ('view_id' not in params or
                                                       params['view_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `view_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `update_counterparty_url`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_counterparty_url`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'other_account_id' in params:
            path_params['OTHER_ACCOUNT_ID'] = params['other_account_id']  # noqa: E501
        if 'view_id' in params:
            path_params['VIEW_ID'] = params['view_id']  # noqa: E501
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/{VIEW_ID}/other_accounts/{OTHER_ACCOUNT_ID}/metadata/url', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
