# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class CustomerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_customer_message(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Message  # noqa: E501

        <p>Create a message for the customer specified by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_message(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerMessageJson body: AddCustomerMessageJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_customer_message_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_customer_message_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_customer_message_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Message  # noqa: E501

        <p>Create a message for the customer specified by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_customer_message_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AddCustomerMessageJson body: AddCustomerMessageJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_customer_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_customer_message`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_customer_message`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_customer_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer/{CUSTOMER_ID}/messages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_check(self, body, kyc_check_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Check  # noqa: E501

        <p>Add a KYC check for the customer specified by CUSTOMER_ID. KYC Checks store details of checks on a customer made by the KYC team, their comments and a satisfied status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_check(body, kyc_check_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycCheckJSON body: PostKycCheckJSON object that needs to be added. (required)
        :param str kyc_check_id: The kyc check id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycCheckJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_check_with_http_info(self, body, kyc_check_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Check  # noqa: E501

        <p>Add a KYC check for the customer specified by CUSTOMER_ID. KYC Checks store details of checks on a customer made by the KYC team, their comments and a satisfied status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycCheckJSON body: PostKycCheckJSON object that needs to be added. (required)
        :param str kyc_check_id: The kyc check id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycCheckJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_check_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_check" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'kyc_check_id' is set
        if self.api_client.client_side_validation and ('kyc_check_id' not in params or
                                                       params['kyc_check_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_check_id` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_check`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_check_id' in params:
            path_params['KYC_CHECK_ID'] = params['kyc_check_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_check/{KYC_CHECK_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycCheckJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_document(self, body, kyc_document_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Document  # noqa: E501

        <p>Add a KYC document for the customer specified by CUSTOMER_ID. KYC Documents contain the document type (e.g. passport), place of issue, expiry etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_document(body, kyc_document_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycDocumentJSON body: PostKycDocumentJSON object that needs to be added. (required)
        :param str kyc_document_id: The kyc document id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycDocumentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_document_with_http_info(self, body, kyc_document_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Document  # noqa: E501

        <p>Add a KYC document for the customer specified by CUSTOMER_ID. KYC Documents contain the document type (e.g. passport), place of issue, expiry etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycDocumentJSON body: PostKycDocumentJSON object that needs to be added. (required)
        :param str kyc_document_id: The kyc document id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycDocumentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_document_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'kyc_document_id' is set
        if self.api_client.client_side_validation and ('kyc_document_id' not in params or
                                                       params['kyc_document_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_document_id` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_document_id' in params:
            path_params['KYC_DOCUMENT_ID'] = params['kyc_document_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_documents/{KYC_DOCUMENT_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycDocumentJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_media(self, body, kyc_media_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Media  # noqa: E501

        <p>Add some KYC media for the customer specified by CUSTOMER_ID. KYC Media resources relate to KYC Documents and KYC Checks and contain media urls for scans of passports, utility bills etc</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_media(body, kyc_media_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycMediaJSON body: PostKycMediaJSON object that needs to be added. (required)
        :param str kyc_media_id: The kyc media id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycMediaJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_media_with_http_info(self, body, kyc_media_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Media  # noqa: E501

        <p>Add some KYC media for the customer specified by CUSTOMER_ID. KYC Media resources relate to KYC Documents and KYC Checks and contain media urls for scans of passports, utility bills etc</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycMediaJSON body: PostKycMediaJSON object that needs to be added. (required)
        :param str kyc_media_id: The kyc media id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycMediaJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_media_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_media" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'kyc_media_id' is set
        if self.api_client.client_side_validation and ('kyc_media_id' not in params or
                                                       params['kyc_media_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_media_id` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_media_id' in params:
            path_params['KYC_MEDIA_ID'] = params['kyc_media_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_media/{KYC_MEDIA_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycMediaJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_status(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Status  # noqa: E501

        <p>Add a kyc_status for the customer specified by CUSTOMER_ID. KYC Status is a timeline of the KYC status of the customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_status(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycStatusJSON body: PostKycStatusJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycStatusJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_status_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_status_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_status_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Status  # noqa: E501

        <p>Add a kyc_status for the customer specified by CUSTOMER_ID. KYC Status is a timeline of the KYC status of the customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_status_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycStatusJSON body: PostKycStatusJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycStatusJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_status`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_status`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_statuses', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycStatusJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_social_media_handle(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add Social Media Handle  # noqa: E501

        <p>Add a social media handle for the customer specified by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_social_media_handle(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SocialMediaJSON body: SocialMediaJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_social_media_handle_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_social_media_handle_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_social_media_handle_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add Social Media Handle  # noqa: E501

        <p>Add a social media handle for the customer specified by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_social_media_handle_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param SocialMediaJSON body: SocialMediaJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_social_media_handle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_social_media_handle`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_social_media_handle`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_social_media_handle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/social_media_handles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_credit_limit_request(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Credit Limit Order Request  # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><p>Create credit limit order request</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_credit_limit_request(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreditLimitRequestJson body: CreditLimitRequestJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_credit_limit_request_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_credit_limit_request_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_credit_limit_request_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Credit Limit Order Request  # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><p>Create credit limit order request</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_credit_limit_request_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreditLimitRequestJson body: CreditLimitRequestJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_credit_limit_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_credit_limit_request`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_credit_limit_request`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_credit_limit_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/credit_limit/requests', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreditLimitOrderResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_customer(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Customer  # noqa: E501

        <p>The Customer resource stores the customer number (which is set by the backend), legal name, email, phone number, their date of birth, relationship status, education attained, a url for a profile image, KYC status etc.<br />Dates need to be in the format 2013-01-21T23:08:00Z</p><p>Note: If you need to set a specific customer number, use the Update Customer Number endpoint after this call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerJsonV500 body: PostCustomerJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_customer_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Customer  # noqa: E501

        <p>The Customer resource stores the customer number (which is set by the backend), legal name, email, phone number, their date of birth, relationship status, education attained, a url for a profile image, KYC status etc.<br />Dates need to be in the format 2013-01-21T23:08:00Z</p><p>Note: If you need to set a specific customer number, use the Update Customer Number endpoint after this call.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerJsonV500 body: PostCustomerJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_customer`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_customer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_customer_account_link(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Customer Account Link  # noqa: E501

        <p>Link a Customer to a Account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_account_link(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateCustomerAccountLinkJson body: CreateCustomerAccountLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_account_link_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_account_link_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_customer_account_link_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Customer Account Link  # noqa: E501

        <p>Link a Customer to a Account</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_account_link_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateCustomerAccountLinkJson body: CreateCustomerAccountLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_account_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_customer_account_link`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_customer_account_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer-account-links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAccountLinkJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_customer_address(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Address  # noqa: E501

        <p>Create an Address for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_address(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerAddressJsonV310 body: PostCustomerAddressJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_address_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_address_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_customer_address_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Address  # noqa: E501

        <p>Create an Address for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_address_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerAddressJsonV310 body: PostCustomerAddressJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_customer_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_customer_address`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_customer_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/address', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAddressJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_customer_attribute(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Attribute  # noqa: E501

        <p>Create Customer Attribute</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_attribute(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerAttributeJsonV400 body: CustomerAttributeJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_attribute_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_attribute_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_customer_attribute_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Attribute  # noqa: E501

        <p>Create Customer Attribute</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_attribute_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerAttributeJsonV400 body: CustomerAttributeJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_customer_attribute`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_customer_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_customer_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/attribute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAttributeResponseJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_customer_message(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Message  # noqa: E501

        <p>Create a message for the customer specified by CUSTOMER_ID<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_message(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMessageJsonV400 body: CreateMessageJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_customer_message_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_customer_message_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_customer_message_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Customer Message  # noqa: E501

        <p>Create a message for the customer specified by CUSTOMER_ID<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_customer_message_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMessageJsonV400 body: CreateMessageJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SuccessMessage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_customer_message" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_customer_message`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_customer_message`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_customer_message`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/messages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SuccessMessage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_meeting(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Meeting (video conference/call)  # noqa: E501

        <p>Create Meeting: Initiate a video conference/call with the bank.</p><p>The Meetings resource contains meta data about video/other conference sessions</p><p>provider_id determines the provider of the meeting / video chat service. MUST be url friendly (no spaces).</p><p>purpose_id explains the purpose of the chat. onboarding | mortgage | complaint etc. MUST be url friendly (no spaces).</p><p>Login is required.</p><p>This call is <strong>experimental</strong>. Currently staff_user_id is not set. Further calls will be needed to correctly set this.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_meeting(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMeetingJsonV310 body: CreateMeetingJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: MeetingJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_meeting_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_meeting_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_meeting_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Meeting (video conference/call)  # noqa: E501

        <p>Create Meeting: Initiate a video conference/call with the bank.</p><p>The Meetings resource contains meta data about video/other conference sessions</p><p>provider_id determines the provider of the meeting / video chat service. MUST be url friendly (no spaces).</p><p>purpose_id explains the purpose of the chat. onboarding | mortgage | complaint etc. MUST be url friendly (no spaces).</p><p>Login is required.</p><p>This call is <strong>experimental</strong>. Currently staff_user_id is not set. Further calls will be needed to correctly set this.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_meeting_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateMeetingJsonV310 body: CreateMeetingJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: MeetingJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_meeting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_meeting`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_meeting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/meetings', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MeetingJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_or_update_customer_attribute_attribute_definition(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Customer Attribute Definition  # noqa: E501

        <p>Create or Update Customer Attribute Definition</p><p>The category field must be one of: Customer</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer_attribute_attribute_definition(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_customer_attribute_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_customer_attribute_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_or_update_customer_attribute_attribute_definition_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Customer Attribute Definition  # noqa: E501

        <p>Create or Update Customer Attribute Definition</p><p>The category field must be one of: Customer</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_customer_attribute_attribute_definition_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_customer_attribute_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_customer_attribute_attribute_definition`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_or_update_customer_attribute_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/customer', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tax_residence(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Tax Residence  # noqa: E501

        <p>Create a Tax Residence for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_residence(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTaxResidenceJsonV310 body: PostTaxResidenceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tax_residence_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tax_residence_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_tax_residence_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Tax Residence  # noqa: E501

        <p>Create a Tax Residence for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_residence_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTaxResidenceJsonV310 body: PostTaxResidenceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_tax_residence`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax-residence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxResidenceV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_user_customer_links(self, body, bank_id, **kwargs):  # noqa: E501
        """Create User Customer Link  # noqa: E501

        <p>Link a User to a Customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_customer_links(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUserCustomerLinkJson body: CreateUserCustomerLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_user_customer_links_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_user_customer_links_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_user_customer_links_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create User Customer Link  # noqa: E501

        <p>Link a User to a Customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_customer_links_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateUserCustomerLinkJson body: CreateUserCustomerLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_customer_links" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_user_customer_links`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_user_customer_links`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user_customer_links', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserCustomerLinkJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_account_link_by_id(self, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Account Link  # noqa: E501

        <p>Delete Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_account_link_by_id(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_account_link_by_id_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_account_link_by_id_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_account_link_by_id_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Account Link  # noqa: E501

        <p>Delete Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_account_link_by_id_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_account_link_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_account_link_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer-account-links/CUSTOMER_ACCOUNT_LINK_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_address(self, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Address  # noqa: E501

        <p>Delete an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_address(customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_address_with_http_info(self, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Address  # noqa: E501

        <p>Delete an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_address_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_address_id' is set
        if self.api_client.client_side_validation and ('customer_address_id' not in params or
                                                       params['customer_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_address_id` when calling `delete_customer_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_customer_address`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_address_id' in params:
            path_params['CUSTOMER_ADDRESS_ID'] = params['customer_address_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/addresses/{CUSTOMER_ADDRESS_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_attribute(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Attribute  # noqa: E501

        <p>Delete Customer Attribute</p><p>CustomerAttributes are used to enhance the OBP Customer object with Bank specific entities.</p><p>Delete a Customer Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_attribute(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_attribute_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_attribute_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_attribute_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Attribute  # noqa: E501

        <p>Delete Customer Attribute</p><p>CustomerAttributes are used to enhance the OBP Customer object with Bank specific entities.</p><p>Delete a Customer Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_attribute_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_customer_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/{CUSTOMER_ID}/attributes/CUSTOMER_ATTRIBUTE_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Attribute Definition  # noqa: E501

        <p>Delete Customer Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Attribute Definition  # noqa: E501

        <p>Delete Customer Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/ATTRIBUTE_DEFINITION_ID/customer', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_cascade(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Cascade  # noqa: E501

        <p>Delete a Customer Cascade specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_cascade(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_cascade_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_cascade_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_cascade_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Cascade  # noqa: E501

        <p>Delete a Customer Cascade specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_cascade_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_cascade" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_customer_cascade`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_cascade`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/cascading/banks/{BANK_ID}/customers/{CUSTOMER_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_residence(self, tax_residence_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Tax Residence  # noqa: E501

        <p>Delete a Tax Residence of the Customer specified by TAX_RESIDENCE_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_residence(tax_residence_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tax_residence_id: the tax residence id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_tax_residence_with_http_info(self, tax_residence_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Tax Residence  # noqa: E501

        <p>Delete a Tax Residence of the Customer specified by TAX_RESIDENCE_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tax_residence_id: the tax residence id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_residence_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_residence_id' is set
        if self.api_client.client_side_validation and ('tax_residence_id' not in params or
                                                       params['tax_residence_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tax_residence_id` when calling `delete_tax_residence`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_residence_id' in params:
            path_params['TAX_RESIDENCE_ID'] = params['tax_residence_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax_residencies/{TAX_RESIDENCE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user_customer_link(self, bank_id, **kwargs):  # noqa: E501
        """Delete User Customer Link  # noqa: E501

        <p>Delete User Customer Link by USER_CUSTOMER_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_customer_link(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_user_customer_link_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_user_customer_link_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_user_customer_link_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete User Customer Link  # noqa: E501

        <p>Delete User Customer Link by USER_CUSTOMER_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_customer_link_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_customer_link" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_user_customer_link`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user_customer_links/USER_CUSTOMER_LINK_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_correlated_users_info_by_customer_id(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Correlated User Info by Customer  # noqa: E501

        <p>Get Correlated User Info by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correlated_users_info_by_customer_id(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAndUsersWithAttributesResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_correlated_users_info_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_correlated_users_info_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_correlated_users_info_by_customer_id_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Correlated User Info by Customer  # noqa: E501

        <p>Get Correlated User Info by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_correlated_users_info_by_customer_id_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAndUsersWithAttributesResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_correlated_users_info_by_customer_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_correlated_users_info_by_customer_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_correlated_users_info_by_customer_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/correlated-users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAndUsersWithAttributesResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_credit_limit_request_by_request_id(self, request_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Credit Limit Order Request By Request Id  # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><pre><code>    Get Credit Limit Order Request By Request Id</code></pre><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credit_limit_request_by_request_id(request_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str request_id: the request id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_credit_limit_request_by_request_id_with_http_info(request_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_credit_limit_request_by_request_id_with_http_info(request_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_credit_limit_request_by_request_id_with_http_info(self, request_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Credit Limit Order Request By Request Id  # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><pre><code>    Get Credit Limit Order Request By Request Id</code></pre><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credit_limit_request_by_request_id_with_http_info(request_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str request_id: the request id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_credit_limit_request_by_request_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'request_id' is set
        if self.api_client.client_side_validation and ('request_id' not in params or
                                                       params['request_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `request_id` when calling `get_credit_limit_request_by_request_id`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_credit_limit_request_by_request_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_credit_limit_request_by_request_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'request_id' in params:
            path_params['REQUEST_ID'] = params['request_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/credit_limit/requests/{REQUEST_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreditLimitOrderJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_credit_limit_requests(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Credit Limit Order Requests   # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><p>Get Credit Limit Order Requests</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credit_limit_requests(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_credit_limit_requests_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_credit_limit_requests_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_credit_limit_requests_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Credit Limit Order Requests   # noqa: E501

        <p><strong>NOTE: This endpoint currently only returns example data.</strong></p><p>Get Credit Limit Order Requests</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_credit_limit_requests_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CreditLimitOrderJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_credit_limit_requests" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_credit_limit_requests`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_credit_limit_requests`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/credit_limit/requests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreditLimitOrderJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_crm_events(self, body, bank_id, **kwargs):  # noqa: E501
        """Get CRM Events  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crm_events(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CrmEventsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_crm_events_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_crm_events_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_crm_events_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get CRM Events  # noqa: E501

        <p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_crm_events_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CrmEventsJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_crm_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_crm_events`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_crm_events`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/crm-events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CrmEventsJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_account_link_by_id(self, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Link by Id  # noqa: E501

        <p>Get Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_link_by_id(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_account_link_by_id_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_account_link_by_id_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_account_link_by_id_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Link by Id  # noqa: E501

        <p>Get Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_link_by_id_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_account_link_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_account_link_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer-account-links/CUSTOMER_ACCOUNT_LINK_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAccountLinkJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_account_links_by_bank_id_account_id(self, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Links by ACCOUNT_ID  # noqa: E501

        <p>Get Customer Account Links by ACCOUNT_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_links_by_bank_id_account_id(account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_account_links_by_bank_id_account_id_with_http_info(account_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_account_links_by_bank_id_account_id_with_http_info(account_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_account_links_by_bank_id_account_id_with_http_info(self, account_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Links by ACCOUNT_ID  # noqa: E501

        <p>Get Customer Account Links by ACCOUNT_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_links_by_bank_id_account_id_with_http_info(account_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str account_id: The account id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_account_links_by_bank_id_account_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if self.api_client.client_side_validation and ('account_id' not in params or
                                                       params['account_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `account_id` when calling `get_customer_account_links_by_bank_id_account_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_account_links_by_bank_id_account_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['ACCOUNT_ID'] = params['account_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/accounts/{ACCOUNT_ID}/customer-account-links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAccountLinksJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_account_links_by_customer_id(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Links by CUSTOMER_ID  # noqa: E501

        <p>Get Customer Account Links by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_links_by_customer_id(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_account_links_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_account_links_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_account_links_by_customer_id_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Account Links by CUSTOMER_ID  # noqa: E501

        <p>Get Customer Account Links by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_account_links_by_customer_id_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_account_links_by_customer_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_account_links_by_customer_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_account_links_by_customer_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/customer-account-links', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAccountLinksJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_addresses(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Addresses  # noqa: E501

        <p>Get the Addresses of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_addresses(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_addresses_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_addresses_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_addresses_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Addresses  # noqa: E501

        <p>Get the Addresses of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_addresses_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_addresses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_addresses`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_addresses`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAddressesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_attribute_by_id(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attribute By Id  # noqa: E501

        <p>Get Customer Attribute By Id</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attribute_by_id(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_attribute_by_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_attribute_by_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_attribute_by_id_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attribute By Id  # noqa: E501

        <p>Get Customer Attribute By Id</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attribute_by_id_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_attribute_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_attribute_by_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_attribute_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/attributes/ATTRIBUTE_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAttributeResponseJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attribute Definition  # noqa: E501

        <p>Get Customer Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attribute Definition  # noqa: E501

        <p>Get Customer Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/customer', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionsResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_attributes(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attributes  # noqa: E501

        <p>Get Customer Attributes</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attributes(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributesResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_attributes_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_attributes_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_attributes_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Attributes  # noqa: E501

        <p>Get Customer Attributes</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_attributes_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributesResponseJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_attributes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_attributes`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_attributes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/attributes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAttributesResponseJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_customer_id(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_ID  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_id(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_by_customer_id_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_ID  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_id_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_customer_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_by_customer_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_by_customer_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerWithAttributesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_customer_number(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_NUMBER  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_NUMBER.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_number(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerNumberJsonV310 body: PostCustomerNumberJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_customer_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_customer_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_by_customer_number_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_NUMBER  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_NUMBER.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_number_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerNumberJsonV310 body: PostCustomerNumberJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_customer_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_by_customer_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_by_customer_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerWithAttributesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_messages(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Messages for a Customer  # noqa: E501

        <p>Get messages for the customer specified by CUSTOMER_ID<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_messages(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerMessagesJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_messages_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_messages_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_messages_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Messages for a Customer  # noqa: E501

        <p>Get messages for the customer specified by CUSTOMER_ID<br />Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_messages_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerMessagesJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_messages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_messages`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_messages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerMessagesJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_overview(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview  # noqa: E501

        <p>Gets the Customer Overview specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_overview_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_overview_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_overview_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview  # noqa: E501

        <p>Gets the Customer Overview specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_overview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_overview`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_overview`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number-query/overview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerOverviewJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_overview_flat(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview Flat  # noqa: E501

        <p>Gets the Customer Overview Flat specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_flat(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewFlatJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_overview_flat_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_overview_flat_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_overview_flat_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview Flat  # noqa: E501

        <p>Gets the Customer Overview Flat specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_flat_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewFlatJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_overview_flat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_overview_flat`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_overview_flat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number-query/overview-flat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerOverviewFlatJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_at_any_bank(self, **kwargs):  # noqa: E501
        """Get Customers at Any Bank  # noqa: E501

        <p>Get Customers at Any Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_at_any_bank(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerJSONsV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_at_any_bank_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_at_any_bank_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_at_any_bank_with_http_info(self, **kwargs):  # noqa: E501
        """Get Customers at Any Bank  # noqa: E501

        <p>Get Customers at Any Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_at_any_bank_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerJSONsV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_at_any_bank" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJSONsV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_at_one_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Customers at Bank  # noqa: E501

        <p>Get Customers at Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_at_one_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONsV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_at_one_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_at_one_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_customers_at_one_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Customers at Bank  # noqa: E501

        <p>Get Customers at Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_at_one_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONsV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_at_one_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customers_at_one_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJSONsV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_by_customer_phone_number(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customers by MOBILE_PHONE_NUMBER  # noqa: E501

        <p>Gets the Customers specified by MOBILE_PHONE_NUMBER.</p><p>There are two wildcards often used in conjunction with the LIKE operator:<br />% - The percent sign represents zero, one, or multiple characters<br />_ - The underscore represents a single character<br />For example {&quot;customer_phone_number&quot;:&quot;%381%&quot;} lists all numbers which contain 381 sequence</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_customer_phone_number(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerPhoneNumberJsonV400 body: PostCustomerPhoneNumberJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_by_customer_phone_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_by_customer_phone_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customers_by_customer_phone_number_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customers by MOBILE_PHONE_NUMBER  # noqa: E501

        <p>Gets the Customers specified by MOBILE_PHONE_NUMBER.</p><p>There are two wildcards often used in conjunction with the LIKE operator:<br />% - The percent sign represents zero, one, or multiple characters<br />_ - The underscore represents a single character<br />For example {&quot;customer_phone_number&quot;:&quot;%381%&quot;} lists all numbers which contain 381 sequence</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_customer_phone_number_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerPhoneNumberJsonV400 body: PostCustomerPhoneNumberJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_by_customer_phone_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customers_by_customer_phone_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customers_by_customer_phone_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/search/customers/mobile-phone-number', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_for_user(self, **kwargs):  # noqa: E501
        """Get Customers for Current User  # noqa: E501

        <p>Gets all Customers that are linked to a User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_for_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomersWithAttributesJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_for_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_for_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_for_user_with_http_info(self, **kwargs):  # noqa: E501
        """Get Customers for Current User  # noqa: E501

        <p>Gets all Customers that are linked to a User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_for_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomersWithAttributesJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_for_user" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/users/current/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomersWithAttributesJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_messages(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Messages for all Customers  # noqa: E501

        <p>Get messages for the logged in customer<br />Messages sent to the currently authenticated user.</p><p>Authentication via OAuth is required.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_messages(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerMessagesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_messages_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_messages_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customers_messages_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Messages for all Customers  # noqa: E501

        <p>Get messages for the logged in customer<br />Messages sent to the currently authenticated user.</p><p>Authentication via OAuth is required.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_messages_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerMessagesJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_messages" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customers_messages`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customers_messages`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer/messages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerMessagesJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_minimal_at_any_bank(self, **kwargs):  # noqa: E501
        """Get Customers Minimal at Any Bank  # noqa: E501

        <p>Get Customers Minimal at Any Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_minimal_at_any_bank(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomersMinimalJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_minimal_at_any_bank_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_minimal_at_any_bank_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_customers_minimal_at_any_bank_with_http_info(self, **kwargs):  # noqa: E501
        """Get Customers Minimal at Any Bank  # noqa: E501

        <p>Get Customers Minimal at Any Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_minimal_at_any_bank_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomersMinimalJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_minimal_at_any_bank" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers-minimal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomersMinimalJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_minimal_at_one_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get Customers Minimal at Bank  # noqa: E501

        <p>Get Customers Minimal at Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_minimal_at_one_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomersMinimalJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_minimal_at_one_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_minimal_at_one_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_customers_minimal_at_one_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Customers Minimal at Bank  # noqa: E501

        <p>Get Customers Minimal at Bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_minimal_at_one_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomersMinimalJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_minimal_at_one_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customers_minimal_at_one_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers-minimal', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomersMinimalJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_firehose_customers(self, bank_id, **kwargs):  # noqa: E501
        """Get Firehose Customers  # noqa: E501

        <p>Get Customers that has a firehose View.</p><p>Allows bulk access to customers.<br />User must have the CanUseFirehoseAtAnyBank Role</p><p>Possible custom url parameters for pagination:</p><ul><li>limit=NUMBER ==&gt; default value: 50</li><li>offset=NUMBER ==&gt; default value: 0</li></ul><p>eg1:?limit=100&amp;offset=0</p><ul><li>sort_direction=ASC/DESC ==&gt; default value: DESC.</li></ul><p>eg2:?limit=100&amp;offset=0&amp;sort_direction=ASC</p><ul><li>from_date=DATE =&gt; example value: 1970-01-01T00:00:00.000Z. NOTE! The default value is one year ago (1970-01-01T00:00:00.000Z).</li><li>to_date=DATE =&gt; example value: 2023-03-29T11:38:53.816Z. NOTE! The default value is now (2023-03-29T11:38:53.816Z).</li></ul><p>Date format parameter: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'(1100-01-01T01:01:01.000Z) ==&gt; time zone is UTC.</p><p>eg3:?sort_direction=ASC&amp;limit=100&amp;offset=0&amp;from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_firehose_customers(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_firehose_customers_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_firehose_customers_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_firehose_customers_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Firehose Customers  # noqa: E501

        <p>Get Customers that has a firehose View.</p><p>Allows bulk access to customers.<br />User must have the CanUseFirehoseAtAnyBank Role</p><p>Possible custom url parameters for pagination:</p><ul><li>limit=NUMBER ==&gt; default value: 50</li><li>offset=NUMBER ==&gt; default value: 0</li></ul><p>eg1:?limit=100&amp;offset=0</p><ul><li>sort_direction=ASC/DESC ==&gt; default value: DESC.</li></ul><p>eg2:?limit=100&amp;offset=0&amp;sort_direction=ASC</p><ul><li>from_date=DATE =&gt; example value: 1970-01-01T00:00:00.000Z. NOTE! The default value is one year ago (1970-01-01T00:00:00.000Z).</li><li>to_date=DATE =&gt; example value: 2023-03-29T11:38:53.816Z. NOTE! The default value is now (2023-03-29T11:38:53.816Z).</li></ul><p>Date format parameter: yyyy-MM-dd'T'HH:mm:ss.SSS'Z'(1100-01-01T01:01:01.000Z) ==&gt; time zone is UTC.</p><p>eg3:?sort_direction=ASC&amp;limit=100&amp;offset=0&amp;from_date=1100-01-01T01:01:01.000Z&amp;to_date=1100-01-01T01:01:01.000Z</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_firehose_customers_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_firehose_customers" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_firehose_customers`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/firehose/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJSONs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_checks(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Checks  # noqa: E501

        <p>Get KYC checks for the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_checks(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycChecksJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_checks_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_checks_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_checks_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Checks  # noqa: E501

        <p>Get KYC checks for the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_checks_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycChecksJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_checks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_checks`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_checks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_checks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycChecksJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_documents(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Documents  # noqa: E501

        <p>Get KYC (know your customer) documents for a customer specified by CUSTOMER_ID<br />Get a list of documents that affirm the identity of the customer<br />Passport, driving licence etc.<br />Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_documents(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycDocumentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_documents_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_documents_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_documents_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Documents  # noqa: E501

        <p>Get KYC (know your customer) documents for a customer specified by CUSTOMER_ID<br />Get a list of documents that affirm the identity of the customer<br />Passport, driving licence etc.<br />Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_documents_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycDocumentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_documents`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_documents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycDocumentsJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_media(self, body, customer_id, **kwargs):  # noqa: E501
        """Get KYC Media for a customer  # noqa: E501

        <p>Get KYC media (scans, pictures, videos) that affirms the identity of the customer.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_media(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_media_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_media_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_media_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get KYC Media for a customer  # noqa: E501

        <p>Get KYC media (scans, pictures, videos) that affirms the identity of the customer.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_media_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_media" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_media`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_media', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycMediasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_statuses(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC statuses  # noqa: E501

        <p>Get the KYC statuses for a customer specified by CUSTOMER_ID over time.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_statuses(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycStatusesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_statuses_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_statuses_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_statuses_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC statuses  # noqa: E501

        <p>Get the KYC statuses for a customer specified by CUSTOMER_ID over time.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_statuses_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycStatusesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_statuses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_statuses`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_statuses`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_statuses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycStatusesJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_meeting(self, meeting_id, bank_id, **kwargs):  # noqa: E501
        """Get Meeting  # noqa: E501

        <p>Get Meeting specified by BANK_ID / MEETING_ID<br />Meetings contain meta data about, and are used to facilitate, video conferences / chats etc.</p><p>The actual conference/chats are handled by external services.</p><p>Login is required.</p><p>This call is <strong>experimental</strong> and will require further authorisation in the future.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meeting(meeting_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meeting_id: the meeting id (required)
        :param str bank_id: The bank id (required)
        :return: MeetingJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_meeting_with_http_info(meeting_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_meeting_with_http_info(meeting_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_meeting_with_http_info(self, meeting_id, bank_id, **kwargs):  # noqa: E501
        """Get Meeting  # noqa: E501

        <p>Get Meeting specified by BANK_ID / MEETING_ID<br />Meetings contain meta data about, and are used to facilitate, video conferences / chats etc.</p><p>The actual conference/chats are handled by external services.</p><p>Login is required.</p><p>This call is <strong>experimental</strong> and will require further authorisation in the future.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meeting_with_http_info(meeting_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str meeting_id: the meeting id (required)
        :param str bank_id: The bank id (required)
        :return: MeetingJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['meeting_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_meeting" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'meeting_id' is set
        if self.api_client.client_side_validation and ('meeting_id' not in params or
                                                       params['meeting_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `meeting_id` when calling `get_meeting`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_meeting`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'meeting_id' in params:
            path_params['MEETING_ID'] = params['meeting_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/meetings/{MEETING_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MeetingJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_meetings(self, bank_id, **kwargs):  # noqa: E501
        """Get Meetings  # noqa: E501

        <p>Meetings contain meta data about, and are used to facilitate, video conferences / chats etc.</p><p>The actual conference/chats are handled by external services.</p><p>Login is required.</p><p>This call is <strong>experimental</strong> and will require further authorisation in the future.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meetings(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MeetingsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_meetings_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_meetings_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_meetings_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Meetings  # noqa: E501

        <p>Meetings contain meta data about, and are used to facilitate, video conferences / chats etc.</p><p>The actual conference/chats are handled by external services.</p><p>Login is required.</p><p>This call is <strong>experimental</strong> and will require further authorisation in the future.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_meetings_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: MeetingsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_meetings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_meetings`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/meetings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MeetingsJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_correlated_entities(self, **kwargs):  # noqa: E501
        """Get Correlated Entities for the current User  # noqa: E501

        <p>Correlated Entities are users and customers linked to the currently authenticated user via User-Customer-Links</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_correlated_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CorrelatedEntities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_correlated_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_correlated_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_correlated_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Get Correlated Entities for the current User  # noqa: E501

        <p>Correlated Entities are users and customers linked to the currently authenticated user via User-Customer-Links</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_correlated_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CorrelatedEntities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_correlated_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/correlated-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CorrelatedEntities',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_customers_at_any_bank(self, **kwargs):  # noqa: E501
        """Get My Customers  # noqa: E501

        <p>Gets all Customers that are linked to me.</p><p>Authentication via OAuth is required.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_customers_at_any_bank(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerJsonV210
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_customers_at_any_bank_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_customers_at_any_bank_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_customers_at_any_bank_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Customers  # noqa: E501

        <p>Gets all Customers that are linked to me.</p><p>Authentication via OAuth is required.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_customers_at_any_bank_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: CustomerJsonV210
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_customers_at_any_bank" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV210',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_customers_at_bank(self, bank_id, **kwargs):  # noqa: E501
        """Get My Customers at Bank  # noqa: E501

        <p>Returns a list of Customers at the Bank that are linked to the currently authenticated User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_customers_at_bank(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_customers_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_my_customers_at_bank_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_my_customers_at_bank_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get My Customers at Bank  # noqa: E501

        <p>Returns a list of Customers at the Bank that are linked to the currently authenticated User.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_customers_at_bank_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: CustomerJSONs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_customers_at_bank" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_my_customers_at_bank`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/my/customers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJSONs',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_social_media_handles(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Social Media Handles  # noqa: E501

        <p>Get social media handles for a customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_social_media_handles(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SocialMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_social_media_handles_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_social_media_handles_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_social_media_handles_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Social Media Handles  # noqa: E501

        <p>Get social media handles for a customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_social_media_handles_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: SocialMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_social_media_handles" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_social_media_handles`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_social_media_handles`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_social_media_handles`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/social_media_handles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SocialMediasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_residence(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Tax Residences of Customer  # noqa: E501

        <p>Get the Tax Residences of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_residence(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_residence_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_residence_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_tax_residence_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Tax Residences of Customer  # noqa: E501

        <p>Get the Tax Residences of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_residence_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax-residences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxResidenceJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_customer_links_by_customer_id(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get User Customer Links by Customer  # noqa: E501

        <p>Get User Customer Links by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_customer_links_by_customer_id(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_customer_links_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_customer_links_by_customer_id_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_user_customer_links_by_customer_id_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get User Customer Links by Customer  # noqa: E501

        <p>Get User Customer Links by CUSTOMER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_customer_links_by_customer_id_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_customer_links_by_customer_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_user_customer_links_by_customer_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_user_customer_links_by_customer_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user_customer_links/customers/{CUSTOMER_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserCustomerLinksJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_customer_links_by_user_id(self, user_id, bank_id, **kwargs):  # noqa: E501
        """Get User Customer Links by User  # noqa: E501

        <p>Get User Customer Links by USER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_customer_links_by_user_id(user_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user id (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_customer_links_by_user_id_with_http_info(user_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_customer_links_by_user_id_with_http_info(user_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_user_customer_links_by_user_id_with_http_info(self, user_id, bank_id, **kwargs):  # noqa: E501
        """Get User Customer Links by User  # noqa: E501

        <p>Get User Customer Links by USER_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_customer_links_by_user_id_with_http_info(user_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The user id (required)
        :param str bank_id: The bank id (required)
        :return: UserCustomerLinksJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_customer_links_by_user_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_customer_links_by_user_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_user_customer_links_by_user_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['USER_ID'] = params['user_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user_customer_links/users/{USER_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserCustomerLinksJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_account_link_by_id(self, body, bank_id, **kwargs):  # noqa: E501
        """Update Customer Account Link by Id  # noqa: E501

        <p>Update Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_account_link_by_id(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateCustomerAccountLinkJson body: UpdateCustomerAccountLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_account_link_by_id_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_account_link_by_id_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_account_link_by_id_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Update Customer Account Link by Id  # noqa: E501

        <p>Update Customer Account Link by CUSTOMER_ACCOUNT_LINK_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_account_link_by_id_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateCustomerAccountLinkJson body: UpdateCustomerAccountLinkJson object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAccountLinkJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_account_link_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_account_link_by_id`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_account_link_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customer-account-links/CUSTOMER_ACCOUNT_LINK_ID', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAccountLinkJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_address(self, body, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the Address of a Customer  # noqa: E501

        <p>Update an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_address(body, customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerAddressJsonV310 body: PostCustomerAddressJsonV310 object that needs to be added. (required)
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_address_with_http_info(body, customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_address_with_http_info(body, customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_address_with_http_info(self, body, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the Address of a Customer  # noqa: E501

        <p>Update an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_address_with_http_info(body, customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerAddressJsonV310 body: PostCustomerAddressJsonV310 object that needs to be added. (required)
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_address_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_address`")  # noqa: E501
        # verify the required parameter 'customer_address_id' is set
        if self.api_client.client_side_validation and ('customer_address_id' not in params or
                                                       params['customer_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_address_id` when calling `update_customer_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_address`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_address_id' in params:
            path_params['CUSTOMER_ADDRESS_ID'] = params['customer_address_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/addresses/{CUSTOMER_ADDRESS_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAddressJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_attribute(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update Customer Attribute  # noqa: E501

        <p>Update Customer Attribute</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_attribute(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerAttributeJsonV400 body: CustomerAttributeJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_attribute_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_attribute_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_attribute_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update Customer Attribute  # noqa: E501

        <p>Update Customer Attribute</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_attribute_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomerAttributeJsonV400 body: CustomerAttributeJsonV400 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAttributeResponseJsonV300
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_attribute`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/attributes/CUSTOMER_ATTRIBUTE_ID', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAttributeResponseJsonV300',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_branch(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the Branch of a Customer  # noqa: E501

        <p>Update the Branch of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_branch(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerBranchJsonV310 body: PutUpdateCustomerBranchJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_branch_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_branch_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_branch_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the Branch of a Customer  # noqa: E501

        <p>Update the Branch of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_branch_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerBranchJsonV310 body: PutUpdateCustomerBranchJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_branch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_branch`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_branch`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_branch`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/branch', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_credit_limit(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the credit limit of a Customer  # noqa: E501

        <p>Update the credit limit of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_credit_limit(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerCreditLimitJsonV310 body: PutUpdateCustomerCreditLimitJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_credit_limit_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_credit_limit_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_credit_limit_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the credit limit of a Customer  # noqa: E501

        <p>Update the credit limit of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_credit_limit_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerCreditLimitJsonV310 body: PutUpdateCustomerCreditLimitJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_credit_limit" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_credit_limit`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_credit_limit`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_credit_limit`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/credit-limit', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_credit_rating_and_source(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the credit rating and source of a Customer  # noqa: E501

        <p>Update the credit rating and source of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_credit_rating_and_source(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerCreditRatingAndSourceJsonV310 body: PutUpdateCustomerCreditRatingAndSourceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_credit_rating_and_source_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_credit_rating_and_source_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_credit_rating_and_source_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the credit rating and source of a Customer  # noqa: E501

        <p>Update the credit rating and source of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_credit_rating_and_source_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerCreditRatingAndSourceJsonV310 body: PutUpdateCustomerCreditRatingAndSourceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_credit_rating_and_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_credit_rating_and_source`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_credit_rating_and_source`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_credit_rating_and_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/credit-rating-and-source', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_data(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the other data of a Customer  # noqa: E501

        <p>Update the other data of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_data(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerDataJsonV310 body: PutUpdateCustomerDataJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_data_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_data_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_data_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the other data of a Customer  # noqa: E501

        <p>Update the other data of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_data_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerDataJsonV310 body: PutUpdateCustomerDataJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_data`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_data`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/data', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_email(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the email of a Customer  # noqa: E501

        <p>Update an email of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_email(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerEmailJsonV310 body: PutUpdateCustomerEmailJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_email_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_email_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_email_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the email of a Customer  # noqa: E501

        <p>Update an email of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_email_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerEmailJsonV310 body: PutUpdateCustomerEmailJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_email" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_email`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_email`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_email`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/email', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_identity(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the identity data of a Customer  # noqa: E501

        <p>Update the identity data of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_identity(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerIdentityJsonV310 body: PutUpdateCustomerIdentityJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_identity_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_identity_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_identity_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the identity data of a Customer  # noqa: E501

        <p>Update the identity data of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_identity_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerIdentityJsonV310 body: PutUpdateCustomerIdentityJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_identity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_identity`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_identity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_identity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/identity', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_mobile_number(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the mobile number of a Customer  # noqa: E501

        <p>Update the mobile number of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_mobile_number(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerMobilePhoneNumberJsonV310 body: PutUpdateCustomerMobilePhoneNumberJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_mobile_number_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_mobile_number_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_mobile_number_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the mobile number of a Customer  # noqa: E501

        <p>Update the mobile number of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_mobile_number_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerMobilePhoneNumberJsonV310 body: PutUpdateCustomerMobilePhoneNumberJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_mobile_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_mobile_number`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_mobile_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_mobile_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/mobile-number', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_customer_number(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the number of a Customer  # noqa: E501

        <p>Update the number of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_number(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerNumberJsonV310 body: PutUpdateCustomerNumberJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_customer_number_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_customer_number_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_customer_number_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Update the number of a Customer  # noqa: E501

        <p>Update the number of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_customer_number_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutUpdateCustomerNumberJsonV310 body: PutUpdateCustomerNumberJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_customer_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_customer_number`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `update_customer_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_customer_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/number', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
