# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class DataWarehouseApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def data_warehouse_search(self, body, index, **kwargs):  # noqa: E501
        """Data Warehouse Search  # noqa: E501

        <p>Search the data warehouse and get row level results.</p><p>Authentication is Mandatory</p><p>CanSearchWarehouse entitlement is required. You can request the Role below.</p><p>Elastic (search) is used in the background. See links below for syntax.</p><p>Examples of usage:</p><p>POST /search/warehouse/THE_INDEX_YOU_WANT_TO_USE</p><p>POST /search/warehouse/INDEX1,INDEX2</p><p>POST /search/warehouse/ALL</p><p>{ Any valid elasticsearch query DSL in the body }</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html\">Elasticsearch query DSL</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-request-body.html\">Elastic simple query</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-aggregations.html\">Elastic aggregations</a></p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_warehouse_search(body, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ElasticSearchJsonV300 body: ElasticSearchJsonV300 object that needs to be added. (required)
        :param str index: the elastic search index (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_warehouse_search_with_http_info(body, index, **kwargs)  # noqa: E501
        else:
            (data) = self.data_warehouse_search_with_http_info(body, index, **kwargs)  # noqa: E501
            return data

    def data_warehouse_search_with_http_info(self, body, index, **kwargs):  # noqa: E501
        """Data Warehouse Search  # noqa: E501

        <p>Search the data warehouse and get row level results.</p><p>Authentication is Mandatory</p><p>CanSearchWarehouse entitlement is required. You can request the Role below.</p><p>Elastic (search) is used in the background. See links below for syntax.</p><p>Examples of usage:</p><p>POST /search/warehouse/THE_INDEX_YOU_WANT_TO_USE</p><p>POST /search/warehouse/INDEX1,INDEX2</p><p>POST /search/warehouse/ALL</p><p>{ Any valid elasticsearch query DSL in the body }</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html\">Elasticsearch query DSL</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-request-body.html\">Elastic simple query</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-aggregations.html\">Elastic aggregations</a></p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_warehouse_search_with_http_info(body, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ElasticSearchJsonV300 body: ElasticSearchJsonV300 object that needs to be added. (required)
        :param str index: the elastic search index (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_warehouse_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `data_warehouse_search`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in params or
                                                       params['index'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `index` when calling `data_warehouse_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'index' in params:
            path_params['INDEX'] = params['index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/search/warehouse/{INDEX}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def data_warehouse_statistics(self, body, field, index, **kwargs):  # noqa: E501
        """Data Warehouse Statistics  # noqa: E501

        <p>Search the data warehouse and get statistical aggregations over a warehouse field</p><p>Does a stats aggregation over some numeric field:</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-stats-aggregation.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-stats-aggregation.html</a></p><p>Authentication is Mandatory</p><p>CanSearchWarehouseStats Role is required. You can request this below.</p><p>Elastic (search) is used in the background. See links below for syntax.</p><p>Examples of usage:</p><p>POST /search/warehouse/statistics/INDEX/FIELD</p><p>POST /search/warehouse/statistics/ALL/FIELD</p><p>{ Any valid elasticsearch query DSL in the body }</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html\">Elasticsearch query DSL</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-request-body.html\">Elastic simple query</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-aggregations.html\">Elastic aggregations</a></p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_warehouse_statistics(body, field, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ElasticSearchJsonV300 body: ElasticSearchJsonV300 object that needs to be added. (required)
        :param str field: the elastic search field (required)
        :param str index: the elastic search index (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.data_warehouse_statistics_with_http_info(body, field, index, **kwargs)  # noqa: E501
        else:
            (data) = self.data_warehouse_statistics_with_http_info(body, field, index, **kwargs)  # noqa: E501
            return data

    def data_warehouse_statistics_with_http_info(self, body, field, index, **kwargs):  # noqa: E501
        """Data Warehouse Statistics  # noqa: E501

        <p>Search the data warehouse and get statistical aggregations over a warehouse field</p><p>Does a stats aggregation over some numeric field:</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-stats-aggregation.html\">https://www.elastic.co/guide/en/elasticsearch/reference/current/search-aggregations-metrics-stats-aggregation.html</a></p><p>Authentication is Mandatory</p><p>CanSearchWarehouseStats Role is required. You can request this below.</p><p>Elastic (search) is used in the background. See links below for syntax.</p><p>Examples of usage:</p><p>POST /search/warehouse/statistics/INDEX/FIELD</p><p>POST /search/warehouse/statistics/ALL/FIELD</p><p>{ Any valid elasticsearch query DSL in the body }</p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html\">Elasticsearch query DSL</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-request-body.html\">Elastic simple query</a></p><p><a href=\"https://www.elastic.co/guide/en/elasticsearch/reference/6.2/search-aggregations.html\">Elastic aggregations</a></p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.data_warehouse_statistics_with_http_info(body, field, index, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ElasticSearchJsonV300 body: ElasticSearchJsonV300 object that needs to be added. (required)
        :param str field: the elastic search field (required)
        :param str index: the elastic search index (required)
        :return: EmptyClassJson
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'field', 'index']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method data_warehouse_statistics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `data_warehouse_statistics`")  # noqa: E501
        # verify the required parameter 'field' is set
        if self.api_client.client_side_validation and ('field' not in params or
                                                       params['field'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `field` when calling `data_warehouse_statistics`")  # noqa: E501
        # verify the required parameter 'index' is set
        if self.api_client.client_side_validation and ('index' not in params or
                                                       params['index'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `index` when calling `data_warehouse_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'field' in params:
            path_params['FIELD'] = params['field']  # noqa: E501
        if 'index' in params:
            path_params['INDEX'] = params['index']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/search/warehouse/statistics/{INDEX}/{FIELD}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EmptyClassJson',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
