# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class DynamicEntityManageApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_bank_level_dynamic_entity(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Entity  # noqa: E501

        <p>Create a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;branchId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;atmId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;productCode=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;cardId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;transactionId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;counterpartyId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_entity(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_bank_level_dynamic_entity_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_bank_level_dynamic_entity_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_bank_level_dynamic_entity_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create Bank Level Dynamic Entity  # noqa: E501

        <p>Create a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;branchId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;atmId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;productCode=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;cardId=29075a18-2984-4e93-8c39-e1fcefc924b5&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;transactionId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=ef34a1cb-8ad8-407a-ab8b-9d2c000e5a7a&amp;accountId=29075a18-2984-4e93-8c39-e1fcefc924b5&amp;counterpartyId=c376d996-0651-4e0f-ba1d-1d4b510857fc&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_bank_level_dynamic_entity_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_system_dynamic_entity(self, body, **kwargs):  # noqa: E501
        """Create System Level Dynamic Entity  # noqa: E501

        <p>Create a system level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />See the following list of currently available reference types and examples of how to construct key values correctly. Note: As more Dynamic Entities are created on this instance, this list will grow:</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;branchId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;atmId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;productCode=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;cardId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;transactionId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;counterpartyId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_dynamic_entity(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_system_dynamic_entity_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_system_dynamic_entity_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_system_dynamic_entity_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create System Level Dynamic Entity  # noqa: E501

        <p>Create a system level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Create a DynamicEntity. If creation is successful, the corresponding POST, GET, PUT and DELETE (Create, Read, Update, Delete or CRUD for short) endpoints will be generated automatically</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>The DATE_WITH_DAY format is: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />See the following list of currently available reference types and examples of how to construct key values correctly. Note: As more Dynamic Entities are created on this instance, this list will grow:</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;5a8be464-dc73-4664-a1de-b2cf4c1851d3&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;branchId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;atmId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;productCode=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;cardId=d4370109-a8bb-4d28-b737-a742d5dd8246&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;transactionId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=5a8be464-dc73-4664-a1de-b2cf4c1851d3&amp;accountId=d4370109-a8bb-4d28-b737-a742d5dd8246&amp;counterpartyId=fbb418d2-038a-4ad9-823a-7367dd8cbbcb&quot;}</code></pre><p>Note: if you set <code>hasPersonalEntity</code> = false, then OBP will not generate the CRUD my FooBar endpoints.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_system_dynamic_entity_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_bank_level_dynamic_entity(self, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Dynamic Entity  # noqa: E501

        <p>Delete a Bank Level DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_entity(dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_bank_level_dynamic_entity_with_http_info(self, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Delete Bank Level Dynamic Entity  # noqa: E501

        <p>Delete a Bank Level DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_bank_level_dynamic_entity_with_http_info(dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_my_dynamic_entity(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete My Dynamic Entity  # noqa: E501

        <p>Delete my DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_entity(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def delete_my_dynamic_entity_with_http_info(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete My Dynamic Entity  # noqa: E501

        <p>Delete my DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_my_dynamic_entity_with_http_info(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_my_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_my_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_system_dynamic_entity(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete System Level Dynamic Entity  # noqa: E501

        <p>Delete a DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_dynamic_entity(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def delete_system_dynamic_entity_with_http_info(self, dynamic_entity_id, **kwargs):  # noqa: E501
        """Delete System Level Dynamic Entity  # noqa: E501

        <p>Delete a DynamicEntity specified by DYNAMIC_ENTITY_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_system_dynamic_entity_with_http_info(dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `delete_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities/{DYNAMIC_ENTITY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_bank_level_dynamic_entities(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Entities  # noqa: E501

        <p>Get all the bank level Dynamic Entities for one bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_entities(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_bank_level_dynamic_entities_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_bank_level_dynamic_entities_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_bank_level_dynamic_entities_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Bank Level Dynamic Entities  # noqa: E501

        <p>Get all the bank level Dynamic Entities for one bank.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_bank_level_dynamic_entities_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_bank_level_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_bank_level_dynamic_entities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_my_dynamic_entities(self, **kwargs):  # noqa: E501
        """Get My Dynamic Entities  # noqa: E501

        <p>Get all my Dynamic Entities.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_my_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_dynamic_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Get My Dynamic Entities  # noqa: E501

        <p>Get all my Dynamic Entities.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_dynamic_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_system_dynamic_entities(self, **kwargs):  # noqa: E501
        """Get System Dynamic Entities  # noqa: E501

        <p>Get all System Dynamic Entities</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_dynamic_entities(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_system_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_system_dynamic_entities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_system_dynamic_entities_with_http_info(self, **kwargs):  # noqa: E501
        """Get System Dynamic Entities  # noqa: E501

        <p>Get all System Dynamic Entities</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_system_dynamic_entities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: InlineResponse2004
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_system_dynamic_entities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2004',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_bank_level_dynamic_entity(self, body, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Dynamic Entity  # noqa: E501

        <p>Update a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;branchId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;atmId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;productCode=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;cardId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;transactionId=161fafb6-f008-418e-9d1b-aba419942289&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;counterpartyId=161fafb6-f008-418e-9d1b-aba419942289&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_entity(body, dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, **kwargs)  # noqa: E501
            return data

    def update_bank_level_dynamic_entity_with_http_info(self, body, dynamic_entity_id, bank_id, **kwargs):  # noqa: E501
        """Update Bank Level Dynamic Entity  # noqa: E501

        <p>Update a Bank Level DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;a68c494d-ed3c-415b-b4c5-f1a3f1822e46&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;branchId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;atmId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;productCode=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;cardId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;transactionId=161fafb6-f008-418e-9d1b-aba419942289&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=a68c494d-ed3c-415b-b4c5-f1a3f1822e46&amp;accountId=2f6c6ccd-cf77-488a-8889-6eb9cf077d94&amp;counterpartyId=161fafb6-f008-418e-9d1b-aba419942289&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_bank_level_dynamic_entity_with_http_info(body, dynamic_entity_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :param str bank_id: The bank id (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_bank_level_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_bank_level_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_bank_level_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/banks/{BANK_ID}/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_my_dynamic_entity(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update My Dynamic Entity  # noqa: E501

        <p>Update my DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one of my DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>Current support filed types as follow:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;branchId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;atmId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;productCode=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;cardId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;transactionId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;counterpartyId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_dynamic_entity(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def update_my_dynamic_entity_with_http_info(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update My Dynamic Entity  # noqa: E501

        <p>Update my DynamicEntity.</p><p>Authentication is Mandatory</p><p>Update one of my DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>Current support filed types as follow:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;branchId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;atmId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;productCode=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;cardId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;transactionId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=78c3c80c-e178-4b8d-9c0c-ea2caa380a2b&amp;accountId=2a6ebfa5-528c-419e-83ce-845bb8a9f53b&amp;counterpartyId=7d22e81c-5a7c-40a3-9dea-9fb19d8cb2e9&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_my_dynamic_entity_with_http_info(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_my_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_my_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_my_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/my/dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_system_dynamic_entity(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update System Level Dynamic Entity  # noqa: E501

        <p>Update a System Level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;branchId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;atmId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;productCode=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;cardId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;transactionId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;counterpartyId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_dynamic_entity(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, **kwargs)  # noqa: E501
            return data

    def update_system_dynamic_entity_with_http_info(self, body, dynamic_entity_id, **kwargs):  # noqa: E501
        """Update System Level Dynamic Entity  # noqa: E501

        <p>Update a System Level Dynamic Entity.</p><p>Authentication is Mandatory</p><p>Update one DynamicEntity, after update finished, the corresponding CRUD endpoints will be changed.</p><p>The following field types are as supported:<br />[number, integer, boolean, string, DATE_WITH_DAY, reference]</p><p>DATE_WITH_DAY format: yyyy-MM-dd</p><p>Reference types are like foreign keys and composite foreign keys are supported. The value you need to supply as the (composite) foreign key is a UUID (or several UUIDs in the case of a composite key) that match value in another Entity..<br />The following list shows all the possible reference types in the system with corresponding examples values so you can see how to construct each reference type value.</p><pre><code>&quot;someField0&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField1&quot;: {    &quot;type&quot;: &quot;reference:customers_favorite_icecream&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField2&quot;: {    &quot;type&quot;: &quot;reference:Bank&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField3&quot;: {    &quot;type&quot;: &quot;reference:Consumer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField4&quot;: {    &quot;type&quot;: &quot;reference:Customer&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField5&quot;: {    &quot;type&quot;: &quot;reference:MethodRouting&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField6&quot;: {    &quot;type&quot;: &quot;reference:DynamicEntity&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField7&quot;: {    &quot;type&quot;: &quot;reference:TransactionRequest&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField8&quot;: {    &quot;type&quot;: &quot;reference:ProductAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField9&quot;: {    &quot;type&quot;: &quot;reference:AccountAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField10&quot;: {    &quot;type&quot;: &quot;reference:TransactionAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField11&quot;: {    &quot;type&quot;: &quot;reference:CustomerAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField12&quot;: {    &quot;type&quot;: &quot;reference:AccountApplication&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField13&quot;: {    &quot;type&quot;: &quot;reference:CardAttribute&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField14&quot;: {    &quot;type&quot;: &quot;reference:Counterparty&quot;,    &quot;example&quot;: &quot;8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&quot;}&quot;someField15&quot;: {    &quot;type&quot;: &quot;reference:Branch:bankId&amp;branchId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;branchId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField16&quot;: {    &quot;type&quot;: &quot;reference:Atm:bankId&amp;atmId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;atmId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField17&quot;: {    &quot;type&quot;: &quot;reference:BankAccount:bankId&amp;accountId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField18&quot;: {    &quot;type&quot;: &quot;reference:Product:bankId&amp;productCode&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;productCode=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField19&quot;: {    &quot;type&quot;: &quot;reference:PhysicalCard:bankId&amp;cardId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;cardId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&quot;}&quot;someField20&quot;: {    &quot;type&quot;: &quot;reference:Transaction:bankId&amp;accountId&amp;transactionId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;transactionId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}&quot;someField21&quot;: {    &quot;type&quot;: &quot;reference:Counterparty:bankId&amp;accountId&amp;counterpartyId&quot;,    &quot;example&quot;: &quot;bankId=8ee0cbcf-83fe-4b68-82b9-f1233929f5ee&amp;accountId=bc8e6f5c-5333-4f6b-bd10-b3aa7a2a0787&amp;counterpartyId=770622f9-7c29-4a8a-a944-a99fc627bd95&quot;}</code></pre>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_system_dynamic_entity_with_http_info(body, dynamic_entity_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DynamicEntityFooBar body: DynamicEntityFooBar object that needs to be added. (required)
        :param str dynamic_entity_id: the dynamic entity id  (required)
        :return: DynamicEntityFooBar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dynamic_entity_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_system_dynamic_entity" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_system_dynamic_entity`")  # noqa: E501
        # verify the required parameter 'dynamic_entity_id' is set
        if self.api_client.client_side_validation and ('dynamic_entity_id' not in params or
                                                       params['dynamic_entity_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dynamic_entity_id` when calling `update_system_dynamic_entity`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dynamic_entity_id' in params:
            path_params['DYNAMIC_ENTITY_ID'] = params['dynamic_entity_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/system-dynamic-entities/{DYNAMIC_ENTITY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DynamicEntityFooBar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
