# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class KYCApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_kyc_check(self, body, kyc_check_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Check  # noqa: E501

        <p>Add a KYC check for the customer specified by CUSTOMER_ID. KYC Checks store details of checks on a customer made by the KYC team, their comments and a satisfied status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_check(body, kyc_check_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycCheckJSON body: PostKycCheckJSON object that needs to be added. (required)
        :param str kyc_check_id: The kyc check id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycCheckJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_check_with_http_info(self, body, kyc_check_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Check  # noqa: E501

        <p>Add a KYC check for the customer specified by CUSTOMER_ID. KYC Checks store details of checks on a customer made by the KYC team, their comments and a satisfied status</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_check_with_http_info(body, kyc_check_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycCheckJSON body: PostKycCheckJSON object that needs to be added. (required)
        :param str kyc_check_id: The kyc check id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycCheckJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_check_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_check" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'kyc_check_id' is set
        if self.api_client.client_side_validation and ('kyc_check_id' not in params or
                                                       params['kyc_check_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_check_id` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_check`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_check`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_check_id' in params:
            path_params['KYC_CHECK_ID'] = params['kyc_check_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_check/{KYC_CHECK_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycCheckJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_document(self, body, kyc_document_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Document  # noqa: E501

        <p>Add a KYC document for the customer specified by CUSTOMER_ID. KYC Documents contain the document type (e.g. passport), place of issue, expiry etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_document(body, kyc_document_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycDocumentJSON body: PostKycDocumentJSON object that needs to be added. (required)
        :param str kyc_document_id: The kyc document id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycDocumentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_document_with_http_info(self, body, kyc_document_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Document  # noqa: E501

        <p>Add a KYC document for the customer specified by CUSTOMER_ID. KYC Documents contain the document type (e.g. passport), place of issue, expiry etc.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_document_with_http_info(body, kyc_document_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycDocumentJSON body: PostKycDocumentJSON object that needs to be added. (required)
        :param str kyc_document_id: The kyc document id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycDocumentJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_document_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_document" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'kyc_document_id' is set
        if self.api_client.client_side_validation and ('kyc_document_id' not in params or
                                                       params['kyc_document_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_document_id` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_document`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_document`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_document_id' in params:
            path_params['KYC_DOCUMENT_ID'] = params['kyc_document_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_documents/{KYC_DOCUMENT_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycDocumentJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_media(self, body, kyc_media_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Media  # noqa: E501

        <p>Add some KYC media for the customer specified by CUSTOMER_ID. KYC Media resources relate to KYC Documents and KYC Checks and contain media urls for scans of passports, utility bills etc</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_media(body, kyc_media_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycMediaJSON body: PostKycMediaJSON object that needs to be added. (required)
        :param str kyc_media_id: The kyc media id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycMediaJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_media_with_http_info(self, body, kyc_media_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Media  # noqa: E501

        <p>Add some KYC media for the customer specified by CUSTOMER_ID. KYC Media resources relate to KYC Documents and KYC Checks and contain media urls for scans of passports, utility bills etc</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_media_with_http_info(body, kyc_media_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycMediaJSON body: PostKycMediaJSON object that needs to be added. (required)
        :param str kyc_media_id: The kyc media id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycMediaJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'kyc_media_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_media" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'kyc_media_id' is set
        if self.api_client.client_side_validation and ('kyc_media_id' not in params or
                                                       params['kyc_media_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `kyc_media_id` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_media`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'kyc_media_id' in params:
            path_params['KYC_MEDIA_ID'] = params['kyc_media_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_media/{KYC_MEDIA_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycMediaJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_kyc_status(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Status  # noqa: E501

        <p>Add a kyc_status for the customer specified by CUSTOMER_ID. KYC Status is a timeline of the KYC status of the customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_status(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycStatusJSON body: PostKycStatusJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycStatusJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_kyc_status_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_kyc_status_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def add_kyc_status_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Add KYC Status  # noqa: E501

        <p>Add a kyc_status for the customer specified by CUSTOMER_ID. KYC Status is a timeline of the KYC status of the customer</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_kyc_status_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostKycStatusJSON body: PostKycStatusJSON object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: KycStatusJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_kyc_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_kyc_status`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `add_kyc_status`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `add_kyc_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/kyc_statuses', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycStatusJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tax_residence(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Tax Residence  # noqa: E501

        <p>Create a Tax Residence for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_residence(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTaxResidenceJsonV310 body: PostTaxResidenceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tax_residence_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tax_residence_with_http_info(body, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def create_tax_residence_with_http_info(self, body, customer_id, bank_id, **kwargs):  # noqa: E501
        """Create Tax Residence  # noqa: E501

        <p>Create a Tax Residence for a Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tax_residence_with_http_info(body, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostTaxResidenceJsonV310 body: PostTaxResidenceJsonV310 object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_tax_residence`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `create_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax-residence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxResidenceV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_user_invitation(self, body, bank_id, **kwargs):  # noqa: E501
        """Create User Invitation  # noqa: E501

        <p>Create User Invitation.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_invitation(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostUserInvitationJsonV400 body: PostUserInvitationJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserInvitationJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_user_invitation_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_user_invitation_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_user_invitation_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create User Invitation  # noqa: E501

        <p>Create User Invitation.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_user_invitation_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostUserInvitationJsonV400 body: PostUserInvitationJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserInvitationJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_invitation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_user_invitation`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_user_invitation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user-invitation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserInvitationJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_customer_address(self, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Address  # noqa: E501

        <p>Delete an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_address(customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_customer_address_with_http_info(self, customer_address_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Customer Address  # noqa: E501

        <p>Delete an Address of the Customer specified by CUSTOMER_ADDRESS_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_customer_address_with_http_info(customer_address_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_address_id: the customer address id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_address_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_customer_address" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_address_id' is set
        if self.api_client.client_side_validation and ('customer_address_id' not in params or
                                                       params['customer_address_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_address_id` when calling `delete_customer_address`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_customer_address`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_customer_address`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_address_id' in params:
            path_params['CUSTOMER_ADDRESS_ID'] = params['customer_address_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/addresses/{CUSTOMER_ADDRESS_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tax_residence(self, tax_residence_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Tax Residence  # noqa: E501

        <p>Delete a Tax Residence of the Customer specified by TAX_RESIDENCE_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_residence(tax_residence_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tax_residence_id: the tax residence id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_tax_residence_with_http_info(self, tax_residence_id, customer_id, bank_id, **kwargs):  # noqa: E501
        """Delete Tax Residence  # noqa: E501

        <p>Delete a Tax Residence of the Customer specified by TAX_RESIDENCE_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tax_residence_with_http_info(tax_residence_id, customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tax_residence_id: the tax residence id (required)
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tax_residence_id', 'customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tax_residence_id' is set
        if self.api_client.client_side_validation and ('tax_residence_id' not in params or
                                                       params['tax_residence_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tax_residence_id` when calling `delete_tax_residence`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `delete_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tax_residence_id' in params:
            path_params['TAX_RESIDENCE_ID'] = params['tax_residence_id']  # noqa: E501
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax_residencies/{TAX_RESIDENCE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_addresses(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Addresses  # noqa: E501

        <p>Get the Addresses of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_addresses(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_addresses_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_addresses_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_addresses_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Customer Addresses  # noqa: E501

        <p>Get the Addresses of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_addresses_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: CustomerAddressesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_addresses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_customer_addresses`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_addresses`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/addresses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerAddressesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_by_customer_number(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_NUMBER  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_NUMBER.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_number(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerNumberJsonV310 body: PostCustomerNumberJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_by_customer_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_by_customer_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_by_customer_number_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer by CUSTOMER_NUMBER  # noqa: E501

        <p>Gets the Customer specified by CUSTOMER_NUMBER.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_by_customer_number_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerNumberJsonV310 body: PostCustomerNumberJsonV310 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerWithAttributesJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_by_customer_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_by_customer_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_by_customer_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerWithAttributesJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_overview(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview  # noqa: E501

        <p>Gets the Customer Overview specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_overview_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_overview_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_overview_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview  # noqa: E501

        <p>Gets the Customer Overview specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_overview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_overview`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_overview`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number-query/overview', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerOverviewJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customer_overview_flat(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview Flat  # noqa: E501

        <p>Gets the Customer Overview Flat specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_flat(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewFlatJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customer_overview_flat_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customer_overview_flat_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customer_overview_flat_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customer Overview Flat  # noqa: E501

        <p>Gets the Customer Overview Flat specified by customer_number and bank_code.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customer_overview_flat_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerOverviewJsonV500 body: PostCustomerOverviewJsonV500 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerOverviewFlatJsonV500
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customer_overview_flat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customer_overview_flat`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customer_overview_flat`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/customer-number-query/overview-flat', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerOverviewFlatJsonV500',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_customers_by_customer_phone_number(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customers by MOBILE_PHONE_NUMBER  # noqa: E501

        <p>Gets the Customers specified by MOBILE_PHONE_NUMBER.</p><p>There are two wildcards often used in conjunction with the LIKE operator:<br />% - The percent sign represents zero, one, or multiple characters<br />_ - The underscore represents a single character<br />For example {&quot;customer_phone_number&quot;:&quot;%381%&quot;} lists all numbers which contain 381 sequence</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_customer_phone_number(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerPhoneNumberJsonV400 body: PostCustomerPhoneNumberJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_customers_by_customer_phone_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_customers_by_customer_phone_number_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_customers_by_customer_phone_number_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get Customers by MOBILE_PHONE_NUMBER  # noqa: E501

        <p>Gets the Customers specified by MOBILE_PHONE_NUMBER.</p><p>There are two wildcards often used in conjunction with the LIKE operator:<br />% - The percent sign represents zero, one, or multiple characters<br />_ - The underscore represents a single character<br />For example {&quot;customer_phone_number&quot;:&quot;%381%&quot;} lists all numbers which contain 381 sequence</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_customers_by_customer_phone_number_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostCustomerPhoneNumberJsonV400 body: PostCustomerPhoneNumberJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: CustomerJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_customers_by_customer_phone_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_customers_by_customer_phone_number`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_customers_by_customer_phone_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/search/customers/mobile-phone-number', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomerJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_checks(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Checks  # noqa: E501

        <p>Get KYC checks for the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_checks(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycChecksJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_checks_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_checks_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_checks_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Checks  # noqa: E501

        <p>Get KYC checks for the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_checks_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycChecksJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_checks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_checks`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_checks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_checks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycChecksJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_documents(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Documents  # noqa: E501

        <p>Get KYC (know your customer) documents for a customer specified by CUSTOMER_ID<br />Get a list of documents that affirm the identity of the customer<br />Passport, driving licence etc.<br />Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_documents(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycDocumentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_documents_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_documents_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_documents_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC Documents  # noqa: E501

        <p>Get KYC (know your customer) documents for a customer specified by CUSTOMER_ID<br />Get a list of documents that affirm the identity of the customer<br />Passport, driving licence etc.<br />Authentication is Optional</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_documents_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycDocumentsJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_documents" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_documents`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_documents`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_documents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycDocumentsJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_media(self, body, customer_id, **kwargs):  # noqa: E501
        """Get KYC Media for a customer  # noqa: E501

        <p>Get KYC media (scans, pictures, videos) that affirms the identity of the customer.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_media(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_media_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_media_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_media_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get KYC Media for a customer  # noqa: E501

        <p>Get KYC media (scans, pictures, videos) that affirms the identity of the customer.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_media_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycMediasJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_media" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_media`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_media`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_media', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycMediasJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_kyc_statuses(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC statuses  # noqa: E501

        <p>Get the KYC statuses for a customer specified by CUSTOMER_ID over time.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_statuses(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycStatusesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_kyc_statuses_with_http_info(body, customer_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_kyc_statuses_with_http_info(body, customer_id, **kwargs)  # noqa: E501
            return data

    def get_kyc_statuses_with_http_info(self, body, customer_id, **kwargs):  # noqa: E501
        """Get Customer KYC statuses  # noqa: E501

        <p>Get the KYC statuses for a customer specified by CUSTOMER_ID over time.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_kyc_statuses_with_http_info(body, customer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EmptyClassJson body: EmptyClassJson object that needs to be added. (required)
        :param str customer_id: The customer id (required)
        :return: KycStatusesJSON
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_kyc_statuses" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_kyc_statuses`")  # noqa: E501
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_kyc_statuses`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/customers/{CUSTOMER_ID}/kyc_statuses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KycStatusesJSON',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tax_residence(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Tax Residences of Customer  # noqa: E501

        <p>Get the Tax Residences of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_residence(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tax_residence_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tax_residence_with_http_info(customer_id, bank_id, **kwargs)  # noqa: E501
            return data

    def get_tax_residence_with_http_info(self, customer_id, bank_id, **kwargs):  # noqa: E501
        """Get Tax Residences of Customer  # noqa: E501

        <p>Get the Tax Residences of the Customer specified by CUSTOMER_ID.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tax_residence_with_http_info(customer_id, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str customer_id: The customer id (required)
        :param str bank_id: The bank id (required)
        :return: TaxResidenceJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_id', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tax_residence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'customer_id' is set
        if self.api_client.client_side_validation and ('customer_id' not in params or
                                                       params['customer_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `customer_id` when calling `get_tax_residence`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_tax_residence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'customer_id' in params:
            path_params['CUSTOMER_ID'] = params['customer_id']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/customers/{CUSTOMER_ID}/tax-residences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaxResidenceJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_invitation_anonymous(self, body, bank_id, **kwargs):  # noqa: E501
        """Get User Invitation Information  # noqa: E501

        <p>Create User Invitation Information.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_invitation_anonymous(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostUserInvitationAnonymousJsonV400 body: PostUserInvitationAnonymousJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserInvitationJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_invitation_anonymous_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_invitation_anonymous_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def get_user_invitation_anonymous_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Get User Invitation Information  # noqa: E501

        <p>Create User Invitation Information.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_invitation_anonymous_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PostUserInvitationAnonymousJsonV400 body: PostUserInvitationAnonymousJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: UserInvitationJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_invitation_anonymous" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `get_user_invitation_anonymous`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_user_invitation_anonymous`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/user-invitations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UserInvitationJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
