# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ProductApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_or_update_product_attribute_definition(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Product Attribute Definition  # noqa: E501

        <p>Create or Update Product Attribute Definition</p><p>The category field must be Product</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_product_attribute_definition(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_or_update_product_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_or_update_product_attribute_definition_with_http_info(body, bank_id, **kwargs)  # noqa: E501
            return data

    def create_or_update_product_attribute_definition_with_http_info(self, body, bank_id, **kwargs):  # noqa: E501
        """Create or Update Product Attribute Definition  # noqa: E501

        <p>Create or Update Product Attribute Definition</p><p>The category field must be Product</p><p>The type field must be one of; DOUBLE, STRING, INTEGER and DATE_WITH_DAY</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_or_update_product_attribute_definition_with_http_info(body, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AttributeDefinitionJsonV400 body: AttributeDefinitionJsonV400 object that needs to be added. (required)
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_or_update_product_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_or_update_product_attribute_definition`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_or_update_product_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/product', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product  # noqa: E501

        <p>Create or Update Product for the Bank.</p><p>Typical Super Family values / Asset classes are:</p><p>Debt<br />Equity<br />FX<br />Commodity<br />Derivative</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductJsonV500 body: PutProductJsonV500 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def create_product_with_http_info(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product  # noqa: E501

        <p>Create or Update Product for the Bank.</p><p>Typical Super Family values / Asset classes are:</p><p>Debt<br />Equity<br />FX<br />Commodity<br />Derivative</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_with_http_info(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductJsonV500 body: PutProductJsonV500 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_product`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `create_product`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product_attribute(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Attribute  # noqa: E501

        <p>Create Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Typical product attributes might be:</p><p>ISIN (for International bonds)<br />VKN (for German bonds)<br />REDCODE (markit short code for credit derivative)<br />LOAN_ID (e.g. used for Anacredit reporting)</p><p>ISSUE_DATE (When the bond was issued in the market)<br />MATURITY_DATE (End of life time of a product)<br />TRADABLE</p><p>See <a href=\"http://www.fpml.org/\">FPML</a> for more examples.</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_attribute(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductAttributeJsonV400 body: ProductAttributeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_attribute_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_attribute_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def create_product_attribute_with_http_info(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Attribute  # noqa: E501

        <p>Create Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Typical product attributes might be:</p><p>ISIN (for International bonds)<br />VKN (for German bonds)<br />REDCODE (markit short code for credit derivative)<br />LOAN_ID (e.g. used for Anacredit reporting)</p><p>ISSUE_DATE (When the bond was issued in the market)<br />MATURITY_DATE (End of life time of a product)<br />TRADABLE</p><p>See <a href=\"http://www.fpml.org/\">FPML</a> for more examples.</p><p>The type field must be one of &quot;STRING&quot;, &quot;INTEGER&quot;, &quot;DOUBLE&quot; or DATE_WITH_DAY&quot;</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_attribute_with_http_info(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductAttributeJsonV400 body: ProductAttributeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_product_attribute`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `create_product_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_product_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/attribute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAttributeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product_collection(self, body, collection_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Collection  # noqa: E501

        <p>Create or Update a Product Collection at the Bank.</p><p>Use Product Collections to create Product &quot;Baskets&quot;, &quot;Portfolios&quot;, &quot;Indices&quot;, &quot;Collections&quot;, &quot;Underlyings-lists&quot;, &quot;Buckets&quot; etc. etc.</p><p>There is a many to many relationship between Products and Product Collections:</p><ul><li><p>A Product can exist in many Collections</p></li><li><p>A Collection can contain many Products.</p></li></ul><p>A collection has collection code, one parent Product and one or more child Products.</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_collection(body, collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductCollectionsV310 body: PutProductCollectionsV310 object that needs to be added. (required)
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_collection_with_http_info(body, collection_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_collection_with_http_info(body, collection_code, bank_id, **kwargs)  # noqa: E501
            return data

    def create_product_collection_with_http_info(self, body, collection_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Collection  # noqa: E501

        <p>Create or Update a Product Collection at the Bank.</p><p>Use Product Collections to create Product &quot;Baskets&quot;, &quot;Portfolios&quot;, &quot;Indices&quot;, &quot;Collections&quot;, &quot;Underlyings-lists&quot;, &quot;Buckets&quot; etc. etc.</p><p>There is a many to many relationship between Products and Product Collections:</p><ul><li><p>A Product can exist in many Collections</p></li><li><p>A Collection can contain many Products.</p></li></ul><p>A collection has collection code, one parent Product and one or more child Products.</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_collection_with_http_info(body, collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductCollectionsV310 body: PutProductCollectionsV310 object that needs to be added. (required)
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_product_collection`")  # noqa: E501
        # verify the required parameter 'collection_code' is set
        if self.api_client.client_side_validation and ('collection_code' not in params or
                                                       params['collection_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_code` when calling `create_product_collection`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_product_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_code' in params:
            path_params['COLLECTION_CODE'] = params['collection_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/product-collections/{COLLECTION_CODE}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductCollectionsJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_product_fee(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Fee  # noqa: E501

        <p>Create Product Fee</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_fee(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductFeeJsonV400 body: ProductFeeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_fee_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_fee_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def create_product_fee_with_http_info(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Fee  # noqa: E501

        <p>Create Product Fee</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_fee_with_http_info(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductFeeJsonV400 body: ProductFeeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_product_fee`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `create_product_fee`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_product_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/fee', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductFeeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_attribute(self, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Attribute  # noqa: E501

        <p>Delete Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Delete a Product Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_attribute(product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_product_attribute_with_http_info(self, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Attribute  # noqa: E501

        <p>Delete Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Delete a Product Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_attribute_id', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_attribute_id' is set
        if self.api_client.client_side_validation and ('product_attribute_id' not in params or
                                                       params['product_attribute_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_attribute_id` when calling `delete_product_attribute`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `delete_product_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_product_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_attribute_id' in params:
            path_params['PRODUCT_ATTRIBUTE_ID'] = params['product_attribute_id']  # noqa: E501
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/attributes/{PRODUCT_ATTRIBUTE_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Delete Product Attribute Definition  # noqa: E501

        <p>Delete Product Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def delete_product_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Delete Product Attribute Definition  # noqa: E501

        <p>Delete Product Attribute Definition by ATTRIBUTE_DEFINITION_ID</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_product_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/ATTRIBUTE_DEFINITION_ID/product', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_cascade(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Cascade  # noqa: E501

        <p>Delete a Product Cascade specified by PRODUCT_CODE.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_cascade(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_cascade_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_cascade_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_product_cascade_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Cascade  # noqa: E501

        <p>Delete a Product Cascade specified by PRODUCT_CODE.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_cascade_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_cascade" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `delete_product_cascade`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_product_cascade`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/management/cascading/banks/{BANK_ID}/products/{PRODUCT_CODE}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_product_fee(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Fee  # noqa: E501

        <p>Delete Product Fee</p><p>Delete one product fee by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_fee(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_product_fee_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_product_fee_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def delete_product_fee_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Delete Product Fee  # noqa: E501

        <p>Delete Product Fee</p><p>Delete one product fee by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_product_fee_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_product_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `delete_product_fee`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `delete_product_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/fees/PRODUCT_FEE_ID', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Bank Product  # noqa: E501

        <p>Returns information about a financial Product offered by the bank specified by BANK_ID and PRODUCT_CODE including:</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>More info URL</li><li>Description</li><li>Terms and Conditions</li><li>Description</li><li>Meta</li><li>Attributes</li><li>Fees</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Bank Product  # noqa: E501

        <p>Returns information about a financial Product offered by the bank specified by BANK_ID and PRODUCT_CODE including:</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>More info URL</li><li>Description</li><li>Terms and Conditions</li><li>Description</li><li>Meta</li><li>Attributes</li><li>Fees</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `get_product`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_attribute(self, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Attribute  # noqa: E501

        <p>Get Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Get one product attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_attribute(product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_attribute_with_http_info(self, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Attribute  # noqa: E501

        <p>Get Product Attribute</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Get one product attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_attribute_with_http_info(product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_attribute_id', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_attribute_id' is set
        if self.api_client.client_side_validation and ('product_attribute_id' not in params or
                                                       params['product_attribute_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_attribute_id` when calling `get_product_attribute`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `get_product_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_attribute_id' in params:
            path_params['PRODUCT_ATTRIBUTE_ID'] = params['product_attribute_id']  # noqa: E501
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/attributes/{PRODUCT_ATTRIBUTE_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAttributeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_attribute_definition(self, bank_id, **kwargs):  # noqa: E501
        """Get Product Attribute Definition  # noqa: E501

        <p>Get Product Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_attribute_definition(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_attribute_definition_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_attribute_definition_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Product Attribute Definition  # noqa: E501

        <p>Get Product Attribute Definition</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_attribute_definition_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: AttributeDefinitionsResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_attribute_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_attribute_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/attribute-definitions/product', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AttributeDefinitionsResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_collection(self, collection_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Collection  # noqa: E501

        <p>Returns information about the financial Product Collection specified by BANK_ID and COLLECTION_CODE:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_collection(collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionJsonTreeV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_collection_with_http_info(collection_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_collection_with_http_info(collection_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_collection_with_http_info(self, collection_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Collection  # noqa: E501

        <p>Returns information about the financial Product Collection specified by BANK_ID and COLLECTION_CODE:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_collection_with_http_info(collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionJsonTreeV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_code' is set
        if self.api_client.client_side_validation and ('collection_code' not in params or
                                                       params['collection_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_code` when calling `get_product_collection`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_code' in params:
            path_params['COLLECTION_CODE'] = params['collection_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/product-collections/{COLLECTION_CODE}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductCollectionJsonTreeV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_fee(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Fee  # noqa: E501

        <p>Get Product Fee</p><p>Get one product fee by its id.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_fee(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_fee_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_fee_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_fee_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Fee  # noqa: E501

        <p>Get Product Fee</p><p>Get one product fee by its id.</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_fee_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `get_product_fee`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/fees/PRODUCT_FEE_ID', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductFeeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_fees(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Fees  # noqa: E501

        <p>Get Product Fees</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_fees(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_fees_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_fees_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_fees_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Fees  # noqa: E501

        <p>Get Product Fees</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_fees_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeesResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_fees" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `get_product_fees`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_fees`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/fees', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductFeesResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_tree(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Tree  # noqa: E501

        <p>Returns information about a particular financial product specified by BANK_ID and PRODUCT_CODE<br />and it's parent product(s) recursively as specified by parent_product_code.</p><p>Each product includes the following information.</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>Category</li><li>Family</li><li>Super Family</li><li>More info URL</li><li>Description</li><li>Terms and Conditions</li><li>License: The licence under which this product data is released. Licence can be an Open Data licence such as Open Data Commons Public Domain Dedication and License (PDDL) or Copyright etc.</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_tree(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductTreeJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_tree_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_tree_with_http_info(product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_tree_with_http_info(self, product_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Tree  # noqa: E501

        <p>Returns information about a particular financial product specified by BANK_ID and PRODUCT_CODE<br />and it's parent product(s) recursively as specified by parent_product_code.</p><p>Each product includes the following information.</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>Category</li><li>Family</li><li>Super Family</li><li>More info URL</li><li>Description</li><li>Terms and Conditions</li><li>License: The licence under which this product data is released. Licence can be an Open Data licence such as Open Data Commons Public Domain Dedication and License (PDDL) or Copyright etc.</li></ul><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_tree_with_http_info(product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductTreeJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_tree" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `get_product_tree`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_tree`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/product-tree/{PRODUCT_CODE}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductTreeJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_products(self, bank_id, **kwargs):  # noqa: E501
        """Get Products  # noqa: E501

        <p>Returns information about the financial products offered by a bank specified by BANK_ID including:</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>More info URL</li><li>Terms And Conditions URL</li><li>Description</li><li>Terms and Conditions</li><li>License the data under this endpoint is released under</li></ul><p>Can filter with attributes name and values.<br />URL params example: /banks/some-bank-id/products?manager=John&amp;count=8</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: ProductsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_products_with_http_info(bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_products_with_http_info(bank_id, **kwargs)  # noqa: E501
            return data

    def get_products_with_http_info(self, bank_id, **kwargs):  # noqa: E501
        """Get Products  # noqa: E501

        <p>Returns information about the financial products offered by a bank specified by BANK_ID including:</p><ul><li>Name</li><li>Code</li><li>Parent Product Code</li><li>More info URL</li><li>Terms And Conditions URL</li><li>Description</li><li>Terms and Conditions</li><li>License the data under this endpoint is released under</li></ul><p>Can filter with attributes name and values.<br />URL params example: /banks/some-bank-id/products?manager=John&amp;count=8</p><p>Authentication is Optional</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_products_with_http_info(bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str bank_id: The bank id (required)
        :return: ProductsJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_products" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_products`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductsJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_product_attribute(self, body, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Update Product Attribute  # noqa: E501

        <p>Update Product Attribute.</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Update one Product Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_attribute(body, product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductAttributeJsonV400 body: ProductAttributeJsonV400 object that needs to be added. (required)
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_product_attribute_with_http_info(body, product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_product_attribute_with_http_info(body, product_attribute_id, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def update_product_attribute_with_http_info(self, body, product_attribute_id, product_code, bank_id, **kwargs):  # noqa: E501
        """Update Product Attribute  # noqa: E501

        <p>Update Product Attribute.</p><p>Product Attributes are used to describe a financial Product with a list of typed key value pairs.</p><p>Each Product Attribute is linked to its Product by PRODUCT_CODE</p><p>Update one Product Attribute by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_attribute_with_http_info(body, product_attribute_id, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductAttributeJsonV400 body: ProductAttributeJsonV400 object that needs to be added. (required)
        :param str product_attribute_id: the product attribute id (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductAttributeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_attribute_id', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_product_attribute" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_product_attribute`")  # noqa: E501
        # verify the required parameter 'product_attribute_id' is set
        if self.api_client.client_side_validation and ('product_attribute_id' not in params or
                                                       params['product_attribute_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_attribute_id` when calling `update_product_attribute`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `update_product_attribute`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_product_attribute`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_attribute_id' in params:
            path_params['PRODUCT_ATTRIBUTE_ID'] = params['product_attribute_id']  # noqa: E501
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/attributes/{PRODUCT_ATTRIBUTE_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductAttributeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_product_fee(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Update Product Fee  # noqa: E501

        <p>Update Product Fee.</p><p>Update one Product Fee by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_fee(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductFeeJsonV400 body: ProductFeeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_product_fee_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_product_fee_with_http_info(body, product_code, bank_id, **kwargs)  # noqa: E501
            return data

    def update_product_fee_with_http_info(self, body, product_code, bank_id, **kwargs):  # noqa: E501
        """Update Product Fee  # noqa: E501

        <p>Update Product Fee.</p><p>Update one Product Fee by its id.</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_product_fee_with_http_info(body, product_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProductFeeJsonV400 body: ProductFeeJsonV400 object that needs to be added. (required)
        :param str product_code: the product code (required)
        :param str bank_id: The bank id (required)
        :return: ProductFeeResponseJsonV400
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'product_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_product_fee" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_product_fee`")  # noqa: E501
        # verify the required parameter 'product_code' is set
        if self.api_client.client_side_validation and ('product_code' not in params or
                                                       params['product_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `product_code` when calling `update_product_fee`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `update_product_fee`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'product_code' in params:
            path_params['PRODUCT_CODE'] = params['product_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/products/{PRODUCT_CODE}/fees/PRODUCT_FEE_ID', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductFeeResponseJsonV400',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
