# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from obp_python.api_client import ApiClient


class ProductCollectionApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_product_collection(self, body, collection_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Collection  # noqa: E501

        <p>Create or Update a Product Collection at the Bank.</p><p>Use Product Collections to create Product &quot;Baskets&quot;, &quot;Portfolios&quot;, &quot;Indices&quot;, &quot;Collections&quot;, &quot;Underlyings-lists&quot;, &quot;Buckets&quot; etc. etc.</p><p>There is a many to many relationship between Products and Product Collections:</p><ul><li><p>A Product can exist in many Collections</p></li><li><p>A Collection can contain many Products.</p></li></ul><p>A collection has collection code, one parent Product and one or more child Products.</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_collection(body, collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductCollectionsV310 body: PutProductCollectionsV310 object that needs to be added. (required)
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_product_collection_with_http_info(body, collection_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_product_collection_with_http_info(body, collection_code, bank_id, **kwargs)  # noqa: E501
            return data

    def create_product_collection_with_http_info(self, body, collection_code, bank_id, **kwargs):  # noqa: E501
        """Create Product Collection  # noqa: E501

        <p>Create or Update a Product Collection at the Bank.</p><p>Use Product Collections to create Product &quot;Baskets&quot;, &quot;Portfolios&quot;, &quot;Indices&quot;, &quot;Collections&quot;, &quot;Underlyings-lists&quot;, &quot;Buckets&quot; etc. etc.</p><p>There is a many to many relationship between Products and Product Collections:</p><ul><li><p>A Product can exist in many Collections</p></li><li><p>A Collection can contain many Products.</p></li></ul><p>A collection has collection code, one parent Product and one or more child Products.</p><p>Product hiearchy vs Product Collections:</p><ul><li><p>You can define a hierarchy of products - so that a child Product inherits attributes of its parent Product -  using the parent_product_code in Product.</p></li><li><p>You can define a collection (also known as baskets or buckets) of products using Product Collections.</p></li></ul><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_product_collection_with_http_info(body, collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PutProductCollectionsV310 body: PutProductCollectionsV310 object that needs to be added. (required)
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionsJsonV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'collection_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_product_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_product_collection`")  # noqa: E501
        # verify the required parameter 'collection_code' is set
        if self.api_client.client_side_validation and ('collection_code' not in params or
                                                       params['collection_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_code` when calling `create_product_collection`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `create_product_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_code' in params:
            path_params['COLLECTION_CODE'] = params['collection_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/product-collections/{COLLECTION_CODE}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductCollectionsJsonV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_product_collection(self, collection_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Collection  # noqa: E501

        <p>Returns information about the financial Product Collection specified by BANK_ID and COLLECTION_CODE:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_collection(collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionJsonTreeV310
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_product_collection_with_http_info(collection_code, bank_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_product_collection_with_http_info(collection_code, bank_id, **kwargs)  # noqa: E501
            return data

    def get_product_collection_with_http_info(self, collection_code, bank_id, **kwargs):  # noqa: E501
        """Get Product Collection  # noqa: E501

        <p>Returns information about the financial Product Collection specified by BANK_ID and COLLECTION_CODE:</p><p>Authentication is Mandatory</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_product_collection_with_http_info(collection_code, bank_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str collection_code: the collection code (required)
        :param str bank_id: The bank id (required)
        :return: ProductCollectionJsonTreeV310
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_code', 'bank_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_product_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_code' is set
        if self.api_client.client_side_validation and ('collection_code' not in params or
                                                       params['collection_code'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_code` when calling `get_product_collection`")  # noqa: E501
        # verify the required parameter 'bank_id' is set
        if self.api_client.client_side_validation and ('bank_id' not in params or
                                                       params['bank_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `bank_id` when calling `get_product_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_code' in params:
            path_params['COLLECTION_CODE'] = params['collection_code']  # noqa: E501
        if 'bank_id' in params:
            path_params['BANK_ID'] = params['bank_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['directLogin', 'gatewayLogin']  # noqa: E501

        return self.api_client.call_api(
            '/obp/v5.0.0/banks/{BANK_ID}/product-collections/{COLLECTION_CODE}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProductCollectionJsonTreeV310',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
