# coding: utf-8

"""
    Open Bank Project API

    An Open Source API for Banks. (c) TESOBE GmbH. 2011 - 2023. Licensed under the AGPL and commercial licences.  # noqa: E501

    OpenAPI spec version: v5.0.0
    Contact: contact@tesobe.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from obp_python.configuration import Configuration


class UserJsonV400(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'provider': 'str',
        'email': 'str',
        'username': 'str',
        'is_deleted': 'bool',
        'provider_id': 'str',
        'user_id': 'str',
        'views': 'ViewsJSON300',
        'is_locked': 'bool',
        'entitlements': 'EntitlementJSONs',
        'last_marketing_agreement_signed_date': 'date',
        'agreements': 'list[UserAgreementJson]'
    }

    attribute_map = {
        'provider': 'provider',
        'email': 'email',
        'username': 'username',
        'is_deleted': 'is_deleted',
        'provider_id': 'provider_id',
        'user_id': 'user_id',
        'views': 'views',
        'is_locked': 'is_locked',
        'entitlements': 'entitlements',
        'last_marketing_agreement_signed_date': 'last_marketing_agreement_signed_date',
        'agreements': 'agreements'
    }

    def __init__(self, provider=None, email=None, username=None, is_deleted=None, provider_id=None, user_id=None, views=None, is_locked=None, entitlements=None, last_marketing_agreement_signed_date=None, agreements=None, _configuration=None):  # noqa: E501
        """UserJsonV400 - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._provider = None
        self._email = None
        self._username = None
        self._is_deleted = None
        self._provider_id = None
        self._user_id = None
        self._views = None
        self._is_locked = None
        self._entitlements = None
        self._last_marketing_agreement_signed_date = None
        self._agreements = None
        self.discriminator = None

        self.provider = provider
        self.email = email
        self.username = username
        self.is_deleted = is_deleted
        self.provider_id = provider_id
        self.user_id = user_id
        if views is not None:
            self.views = views
        self.is_locked = is_locked
        self.entitlements = entitlements
        if last_marketing_agreement_signed_date is not None:
            self.last_marketing_agreement_signed_date = last_marketing_agreement_signed_date
        if agreements is not None:
            self.agreements = agreements

    @property
    def provider(self):
        """Gets the provider of this UserJsonV400.  # noqa: E501


        :return: The provider of this UserJsonV400.  # noqa: E501
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """Sets the provider of this UserJsonV400.


        :param provider: The provider of this UserJsonV400.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and provider is None:
            raise ValueError("Invalid value for `provider`, must not be `None`")  # noqa: E501

        self._provider = provider

    @property
    def email(self):
        """Gets the email of this UserJsonV400.  # noqa: E501


        :return: The email of this UserJsonV400.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this UserJsonV400.


        :param email: The email of this UserJsonV400.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and email is None:
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def username(self):
        """Gets the username of this UserJsonV400.  # noqa: E501


        :return: The username of this UserJsonV400.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this UserJsonV400.


        :param username: The username of this UserJsonV400.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    @property
    def is_deleted(self):
        """Gets the is_deleted of this UserJsonV400.  # noqa: E501


        :return: The is_deleted of this UserJsonV400.  # noqa: E501
        :rtype: bool
        """
        return self._is_deleted

    @is_deleted.setter
    def is_deleted(self, is_deleted):
        """Sets the is_deleted of this UserJsonV400.


        :param is_deleted: The is_deleted of this UserJsonV400.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and is_deleted is None:
            raise ValueError("Invalid value for `is_deleted`, must not be `None`")  # noqa: E501

        self._is_deleted = is_deleted

    @property
    def provider_id(self):
        """Gets the provider_id of this UserJsonV400.  # noqa: E501


        :return: The provider_id of this UserJsonV400.  # noqa: E501
        :rtype: str
        """
        return self._provider_id

    @provider_id.setter
    def provider_id(self, provider_id):
        """Sets the provider_id of this UserJsonV400.


        :param provider_id: The provider_id of this UserJsonV400.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and provider_id is None:
            raise ValueError("Invalid value for `provider_id`, must not be `None`")  # noqa: E501

        self._provider_id = provider_id

    @property
    def user_id(self):
        """Gets the user_id of this UserJsonV400.  # noqa: E501


        :return: The user_id of this UserJsonV400.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this UserJsonV400.


        :param user_id: The user_id of this UserJsonV400.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and user_id is None:
            raise ValueError("Invalid value for `user_id`, must not be `None`")  # noqa: E501

        self._user_id = user_id

    @property
    def views(self):
        """Gets the views of this UserJsonV400.  # noqa: E501


        :return: The views of this UserJsonV400.  # noqa: E501
        :rtype: ViewsJSON300
        """
        return self._views

    @views.setter
    def views(self, views):
        """Sets the views of this UserJsonV400.


        :param views: The views of this UserJsonV400.  # noqa: E501
        :type: ViewsJSON300
        """

        self._views = views

    @property
    def is_locked(self):
        """Gets the is_locked of this UserJsonV400.  # noqa: E501


        :return: The is_locked of this UserJsonV400.  # noqa: E501
        :rtype: bool
        """
        return self._is_locked

    @is_locked.setter
    def is_locked(self, is_locked):
        """Sets the is_locked of this UserJsonV400.


        :param is_locked: The is_locked of this UserJsonV400.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and is_locked is None:
            raise ValueError("Invalid value for `is_locked`, must not be `None`")  # noqa: E501

        self._is_locked = is_locked

    @property
    def entitlements(self):
        """Gets the entitlements of this UserJsonV400.  # noqa: E501


        :return: The entitlements of this UserJsonV400.  # noqa: E501
        :rtype: EntitlementJSONs
        """
        return self._entitlements

    @entitlements.setter
    def entitlements(self, entitlements):
        """Sets the entitlements of this UserJsonV400.


        :param entitlements: The entitlements of this UserJsonV400.  # noqa: E501
        :type: EntitlementJSONs
        """
        if self._configuration.client_side_validation and entitlements is None:
            raise ValueError("Invalid value for `entitlements`, must not be `None`")  # noqa: E501

        self._entitlements = entitlements

    @property
    def last_marketing_agreement_signed_date(self):
        """Gets the last_marketing_agreement_signed_date of this UserJsonV400.  # noqa: E501


        :return: The last_marketing_agreement_signed_date of this UserJsonV400.  # noqa: E501
        :rtype: date
        """
        return self._last_marketing_agreement_signed_date

    @last_marketing_agreement_signed_date.setter
    def last_marketing_agreement_signed_date(self, last_marketing_agreement_signed_date):
        """Sets the last_marketing_agreement_signed_date of this UserJsonV400.


        :param last_marketing_agreement_signed_date: The last_marketing_agreement_signed_date of this UserJsonV400.  # noqa: E501
        :type: date
        """

        self._last_marketing_agreement_signed_date = last_marketing_agreement_signed_date

    @property
    def agreements(self):
        """Gets the agreements of this UserJsonV400.  # noqa: E501


        :return: The agreements of this UserJsonV400.  # noqa: E501
        :rtype: list[UserAgreementJson]
        """
        return self._agreements

    @agreements.setter
    def agreements(self, agreements):
        """Sets the agreements of this UserJsonV400.


        :param agreements: The agreements of this UserJsonV400.  # noqa: E501
        :type: list[UserAgreementJson]
        """

        self._agreements = agreements

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(UserJsonV400, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserJsonV400):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserJsonV400):
            return True

        return self.to_dict() != other.to_dict()
