/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.Collection;
import com.datapps.linkoopdb.jdbc.lib.Iterator;
import com.datapps.linkoopdb.jdbc.lib.Set;
import com.datapps.linkoopdb.jdbc.map.BaseHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LongKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long key) {
        this.readLock.lock();
        try {
            int lookup = this.getLookup(key);
            if (lookup != -1) {
                Object object = this.objectValueTable[lookup];
                return object;
            }
            Object var4_4 = null;
            return var4_4;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(long key, Object value) {
        this.writeLock.lock();
        try {
            Object object = super.addOrRemove(key, 0L, null, value, false);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = super.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long key) {
        this.writeLock.lock();
        try {
            Object object = super.addOrRemove(key, 0L, null, null, true);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        this.readLock.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void putAll(LongKeyHashMap other) {
        Iterator it = other.keySet().iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            this.put(key, other.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.readLock.lock();
        try {
            if (this.isEmpty()) {
                Object[] objectArray = emptyObjectArray;
                return objectArray;
            }
            Object[] array = new Object[this.size()];
            int i = 0;
            BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this, false);
            while (it.hasNext()) {
                array[i++] = it.next();
            }
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOrderedMatchCount(int[] array) {
        int i;
        this.readLock.lock();
        try {
            for (i = 0; i < array.length; ++i) {
                if (super.containsKey(array[i])) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return i;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }
}

