# Copyright (c) 2021 AccelByte Inc. All Rights Reserved.
# This is licensed software from AccelByte Inc, for limitations
# and restrictions contact your company contract manager.
#
# Code generated. DO NOT EDIT!

# template file: accelbyte_cloud_py_codegen

# pylint: disable=duplicate-code
# pylint: disable=line-too-long
# pylint: disable=missing-function-docstring
# pylint: disable=missing-module-docstring
# pylint: disable=too-many-arguments
# pylint: disable=too-many-branches
# pylint: disable=too-many-instance-attributes
# pylint: disable=too-many-lines
# pylint: disable=too-many-locals
# pylint: disable=too-many-public-methods
# pylint: disable=too-many-return-statements
# pylint: disable=too-many-statements
# pylint: disable=unused-import

# AccelByte Cloud Iam Service (5.24.0)

from __future__ import annotations
from typing import Any, Dict, List, Optional, Tuple, Union

from .....core import Operation
from .....core import HeaderStr
from .....core import HttpResponse

from ...models import RestErrorResponse


class PublicForcePlatformLinkV3(Operation):
    """Force linking user's account with platform (PublicForcePlatformLinkV3)

    Force linking user account with platform.

    If this platform account was already linked to another user account, this endpoint will perform force linking and remove platform from that conflict user, not only from the current request namespace but also include all the enrolled namespaces.

    If current user have linked to this platform with another platform account (include once linked but it is unlinked now), it will not allow user to perform linking.


    ## Supported platforms:






      * steam : The platform_tokenâs value is the authentication code returned by Steam.


      * steamopenid : Steam's user authentication method using OpenID 2.0. The platform_token's value is URL generated by Steam on web authentication


      * facebook : The platform_tokenâs value is the authorization code returned by Facebook OAuth


      * google : The platform_tokenâs value is the authorization code returned by Google OAuth


      * oculus : The platform_tokenâs value is a string composed of Oculus's user ID and the nonce separated by a colon (:).


      * twitch : The platform_tokenâs value is the authorization code returned by Twitch OAuth.


      * discord : The platform_tokenâs value is the authorization code returned by Discord OAuth


      * android : The device_id is the Androidâs device ID


      * ios : The device_id is the iOSâs device ID.


      * apple : The platform_tokenâs value is the authorization code returned by Apple OAuth.(We will use this code to generate APP token)


      * device : Every device that doesânt run Android and iOS is categorized as a device. The device_id is the deviceâs ID.


      * justice : The platform_tokenâs value is the designated userâs access token.


      * epicgames : The platform_tokenâs value is an access-token obtained from Epicgames EOS Account Service.


      * stadia : The platform_token's value is a JWT Token, which can be obtained after calling the Stadia SDK's function.


      * ps4 : The platform_tokenâs value is the authorization code returned by Sony OAuth.


      * ps5 : The platform_tokenâs value is the authorization code returned by Sony OAuth.


      * nintendo : The platform_tokenâs value is the authorization code(id_token) returned by Nintendo OAuth.


      * awscognito : The platform_tokenâs value is the aws cognito access token or id token (JWT).


      * live : The platform_tokenâs value is xbox XSTS token


      * xblweb : The platform_tokenâs value is code returned by xbox after login


      * netflix : The platform_tokenâs value is GAT (Gamer Access Token) returned by Netflix backend


      * snapchat : The platform_tokenâs value is the authorization code returned by Snapchat OAuth.

    Properties:
        url: /iam/v3/public/namespaces/{namespace}/users/me/platforms/{platformId}/force

        method: POST

        tags: ["Users"]

        consumes: ["application/x-www-form-urlencoded"]

        produces: ["application/json"]

        securities: [BEARER_AUTH]

        ticket: (ticket) REQUIRED str in form_data

        namespace: (namespace) REQUIRED str in path

        platform_id: (platformId) REQUIRED str in path

    Responses:
        204: No Content - (Operation succeeded)

        400: Bad Request - RestErrorResponse (20002: validation error | 20019: unable to parse request body)

        401: Unauthorized - RestErrorResponse (20001: unauthorized access | 20022: token is not user token)

        404: Not Found - RestErrorResponse (10174: platform client not found)

        409: Conflict - RestErrorResponse (10163: platform is already linked with the user account | 10172: platform user is already linked with the account)

        500: Internal Server Error - RestErrorResponse (20000: internal server error)
    """

    # region fields

    _url: str = (
        "/iam/v3/public/namespaces/{namespace}/users/me/platforms/{platformId}/force"
    )
    _method: str = "POST"
    _consumes: List[str] = ["application/x-www-form-urlencoded"]
    _produces: List[str] = ["application/json"]
    _securities: List[List[str]] = [["BEARER_AUTH"]]
    _location_query: str = None

    ticket: str  # REQUIRED in [form_data]
    namespace: str  # REQUIRED in [path]
    platform_id: str  # REQUIRED in [path]

    # endregion fields

    # region properties

    @property
    def url(self) -> str:
        return self._url

    @property
    def method(self) -> str:
        return self._method

    @property
    def consumes(self) -> List[str]:
        return self._consumes

    @property
    def produces(self) -> List[str]:
        return self._produces

    @property
    def securities(self) -> List[List[str]]:
        return self._securities

    @property
    def location_query(self) -> str:
        return self._location_query

    # endregion properties

    # region get methods

    # endregion get methods

    # region get_x_params methods

    def get_all_params(self) -> dict:
        return {
            "form_data": self.get_form_data_params(),
            "path": self.get_path_params(),
        }

    def get_form_data_params(self) -> dict:
        result = {}
        if hasattr(self, "ticket"):
            result["ticket"] = self.ticket
        return result

    def get_path_params(self) -> dict:
        result = {}
        if hasattr(self, "namespace"):
            result["namespace"] = self.namespace
        if hasattr(self, "platform_id"):
            result["platformId"] = self.platform_id
        return result

    # endregion get_x_params methods

    # region is/has methods

    # endregion is/has methods

    # region with_x methods

    def with_ticket(self, value: str) -> PublicForcePlatformLinkV3:
        self.ticket = value
        return self

    def with_namespace(self, value: str) -> PublicForcePlatformLinkV3:
        self.namespace = value
        return self

    def with_platform_id(self, value: str) -> PublicForcePlatformLinkV3:
        self.platform_id = value
        return self

    # endregion with_x methods

    # region to methods

    def to_dict(self, include_empty: bool = False) -> dict:
        result: dict = {}
        if hasattr(self, "ticket") and self.ticket:
            result["ticket"] = str(self.ticket)
        elif include_empty:
            result["ticket"] = ""
        if hasattr(self, "namespace") and self.namespace:
            result["namespace"] = str(self.namespace)
        elif include_empty:
            result["namespace"] = ""
        if hasattr(self, "platform_id") and self.platform_id:
            result["platformId"] = str(self.platform_id)
        elif include_empty:
            result["platformId"] = ""
        return result

    # endregion to methods

    # region response methods

    # noinspection PyMethodMayBeStatic
    def parse_response(
        self, code: int, content_type: str, content: Any
    ) -> Tuple[None, Union[None, HttpResponse, RestErrorResponse]]:
        """Parse the given response.

        204: No Content - (Operation succeeded)

        400: Bad Request - RestErrorResponse (20002: validation error | 20019: unable to parse request body)

        401: Unauthorized - RestErrorResponse (20001: unauthorized access | 20022: token is not user token)

        404: Not Found - RestErrorResponse (10174: platform client not found)

        409: Conflict - RestErrorResponse (10163: platform is already linked with the user account | 10172: platform user is already linked with the account)

        500: Internal Server Error - RestErrorResponse (20000: internal server error)

        ---: HttpResponse (Undocumented Response)

        ---: HttpResponse (Unexpected Content-Type Error)

        ---: HttpResponse (Unhandled Error)
        """
        pre_processed_response, error = self.pre_process_response(
            code=code, content_type=content_type, content=content
        )
        if error is not None:
            return None, None if error.is_no_content() else error
        code, content_type, content = pre_processed_response

        if code == 204:
            return None, None
        if code == 400:
            return None, RestErrorResponse.create_from_dict(content)
        if code == 401:
            return None, RestErrorResponse.create_from_dict(content)
        if code == 404:
            return None, RestErrorResponse.create_from_dict(content)
        if code == 409:
            return None, RestErrorResponse.create_from_dict(content)
        if code == 500:
            return None, RestErrorResponse.create_from_dict(content)

        return self.handle_undocumented_response(
            code=code, content_type=content_type, content=content
        )

    # endregion response methods

    # region static methods

    @classmethod
    def create(
        cls,
        ticket: str,
        namespace: str,
        platform_id: str,
    ) -> PublicForcePlatformLinkV3:
        instance = cls()
        instance.ticket = ticket
        instance.namespace = namespace
        instance.platform_id = platform_id
        return instance

    @classmethod
    def create_from_dict(
        cls, dict_: dict, include_empty: bool = False
    ) -> PublicForcePlatformLinkV3:
        instance = cls()
        if "ticket" in dict_ and dict_["ticket"] is not None:
            instance.ticket = str(dict_["ticket"])
        elif include_empty:
            instance.ticket = ""
        if "namespace" in dict_ and dict_["namespace"] is not None:
            instance.namespace = str(dict_["namespace"])
        elif include_empty:
            instance.namespace = ""
        if "platformId" in dict_ and dict_["platformId"] is not None:
            instance.platform_id = str(dict_["platformId"])
        elif include_empty:
            instance.platform_id = ""
        return instance

    @staticmethod
    def get_field_info() -> Dict[str, str]:
        return {
            "ticket": "ticket",
            "namespace": "namespace",
            "platformId": "platform_id",
        }

    @staticmethod
    def get_required_map() -> Dict[str, bool]:
        return {
            "ticket": True,
            "namespace": True,
            "platformId": True,
        }

    # endregion static methods
