import { DocumentationLanguage } from './language';
/**
 * Key prefix for the package data storage.
 */
export declare const STORAGE_KEY_PREFIX = "data/";
/**
 * Key suffix for storing npm package bundles.
 */
export declare const PACKAGE_KEY_SUFFIX = "/package.tgz";
/**
 * Key suffix for storing npm package metadata.
 */
export declare const METADATA_KEY_SUFFIX = "/metadata.json";
/**
 * The key suffix for (TypeScript) assembly files
 */
export declare const ASSEMBLY_KEY_SUFFIX = "/assembly.json";
/**
 * The key suffix for a TypeScript doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_TYPESCRIPT: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_PYTHON: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_JAVA: string;
/**
 * The key suffix for a Python doc artifact (root module).
 */
export declare const DOCS_KEY_SUFFIX_CSHARP: string;
/**
 * The key suffix matching any documentation artifact.
 */
export declare const DOCS_KEY_SUFFIX_ANY: string;
/**
 * Return the S3 object key prefix for a specific package name and optionally a
 * version. Note that the prefix does not end with a "/" so you will likely want
 * to add that if you want to match a specific set of objects.
 */
export declare function getObjectKeyPrefix(packageName: string, packageVersion?: string): string;
/**
 * Resolves the set of S3 object keys use for a specific package/version.
 */
export declare function getObjectKeys(packageName: string, packageVersion: string): {
    assemblyKey: string;
    packageKey: string;
    metadataKey: string;
};
/**
 * The key suffix for documentation artifacts by language and submodule.
 */
export declare function docsKeySuffix(lang?: DocumentationLanguage | '*', submodule?: string, fileExt?: string): string;
/**
 * The key suffix for a corrupted assembly marker by language and submodule.
 */
export declare function corruptAssemblyKeySuffix(lang?: DocumentationLanguage | '*', submodule?: string, fileExt?: string): string;
/**
 * The key suffix for a not supported marker by language and submodule.
 */
export declare function notSupportedKeySuffix(lang?: DocumentationLanguage | '*', submodule?: string, fileExt?: string): string;
/**
 * Key suffix for beacon files when a particular feature is not supported for
 * the particular package (i.e: Python docs for a package that does not have a
 * Python target configured).
 */
export declare const NOT_SUPPORTED_SUFFIX = ".not-supported";
/**
 * Key suffix for beacon files marking that a language specific assembly is corrupt
 * and we cannot generate docs from it.
 */
export declare const CORRUPT_ASSEMBLY_SUFFIX = ".corruptassembly";
/**
 * Key suffix for a beacon file when a package cannot be installed.
 */
export declare const UNINSTALLABLE_PACKAGE_SUFFIX = "/uninstallable";
/**
 * Name of the error denoting an unprocessable package that should be diverted away from the DLQ.
 */
export declare const UNPROCESSABLE_PACKAGE_ERROR_NAME = "UnprocessablePackageError";
/**
 * The key for the catalog document.
 */
export declare const CATALOG_KEY = "catalog.json";
/**
 * The key for the version tracking document.
 */
export declare const VERSION_TRACKER_KEY = "all-versions.json";
/**
 * The key for missing documentation report.
 *
 * @param language the language for which missing documentation is requested.
 */
export declare function missingDocumentationReport(language: DocumentationLanguage): string;
/**
 * The key for corrupt assembly report.
 *
 * @param language the language for which the report is requested.
 */
export declare function corruptAssemblyReport(language: DocumentationLanguage): string;
/**
 * The key for uninstallable packages report.
 */
export declare const UNINSTALLABLE_PACKAGES_REPORT = "uninstallable-objects/data.json";
/**
 * The key pattern for objects containing missing documentation lists.
 */
export declare const MISSING_DOCUMENTATION_REPORT_PATTERN = "missing-objects/*-documentation.json";
/**
 * The key pattern for objects containing unprocessable assembly lists.
 */
export declare const CORRUPT_ASSEMBLY_REPORT_PATTERN = "corruptassembly-objects/*.json";
/**
 * A regular expression that can be used to parse out a storage key.
 */
export declare const STORAGE_KEY_FORMAT_REGEX: RegExp;
