import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { CfnRepository } from '@aws-cdk/aws-codeartifact';
import { IBucket } from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import type { IPackageSource, PackageSourceBindOptions, PackageSourceBindResult } from '../package-source';
export interface CodeArtifactProps {
    /**
     * The CodeArtifact repository where packages are obtained from.
     */
    readonly repository: CfnRepository;
    /**
     * The S3 bucket where packages will be staged.
     */
    readonly bucket?: IBucket;
}
/**
 * A package source that obtains package data from an npm CodeArtifact
 * repository.
 */
export declare class CodeArtifact implements IPackageSource {
    private readonly props;
    constructor(props: CodeArtifactProps);
    bind(scope: Construct, { denyList, ingestion, licenseList, monitoring, queue }: PackageSourceBindOptions): PackageSourceBindResult;
    /**
     * The count of package versions that were ignored due to being in the deny list.
     */
    metricDenyListedCount(opts?: MetricOptions): Metric;
    /**
     * The number of package versions that were ignored due to using an ineloigible license.
     */
    metricIneligibleLicense(opts?: MetricOptions): Metric;
    /**
     * The number of package versions that were deleted from CodeArtifact (those events are not
     * handled currently).
     */
    metricDeletedCount(opts?: MetricOptions): Metric;
    /**
     * The number of package versions that do not have a jsii assembly in the package.
     */
    metricNotJsiiEnabledCount(opts?: MetricOptions): Metric;
}
