export interface FilterTypeValue {
    readonly type: 'checkbox' | 'radio';
}
export declare abstract class FilterType {
    static checkbox(): FilterType;
    static radio(): FilterType;
    abstract bind(): FilterTypeValue;
}
export interface PackageTagGroupProps {
    /**
     * Group label to display. Falls back to id if not provided
     */
    readonly label?: string;
    /**
     * Optional message to show within a tooltip next to the filter label
     */
    readonly tooltip?: string;
    /**
     * Allows to specify the group filter type. Defaults to checkbox if not specified
     */
    readonly filterType?: FilterType;
}
export interface PackageTagGroupConfig {
    readonly id: string;
    readonly label?: string;
    readonly tooltip?: string;
    readonly filterType?: string;
}
/**
 * Defines a custom package tag group
 */
export declare class PackageTagGroup {
    readonly id: string;
    readonly label?: string;
    readonly tooltip?: string;
    readonly filterType?: string;
    constructor(id: string, props?: PackageTagGroupProps);
    bind(): PackageTagGroupConfig;
}
