import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * Properties for `S3StorageFactory`
 */
export interface S3StorageFactoryProps {
    /**
     * When enabled, the factory will return the failover buckets instead of the primary.
     *
     * @default false
     */
    readonly failover?: boolean;
}
/**
 * Create s3 storage resources.
 */
export declare class S3StorageFactory extends Construct {
    /**
     * Retrieve or create the storage factory for the current scope.
     *
     * This is stack singleton.
     */
    static getOrCreate(scope: Construct, props?: S3StorageFactoryProps): S3StorageFactory;
    private static readonly UID;
    private failoverActive;
    private constructor();
    /**
     * Create a new bucket in a storage config aware manner.
     *
     * @returns s3.Bucket
     */
    newBucket(scope: Construct, id: string, props?: s3.BucketProps): s3.Bucket;
}
