from typing import Any, Dict, List, Type, TypeVar, Union

import attr

from ..models.raw_script_input_transforms import RawScriptInputTransforms
from ..models.raw_script_language import RawScriptLanguage
from ..models.raw_script_type import RawScriptType
from ..types import UNSET, Unset

T = TypeVar("T", bound="RawScript")


@attr.s(auto_attribs=True)
class RawScript:
    """
    Attributes:
        input_transforms (RawScriptInputTransforms):
        content (str):
        language (RawScriptLanguage):
        type (RawScriptType):
        path (Union[Unset, str]):
    """

    input_transforms: RawScriptInputTransforms
    content: str
    language: RawScriptLanguage
    type: RawScriptType
    path: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        input_transforms = self.input_transforms.to_dict()

        content = self.content
        language = self.language.value

        type = self.type.value

        path = self.path

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "input_transforms": input_transforms,
                "content": content,
                "language": language,
                "type": type,
            }
        )
        if path is not UNSET:
            field_dict["path"] = path

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        input_transforms = RawScriptInputTransforms.from_dict(d.pop("input_transforms"))

        content = d.pop("content")

        language = RawScriptLanguage(d.pop("language"))

        type = RawScriptType(d.pop("type"))

        path = d.pop("path", UNSET)

        raw_script = cls(
            input_transforms=input_transforms,
            content=content,
            language=language,
            type=type,
            path=path,
        )

        raw_script.additional_properties = d
        return raw_script

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
