# AUTOGENERATED! DO NOT EDIT! File to edit: ../08_websocket_rosbridge.ipynb.

# %% auto 0
__all__ = ['ros_socket']

# %% ../08_websocket_rosbridge.ipynb 5
import roslibpy
import time

# %% ../08_websocket_rosbridge.ipynb 6
class ros_socket():
    def __init__(self, ip, port=9090):
        '''
        __init__
        
        Input:
            ip(type: string) ip address you want to connect
            port(type: int) default is 9090 
        '''
        self.ip = ip
        self.port = port
        self.topic = []
        self.node = []
        self.topic_name = ''
        self.topic_type = ''
        self.client = roslibpy.Ros(host = ip, port = port)
        self.client.run()
    
    def get_topic(self):
        self.topic = self.client.get_topics()
        return self.topic
    
    def get_node(self):
        self.node = self.client.get_nodes()
        return self.node
    
    def check_connecting(self):
        print('Is ROS connected?',  self.client.is_connected)
    
    def subscriber(self, topic_name, subscribe_callback, rate_in_ms=1000):
        '''
        subscriber
        subscribe topic with rate (default = 1sec)
        
        Input:
            topic_name(type:)
            subscribe_callback(message)
            (type: function) *only one argument message-> that will load with data you subscribing
        '''
        self.topic_name = topic_name
        self.topic_type = self.client.get_topic_type(self.topic_name)
        listener = roslibpy.Topic(self.client, self.topic_name, self.topic_type,throttle_rate = rate_in_ms)
        listener.subscribe(subscribe_callback)
    
    def publisher(self, topic_name, topic_type):
        '''
        publisher
        publish message_data to topic_name
        
        Input:
            topic_name(type:string)
            topic_type(type:)
            message_data(type:topic_type)
        '''
        talker = roslibpy.Topic(self.client, topic_name, topic_type)
        return talker
    
    def pub(self, talker, data):
        talker.publish(data)
    
    
    def println(self, ros_list):
        if len(ros_list) == 0:
            print('Empty')
        else:
            for i in ros_list:
                print(i)
        
        
