# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 2.2.0  # noqa: E501
    The version of the OpenAPI document: 0.10.4
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class BlockDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'size': 'int',
        'signature': 'str',
        'signer_public_key': 'str',
        'version': 'int',
        'network': 'NetworkTypeEnum',
        'type': 'int',
        'height': 'str',
        'timestamp': 'str',
        'difficulty': 'str',
        'proof_gamma': 'str',
        'proof_verification_hash': 'str',
        'proof_scalar': 'str',
        'previous_block_hash': 'str',
        'transactions_hash': 'str',
        'receipts_hash': 'str',
        'state_hash': 'str',
        'beneficiary_address': 'str',
        'fee_multiplier': 'int'
    }

    attribute_map = {
        'size': 'size',
        'signature': 'signature',
        'signer_public_key': 'signerPublicKey',
        'version': 'version',
        'network': 'network',
        'type': 'type',
        'height': 'height',
        'timestamp': 'timestamp',
        'difficulty': 'difficulty',
        'proof_gamma': 'proofGamma',
        'proof_verification_hash': 'proofVerificationHash',
        'proof_scalar': 'proofScalar',
        'previous_block_hash': 'previousBlockHash',
        'transactions_hash': 'transactionsHash',
        'receipts_hash': 'receiptsHash',
        'state_hash': 'stateHash',
        'beneficiary_address': 'beneficiaryAddress',
        'fee_multiplier': 'feeMultiplier'
    }

    def __init__(self, size=None, signature=None, signer_public_key=None, version=None, network=None, type=None, height=None, timestamp=None, difficulty=None, proof_gamma=None, proof_verification_hash=None, proof_scalar=None, previous_block_hash=None, transactions_hash=None, receipts_hash=None, state_hash=None, beneficiary_address=None, fee_multiplier=None, local_vars_configuration=None):  # noqa: E501
        """BlockDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._size = None
        self._signature = None
        self._signer_public_key = None
        self._version = None
        self._network = None
        self._type = None
        self._height = None
        self._timestamp = None
        self._difficulty = None
        self._proof_gamma = None
        self._proof_verification_hash = None
        self._proof_scalar = None
        self._previous_block_hash = None
        self._transactions_hash = None
        self._receipts_hash = None
        self._state_hash = None
        self._beneficiary_address = None
        self._fee_multiplier = None
        self.discriminator = None

        self.size = size
        self.signature = signature
        self.signer_public_key = signer_public_key
        self.version = version
        self.network = network
        self.type = type
        self.height = height
        self.timestamp = timestamp
        self.difficulty = difficulty
        self.proof_gamma = proof_gamma
        self.proof_verification_hash = proof_verification_hash
        self.proof_scalar = proof_scalar
        self.previous_block_hash = previous_block_hash
        self.transactions_hash = transactions_hash
        self.receipts_hash = receipts_hash
        self.state_hash = state_hash
        self.beneficiary_address = beneficiary_address
        self.fee_multiplier = fee_multiplier

    @property
    def size(self):
        """Gets the size of this BlockDTO.  # noqa: E501

        A number that allows uint 32 values.  # noqa: E501

        :return: The size of this BlockDTO.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this BlockDTO.

        A number that allows uint 32 values.  # noqa: E501

        :param size: The size of this BlockDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and size is None:  # noqa: E501
            raise ValueError("Invalid value for `size`, must not be `None`")  # noqa: E501

        self._size = size

    @property
    def signature(self):
        """Gets the signature of this BlockDTO.  # noqa: E501

        Entity's signature generated by the signer.  # noqa: E501

        :return: The signature of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._signature

    @signature.setter
    def signature(self, signature):
        """Sets the signature of this BlockDTO.

        Entity's signature generated by the signer.  # noqa: E501

        :param signature: The signature of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and signature is None:  # noqa: E501
            raise ValueError("Invalid value for `signature`, must not be `None`")  # noqa: E501

        self._signature = signature

    @property
    def signer_public_key(self):
        """Gets the signer_public_key of this BlockDTO.  # noqa: E501

        Public key.  # noqa: E501

        :return: The signer_public_key of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._signer_public_key

    @signer_public_key.setter
    def signer_public_key(self, signer_public_key):
        """Sets the signer_public_key of this BlockDTO.

        Public key.  # noqa: E501

        :param signer_public_key: The signer_public_key of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and signer_public_key is None:  # noqa: E501
            raise ValueError("Invalid value for `signer_public_key`, must not be `None`")  # noqa: E501

        self._signer_public_key = signer_public_key

    @property
    def version(self):
        """Gets the version of this BlockDTO.  # noqa: E501

        Entity version.  # noqa: E501

        :return: The version of this BlockDTO.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this BlockDTO.

        Entity version.  # noqa: E501

        :param version: The version of this BlockDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def network(self):
        """Gets the network of this BlockDTO.  # noqa: E501


        :return: The network of this BlockDTO.  # noqa: E501
        :rtype: NetworkTypeEnum
        """
        return self._network

    @network.setter
    def network(self, network):
        """Sets the network of this BlockDTO.


        :param network: The network of this BlockDTO.  # noqa: E501
        :type: NetworkTypeEnum
        """
        if self.local_vars_configuration.client_side_validation and network is None:  # noqa: E501
            raise ValueError("Invalid value for `network`, must not be `None`")  # noqa: E501

        self._network = network

    @property
    def type(self):
        """Gets the type of this BlockDTO.  # noqa: E501


        :return: The type of this BlockDTO.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this BlockDTO.


        :param type: The type of this BlockDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def height(self):
        """Gets the height of this BlockDTO.  # noqa: E501

        Height of the blockchain.  # noqa: E501

        :return: The height of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this BlockDTO.

        Height of the blockchain.  # noqa: E501

        :param height: The height of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and height is None:  # noqa: E501
            raise ValueError("Invalid value for `height`, must not be `None`")  # noqa: E501

        self._height = height

    @property
    def timestamp(self):
        """Gets the timestamp of this BlockDTO.  # noqa: E501

        Number of seconds elapsed since the creation of the nemesis block.  # noqa: E501

        :return: The timestamp of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """Sets the timestamp of this BlockDTO.

        Number of seconds elapsed since the creation of the nemesis block.  # noqa: E501

        :param timestamp: The timestamp of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and timestamp is None:  # noqa: E501
            raise ValueError("Invalid value for `timestamp`, must not be `None`")  # noqa: E501

        self._timestamp = timestamp

    @property
    def difficulty(self):
        """Gets the difficulty of this BlockDTO.  # noqa: E501

        Determines how hard is to harvest a new block, based on previous blocks.  # noqa: E501

        :return: The difficulty of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._difficulty

    @difficulty.setter
    def difficulty(self, difficulty):
        """Sets the difficulty of this BlockDTO.

        Determines how hard is to harvest a new block, based on previous blocks.  # noqa: E501

        :param difficulty: The difficulty of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and difficulty is None:  # noqa: E501
            raise ValueError("Invalid value for `difficulty`, must not be `None`")  # noqa: E501

        self._difficulty = difficulty

    @property
    def proof_gamma(self):
        """Gets the proof_gamma of this BlockDTO.  # noqa: E501

        32-bytes VRF proof gamma.  # noqa: E501

        :return: The proof_gamma of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._proof_gamma

    @proof_gamma.setter
    def proof_gamma(self, proof_gamma):
        """Sets the proof_gamma of this BlockDTO.

        32-bytes VRF proof gamma.  # noqa: E501

        :param proof_gamma: The proof_gamma of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and proof_gamma is None:  # noqa: E501
            raise ValueError("Invalid value for `proof_gamma`, must not be `None`")  # noqa: E501

        self._proof_gamma = proof_gamma

    @property
    def proof_verification_hash(self):
        """Gets the proof_verification_hash of this BlockDTO.  # noqa: E501

        16-bytes VRF proof verification hash.  # noqa: E501

        :return: The proof_verification_hash of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._proof_verification_hash

    @proof_verification_hash.setter
    def proof_verification_hash(self, proof_verification_hash):
        """Sets the proof_verification_hash of this BlockDTO.

        16-bytes VRF proof verification hash.  # noqa: E501

        :param proof_verification_hash: The proof_verification_hash of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and proof_verification_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `proof_verification_hash`, must not be `None`")  # noqa: E501

        self._proof_verification_hash = proof_verification_hash

    @property
    def proof_scalar(self):
        """Gets the proof_scalar of this BlockDTO.  # noqa: E501

        32-bytes VRF proof scalar.  # noqa: E501

        :return: The proof_scalar of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._proof_scalar

    @proof_scalar.setter
    def proof_scalar(self, proof_scalar):
        """Sets the proof_scalar of this BlockDTO.

        32-bytes VRF proof scalar.  # noqa: E501

        :param proof_scalar: The proof_scalar of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and proof_scalar is None:  # noqa: E501
            raise ValueError("Invalid value for `proof_scalar`, must not be `None`")  # noqa: E501

        self._proof_scalar = proof_scalar

    @property
    def previous_block_hash(self):
        """Gets the previous_block_hash of this BlockDTO.  # noqa: E501


        :return: The previous_block_hash of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._previous_block_hash

    @previous_block_hash.setter
    def previous_block_hash(self, previous_block_hash):
        """Sets the previous_block_hash of this BlockDTO.


        :param previous_block_hash: The previous_block_hash of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and previous_block_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `previous_block_hash`, must not be `None`")  # noqa: E501

        self._previous_block_hash = previous_block_hash

    @property
    def transactions_hash(self):
        """Gets the transactions_hash of this BlockDTO.  # noqa: E501


        :return: The transactions_hash of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._transactions_hash

    @transactions_hash.setter
    def transactions_hash(self, transactions_hash):
        """Sets the transactions_hash of this BlockDTO.


        :param transactions_hash: The transactions_hash of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and transactions_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `transactions_hash`, must not be `None`")  # noqa: E501

        self._transactions_hash = transactions_hash

    @property
    def receipts_hash(self):
        """Gets the receipts_hash of this BlockDTO.  # noqa: E501


        :return: The receipts_hash of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._receipts_hash

    @receipts_hash.setter
    def receipts_hash(self, receipts_hash):
        """Sets the receipts_hash of this BlockDTO.


        :param receipts_hash: The receipts_hash of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and receipts_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `receipts_hash`, must not be `None`")  # noqa: E501

        self._receipts_hash = receipts_hash

    @property
    def state_hash(self):
        """Gets the state_hash of this BlockDTO.  # noqa: E501


        :return: The state_hash of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._state_hash

    @state_hash.setter
    def state_hash(self, state_hash):
        """Sets the state_hash of this BlockDTO.


        :param state_hash: The state_hash of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state_hash is None:  # noqa: E501
            raise ValueError("Invalid value for `state_hash`, must not be `None`")  # noqa: E501

        self._state_hash = state_hash

    @property
    def beneficiary_address(self):
        """Gets the beneficiary_address of this BlockDTO.  # noqa: E501

        Address expressed in hexadecimal base.  # noqa: E501

        :return: The beneficiary_address of this BlockDTO.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_address

    @beneficiary_address.setter
    def beneficiary_address(self, beneficiary_address):
        """Sets the beneficiary_address of this BlockDTO.

        Address expressed in hexadecimal base.  # noqa: E501

        :param beneficiary_address: The beneficiary_address of this BlockDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and beneficiary_address is None:  # noqa: E501
            raise ValueError("Invalid value for `beneficiary_address`, must not be `None`")  # noqa: E501

        self._beneficiary_address = beneficiary_address

    @property
    def fee_multiplier(self):
        """Gets the fee_multiplier of this BlockDTO.  # noqa: E501

        Fee multiplier applied to transactions contained in block.  # noqa: E501

        :return: The fee_multiplier of this BlockDTO.  # noqa: E501
        :rtype: int
        """
        return self._fee_multiplier

    @fee_multiplier.setter
    def fee_multiplier(self, fee_multiplier):
        """Sets the fee_multiplier of this BlockDTO.

        Fee multiplier applied to transactions contained in block.  # noqa: E501

        :param fee_multiplier: The fee_multiplier of this BlockDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and fee_multiplier is None:  # noqa: E501
            raise ValueError("Invalid value for `fee_multiplier`, must not be `None`")  # noqa: E501

        self._fee_multiplier = fee_multiplier

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BlockDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, BlockDTO):
            return True

        return self.to_dict() != other.to_dict()
