# -*- coding: utf-8 -*-
# Generated by Django 1.9.1 on 2016-03-01 11:07
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='PasswordHistory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(editable=False, max_length=255, verbose_name='Password hash')),
                ('date', models.DateTimeField(auto_now_add=True, verbose_name='Date')),
            ],
            options={
                'ordering': ['-user_config', 'password'],
                'verbose_name': 'Old password',
                'verbose_name_plural': 'Password history',
            },
        ),
        migrations.CreateModel(
            name='UserPasswordHistoryConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateTimeField(auto_now_add=True, verbose_name='When created salt')),
                ('salt', models.CharField(editable=False, max_length=120, verbose_name='Salt for the user')),
                ('iterations', models.IntegerField(blank=True, default=None, editable=False, null=True, verbose_name='The number of of iterations for Hasher')),
                ('user', models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-user', 'iterations'],
                'verbose_name': 'Configuration',
                'verbose_name_plural': 'Configurations',
            },
        ),
        migrations.AddField(
            model_name='passwordhistory',
            name='user_config',
            field=models.ForeignKey(editable=False, on_delete=django.db.models.deletion.CASCADE, to='password_history.UserPasswordHistoryConfig'),
        ),
        migrations.AlterUniqueTogether(
            name='userpasswordhistoryconfig',
            unique_together=set([('user', 'iterations')]),
        ),
        migrations.AlterUniqueTogether(
            name='passwordhistory',
            unique_together=set([('user_config', 'password')]),
        ),
    ]
