# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from mux_python.api_client import ApiClient
from mux_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class TranscriptionVocabulariesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_transcription_vocabulary(self, create_transcription_vocabulary_request, **kwargs):  # noqa: E501
        """Create a Transcription Vocabulary  # noqa: E501

        Create a new Transcription Vocabulary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transcription_vocabulary(create_transcription_vocabulary_request, async_req=True)
        >>> result = thread.get()

        :param create_transcription_vocabulary_request: (required)
        :type create_transcription_vocabulary_request: CreateTranscriptionVocabularyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranscriptionVocabularyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_transcription_vocabulary_with_http_info(create_transcription_vocabulary_request, **kwargs)  # noqa: E501

    def create_transcription_vocabulary_with_http_info(self, create_transcription_vocabulary_request, **kwargs):  # noqa: E501
        """Create a Transcription Vocabulary  # noqa: E501

        Create a new Transcription Vocabulary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_transcription_vocabulary_with_http_info(create_transcription_vocabulary_request, async_req=True)
        >>> result = thread.get()

        :param create_transcription_vocabulary_request: (required)
        :type create_transcription_vocabulary_request: CreateTranscriptionVocabularyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranscriptionVocabularyResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'create_transcription_vocabulary_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_transcription_vocabulary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'create_transcription_vocabulary_request' is set
        if self.api_client.client_side_validation and ('create_transcription_vocabulary_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['create_transcription_vocabulary_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `create_transcription_vocabulary_request` when calling `create_transcription_vocabulary`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_transcription_vocabulary_request' in local_var_params:
            body_params = local_var_params['create_transcription_vocabulary_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            201: "TranscriptionVocabularyResponse",
        }

        return self.api_client.call_api(
            '/video/v1/transcription-vocabularies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_transcription_vocabulary(self, transcription_vocabulary_id, **kwargs):  # noqa: E501
        """Delete a Transcription Vocabulary  # noqa: E501

        Deletes a Transcription Vocabulary. The Transcription Vocabulary's ID will be disassociated from any live streams using it. Transcription Vocabularies can be deleted while associated live streams are active. However, the words and phrases in the deleted Transcription Vocabulary will remain attached to those streams while they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transcription_vocabulary(transcription_vocabulary_id, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_transcription_vocabulary_with_http_info(transcription_vocabulary_id, **kwargs)  # noqa: E501

    def delete_transcription_vocabulary_with_http_info(self, transcription_vocabulary_id, **kwargs):  # noqa: E501
        """Delete a Transcription Vocabulary  # noqa: E501

        Deletes a Transcription Vocabulary. The Transcription Vocabulary's ID will be disassociated from any live streams using it. Transcription Vocabularies can be deleted while associated live streams are active. However, the words and phrases in the deleted Transcription Vocabulary will remain attached to those streams while they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_transcription_vocabulary_with_http_info(transcription_vocabulary_id, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'transcription_vocabulary_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_transcription_vocabulary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transcription_vocabulary_id' is set
        if self.api_client.client_side_validation and ('transcription_vocabulary_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transcription_vocabulary_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transcription_vocabulary_id` when calling `delete_transcription_vocabulary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transcription_vocabulary_id' in local_var_params:
            path_params['TRANSCRIPTION_VOCABULARY_ID'] = local_var_params['transcription_vocabulary_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {}

        return self.api_client.call_api(
            '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_transcription_vocabulary(self, transcription_vocabulary_id, **kwargs):  # noqa: E501
        """Retrieve a Transcription Vocabulary  # noqa: E501

        Retrieves the details of a Transcription Vocabulary that has previously been created. Supply the unique Transcription Vocabulary ID and Mux will return the corresponding Transcription Vocabulary information. The same information is returned when creating a Transcription Vocabulary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transcription_vocabulary(transcription_vocabulary_id, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranscriptionVocabularyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_transcription_vocabulary_with_http_info(transcription_vocabulary_id, **kwargs)  # noqa: E501

    def get_transcription_vocabulary_with_http_info(self, transcription_vocabulary_id, **kwargs):  # noqa: E501
        """Retrieve a Transcription Vocabulary  # noqa: E501

        Retrieves the details of a Transcription Vocabulary that has previously been created. Supply the unique Transcription Vocabulary ID and Mux will return the corresponding Transcription Vocabulary information. The same information is returned when creating a Transcription Vocabulary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_transcription_vocabulary_with_http_info(transcription_vocabulary_id, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranscriptionVocabularyResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'transcription_vocabulary_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_transcription_vocabulary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transcription_vocabulary_id' is set
        if self.api_client.client_side_validation and ('transcription_vocabulary_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transcription_vocabulary_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transcription_vocabulary_id` when calling `get_transcription_vocabulary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transcription_vocabulary_id' in local_var_params:
            path_params['TRANSCRIPTION_VOCABULARY_ID'] = local_var_params['transcription_vocabulary_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "TranscriptionVocabularyResponse",
        }

        return self.api_client.call_api(
            '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_transcription_vocabularies(self, **kwargs):  # noqa: E501
        """List Transcription Vocabularies  # noqa: E501

        List all Transcription Vocabularies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transcription_vocabularies(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ListTranscriptionVocabulariesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_transcription_vocabularies_with_http_info(**kwargs)  # noqa: E501

    def list_transcription_vocabularies_with_http_info(self, **kwargs):  # noqa: E501
        """List Transcription Vocabularies  # noqa: E501

        List all Transcription Vocabularies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_transcription_vocabularies_with_http_info(async_req=True)
        >>> result = thread.get()

        :param limit: Number of items to include in the response
        :type limit: int
        :param page: Offset by this many pages, of the size of `limit`
        :type page: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ListTranscriptionVocabulariesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_transcription_vocabularies" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 10:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_transcription_vocabularies`, must be a value less than or equal to `10`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "ListTranscriptionVocabulariesResponse",
        }

        return self.api_client.call_api(
            '/video/v1/transcription-vocabularies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_transcription_vocabulary(self, transcription_vocabulary_id, update_transcription_vocabulary_request, **kwargs):  # noqa: E501
        """Update a Transcription Vocabulary  # noqa: E501

        Updates the details of a previously-created Transcription Vocabulary. Updates to Transcription Vocabularies are allowed while associated live streams are active. However, updates will not be applied to those streams while they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transcription_vocabulary(transcription_vocabulary_id, update_transcription_vocabulary_request, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param update_transcription_vocabulary_request: (required)
        :type update_transcription_vocabulary_request: UpdateTranscriptionVocabularyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TranscriptionVocabularyResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_transcription_vocabulary_with_http_info(transcription_vocabulary_id, update_transcription_vocabulary_request, **kwargs)  # noqa: E501

    def update_transcription_vocabulary_with_http_info(self, transcription_vocabulary_id, update_transcription_vocabulary_request, **kwargs):  # noqa: E501
        """Update a Transcription Vocabulary  # noqa: E501

        Updates the details of a previously-created Transcription Vocabulary. Updates to Transcription Vocabularies are allowed while associated live streams are active. However, updates will not be applied to those streams while they are active.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_transcription_vocabulary_with_http_info(transcription_vocabulary_id, update_transcription_vocabulary_request, async_req=True)
        >>> result = thread.get()

        :param transcription_vocabulary_id: The ID of the Transcription Vocabulary. (required)
        :type transcription_vocabulary_id: str
        :param update_transcription_vocabulary_request: (required)
        :type update_transcription_vocabulary_request: UpdateTranscriptionVocabularyRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TranscriptionVocabularyResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'transcription_vocabulary_id',
            'update_transcription_vocabulary_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_transcription_vocabulary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'transcription_vocabulary_id' is set
        if self.api_client.client_side_validation and ('transcription_vocabulary_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['transcription_vocabulary_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `transcription_vocabulary_id` when calling `update_transcription_vocabulary`")  # noqa: E501
        # verify the required parameter 'update_transcription_vocabulary_request' is set
        if self.api_client.client_side_validation and ('update_transcription_vocabulary_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['update_transcription_vocabulary_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `update_transcription_vocabulary_request` when calling `update_transcription_vocabulary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'transcription_vocabulary_id' in local_var_params:
            path_params['TRANSCRIPTION_VOCABULARY_ID'] = local_var_params['transcription_vocabulary_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_transcription_vocabulary_request' in local_var_params:
            body_params = local_var_params['update_transcription_vocabulary_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['accessToken']  # noqa: E501
        
        response_types_map = {
            200: "TranscriptionVocabularyResponse",
        }

        return self.api_client.call_api(
            '/video/v1/transcription-vocabularies/{TRANSCRIPTION_VOCABULARY_ID}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
