# coding: utf-8

"""
    Mux API

    Mux is how developers build online video. This API encompasses both Mux Video and Mux Data functionality to help you build your video-related projects better and faster than ever before.  # noqa: E501

    The version of the OpenAPI document: v1
    Contact: devex@mux.com
    Generated by: https://openapi-generator.tech
"""


import inspect
import pprint
import re  # noqa: F401
import six

from mux_python.configuration import Configuration


class CreateTrackRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'url': 'str',
        'type': 'str',
        'text_type': 'str',
        'language_code': 'str',
        'name': 'str',
        'closed_captions': 'bool',
        'passthrough': 'str'
    }

    attribute_map = {
        'url': 'url',
        'type': 'type',
        'text_type': 'text_type',
        'language_code': 'language_code',
        'name': 'name',
        'closed_captions': 'closed_captions',
        'passthrough': 'passthrough'
    }

    def __init__(self, url=None, type=None, text_type=None, language_code=None, name=None, closed_captions=None, passthrough=None, local_vars_configuration=None):  # noqa: E501
        """CreateTrackRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._url = None
        self._type = None
        self._text_type = None
        self._language_code = None
        self._name = None
        self._closed_captions = None
        self._passthrough = None
        self.discriminator = None

        self.url = url
        self.type = type
        self.text_type = text_type
        self.language_code = language_code
        if name is not None:
            self.name = name
        if closed_captions is not None:
            self.closed_captions = closed_captions
        if passthrough is not None:
            self.passthrough = passthrough

    @property
    def url(self):
        """Gets the url of this CreateTrackRequest.  # noqa: E501


        :return: The url of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this CreateTrackRequest.


        :param url: The url of this CreateTrackRequest.  # noqa: E501
        :type url: str
        """
        if self.local_vars_configuration.client_side_validation and url is None:  # noqa: E501
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def type(self):
        """Gets the type of this CreateTrackRequest.  # noqa: E501


        :return: The type of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this CreateTrackRequest.


        :param type: The type of this CreateTrackRequest.  # noqa: E501
        :type type: str
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["text"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def text_type(self):
        """Gets the text_type of this CreateTrackRequest.  # noqa: E501


        :return: The text_type of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._text_type

    @text_type.setter
    def text_type(self, text_type):
        """Sets the text_type of this CreateTrackRequest.


        :param text_type: The text_type of this CreateTrackRequest.  # noqa: E501
        :type text_type: str
        """
        if self.local_vars_configuration.client_side_validation and text_type is None:  # noqa: E501
            raise ValueError("Invalid value for `text_type`, must not be `None`")  # noqa: E501
        allowed_values = ["subtitles"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and text_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `text_type` ({0}), must be one of {1}"  # noqa: E501
                .format(text_type, allowed_values)
            )

        self._text_type = text_type

    @property
    def language_code(self):
        """Gets the language_code of this CreateTrackRequest.  # noqa: E501

        The language code value must be a valid BCP 47 specification compliant value. For example, en for English or en-US for the US version of English.  # noqa: E501

        :return: The language_code of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """Sets the language_code of this CreateTrackRequest.

        The language code value must be a valid BCP 47 specification compliant value. For example, en for English or en-US for the US version of English.  # noqa: E501

        :param language_code: The language_code of this CreateTrackRequest.  # noqa: E501
        :type language_code: str
        """
        if self.local_vars_configuration.client_side_validation and language_code is None:  # noqa: E501
            raise ValueError("Invalid value for `language_code`, must not be `None`")  # noqa: E501

        self._language_code = language_code

    @property
    def name(self):
        """Gets the name of this CreateTrackRequest.  # noqa: E501

        The name of the track containing a human-readable description. This value must be unique across all the text type and subtitles text type tracks. HLS manifest will associate subtitle text track with this value. For example, set the value to \"English\" for subtitles text track with language_code as en-US. If this parameter is not included, Mux will auto-populate based on the language_code value.  # noqa: E501

        :return: The name of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateTrackRequest.

        The name of the track containing a human-readable description. This value must be unique across all the text type and subtitles text type tracks. HLS manifest will associate subtitle text track with this value. For example, set the value to \"English\" for subtitles text track with language_code as en-US. If this parameter is not included, Mux will auto-populate based on the language_code value.  # noqa: E501

        :param name: The name of this CreateTrackRequest.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def closed_captions(self):
        """Gets the closed_captions of this CreateTrackRequest.  # noqa: E501

        Indicates the track provides Subtitles for the Deaf or Hard-of-hearing (SDH).  # noqa: E501

        :return: The closed_captions of this CreateTrackRequest.  # noqa: E501
        :rtype: bool
        """
        return self._closed_captions

    @closed_captions.setter
    def closed_captions(self, closed_captions):
        """Sets the closed_captions of this CreateTrackRequest.

        Indicates the track provides Subtitles for the Deaf or Hard-of-hearing (SDH).  # noqa: E501

        :param closed_captions: The closed_captions of this CreateTrackRequest.  # noqa: E501
        :type closed_captions: bool
        """

        self._closed_captions = closed_captions

    @property
    def passthrough(self):
        """Gets the passthrough of this CreateTrackRequest.  # noqa: E501

        Arbitrary user-supplied metadata set for the track either when creating the asset or track.  # noqa: E501

        :return: The passthrough of this CreateTrackRequest.  # noqa: E501
        :rtype: str
        """
        return self._passthrough

    @passthrough.setter
    def passthrough(self, passthrough):
        """Sets the passthrough of this CreateTrackRequest.

        Arbitrary user-supplied metadata set for the track either when creating the asset or track.  # noqa: E501

        :param passthrough: The passthrough of this CreateTrackRequest.  # noqa: E501
        :type passthrough: str
        """

        self._passthrough = passthrough

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = inspect.getargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateTrackRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateTrackRequest):
            return True

        return self.to_dict() != other.to_dict()
