"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CATALOG_KEY = exports.assemblyKeySuffix = exports.ASSEMBLY_KEY_SUFFIX = exports.PACKAGE_KEY_SUFFIX = exports.STORAGE_KEY_PREFIX = void 0;
/**
 * Key prefix for the package data storage.
 */
exports.STORAGE_KEY_PREFIX = 'data/';
/**
 * Key suffix for storing npm package bundles.
 */
exports.PACKAGE_KEY_SUFFIX = '/package.tgz';
/**
 * The key suffix for (TypeScript) assembly files
 */
exports.ASSEMBLY_KEY_SUFFIX = '/assembly.json';
/**
 * The key suffix for assemblies in the provided language. This should NOT be
 * used for the TypeScript/JavaScript assembly however.
 */
function assemblyKeySuffix(lang) {
    return `/assembly-${lang}.json`;
}
exports.assemblyKeySuffix = assemblyKeySuffix;
/**
 * The key for the catalog document.
 */
exports.CATALOG_KEY = 'catalog.json';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RhbnRzLmxhbWJkYS1zaGFyZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYmFja2VuZC9zaGFyZWQvY29uc3RhbnRzLmxhbWJkYS1zaGFyZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUE7O0dBRUc7QUFDVSxRQUFBLGtCQUFrQixHQUFHLE9BQU8sQ0FBQztBQUUxQzs7R0FFRztBQUNVLFFBQUEsa0JBQWtCLEdBQUcsY0FBYyxDQUFDO0FBRWpEOztHQUVHO0FBQ1UsUUFBQSxtQkFBbUIsR0FBRyxnQkFBZ0IsQ0FBQztBQUVwRDs7O0dBR0c7QUFDSCxTQUFnQixpQkFBaUIsQ0FBQyxJQUFvQjtJQUNwRCxPQUFPLGFBQWEsSUFBSSxPQUFPLENBQUM7QUFDbEMsQ0FBQztBQUZELDhDQUVDO0FBRUQ7O0dBRUc7QUFDVSxRQUFBLFdBQVcsR0FBRyxjQUFjLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IFRhcmdldExhbmd1YWdlIH0gZnJvbSAnanNpaS1yb3NldHRhJztcblxuLyoqXG4gKiBLZXkgcHJlZml4IGZvciB0aGUgcGFja2FnZSBkYXRhIHN0b3JhZ2UuXG4gKi9cbmV4cG9ydCBjb25zdCBTVE9SQUdFX0tFWV9QUkVGSVggPSAnZGF0YS8nO1xuXG4vKipcbiAqIEtleSBzdWZmaXggZm9yIHN0b3JpbmcgbnBtIHBhY2thZ2UgYnVuZGxlcy5cbiAqL1xuZXhwb3J0IGNvbnN0IFBBQ0tBR0VfS0VZX1NVRkZJWCA9ICcvcGFja2FnZS50Z3onO1xuXG4vKipcbiAqIFRoZSBrZXkgc3VmZml4IGZvciAoVHlwZVNjcmlwdCkgYXNzZW1ibHkgZmlsZXNcbiAqL1xuZXhwb3J0IGNvbnN0IEFTU0VNQkxZX0tFWV9TVUZGSVggPSAnL2Fzc2VtYmx5Lmpzb24nO1xuXG4vKipcbiAqIFRoZSBrZXkgc3VmZml4IGZvciBhc3NlbWJsaWVzIGluIHRoZSBwcm92aWRlZCBsYW5ndWFnZS4gVGhpcyBzaG91bGQgTk9UIGJlXG4gKiB1c2VkIGZvciB0aGUgVHlwZVNjcmlwdC9KYXZhU2NyaXB0IGFzc2VtYmx5IGhvd2V2ZXIuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBhc3NlbWJseUtleVN1ZmZpeChsYW5nOiBUYXJnZXRMYW5ndWFnZSkge1xuICByZXR1cm4gYC9hc3NlbWJseS0ke2xhbmd9Lmpzb25gO1xufVxuXG4vKipcbiAqIFRoZSBrZXkgZm9yIHRoZSBjYXRhbG9nIGRvY3VtZW50LlxuICovXG5leHBvcnQgY29uc3QgQ0FUQUxPR19LRVkgPSAnY2F0YWxvZy5qc29uJztcbiJdfQ==