import * as cloudfront from '@aws-cdk/aws-cloudfront';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
import { Domain } from '../api';
import { Monitoring } from '../monitoring';
export interface WebAppProps {
    /**
     * Connect to a domain.
     * @default - uses the default CloudFront domain.
     */
    readonly domain?: Domain;
    /**
     * Monitoring system.
     */
    readonly monitoring: Monitoring;
}
export declare class WebApp extends Construct {
    readonly bucket: s3.Bucket;
    readonly distribution: cloudfront.Distribution;
    constructor(scope: Construct, id: string, props: WebAppProps);
}
