# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.1.0  # noqa: E501
    The version of the OpenAPI document: 0.9.1
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class MultisigDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_address': 'str',
        'min_approval': 'int',
        'min_removal': 'int',
        'cosignatory_addresses': 'list[str]',
        'multisig_addresses': 'list[str]'
    }

    attribute_map = {
        'account_address': 'accountAddress',
        'min_approval': 'minApproval',
        'min_removal': 'minRemoval',
        'cosignatory_addresses': 'cosignatoryAddresses',
        'multisig_addresses': 'multisigAddresses'
    }

    def __init__(self, account_address=None, min_approval=None, min_removal=None, cosignatory_addresses=None, multisig_addresses=None, local_vars_configuration=None):  # noqa: E501
        """MultisigDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_address = None
        self._min_approval = None
        self._min_removal = None
        self._cosignatory_addresses = None
        self._multisig_addresses = None
        self.discriminator = None

        self.account_address = account_address
        self.min_approval = min_approval
        self.min_removal = min_removal
        self.cosignatory_addresses = cosignatory_addresses
        self.multisig_addresses = multisig_addresses

    @property
    def account_address(self):
        """Gets the account_address of this MultisigDTO.  # noqa: E501

        Address expressed in hexadecimal base.  # noqa: E501

        :return: The account_address of this MultisigDTO.  # noqa: E501
        :rtype: str
        """
        return self._account_address

    @account_address.setter
    def account_address(self, account_address):
        """Sets the account_address of this MultisigDTO.

        Address expressed in hexadecimal base.  # noqa: E501

        :param account_address: The account_address of this MultisigDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and account_address is None:  # noqa: E501
            raise ValueError("Invalid value for `account_address`, must not be `None`")  # noqa: E501

        self._account_address = account_address

    @property
    def min_approval(self):
        """Gets the min_approval of this MultisigDTO.  # noqa: E501

        Number of signatures needed to approve a transaction.  # noqa: E501

        :return: The min_approval of this MultisigDTO.  # noqa: E501
        :rtype: int
        """
        return self._min_approval

    @min_approval.setter
    def min_approval(self, min_approval):
        """Sets the min_approval of this MultisigDTO.

        Number of signatures needed to approve a transaction.  # noqa: E501

        :param min_approval: The min_approval of this MultisigDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and min_approval is None:  # noqa: E501
            raise ValueError("Invalid value for `min_approval`, must not be `None`")  # noqa: E501

        self._min_approval = min_approval

    @property
    def min_removal(self):
        """Gets the min_removal of this MultisigDTO.  # noqa: E501

        Number of signatures needed to remove a cosignatory.  # noqa: E501

        :return: The min_removal of this MultisigDTO.  # noqa: E501
        :rtype: int
        """
        return self._min_removal

    @min_removal.setter
    def min_removal(self, min_removal):
        """Sets the min_removal of this MultisigDTO.

        Number of signatures needed to remove a cosignatory.  # noqa: E501

        :param min_removal: The min_removal of this MultisigDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and min_removal is None:  # noqa: E501
            raise ValueError("Invalid value for `min_removal`, must not be `None`")  # noqa: E501

        self._min_removal = min_removal

    @property
    def cosignatory_addresses(self):
        """Gets the cosignatory_addresses of this MultisigDTO.  # noqa: E501

        Addresses of the cosignatory accounts.  # noqa: E501

        :return: The cosignatory_addresses of this MultisigDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._cosignatory_addresses

    @cosignatory_addresses.setter
    def cosignatory_addresses(self, cosignatory_addresses):
        """Sets the cosignatory_addresses of this MultisigDTO.

        Addresses of the cosignatory accounts.  # noqa: E501

        :param cosignatory_addresses: The cosignatory_addresses of this MultisigDTO.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and cosignatory_addresses is None:  # noqa: E501
            raise ValueError("Invalid value for `cosignatory_addresses`, must not be `None`")  # noqa: E501

        self._cosignatory_addresses = cosignatory_addresses

    @property
    def multisig_addresses(self):
        """Gets the multisig_addresses of this MultisigDTO.  # noqa: E501

        Multisig accounts where the account is cosignatory.  # noqa: E501

        :return: The multisig_addresses of this MultisigDTO.  # noqa: E501
        :rtype: list[str]
        """
        return self._multisig_addresses

    @multisig_addresses.setter
    def multisig_addresses(self, multisig_addresses):
        """Sets the multisig_addresses of this MultisigDTO.

        Multisig accounts where the account is cosignatory.  # noqa: E501

        :param multisig_addresses: The multisig_addresses of this MultisigDTO.  # noqa: E501
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and multisig_addresses is None:  # noqa: E501
            raise ValueError("Invalid value for `multisig_addresses`, must not be `None`")  # noqa: E501

        self._multisig_addresses = multisig_addresses

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultisigDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MultisigDTO):
            return True

        return self.to_dict() != other.to_dict()
