"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AliasTargetInstance = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const instance_1 = require("./instance");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Instance that uses Route 53 Alias record type. Currently, the only resource types supported are Elastic Load
 * Balancers.
 *
 * @resource AWS::ServiceDiscovery::Instance
 */
class AliasTargetInstance extends instance_1.InstanceBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_AliasTargetInstanceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.service.namespace.type === namespace_1.NamespaceType.HTTP) {
            throw new Error('Namespace associated with Service must be a DNS Namespace.');
        }
        // Should already be enforced when creating service, but validates if service is not instantiated with #createService
        const dnsRecordType = props.service.dnsRecordType;
        if (dnsRecordType !== service_1.DnsRecordType.A
            && dnsRecordType !== service_1.DnsRecordType.AAAA
            && dnsRecordType !== service_1.DnsRecordType.A_AAAA) {
            throw new Error('Service must use `A` or `AAAA` records to register an AliasRecordTarget.');
        }
        if (props.service.routingPolicy !== service_1.RoutingPolicy.WEIGHTED) {
            throw new Error('Service must use `WEIGHTED` routing policy.');
        }
        const resource = new servicediscovery_generated_1.CfnInstance(this, 'Resource', {
            instanceAttributes: {
                AWS_ALIAS_DNS_NAME: props.dnsName,
                ...props.customAttributes,
            },
            instanceId: props.instanceId || core_1.Names.uniqueId(this),
            serviceId: props.service.serviceId,
        });
        this.service = props.service;
        this.instanceId = resource.ref;
        this.dnsName = props.dnsName;
    }
}
exports.AliasTargetInstance = AliasTargetInstance;
_a = JSII_RTTI_SYMBOL_1;
AliasTargetInstance[_a] = { fqn: "@aws-cdk/aws-servicediscovery.AliasTargetInstance", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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