"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrivateDnsNamespace = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Service Discovery HTTP Namespace
 */
class PrivateDnsNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_PrivateDnsNamespaceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.vpc === undefined) {
            throw new Error('VPC must be specified for PrivateDNSNamespaces');
        }
        const ns = new servicediscovery_generated_1.CfnPrivateDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
            vpc: props.vpc.vpcId,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PRIVATE;
    }
    static fromPrivateDnsNamespaceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_PrivateDnsNamespaceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPrivateDnsNamespaceAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PRIVATE;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get privateDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get privateDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get privateDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicediscovery_DnsServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createService);
            }
            throw error;
        }
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PrivateDnsNamespace = PrivateDnsNamespace;
_a = JSII_RTTI_SYMBOL_1;
PrivateDnsNamespace[_a] = { fqn: "@aws-cdk/aws-servicediscovery.PrivateDnsNamespace", version: "1.157.0" };
//# sourceMappingURL=data:application/json;base64,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