# mypy-boto3-workdocs

[![PyPI - mypy-boto3-workdocs](https://img.shields.io/pypi/v/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workdocs.svg?color=blue)](https://pypi.org/project/mypy-boto3-workdocs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-workdocs](#mypy-boto3-workdocs)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.WorkDocs 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/workdocs.html#WorkDocs) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-workdocs](#mypy-boto3-workdocs)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkDocs` service.

```bash
python -m pip install boto3-stubs[workdocs]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_workdocs` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_workdocs import WorkDocsClient

# Now mypy can check if your code is valid.
client: WorkDocsClient = boto3.client("workdocs")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkDocsClient = session.client("workdocs")



# Annotated paginators are included as well

import mypy_boto3_workdocs.paginator as workdocs_paginators

describe_activities_paginator: workdocs_paginators.DescribeActivitiesPaginator = client.get_paginator("describe_activities")
describe_comments_paginator: workdocs_paginators.DescribeCommentsPaginator = client.get_paginator("describe_comments")
describe_document_versions_paginator: workdocs_paginators.DescribeDocumentVersionsPaginator = client.get_paginator("describe_document_versions")
describe_folder_contents_paginator: workdocs_paginators.DescribeFolderContentsPaginator = client.get_paginator("describe_folder_contents")
describe_groups_paginator: workdocs_paginators.DescribeGroupsPaginator = client.get_paginator("describe_groups")
describe_notification_subscriptions_paginator: workdocs_paginators.DescribeNotificationSubscriptionsPaginator = client.get_paginator("describe_notification_subscriptions")
describe_resource_permissions_paginator: workdocs_paginators.DescribeResourcePermissionsPaginator = client.get_paginator("describe_resource_permissions")
describe_root_folders_paginator: workdocs_paginators.DescribeRootFoldersPaginator = client.get_paginator("describe_root_folders")
describe_users_paginator: workdocs_paginators.DescribeUsersPaginator = client.get_paginator("describe_users")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_workdocs` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_workdocs as workdocs
from mypy_boto3_workdocs import WorkDocsClient

# with these
from mypy_boto3 import workdocs
from mypy_boto3.workdocs import WorkDocsClient
```