[![triaxtec](https://circleci.com/gh/triaxtec/openapi-python-client.svg?style=svg)](https://circleci.com/gh/triaxtec/openapi-python-client)
[![codecov](https://codecov.io/gh/triaxtec/openapi-python-client/branch/main/graph/badge.svg)](https://codecov.io/gh/triaxtec/openapi-python-client)
[![MIT license](https://img.shields.io/badge/License-MIT-blue.svg)](https://lbesson.mit-license.org/)
[![Generic badge](https://img.shields.io/badge/type_checked-mypy-informational.svg)](https://mypy.readthedocs.io/en/stable/introduction.html)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)
[![PyPI version shields.io](https://img.shields.io/pypi/v/openapi-python-client.svg)](https://pypi.python.org/pypi/openapi-python-client/)
[![Downloads](https://static.pepy.tech/personalized-badge/openapi-python-client?period=total&units=international_system&left_color=blue&right_color=green&left_text=Downloads)](https://pepy.tech/project/openapi-python-client)

# openapi-python-client

Generate modern Python clients from OpenAPI 3.x documents.

_This generator does not support OpenAPI 2.x FKA Swagger. If you need to use an older document, try upgrading it to
version 3 first with one of many available converters._

**This project is still in development and does not support all OpenAPI features**

## Why This?

The Python clients generated by openapi-generator support Python 2 and therefore come with a lot of baggage. This tool
aims to generate clients which:

1. Use all the latest and greatest Python features like type annotations and dataclasses
1. Don't carry around a bunch of compatibility code for older version of Python (e.g. the `six` package)
1. Have better documentation and more obvious usage instructions

Additionally, because this generator is written in Python, it should be more accessible to contribution by the people
using it (Python developers).

## Installation

I recommend you install with [pipx](https://pipxproject.github.io/pipx/) so you don't conflict with any other packages
you might have: `pipx install openapi-python-client`.

Better yet, use `pipx run openapi-python-client <normal params / options>` to always use the latest version of the generator.

You can install with normal pip if you want to though: `pip install openapi-python-client`

Then, if you want tab completion: `openapi-python-client --install-completion`

## Usage

### Create a new client

`openapi-python-client generate --url https://my.api.com/openapi.json`

This will generate a new client library named based on the title in your OpenAPI spec. For example, if the title
of your API is "My API", the expected output will be "my-api-client". If a folder already exists by that name, you'll
get an error.

### Update an existing client

`openapi-python-client update --url https://my.api.com/openapi.json`

> For more usage details run `openapi-python-client --help` or read [usage](usage.md)

## What You Get

1. A `pyproject.toml` file with some basic metadata intended to be used with [Poetry].
1. A `README.md` you'll most definitely need to update with your project's details
1. A Python module named just like the auto-generated project name (e.g. "my_api_client") which contains:
   1. A `client` module which will have both a `Client` class and an `AuthenticatedClient` class. You'll need these
      for calling the functions in the `api` module.
   1. An `api` module which will contain one module for each tag in your OpenAPI spec, as well as a `default` module
      for endpoints without a tag. Each of these modules in turn contains one function for calling each endpoint.
   1. A `models` module which has all the classes defined by the various schemas in your OpenAPI spec

For a full example you can look at the `end_to_end_tests` directory which has an `openapi.json` file.
"golden-record" in that same directory is the generated client from that OpenAPI document.

## OpenAPI features supported

1. All HTTP Methods
1. JSON and form bodies, path and query parameters
1. File uploads with multipart/form-data bodies
1. float, string, int, date, datetime, string enums, and custom schemas or lists containing any of those
1. html/text or application/json responses containing any of the previous types
1. Bearer token security

## Configuration

You can pass a YAML (or JSON) file to openapi-python-client with the `--config` option in order to change some behavior.
The following parameters are supported:

### class_overrides

Used to change the name of generated model classes. This param should be a mapping of existing class name
(usually a key in the "schemas" section of your OpenAPI document) to class_name and module_name. As an example, if the
name of the a model in OpenAPI (and therefore the generated class name) was something like "\_PrivateInternalLongName"
and you want the generated client's model to be called "ShortName" in a module called "short_name" you could do this:

Example:

```yaml
class_overrides:
  _PrivateInternalLongName:
    class_name: ShortName
    module_name: short_name
```

The easiest way to find what needs to be overridden is probably to generate your client and go look at everything in the
models folder.

### project_name_override and package_name_override

Used to change the name of generated client library project/package. If the project name is changed but an override for the package name
isn't provided, the package name will be converted from the project name using the standard convention (replacing `-`'s with `_`'s).

Example:

```yaml
project_name_override: my-special-project-name
package_name_override: my_extra_special_package_name
```

### field_prefix

When generating properties, the `name` attribute of the OpenAPI schema will be used. When the `name` is not a valid
Python identifier (e.g. begins with a number) this string will be prepended. Defaults to "field\_".

Example:

```yaml
field_prefix: attr_
```

### package_version_override

Specify the package version of the generated client. If unset, the client will use the version of the OpenAPI spec.

Example:

```yaml
package_version_override: 1.2.3
```

[changelog.md]: CHANGELOG.md
[poetry]: https://python-poetry.org/
