# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.1.2  # noqa: E501
    The version of the OpenAPI document: 0.9.4
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class StatementsDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'transaction_statements': 'list[TransactionStatementDTO]',
        'address_resolution_statements': 'list[ResolutionStatementDTO]',
        'mosaic_resolution_statements': 'list[ResolutionStatementDTO]'
    }

    attribute_map = {
        'transaction_statements': 'transactionStatements',
        'address_resolution_statements': 'addressResolutionStatements',
        'mosaic_resolution_statements': 'mosaicResolutionStatements'
    }

    def __init__(self, transaction_statements=None, address_resolution_statements=None, mosaic_resolution_statements=None, local_vars_configuration=None):  # noqa: E501
        """StatementsDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._transaction_statements = None
        self._address_resolution_statements = None
        self._mosaic_resolution_statements = None
        self.discriminator = None

        self.transaction_statements = transaction_statements
        self.address_resolution_statements = address_resolution_statements
        self.mosaic_resolution_statements = mosaic_resolution_statements

    @property
    def transaction_statements(self):
        """Gets the transaction_statements of this StatementsDTO.  # noqa: E501

        Array of transaction statements for the block requested.  # noqa: E501

        :return: The transaction_statements of this StatementsDTO.  # noqa: E501
        :rtype: list[TransactionStatementDTO]
        """
        return self._transaction_statements

    @transaction_statements.setter
    def transaction_statements(self, transaction_statements):
        """Sets the transaction_statements of this StatementsDTO.

        Array of transaction statements for the block requested.  # noqa: E501

        :param transaction_statements: The transaction_statements of this StatementsDTO.  # noqa: E501
        :type: list[TransactionStatementDTO]
        """
        if self.local_vars_configuration.client_side_validation and transaction_statements is None:  # noqa: E501
            raise ValueError("Invalid value for `transaction_statements`, must not be `None`")  # noqa: E501

        self._transaction_statements = transaction_statements

    @property
    def address_resolution_statements(self):
        """Gets the address_resolution_statements of this StatementsDTO.  # noqa: E501

        Array of address resolutions for the block requested.  # noqa: E501

        :return: The address_resolution_statements of this StatementsDTO.  # noqa: E501
        :rtype: list[ResolutionStatementDTO]
        """
        return self._address_resolution_statements

    @address_resolution_statements.setter
    def address_resolution_statements(self, address_resolution_statements):
        """Sets the address_resolution_statements of this StatementsDTO.

        Array of address resolutions for the block requested.  # noqa: E501

        :param address_resolution_statements: The address_resolution_statements of this StatementsDTO.  # noqa: E501
        :type: list[ResolutionStatementDTO]
        """
        if self.local_vars_configuration.client_side_validation and address_resolution_statements is None:  # noqa: E501
            raise ValueError("Invalid value for `address_resolution_statements`, must not be `None`")  # noqa: E501

        self._address_resolution_statements = address_resolution_statements

    @property
    def mosaic_resolution_statements(self):
        """Gets the mosaic_resolution_statements of this StatementsDTO.  # noqa: E501

        Array of mosaic resolutions for the block requested.  # noqa: E501

        :return: The mosaic_resolution_statements of this StatementsDTO.  # noqa: E501
        :rtype: list[ResolutionStatementDTO]
        """
        return self._mosaic_resolution_statements

    @mosaic_resolution_statements.setter
    def mosaic_resolution_statements(self, mosaic_resolution_statements):
        """Sets the mosaic_resolution_statements of this StatementsDTO.

        Array of mosaic resolutions for the block requested.  # noqa: E501

        :param mosaic_resolution_statements: The mosaic_resolution_statements of this StatementsDTO.  # noqa: E501
        :type: list[ResolutionStatementDTO]
        """
        if self.local_vars_configuration.client_side_validation and mosaic_resolution_statements is None:  # noqa: E501
            raise ValueError("Invalid value for `mosaic_resolution_statements`, must not be `None`")  # noqa: E501

        self._mosaic_resolution_statements = mosaic_resolution_statements

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StatementsDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StatementsDTO):
            return True

        return self.to_dict() != other.to_dict()
