/*
 * Definitions for libfvde
 *
 * Copyright (C) 2011-2022, Omar Choudary <choudary.omar@gmail.com>,
 *                          Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFVDE_DEFINITIONS_H )
#define _LIBFVDE_DEFINITIONS_H

#include <libfvde/types.h>

#define LIBFVDE_VERSION				20220807

/* The version string
 */
#define LIBFVDE_VERSION_STRING			"20220807"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFVDE_ACCESS_FLAGS
{
	LIBFVDE_ACCESS_FLAG_READ		= 0x01,
/* Reserved: not supported yet */
	LIBFVDE_ACCESS_FLAG_WRITE		= 0x02
};

/* The file access macros
 */
#define LIBFVDE_OPEN_READ			( LIBFVDE_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFVDE_OPEN_WRITE			( LIBFVDE_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFVDE_OPEN_READ_WRITE			( LIBFVDE_ACCESS_FLAG_READ | LIBFVDE_ACCESS_FLAG_WRITE )

/* The encryption methods
 */
enum LIBFVDE_ENCRYPTION_METHODS
{
	LIBFVDE_ENCRYPTION_METHOD_AES_128_XTS	= 2
};

#define LIBFVDE_ENCRYPTION_METHOD_AES_XTS	LIBFVDE_ENCRYPTION_METHOD_AES_128_XTS

#endif /* !defined( _LIBFVDE_DEFINITIONS_H ) */

