"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipelineAnchoreInlineScanAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codebuild_1 = require("aws-cdk-lib/aws-codebuild");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_codepipeline_actions_1 = require("aws-cdk-lib/aws-codepipeline-actions");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
class CodePipelineAnchoreInlineScanAction extends aws_codepipeline_actions_1.Action {
    constructor(props) {
        super({
            ...props,
            category: aws_codepipeline_1.ActionCategory.TEST,
            provider: 'CodeBuild',
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.input],
        });
        this.props = props;
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     */
    bound(scope, _stage, options) {
        var _b, _c, _d;
        const { account, region } = aws_cdk_lib_1.Stack.of(scope);
        const buildImage = aws_codebuild_1.LinuxBuildImage.STANDARD_4_0;
        const version = (_b = this.props.version) !== null && _b !== void 0 ? _b : 'v0.8.2';
        const timeout = (_c = this.props.timeout) !== null && _c !== void 0 ? _c : 300;
        const policyBundlePath = (_d = this.props.policyBundlePath) !== null && _d !== void 0 ? _d : './policy_bundle.json';
        const url = `https://ci-tools.anchore.io/inline_scan-${version}`;
        const project = new aws_codebuild_1.PipelineProject(scope, 'VulnScanProject', {
            cache: aws_codebuild_1.Cache.local(aws_codebuild_1.LocalCacheMode.DOCKER_LAYER),
            role: this.props.projectRole,
            environment: {
                buildImage,
                computeType: this.props.computeType || buildImage.defaultComputeType,
                privileged: true,
            },
            environmentVariables: this.props.customAnchoreImage
                ? {
                    ANCHORE_CI_IMAGE: {
                        value: this.props.customAnchoreImage,
                    },
                }
                : undefined,
            buildSpec: aws_codebuild_1.BuildSpec.fromObject({
                version: '0.2',
                phases: {
                    pre_build: {
                        commands: [
                            'echo Build started on `date`',
                            'docker build -t image2scan:ci .',
                            'echo Build completed on `date`',
                            this.props.ecrLogin &&
                                `aws ecr get-login-password | docker login --username AWS --password-stdin ${account}.dkr.ecr.${region}.amazonaws.com`,
                        ],
                    },
                    build: {
                        commands: [
                            'echo Scan started on `date`',
                            `curl -s ${url} | if [ -f "${policyBundlePath}" ]; then bash -s -- -f -t ${timeout} -b ${policyBundlePath} image2scan:ci; else bash -s -- -f -t ${timeout} image2scan:ci; fi`,
                            'echo Scan completed on `date`',
                        ],
                    },
                },
            }),
        });
        // grant the Pipeline role the required permissions to this Project
        options.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            resources: [project.projectArn],
            actions: ['codebuild:BatchGetBuilds', 'codebuild:StartBuild', 'codebuild:StopBuild'],
        }));
        // allow the Project access to the Pipeline's artifact Bucket
        // but only if the project is not imported
        // (ie., has a role) - otherwise, the IAM library throws an error
        if (project.role) {
            options.bucket.grantRead(project);
        }
        return {
            configuration: {
                ProjectName: project.projectName,
            },
        };
    }
}
exports.CodePipelineAnchoreInlineScanAction = CodePipelineAnchoreInlineScanAction;
_a = JSII_RTTI_SYMBOL_1;
CodePipelineAnchoreInlineScanAction[_a] = { fqn: "@cloudcomponents/cdk-codepipeline-anchore-inline-scan-action.CodePipelineAnchoreInlineScanAction", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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