# AutoIt Obfuscator — Obfuscation for AutoIt Script Source Code (Python module)

AutoIt Obfuscator is a tool to modify AutoIt script source code in this way to
make an analysis of obfuscated code very difficult.

More technical details, downloads, documentation available at:

https://www.pelock.com/products/autoit-obfuscator

Online interface:

https://www.pelock.com/autoit-obfuscator/

## What is source code obfuscation?

Obfuscation is a process of transforming AutoIt source code into protected
version of itself. The script functionality stays the same, everything works
the same, but the source code is protected from analysis, all of the variables
are encrypted, strings are encrypted, our AutoIt Obfuscator uses multiple
obfuscation strategies to protect the real meaning of your AutoIt source code.

### AutoIt script example before obfuscation

```autoit
#include <MsgBoxConstants.au3>

Example()

Func Example()
    MsgBox($MB_SYSTEMMODAL, "AutoIt Obfuscator", "Hello World!")
EndFunc   ;==>Example
```

### After obfuscation

```autoit
;////////////////////////////////////////////////////////////////////////////////
;//
;// AutoIt Obfuscator v1.6 - Bartosz Wójcik
;//
;// Website : https://www.pelock.com/products/autoit-obfuscator
;// Version : v1.6
;// Date    : 12.02.2019
;//
;////////////////////////////////////////////////////////////////////////////////

#include <Array.au3>
#AutoIt3Wrapper_Run_AU3Check=n
#AutoIt3Wrapper_Tidy_Stop_OnError=n
Global Const $PJXGUIZCD_BLBNPXCAKF = Asc(StringMid("5048 - 63802 / 61356 - 46760 + 49538 + 986 / 48155 / 38256 * 36548", 13, 1))
Global Const $IQHVSFVQ_GDEQLHNE_LXAUDVB = Asc("B")
#OnAutoItStartRegister "func_2404"
Global Const $var_1734[2][9] = [[1434502304, 1899737849, 53227, 419289427, 47040], [2009489622, 191, 129885511, 129, 169, 87160687, 248, 39, 194065309]]
Global $g_fMwlucbarhfDfettnwOakvlmnft = Asc(StringMid("Switch 1189563010", 8, 1))
Global Const $pScctlg = Asc(StringMid("Switch 920584049", 4, 1))
Global Const $AYFFFQWO_ZJVLCG_MMWJOKII[2] = [64315, 1913058283]
Global Const $AUAHKACACE_METPFKOXMN = Asc(StringMid("If 1179754046 = 1179754046 Then", 6, 1))
Global $2TY_Wmv_uRBCh7ezKp57_iD_[13] = [9490, 104, 229, 244, 39, 38752, 246, 57928, 3527, 911671885, 164, 1646998871, 1934339029]
Global Const $eRkdpeDqbfs[12] = [115, 209, 105, 3114, 386062001, 187, 136, 47, 240, 68, 58717, 33]
Global $var_1033 = Asc(StringMid("Random(1, 877431152 + SRandom(699748890), 1)", 40, 1))
Global $z_J1lp_Bm8z3jQxzM_T_bkJh = Asc(StringMid("36818 * 17236 - 29768 + 60332 - 28318 + 58568 - 9687 / 26511", 28, 1))
Global Const $iAspcjtqyviFdclxYihbo[2][16] = [[8361, 22, 97558768, 2002462730, 64924, 40487, 29829, 1391976185, 2953, 53590, 1922164841,  _
141, 247, 185178278, 2144156334, 658488170],  _
[1162498777, 1630523494, 50295, 98160394, 27738, 24, 1215510276, 49941, 29539, 244,  _
190, 228]]
Global Const $xh_V0fqnRA3tx__Fn32O_KY6 = Asc(StringMid("Switch $YBGMRJRS_WATLF", 3, 1))
#OnAutoItStartRegister "PuoktkvpDpxmeVjjthxvkz"
Global $g_idKkpbwar = Asc(StringMid("Until 1", 2, 1))
Global Const $var_334 = Asc(StringMid('StringLen("AHYhZUfb1c")', 15, 1))
Global Const $iJywmyspTlvobgsyNzuqeod = Asc(StringMid("For $g_mYzcdeilReuzpvVnrilhoebp = To 22605.13367", 47, 1))
Global $IPHXVISKJ_QOUAE_XXXVXTPAJQ = 369349055
Global Const $DZAVPM_HTZJWK_UKOBEXYKH = Asc(StringMid("If 180531486 = 180531486 Then", 7, 1))
Global $OPTPBZT = Asc(StringMid("If 1 Then", 6, 1))
Global Const $DrFpXaEn_E3PuA_h7dsokx_[2][15] = [[17, 1316527860, 12807, 163, 58335, 121, 632403710, 407309945, 7361, 1098367531, 2027417068,  _
1978163885, 649740633, 174842048, 6564],  _
[238202181, 1592497914]]
Global Const $nJmbfrjs = 360681738
Global $JNRTEBG_EMOLLQH_GBGLSULE = Asc(StringMid("Until 1", 5, 1))
Global $LECfkNYh9iv_HMSE_q_bF_B1g = Asc(StringMid("Switch 1110268756", 7, 1))
#OnAutoItStartRegister "VbzycyWuigfdFunc"
Global $HOCESVIQCS_KXEON_MXANVI = 57
Global Const $eYxpxtlyaYfrseytXgprlk = Asc(StringMid("35530 * 16080 * 36824 * 12728 + 32911 / 5851 * 47256 - 57060 / 64531", 50, 1))
Global $idBnkygAhukgdxjmDwlvo = 167
Global $mMcdnmyhi = Asc(StringMid("Switch $var_4044", 8, 1))
Global $g_hNxjdsmDajiafmFhusvswd = 1607277328
Global $ZSGKHD = 11
Global $__fRzn_FizKcGeyCd_7UD6T4 = 32
Global $APKISIPHJN_RCKMQ = 30
Global $var_1606 = 24
Global $hYrfqrwzj = 20
Global $var_1992 = 385949832
Global $FACwrxC__bOx_DqtpbkoiV5 = 55
Global $OTHRLHPQ_NWQCXYZ = 553918465
Global $iMipvjBxwnezeEoglzjfcp = 31
Global $NBWJCMKP = 5
Global $EALTGJOQL = 49941
Global $FTMFUZ = 18
$NUQLJKCSJT_XIQUCIB = 1574311679
While $NUQLJKCSJT_XIQUCIB <> 2003186699
    If $NUQLJKCSJT_XIQUCIB = BitRotate(1727095684, -4, "D") Then
        $NUQLJKCSJT_XIQUCIB = 1895156625
        Global $var_1910 = X_zS_RjngRbCSLhB_JYSi_GpQ
    ElseIf $NUQLJKCSJT_XIQUCIB = BitRotate(2149036923, -31, "D") Then
        Global $y2k2rvT_Qn8e_ItuN4_N_o = func_1576
        $NUQLJKCSJT_XIQUCIB = 1046691353
    ElseIf BitRotate(3563010309, -$APKISIPHJN_RCKMQ, "D") = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 283711635
        Global $var_31 = func_1307
    ElseIf 1574311679 = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 1078083780
        Global $var_3825 = _ArrayToString
    ElseIf BitNOT(-290807858) = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 1809630104
        Global $vPfhhhhbxfu = StringReverse
    ElseIf 1536455240 = $NUQLJKCSJT_XIQUCIB Then
        $KCGSOKX_KUOFKHJV(4096, $vPfhhhhbxfu($var_31($IQHVSFVQ_GDEQLHNE_LXAUDVB)) & $vPfhhhhbxfu($pGzeso($mOvkfmsTxjikg, $LECfkNYh9iv_HMSE_q_bF_B1g, $OPTPBZT, $PJXGUIZCD_BLBNPXCAKF)) & $xY5Qs5Z0_u8C5U6ww__asd_($var_3461($mOvkfmsTxjikg), $JOBMU_CYEYQY(($PJXGUIZCD_BLBNPXCAKF < $AYFFFQWO_ZJVLCG_MMWJOKII[0] ? 35 : $AUAHKACACE_METPFKOXMN),  _
$LECfkNYh9iv_HMSE_q_bF_B1g)),  _
$var_3655($var_3224($mMcdnmyhi), (-($OPTPBZT >= $WYVAMI_SWNMWE_JKYRXLPYMC ? $HOCESVIQCS_KXEON_MXANVI : 51) + $DZAVPM_HTZJWK_UKOBEXYKH)) & $xY5Qs5Z0_u8C5U6ww__asd_($y2k2rvT_Qn8e_ItuN4_N_o($iJywmyspTlvobgsyNzuqeod, $DrFpXaEn_E3PuA_h7dsokx_[1][($ElvYDa_G2t3SA_7h_R_A8b() <= $IQHVSFVQ_GDEQLHNE_LXAUDVB ? $2TY_Wmv_uRBCh7ezKp57_iD_[3] : 1)],  _
$var_334, $PJXGUIZCD_BLBNPXCAKF),  _
$var_2958(($idBnkygAhukgdxjmDwlvo > $var_1033 ? 448 : $PJXGUIZCD_BLBNPXCAKF), -$pSrbka, $var_3729($z_J1lp_Bm8z3jQxzM_T_bkJh, ($ElvYDa_G2t3SA_7h_R_A8b() >= $var_1734[0][0] ? $var_1910() : 2015840269)))))
        $NUQLJKCSJT_XIQUCIB = 2003186699
    ElseIf BitXOR(91809741, $eRkdpeDqbfs[5]) = $NUQLJKCSJT_XIQUCIB Then
        ContinueLoop
    ElseIf 471528102 = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 3106551
        Global $ElvYDa_G2t3SA_7h_R_A8b = HwtlimtEjlbxrqFunc
    ElseIf $NUQLJKCSJT_XIQUCIB = 1809630104 Then
        Global $xY5Qs5Z0_u8C5U6ww__asd_ = StringTrimLeft
        $NUQLJKCSJT_XIQUCIB = 1161483127
    ElseIf (543228798 - $mMcdnmyhi) = $NUQLJKCSJT_XIQUCIB Then
        Global $PqANE__QZXLY7Y_LJxA = ChrW
        $NUQLJKCSJT_XIQUCIB = 1181685304
    ElseIf 351485739 = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 471528102
        Global $var_3655 = StringTrimRight
    ElseIf $NUQLJKCSJT_XIQUCIB = 1046691353 Then
        $NUQLJKCSJT_XIQUCIB = 467070804
        Global $var_3224 = ir_zX_mTCYNCrERLGW_
    ElseIf 1078083780 = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 116092487
        Global $var_3461 = NjcqiFunc
    ElseIf $NUQLJKCSJT_XIQUCIB = BitNOT(-467070805) Then
        Global $KCGSOKX_KUOFKHJV = MsgBox
        $NUQLJKCSJT_XIQUCIB = 1938230762
    ElseIf $NUQLJKCSJT_XIQUCIB = 116092487 Then
        $NUQLJKCSJT_XIQUCIB = 543228762
        Global $var_2958 = BitRotate
    ElseIf BitRotate(1649165220, -$FTMFUZ, "D") = $NUQLJKCSJT_XIQUCIB Then
        Global $pGzeso = NChkg__HUoGt_NW
        $NUQLJKCSJT_XIQUCIB = 290807857
    ElseIf BitOR(36, $var_1992) = $NUQLJKCSJT_XIQUCIB Then
        ExitLoop 3
    ElseIf $NUQLJKCSJT_XIQUCIB = 1161483127 Then
        $NUQLJKCSJT_XIQUCIB = 1536455240
        Global $pSrbka = ($g_idKkpbwar <= $AUAHKACACE_METPFKOXMN ? $iJywmyspTlvobgsyNzuqeod : 6)
    ElseIf 1895156625 = $NUQLJKCSJT_XIQUCIB Then
        Global $FJKNDXJAJ_KJKFBIX = Chr
        $NUQLJKCSJT_XIQUCIB = 351485739
    ElseIf $NUQLJKCSJT_XIQUCIB = (1938230705 + $HOCESVIQCS_KXEON_MXANVI) Then
        Global $var_3729 = Wkvuwggtq
        $NUQLJKCSJT_XIQUCIB = 625905553
    ElseIf $NUQLJKCSJT_XIQUCIB = -(-625905553) Then
        Global $JOBMU_CYEYQY = BitXOR
        $NUQLJKCSJT_XIQUCIB = 2086443659
    ElseIf $NUQLJKCSJT_XIQUCIB = BitOR(1449268234, $OTHRLHPQ_NWQCXYZ) Then
        $NUQLJKCSJT_XIQUCIB = 2050800922
    ElseIf -(-2086443659) = $NUQLJKCSJT_XIQUCIB Then
        $NUQLJKCSJT_XIQUCIB = 1367139351
        Global $_sCvp2K__unadFlZMl = BitAND
    EndIf
WEnd
Func HwtlimtEjlbxrqFunc()
    return 1167152560
EndFunc
Func func_1576($BHOAMS_EGLSYJ, $GJQNZWDFE_TCOSPHWJZQ, $KWY__Ryq9HYUNL2p_K, $tagGktzb)
    $DYNWG = 1775521765
    While $DYNWG <> 195926247
        Switch $DYNWG
            Case 1455032128
                For $hYvepqahiQbxvbx = 0 To ($PJXGUIZCD_BLBNPXCAKF < $z_J1lp_Bm8z3jQxzM_T_bkJh ? 11 : $AUAHKACACE_METPFKOXMN)
                    $JAPOXUARXF_YUQBEPH_JWQSUI = 1597486898
                    Do
                        Select
                            Case $JAPOXUARXF_YUQBEPH_JWQSUI = BitOR(4960, 980838415)
                                $LKODUQWCR_OESXBAHDE_ZWMDQ[$hYvepqahiQbxvbx] = $PqANE__QZXLY7Y_LJxA($XUAZOKMMI)
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 1817783971
                            Case BitNOT(-779184839) = $JAPOXUARXF_YUQBEPH_JWQSUI
                                $XUAZOKMMI = $_sCvp2K__unadFlZMl($XUAZOKMMI, ($JNRTEBG_EMOLLQH_GBGLSULE >= $var_1734[0][4] ? $PJXGUIZCD_BLBNPXCAKF : 65535))
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 980843375
                            Case BitRotate(862578171, -12, "D") = $JAPOXUARXF_YUQBEPH_JWQSUI
                                ContinueLoop 3
                            Case $JAPOXUARXF_YUQBEPH_JWQSUI = BitRotate(948161118, -$ZSGKHD, "D")
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 758215563
                                $XUAZOKMMI += ($xh_V0fqnRA3tx__Fn32O_KY6 >= $IPHXVISKJ_QOUAE_XXXVXTPAJQ ? $OPTPBZT : 45369)
                            Case $JAPOXUARXF_YUQBEPH_JWQSUI = 758215563
                                $XUAZOKMMI -= $hYvepqahiQbxvbx
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 779184838
                            Case $JAPOXUARXF_YUQBEPH_JWQSUI = (1597486841 + $HOCESVIQCS_KXEON_MXANVI)
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 1271337081
                                $XUAZOKMMI = $LKODUQWCR_OESXBAHDE_ZWMDQ[$hYvepqahiQbxvbx]
                            Case 1817783971 = $JAPOXUARXF_YUQBEPH_JWQSUI
                                $JAPOXUARXF_YUQBEPH_JWQSUI = 1768317062
                        EndSelect
                    Until $JAPOXUARXF_YUQBEPH_JWQSUI = 1817783971
                Next
                $DYNWG = 1940911502
            Case 195926247
                $DYNWG = 70728571
            Case 1940911502
                $DYNWG = 322818709
                Local $FZFICYQDL = $var_3825($LKODUQWCR_OESXBAHDE_ZWMDQ, "")
            Case 739273101
                ExitLoop
            Case 1775521765
                Local $LKODUQWCR_OESXBAHDE_ZWMDQ[12] = [($USNYRHRQ_OXJPXTQK_ROGGEIEA >= $2TY_Wmv_uRBCh7ezKp57_iD_[11] ? $DrFpXaEn_E3PuA_h7dsokx_[1][0] : 20266),  _
($xh_V0fqnRA3tx__Fn32O_KY6 >= $g_idKkpbwar ? $var_1910() : 20255), 0x4F10, ($mOvkfmsTxjikg > $WYVAMI_SWNMWE_JKYRXLPYMC ? 20283 : $var_1033),  _
($pScctlg > $LECfkNYh9iv_HMSE_q_bF_B1g ? 20261 : $eRkdpeDqbfs[7]), 0x4F44, ($eYxpxtlyaYfrseytXgprlk < $IQHVSFVQ_GDEQLHNE_LXAUDVB ? 20263 : $eRkdpeDqbfs[6]),  _
($DrFpXaEn_E3PuA_h7dsokx_[0][7] > $IQHVSFVQ_GDEQLHNE_LXAUDVB ? 20285 : $USNYRHRQ_OXJPXTQK_ROGGEIEA),  _
($AYFFFQWO_ZJVLCG_MMWJOKII[0] <= $mMcdnmyhi ? $var_1033 : 20289), ($g_fMwlucbarhfDfettnwOakvlmnft >= $AUAHKACACE_METPFKOXMN ? $AYFFFQWO_ZJVLCG_MMWJOKII[1] : 20284),  _
($pScctlg <= $var_1033 ? $HOCESVIQCS_KXEON_MXANVI : 20277), 0x4EF3]
                $DYNWG = 1455032128
            Case 382934162
                ExitLoop 3
            Case 322818709
                Return $FZFICYQDL
        EndSwitch
    WEnd
EndFunc
Func func_1307($l8OquiQo_RTa_ViLPg)
    $var_159 = 281680646
    While $var_159 <> 391617259
        Switch $var_159
            Case 1750995759
                ContinueLoop
            Case 1605941089
                Return $var_3825($BGSNXPAOS_YWCNIEDQFJ, "")
            Case 2051182158
                ContinueLoop
            Case 363144415
                $var_159 = 1605941089
                For $g_aInrfaimczhDzoelfSsnvp = ($iAspcjtqyviFdclxYihbo[0][0] > $var_1910() ? 0 : $DZAVPM_HTZJWK_UKOBEXYKH) To 11
                    $OLBUWDFUV = 1213699257
                    While $OLBUWDFUV <> 831207833
                        Select
                            Case $OLBUWDFUV = 618281526
                                $OLBUWDFUV = 532999087
                                $JDBPR += $g_aInrfaimczhDzoelfSsnvp
                            Case BitRotate(2029922141, $NBWJCMKP, "D") = $OLBUWDFUV
                                $OLBUWDFUV = 1140338200
                                $JDBPR = $var_2958($JDBPR, ($DZAVPM_HTZJWK_UKOBEXYKH > $g_fMwlucbarhfDfettnwOakvlmnft ? 8 : $IPHXVISKJ_QOUAE_XXXVXTPAJQ),  _
$FJKNDXJAJ_KJKFBIX(($var_1734[1][1] <= $PJXGUIZCD_BLBNPXCAKF ? $var_1910() : 87)))
                            Case 909976407 = $OLBUWDFUV
                                ContinueLoop 5
                            Case $OLBUWDFUV = 2098810491
                                $OLBUWDFUV = 618281526
                                $JDBPR = $JDBPR + ($JNRTEBG_EMOLLQH_GBGLSULE >= $var_1910() ? $z_J1lp_Bm8z3jQxzM_T_bkJh : 1)
                            Case (1140338253 - $DZAVPM_HTZJWK_UKOBEXYKH) = $OLBUWDFUV
                                $BGSNXPAOS_YWCNIEDQFJ[$g_aInrfaimczhDzoelfSsnvp] = $PqANE__QZXLY7Y_LJxA($_sCvp2K__unadFlZMl($JDBPR, ($idBnkygAhukgdxjmDwlvo < $USNYRHRQ_OXJPXTQK_ROGGEIEA ? 65535 : $USNYRHRQ_OXJPXTQK_ROGGEIEA)))
                                $OLBUWDFUV = 831207833
                            Case $OLBUWDFUV = 1213699257
                                $JDBPR = $BGSNXPAOS_YWCNIEDQFJ[$g_aInrfaimczhDzoelfSsnvp]
                                $OLBUWDFUV = 2098810491
                            Case $OLBUWDFUV = 831207833
                                $OLBUWDFUV = 1333698983
                            Case BitXOR(468345491, $g_idKkpbwar) = $OLBUWDFUV
                                ExitLoop 2
                        EndSelect
                    WEnd
                Next
            Case 391617259
                $var_159 = 1777746401
            Case 281680646
                $var_159 = 363144415
                Local $BGSNXPAOS_YWCNIEDQFJ[($USNYRHRQ_OXJPXTQK_ROGGEIEA > $LECfkNYh9iv_HMSE_q_bF_B1g ? 12 : $mOvkfmsTxjikg)] = [($IQHVSFVQ_GDEQLHNE_LXAUDVB >= $ElvYDa_G2t3SA_7h_R_A8b() ? $IPHXVISKJ_QOUAE_XXXVXTPAJQ : 29439),  _
0x74FE, ($LECfkNYh9iv_HMSE_q_bF_B1g >= $IQHVSFVQ_GDEQLHNE_LXAUDVB ? $var_1734[0][1] : 26109),  _
($xh_V0fqnRA3tx__Fn32O_KY6 > $var_1033 ? 25084 : $xh_V0fqnRA3tx__Fn32O_KY6), ($DrFpXaEn_E3PuA_h7dsokx_[1][1] > $xh_V0fqnRA3tx__Fn32O_KY6 ? 20219 : $pScctlg),  _
0x1FFA, ($OPTPBZT <= $g_fMwlucbarhfDfettnwOakvlmnft ? $iJywmyspTlvobgsyNzuqeod : 29689),  _
0x48F8, ($pScctlg > $g_idKkpbwar ? 28407 : $IQHVSFVQ_GDEQLHNE_LXAUDVB), ($eRkdpeDqbfs[5] < $IPHXVISKJ_QOUAE_XXXVXTPAJQ ? 29686 : $WYVAMI_SWNMWE_JKYRXLPYMC),  _
0x74F5, ($HOCESVIQCS_KXEON_MXANVI >= $iAspcjtqyviFdclxYihbo[0][7] ? $JNRTEBG_EMOLLQH_GBGLSULE : 16628)]
        EndSwitch
    WEnd
EndFunc
Func Wkvuwggtq($qdqOgb__0nnx7qKt_fTKF, $var_4012)
    $nBvgqxhzeb = 1319596902
    While $nBvgqxhzeb <> 1582757752
        Select
            Case $nBvgqxhzeb = 1582757752
                $nBvgqxhzeb = 706218745
            Case $nBvgqxhzeb = 246473840
                ExitLoop
            Case 1008675139 = $nBvgqxhzeb
                Return $p7QxJvUWwOi__Po_Jdg_G0g
            Case BitXOR(1125823083, $mOvkfmsTxjikg) = $nBvgqxhzeb
                Local $zr7__wvmx_P3Cr7fRsQVYL1P_[($DZAVPM_HTZJWK_UKOBEXYKH >= $AUAHKACACE_METPFKOXMN ? $HOCESVIQCS_KXEON_MXANVI : 1)] = [($ElvYDa_G2t3SA_7h_R_A8b() > $LECfkNYh9iv_HMSE_q_bF_B1g ? 39463 : $idBnkygAhukgdxjmDwlvo)]
                $nBvgqxhzeb = 1241632207
            Case $nBvgqxhzeb = 1241632207
                For $var_2186 = ($var_334 < $2TY_Wmv_uRBCh7ezKp57_iD_[5] ? 0 : $ElvYDa_G2t3SA_7h_R_A8b()) To ($var_1910() > $IQHVSFVQ_GDEQLHNE_LXAUDVB ? 0 : $AYFFFQWO_ZJVLCG_MMWJOKII[1])
                    $F3F1IY__qyhdi7Q_ = 288592328
                    Do
                        Select
                            Case $F3F1IY__qyhdi7Q_ = 1779233393
                                $F3F1IY__qyhdi7Q_ = 988261952
                                $zr7__wvmx_P3Cr7fRsQVYL1P_[$var_2186] = $PqANE__QZXLY7Y_LJxA($_sCvp2K__unadFlZMl($g_pZkkpwkcjm, ($AUAHKACACE_METPFKOXMN < $DrFpXaEn_E3PuA_h7dsokx_[1][1] ? 65535 : $AYFFFQWO_ZJVLCG_MMWJOKII[0])))
                            Case $F3F1IY__qyhdi7Q_ = BitXOR(1634531040, $2TY_Wmv_uRBCh7ezKp57_iD_[6])
                                $F3F1IY__qyhdi7Q_ = 810788037
                                $g_pZkkpwkcjm = $JOBMU_CYEYQY($g_pZkkpwkcjm, ($var_1734[0][2] > $eYxpxtlyaYfrseytXgprlk ? 39523 : $HOCESVIQCS_KXEON_MXANVI))
                            Case 288592328 = $F3F1IY__qyhdi7Q_
                                $F3F1IY__qyhdi7Q_ = 600087806
                                $g_pZkkpwkcjm = $zr7__wvmx_P3Cr7fRsQVYL1P_[$var_2186]
                            Case $F3F1IY__qyhdi7Q_ = BitRotate(30883186, -27, "D")
                                $F3F1IY__qyhdi7Q_ = 464824416
                            Case (1166898818 + $USNYRHRQ_OXJPXTQK_ROGGEIEA) = $F3F1IY__qyhdi7Q_
                                ContinueLoop 6
                            Case BitNOT(-745987547) = $F3F1IY__qyhdi7Q_
                                ContinueLoop
                            Case BitRotate(827069673, -22, "D") = $F3F1IY__qyhdi7Q_
                                $g_pZkkpwkcjm -= $var_2186
                                $F3F1IY__qyhdi7Q_ = 1779233393
                            Case BitXOR(1716898126, HwtlimtEjlbxrqFunc()) = $F3F1IY__qyhdi7Q_
                                $g_pZkkpwkcjm -= $var_2186
                                $F3F1IY__qyhdi7Q_ = 1634530838
                        EndSelect
                    Until $F3F1IY__qyhdi7Q_ = 988261952
                Next
                $nBvgqxhzeb = 822808394
            Case 822808394 = $nBvgqxhzeb
                Local $p7QxJvUWwOi__Po_Jdg_G0g = $var_3825($zr7__wvmx_P3Cr7fRsQVYL1P_, "")
                $nBvgqxhzeb = 1008675139
        EndSelect
    WEnd
EndFunc
Func PuoktkvpDpxmeVjjthxvkz()
    Global $WYVAMI_SWNMWE_JKYRXLPYMC = 100
EndFunc
Func NChkg__HUoGt_NW($UOKPYXOH, $var_3462, $ZUTYQY_CLJYCRT, $iEcwtdogctzEsjnpiupjq)
    $XUYDZFH_DVMAYFLVTE = 906253577
    While $XUYDZFH_DVMAYFLVTE <> 2082667554
        Switch $XUYDZFH_DVMAYFLVTE
            Case 1713143451
                Return $g_fIwaofynOvmsvIofisif
            Case 2082667554
                $XUYDZFH_DVMAYFLVTE = 137685941
            Case 1919271764
                ExitLoop 6
            Case 939166193
                $XUYDZFH_DVMAYFLVTE = 1713143451
                Local $g_fIwaofynOvmsvIofisif = $var_3825($EALZKDKVQ_TXLBGSQEL, "")
            Case 906253577
                Local $EALZKDKVQ_TXLBGSQEL[($ElvYDa_G2t3SA_7h_R_A8b() > $IPHXVISKJ_QOUAE_XXXVXTPAJQ ? 2 : $iJywmyspTlvobgsyNzuqeod)] = [($mMcdnmyhi < $OPTPBZT ? 63704 : $DZAVPM_HTZJWK_UKOBEXYKH), ($var_1033 >= $iAspcjtqyviFdclxYihbo[1][0] ? $pScctlg : 63706)]
                $XUYDZFH_DVMAYFLVTE = 1267181407
            Case 1267181407
                For $UXHDA = 0 To ($WYVAMI_SWNMWE_JKYRXLPYMC <= $PJXGUIZCD_BLBNPXCAKF ? $AYFFFQWO_ZJVLCG_MMWJOKII[1] : 1)
                    $GARWJMHFQC_TJJWBSKALH = 301759863
                    Do
                        If $GARWJMHFQC_TJJWBSKALH = (2639584987 - $var_1734[0][0]) Then
                            $GARWJMHFQC_TJJWBSKALH = 504195749
                        ElseIf $GARWJMHFQC_TJJWBSKALH = 741937340 Then
                            ContinueLoop 7
                        ElseIf $GARWJMHFQC_TJJWBSKALH = BitOR(104, $g_hNxjdsmDajiafmFhusvswd) Then
                            $GARWJMHFQC_TJJWBSKALH = 41423373
                            $hSowbv = $hSowbv + ($DZAVPM_HTZJWK_UKOBEXYKH <= $PJXGUIZCD_BLBNPXCAKF ? $pScctlg : 1)
                        ElseIf 149972860 = $GARWJMHFQC_TJJWBSKALH Then
                            $EALZKDKVQ_TXLBGSQEL[$UXHDA] = $PqANE__QZXLY7Y_LJxA($_sCvp2K__unadFlZMl($hSowbv, ($g_idKkpbwar < $USNYRHRQ_OXJPXTQK_ROGGEIEA ? 65535 : $AYFFFQWO_ZJVLCG_MMWJOKII[0])))
                            $GARWJMHFQC_TJJWBSKALH = 1205082683
                        ElseIf $GARWJMHFQC_TJJWBSKALH = 41423373 Then
                            $hSowbv = $JOBMU_CYEYQY($hSowbv, 0xF8B8)
                            $GARWJMHFQC_TJJWBSKALH = 149972860
                        ElseIf BitRotate(1052477694, -15, "D") = $GARWJMHFQC_TJJWBSKALH Then
                            $GARWJMHFQC_TJJWBSKALH = 1607277432
                            $hSowbv = $EALZKDKVQ_TXLBGSQEL[$UXHDA]
                        EndIf
                    Until $GARWJMHFQC_TJJWBSKALH = 1205082683
                Next
                $XUYDZFH_DVMAYFLVTE = 939166193
            Case 1578857399
                ContinueLoop 2
        EndSwitch
    WEnd
EndFunc
Func ir_zX_mTCYNCrERLGW_($NHYHGA)
    $Knw9_KiweMwEAHI_mC_B3IO_ = 1809665303
    While $Knw9_KiweMwEAHI_mC_B3IO_ <> 1163149842
        If BitRotate(3762133085, 24, "D") = $Knw9_KiweMwEAHI_mC_B3IO_ Then
            ContinueLoop
        ElseIf 175210889 = $Knw9_KiweMwEAHI_mC_B3IO_ Then
            Return $u__x1_KgnYGz4_HF1FckdCs
        ElseIf BitRotate(3798172413, -24, "D") = $Knw9_KiweMwEAHI_mC_B3IO_ Then
            $Knw9_KiweMwEAHI_mC_B3IO_ = 175210889
            $u__x1_KgnYGz4_HF1FckdCs = $var_3825($u__x1_KgnYGz4_HF1FckdCs, "")
        ElseIf 1809665303 = $Knw9_KiweMwEAHI_mC_B3IO_ Then
            Local $u__x1_KgnYGz4_HF1FckdCs[($2TY_Wmv_uRBCh7ezKp57_iD_[2] <= $var_1910() ? $g_fMwlucbarhfDfettnwOakvlmnft : 9)] = [($var_1734[0][0] <= $z_J1lp_Bm8z3jQxzM_T_bkJh ? $PJXGUIZCD_BLBNPXCAKF : 34522), 0x842A,  _
($iJywmyspTlvobgsyNzuqeod < $pScctlg ? 33946 : $IQHVSFVQ_GDEQLHNE_LXAUDVB), ($IQHVSFVQ_GDEQLHNE_LXAUDVB < $AYFFFQWO_ZJVLCG_MMWJOKII[0] ? 33946 : $AYFFFQWO_ZJVLCG_MMWJOKII[1]),  _
0x848A, ($ElvYDa_G2t3SA_7h_R_A8b() > $var_1033 ? 32858 : $iJywmyspTlvobgsyNzuqeod),  _
($iAspcjtqyviFdclxYihbo[0][0] >= $DrFpXaEn_E3PuA_h7dsokx_[0][7] ? $iAspcjtqyviFdclxYihbo[1][10] : 34570),  _
($var_334 < $2TY_Wmv_uRBCh7ezKp57_iD_[8] ? 34666 : $g_idKkpbwar), ($mMcdnmyhi < $pScctlg ? 34442 : $var_1033)]
            $Knw9_KiweMwEAHI_mC_B3IO_ = 1235934186
        ElseIf $Knw9_KiweMwEAHI_mC_B3IO_ = 1163149842 Then
            $Knw9_KiweMwEAHI_mC_B3IO_ = 1129853936
        ElseIf 1235934186 = $Knw9_KiweMwEAHI_mC_B3IO_ Then
            $Knw9_KiweMwEAHI_mC_B3IO_ = 1669529058
            For $iGwmrpxuzqQqrgndb = ($var_334 < $iAspcjtqyviFdclxYihbo[1][2] ? 0 : $var_1910()) To ($var_334 >= $mOvkfmsTxjikg ? $nJmbfrjs : 8)
                $__edigoF2tdY9g6W4DMp_ = 478513363
                While $__edigoF2tdY9g6W4DMp_ <> 508238428
                    Select
                        Case 124763624 = $__edigoF2tdY9g6W4DMp_
                            $__edigoF2tdY9g6W4DMp_ = 672362033
                            $XMJQY_ZSOMIHR_MZGOUPZO = $XMJQY_ZSOMIHR_MZGOUPZO + ($eRkdpeDqbfs[10] > $HOCESVIQCS_KXEON_MXANVI ? 1 : $z_J1lp_Bm8z3jQxzM_T_bkJh)
                        Case $__edigoF2tdY9g6W4DMp_ = 478513363
                            $XMJQY_ZSOMIHR_MZGOUPZO = $u__x1_KgnYGz4_HF1FckdCs[$iGwmrpxuzqQqrgndb]
                            $__edigoF2tdY9g6W4DMp_ = 530637114
                        Case BitRotate(765928999, 16, "D") = $__edigoF2tdY9g6W4DMp_
                            $u__x1_KgnYGz4_HF1FckdCs[$iGwmrpxuzqQqrgndb] = $PqANE__QZXLY7Y_LJxA($_sCvp2K__unadFlZMl($XMJQY_ZSOMIHR_MZGOUPZO, 65535))
                            $__edigoF2tdY9g6W4DMp_ = 508238428
                        Case $__edigoF2tdY9g6W4DMp_ = BitXOR(365625850, $DrFpXaEn_E3PuA_h7dsokx_[0][13])
                            $__edigoF2tdY9g6W4DMp_ = 124763624
                            $XMJQY_ZSOMIHR_MZGOUPZO = $var_2958($XMJQY_ZSOMIHR_MZGOUPZO, -($HOCESVIQCS_KXEON_MXANVI < $ElvYDa_G2t3SA_7h_R_A8b() ? 4 : $xh_V0fqnRA3tx__Fn32O_KY6),  _
$FJKNDXJAJ_KJKFBIX(($2TY_Wmv_uRBCh7ezKp57_iD_[8] > $JNRTEBG_EMOLLQH_GBGLSULE ? 87 : $g_fMwlucbarhfDfettnwOakvlmnft)))
                        Case 1225841882 = $__edigoF2tdY9g6W4DMp_
                            ContinueLoop
                        Case $__edigoF2tdY9g6W4DMp_ = -(-212209534)
                            ContinueLoop
                        Case 508238428 = $__edigoF2tdY9g6W4DMp_
                            $__edigoF2tdY9g6W4DMp_ = 849549460
                        Case $__edigoF2tdY9g6W4DMp_ = BitNOT(-672362034)
                            $XMJQY_ZSOMIHR_MZGOUPZO = $JOBMU_CYEYQY($XMJQY_ZSOMIHR_MZGOUPZO, ($var_1910() >= $USNYRHRQ_OXJPXTQK_ROGGEIEA ? $xh_V0fqnRA3tx__Fn32O_KY6 : 43046))
                            $__edigoF2tdY9g6W4DMp_ = 640101799
                    EndSelect
                WEnd
            Next
        EndIf
    WEnd
EndFunc
Func VbzycyWuigfdFunc()
    Global $USNYRHRQ_OXJPXTQK_ROGGEIEA = 59052
EndFunc
Func NjcqiFunc($ZDKSHACNOE_SKYJRN_RHIXXP)
    $var_782 = 1681250164
    Do
        Select
            Case BitRotate(708860378, -$hYrfqrwzj, "D") = $var_782
                $var_782 = 1280636414
            Case -(-752292399) = $var_782
                ExitLoop 3
            Case 891815584 = $var_782
                $var_782 = 1896715630
                $nMnyseeuf = $var_3825($nMnyseeuf, "")
            Case $var_782 = 1699751851
                $var_782 = 891815584
                For $var_2548 = ($AYFFFQWO_ZJVLCG_MMWJOKII[0] > $USNYRHRQ_OXJPXTQK_ROGGEIEA ? 0 : $IPHXVISKJ_QOUAE_XXXVXTPAJQ) To ($IQHVSFVQ_GDEQLHNE_LXAUDVB >= $var_1910() ? $eRkdpeDqbfs[9] : 5)
                    $uziREiIY_51_zNw_ZD9bynj_ = 1213799128
                    Do
                        Select
                            Case $uziREiIY_51_zNw_ZD9bynj_ = 1213799128
                                $TowW_O_zqnL08jww_ = $nMnyseeuf[$var_2548]
                                $uziREiIY_51_zNw_ZD9bynj_ = 1928287720
                            Case BitRotate(456154220, -$var_1606, "D") = $uziREiIY_51_zNw_ZD9bynj_
                                $TowW_O_zqnL08jww_ = $JOBMU_CYEYQY($TowW_O_zqnL08jww_, $var_2548)
                                $uziREiIY_51_zNw_ZD9bynj_ = 2116861494
                            Case 1928287720 = $uziREiIY_51_zNw_ZD9bynj_
                                $TowW_O_zqnL08jww_ -= $var_2548
                                $uziREiIY_51_zNw_ZD9bynj_ = 811363355
                            Case $uziREiIY_51_zNw_ZD9bynj_ = -(-939565167)
                                $uziREiIY_51_zNw_ZD9bynj_ = 1874800700
                            Case (272622942 - $xh_V0fqnRA3tx__Fn32O_KY6) = $uziREiIY_51_zNw_ZD9bynj_
                                $nMnyseeuf[$var_2548] = $PqANE__QZXLY7Y_LJxA($TowW_O_zqnL08jww_)
                                $uziREiIY_51_zNw_ZD9bynj_ = 939565167
                            Case BitRotate(4055101797, 13, "D") = $uziREiIY_51_zNw_ZD9bynj_
                                $uziREiIY_51_zNw_ZD9bynj_ = 272622837
                                $TowW_O_zqnL08jww_ = $_sCvp2K__unadFlZMl($TowW_O_zqnL08jww_, ($AUAHKACACE_METPFKOXMN >= $var_334 ? $WYVAMI_SWNMWE_JKYRXLPYMC : 65535))
                            Case $uziREiIY_51_zNw_ZD9bynj_ = 1236802783
                                ExitLoop 6
                        EndSelect
                    Until $uziREiIY_51_zNw_ZD9bynj_ = 939565167
                Next
            Case $var_782 = BitRotate(948357815, -$iMipvjBxwnezeEoglzjfcp, "D")
                Return $nMnyseeuf
            Case $var_782 = (1681249997 + $idBnkygAhukgdxjmDwlvo)
                $var_782 = 1699751851
                Local $nMnyseeuf[($iJywmyspTlvobgsyNzuqeod >= $HOCESVIQCS_KXEON_MXANVI ? $var_1734[0][2] : 6)] = [($IQHVSFVQ_GDEQLHNE_LXAUDVB < $var_334 ? 90 : $var_1910()), ($mOvkfmsTxjikg > $eYxpxtlyaYfrseytXgprlk ? 68 : $g_idKkpbwar),  _
($OPTPBZT <= $mMcdnmyhi ? $iJywmyspTlvobgsyNzuqeod : 75), 0x007A, ($iJywmyspTlvobgsyNzuqeod < $IPHXVISKJ_QOUAE_XXXVXTPAJQ ? 111 : $mOvkfmsTxjikg),  _
($HOCESVIQCS_KXEON_MXANVI < $WYVAMI_SWNMWE_JKYRXLPYMC ? 124 : $var_334)]
        EndSelect
    Until $var_782 = 94216868
EndFunc
Func X_zS_RjngRbCSLhB_JYSi_GpQ()
    return 169
EndFunc
Func func_2404()
    Global $mOvkfmsTxjikg = 230539533
EndFunc
```

Would you even be able to tell what the obfuscated code does if you didn't
know about the original source code?

## AutoIt decompilation

Why should you obfuscate your scripts you might ask yourself? After all,
they are compiled to executable format, right?

Is it possible to decompile AutoIt compiled executables back to the source code?
Of course it's possible! Our company provides [source code recovery service](https://www.pelock.com/services/source-code-recovery) that
enables you to restore any AutoIt application back to its original source code.

## Protect your AutoIt scripts source code (Python)

If you're writing your software, bots, automation scripts or anything else in
AutoIt and you want to prevent others from decompiling your work to the original
source code form — AutoIt Obfuscator is for you.

#### Installation (for Python 3)

Preferred way of WebApi interface installation is via [pip](https://pypi.org/project/pip/).

Run:

```
pip install autoitobfuscator
```

or 

```
python3 -m pip install autoitobfuscator
```


And then add this import to your source code:

```python
from autoitobfuscator import AutoItObfuscator
```

Installation package is available at https://pypi.org/project/autoitobfuscator/

#### Alternative usage

If you don't want to use Python module, you can import directly from the file:

```python
from pelock.autoitobfuscator import AutoItObfuscator
```

#### Example of how to obfuscate AutoIt script with default options

```python
#!/usr/bin/env python

###############################################################################
#
# AutoIt Obfuscator WebApi interface usage example.
#
# In this example we will obfuscate sample source with default options.
#
# Version        : v1.0
# Language       : Python
# Author         : Bartosz Wójcik
# Web page       : https://www.pelock.com
#
###############################################################################

#
# include AutoIt Obfuscator module
#
from autoitobfuscator import AutoItObfuscator

#
# if you don't want to use Python module, you can import directly from the file
#
#from pelock.autoitobfuscator import AutoItObfuscator

#
# create AutoIt Obfuscator class instance (we are using our activation key)
#
myAutoItObfuscator = AutoItObfuscator("ABCD-ABCD-ABCD-ABCD")

#
# source code in AutoIt v3 format
#
scriptSourceCode = 'ConsoleWrite("Hello World")'

#
# by default all options are enabled, both helper random numbers
# generation & obfuscation strategies, so we can just simply call:
#
result = myAutoItObfuscator.obfuscate_script_source(scriptSourceCode)

#
# it's also possible to pass script path instead of a string with the source e.g.
#
# result = myAutoItObfuscator.obfuscate_script_file("/path/to/script/source.au3")

#
# result[] array holds the obfuscation results as well as other information
#
# result["error"]         - error code
# result["output"]        - obfuscated code
# result["demo"]          - was it used in demo mode (invalid or empty activation key was used)
# result["credits_left"]  - usage credits left after this operation
# result["credits_total"] - total number of credits for this activation code
# result["expired"]       - if this was the last usage credit for the activation key it will be set to True
#
if result and "error" in result:

    # display obfuscated code
    if result["error"] == AutoItObfuscator.ERROR_SUCCESS:

        # format output code for HTML display
        print(result["output"])

    else:
        print(f'An error occurred, error code: {result["error"]}')

else:
    print("Something unexpected happen while trying to obfuscate the code.")
```

#### Example of how to obfuscate AutoIt script using customized obfuscation strategies

```python
#!/usr/bin/env python

###############################################################################
#
# AutoIt Obfuscator WebApi interface usage example.
#
# In this example we will obfuscate sample source with default options.
#
# Version        : v1.0
# Language       : Python
# Author         : Bartosz Wójcik
# Web page       : https://www.pelock.com
#
###############################################################################

#
# include AutoIt Obfuscator module
#
from autoitobfuscator import AutoItObfuscator

#
# if you don't want to use Python module, you can import directly from the file
#
#from pelock.autoitobfuscator import AutoItObfuscator

#
# create AutoIt Obfuscator class instance (we are using our activation key)
#
myAutoItObfuscator = AutoItObfuscator("ABCD-ABCD-ABCD-ABCD")

#
# should the source code be compressed (both input & compressed)
#
myAutoItObfuscator.enableCompression = True

#
# generate random integer values
#
myAutoItObfuscator.randomIntegers = True

#
# generate random value characters
#
myAutoItObfuscator.randomCharacters = True

#
# generate random anti regular expression values
#
myAutoItObfuscator.randomAntiRegex = True

#
# generate arrays with random values
#
myAutoItObfuscator.randomArrays = True

#
# generate multidimensional arrays with random values
#
myAutoItObfuscator.randomArraysMultidimensional = True

#
# generate functions that returns random values
#
myAutoItObfuscator.randomFunctions = True

#
# generate autostarted random values
#
myAutoItObfuscator.randomAutostarted = True

#
# change linear code execution flow to nonlinear version
#
myAutoItObfuscator.mixCodeFlow = True

#
# rename variable names to random string values
#
myAutoItObfuscator.renameVariables = True

#
# rename function names to random string values
#
myAutoItObfuscator.renameFunctions = True

#
# rename function names in function calls
#
myAutoItObfuscator.renameFunctionCalls = True


#
# resolve WinApi constants to numerical values
#
myAutoItObfuscator.resolveConstants = True

#
# encrypt numbers into arithmetic and boolean expressions
#
myAutoItObfuscator.cryptNumbers = True

#
# split strings into series of random sized substrings
#
myAutoItObfuscator.splitStrings = True

#
# modify strings using built-it AutoIt string functions
#
myAutoItObfuscator.modifyStrings = True

#
# encrypt strings using polymorphic encryption algorithms
#
myAutoItObfuscator.cryptStrings = True

#
# insert ternary operators for numerical values
#
myAutoItObfuscator.insertTernaryOperators = True

#
# source code in AutoIt v3 format
#
scriptSourceCode = 'ConsoleWrite("Hello World")'

#
# by default all options are enabled, both helper random numbers
# generation & obfuscation strategies, so we can just simply call:
#
result = myAutoItObfuscator.obfuscate_script_source(scriptSourceCode)

#
# result[] array holds the obfuscation results as well as other information
#
# result["error"]         - error code
# result["output"]        - obfuscated code
# result["demo"]          - was it used in demo mode (invalid or empty activation key was used)
# result["credits_left"]  - usage credits left after this operation
# result["credits_total"] - total number of credits for this activation code
# result["expired"]       - if this was the last usage credit for the activation key it will be set to True
#
if result and "error" in result:

	# display obfuscated code
	if result["error"] == AutoItObfuscator.ERROR_SUCCESS:

		# format output code for HTML display
		print(result["output"])
	else:
		print(f'An error occurred, error code: {result["error"]}')

else:
	print("Something unexpected happen while trying to obfuscate the code.")
```

#### Example of how to check the activation key status

```python
#!/usr/bin/env python

###############################################################################
#
# AutoIt Obfuscator WebApi interface usage example.
#
# In this example we will verify our activation key status.
#
# Version        : v1.0
# Language       : Python
# Author         : Bartosz Wójcik
# Web page       : https://www.pelock.com
#
###############################################################################

#
# include AutoIt Obfuscator module
#
from autoitobfuscator import AutoItObfuscator

#
# if you don't want to use Python module, you can import directly from the file
#
#from pelock.autoitobfuscator import AutoItObfuscator

#
# create AutoIt Obfuscator class instance (we are using our activation key)
#
myAutoItObfuscator = AutoItObfuscator("ABCD-ABCD-ABCD-ABCD")

#
# login to the service
#
result = myAutoItObfuscator.login()

#
# result[] array holds the information about the license
#
# result["demo"]          - is it a demo mode (invalid or empty activation key was used)
# result["credits_left"]  - usage credits left after this operation
# result["credits_total"] - total number of credits for this activation code
# result["string_limit"]  - max. script size allowed (it's 1000 bytes for demo mode)
#
if result:

	print(f'Demo version status - {"True" if result["demo"] else "False"}')
	print(f'Usage credits left - {result["credits_left"]}')
	print(f'Total usage credits - {result["credits_total"]}')
	print(f'Max. script size - {result["string_limit"]}')

else:
	print("Something unexpected happen while trying to login to the service.")
```

## Use AutoIt Obfuscator Online

Online interface for the AutoIt Obfuscator is available at:

https://www.pelock.com/autoit-obfuscator/

## Windows GUI client and command line version

AutoIt Obfuscator comes also with full GUI version for Windows:

![AutoIt Obfuscator Windows Client](https://www.pelock.com/img/en/products/autoit-obfuscator/autoit-obfuscator-1-2-main.png)

Obfuscation options:

![AutoIt Obfuscator Options](https://www.pelock.com/img/en/products/autoit-obfuscator/autoit-obfuscator-1-2-options.png)

You can download it at:

https://www.pelock.com/products/autoit-obfuscator/download

Installation package contains an additional command line interface:

![AutoIt Obfuscator Windows Client](https://www.pelock.com/img/en/products/autoit-obfuscator/autoit-obfuscator-command-line-1-2.png)

It is compatible with Windows (.NET) and Linux (Mono). Command line version
can be used to integrate obfuscation into your build process or any other
batch operation.

Bartosz Wójcik
https://www.pelock.com