"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerController = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
/**
 * (experimental) Generate aws-load-balancer-controller config yaml.
 *
 * see https://github.com/kubernetes-sigs/aws-aws-load-balancer-controller/blob/master/docs/install/v2_0_0_full.yaml
 *
 * @experimental
 */
class AwsLoadBalancerController extends constructs_1.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, options) {
        var _b, _c, _d, _e, _f, _g;
        super(scope, id);
        this.serviceAccountName = (_b = options === null || options === void 0 ? void 0 : options.serviceAccountName) !== null && _b !== void 0 ? _b : 'aws-load-balancer-controller';
        this.deploymentName = 'aws-load-balancer-controller';
        this.clusterName = options.clusterName;
        this.namespace = (_c = options === null || options === void 0 ? void 0 : options.namespace) !== null && _c !== void 0 ? _c : 'kube-system';
        this.createServiceAccount = (_d = options === null || options === void 0 ? void 0 : options.createServiceAccount) !== null && _d !== void 0 ? _d : true;
        this.certManager = (_e = options === null || options === void 0 ? void 0 : options.certManager) !== null && _e !== void 0 ? _e : true;
        if (this.certManager === true) {
            new cdk8s.Include(this, 'certificate-manager', {
                url: 'https://github.com/jetstack/cert-manager/releases/download/v1.1.1/cert-manager.yaml',
            });
        }
        new cdk8s.Include(this, 'alb-crds', {
            url: path.join(__dirname, 'imports', 'crds.yaml'),
        });
        new k8s.KubeMutatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-webhook', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-v1-pod',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mpod.elbv2.k8s.aws',
                    namespaceSelector: {
                        matchExpressions: [
                            {
                                key: 'elbv2.k8s.aws/pod-readiness-gate-inject',
                                operator: 'In',
                                values: ['enabled'],
                            },
                        ],
                    },
                    rules: [{
                            apiGroups: [''],
                            apiVersions: ['v1'],
                            operations: [
                                'CREATE',
                            ],
                            resources: ['pods'],
                        }],
                    sideEffects: 'None',
                },
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/mutate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'mtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
        if (options.createServiceAccount === true) {
            new k8s.KubeServiceAccount(this, 'aws-load-balancer-controller-sa', {
                metadata: {
                    labels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            });
        }
        new k8s.KubeRole(this, 'aws-load-balancer-controller-leader-election-role', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-role',
                namespace: this.namespace,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    verbs: ['create'],
                }, {
                    apiGroups: [''],
                    resources: ['configmaps'],
                    resourceNames: ['aws-load-balancer-controller-leader'],
                    verbs: ['get', 'update', 'patch'],
                },
            ],
        });
        new cdk8s.ApiObject(this, 'leader-cluster-role', {
            apiVersion: 'rbac.authorization.k8s.io/v1',
            kind: 'ClusterRole',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: `${this.serviceAccountName}-role`,
            },
            rules: [
                {
                    apiGroups: [''],
                    resources: ['endpoints'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['events'],
                    verbs: [
                        'create',
                        'patch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['namespaces'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['nodes'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['pods/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['secrets'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: [''],
                    resources: ['services/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['ingressclassparams'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings'],
                    verbs: [
                        'create',
                        'delete',
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['elbv2.k8s.aws'],
                    resources: ['targetgroupbindings/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['extensions'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingressclasses'],
                    verbs: [
                        'get',
                        'list',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses'],
                    verbs: [
                        'get',
                        'list',
                        'patch',
                        'update',
                        'watch',
                    ],
                },
                {
                    apiGroups: ['networking.k8s.io'],
                    resources: ['ingresses/status'],
                    verbs: [
                        'patch',
                        'update',
                    ],
                },
            ],
        });
        new k8s.KubeRoleBinding(this, 'aws-load-balancer-controller-leader-election-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-leader-election-rolebinding',
                namespace: this.namespace,
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'Role',
                name: 'aws-load-balancer-controller-leader-election-role',
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    name: this.serviceAccountName,
                    namespace: this.namespace,
                },
            ],
        });
        new k8s.KubeClusterRoleBinding(this, 'aws-load-balancer-controller-rolebinding', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-controller-rolebinding',
            },
            roleRef: {
                apiGroup: 'rbac.authorization.k8s.io',
                kind: 'ClusterRole',
                name: `${this.serviceAccountName}-role`,
            },
            subjects: [
                {
                    kind: 'ServiceAccount',
                    namespace: this.namespace,
                    name: this.serviceAccountName,
                },
            ],
        });
        new k8s.KubeService(this, 'aws-load-balancer-webhook-service', {
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook-service',
                namespace: this.namespace,
            },
            spec: {
                ports: [
                    {
                        port: 443,
                        targetPort: 9443,
                    },
                ],
                selector: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                },
            },
        });
        new k8s.KubeDeployment(this, 'aws-load-balancer-controller-deployment', {
            metadata: {
                labels: {
                    'app.kubernetes.io/component': 'controller',
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                namespace: this.namespace,
                name: this.deploymentName,
            },
            spec: {
                replicas: (_f = options === null || options === void 0 ? void 0 : options.replicas) !== null && _f !== void 0 ? _f : 1,
                selector: {
                    matchLabels: {
                        'app.kubernetes.io/component': 'controller',
                        'app.kubernetes.io/name': this.serviceAccountName,
                        ...options.labels,
                    },
                },
                template: {
                    metadata: {
                        labels: {
                            'app.kubernetes.io/component': 'controller',
                            'app.kubernetes.io/name': this.serviceAccountName,
                            ...options.labels,
                        },
                    },
                    spec: {
                        containers: [{
                                name: 'controller',
                                image: (_g = options === null || options === void 0 ? void 0 : options.image) !== null && _g !== void 0 ? _g : 'amazon/aws-alb-ingress-controller:v2.2.0',
                                args: this.argsFunc(options.args),
                                env: this.envFunc(options.env),
                                livenessProbe: {
                                    failureThreshold: 2,
                                    httpGet: {
                                        path: '/healthz',
                                        port: 61779,
                                        scheme: 'HTTP',
                                    },
                                    initialDelaySeconds: 30,
                                    timeoutSeconds: 10,
                                },
                                ports: [
                                    {
                                        containerPort: 9443,
                                        name: 'webhook-server',
                                        protocol: 'TCP',
                                    },
                                ],
                                resources: {
                                    limits: {
                                        cpu: '200m',
                                        memory: '500Mi',
                                    },
                                    requests: {
                                        cpu: '100m',
                                        memory: '200Mi',
                                    },
                                },
                                securityContext: {
                                    allowPrivilegeEscalation: false,
                                    readOnlyRootFilesystem: true,
                                    runAsNonRoot: true,
                                },
                                volumeMounts: [
                                    {
                                        mountPath: '/tmp/k8s-webhook-server/serving-certs',
                                        name: 'cert',
                                        readOnly: true,
                                    },
                                ],
                            }],
                        securityContext: {
                            fsGroup: 1337,
                        },
                        serviceAccountName: `${this.serviceAccountName}`,
                        terminationGracePeriodSeconds: 10,
                        priorityClassName: 'system-cluster-critical',
                        volumes: [{
                                name: 'cert',
                                secret: {
                                    defaultMode: 420,
                                    secretName: 'aws-load-balancer-webhook-tls',
                                },
                            }],
                    },
                },
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-serving-cert', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Certificate',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-serving-cert',
                namespace: this.namespace,
            },
            spec: {
                dnsNames: [
                    'aws-load-balancer-webhook-service.kube-system.svc',
                    'aws-load-balancer-webhook-service.kube-system.svc.cluster.local',
                ],
                issuerRef: {
                    kind: 'Issuer',
                    name: 'aws-load-balancer-selfsigned-issuer',
                },
                secretName: 'aws-load-balancer-webhook-tls',
            },
        });
        new cdk8s.ApiObject(this, 'aws-load-balancer-selfsigned-issuer', {
            apiVersion: 'cert-manager.io/v1alpha2',
            kind: 'Issuer',
            metadata: {
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-selfsigned-issuer',
                namespace: this.namespace,
            },
            spec: {
                selfSigned: {},
            },
        });
        new k8s.KubeValidatingWebhookConfigurationV1Beta1(this, 'aws-load-balancer-selfsigned-issuer-valid', {
            metadata: {
                annotations: {
                    'cert-manager.io/inject-ca-from': 'kube-system/aws-load-balancer-serving-cert',
                },
                labels: {
                    'app.kubernetes.io/name': this.serviceAccountName,
                    ...options.labels,
                },
                name: 'aws-load-balancer-webhook',
            },
            webhooks: [
                {
                    clientConfig: {
                        caBundle: 'Cg==',
                        service: {
                            name: 'aws-load-balancer-webhook-service',
                            namespace: this.namespace,
                            path: '/validate-elbv2-k8s-aws-v1beta1-targetgroupbinding',
                        },
                    },
                    failurePolicy: 'Fail',
                    name: 'vtargetgroupbinding.elbv2.k8s.aws',
                    rules: [{
                            apiGroups: ['elbv2.k8s.aws'],
                            apiVersions: ['v1beta1'],
                            operations: [
                                'CREATE',
                                'UPDATE',
                            ],
                            resources: ['targetgroupbindings'],
                        }],
                    sideEffects: 'None',
                },
            ],
        });
    }
    argsFunc(args) {
        const defaultArgs = ['--ingress-class=alb', `--cluster-name=${this.clusterName}`];
        if (args) {
            args.forEach(e => defaultArgs.push(e));
        }
        return defaultArgs;
    }
    envFunc(envSet) {
        return envSet;
    }
}
exports.AwsLoadBalancerController = AwsLoadBalancerController;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerController[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerController", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,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