# String Kernels

This repo contains an implementation of the **Polynomial String Kernel** and a linear time **String Kernel** algorithm as described in our paper, [High Resolution Ancestry Deconvolution for Next Generation Genomic Data](https://www.biorxiv.org/content/10.1101/2021.09.19.460980v1). 

<img caption="String Kernel Computations" src="https://raw.githubusercontent.com/weekend37/string-kernels/master/doc/fig/triangular_numbers.png">

It offers

- Linear time computation of two effective string kernels.

- Compatibility with Scikit-Learn's Support Vector Machines (easy plug-in).

- Multithreading.

See the notebook *example.ipynb* for demonstration of easy use.

If you end up using this in your research we kindly ask you to cite us! :)
