"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultRegionalRestApiProps = exports.DefaultGlobalRestApiProps = exports.DefaultRegionalLambdaRestApiProps = exports.DefaultGlobalLambdaRestApiProps = void 0;
const api = require("@aws-cdk/aws-apigateway");
/**
 * Private function to configure an api.RestApiProps
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultRestApiProps(_endpointType, _logGroup) {
    return {
        endpointConfiguration: {
            types: _endpointType
        },
        cloudWatchRole: false,
        // Configure API Gateway Access logging
        deployOptions: {
            accessLogDestination: new api.LogGroupLogDestination(_logGroup),
            accessLogFormat: api.AccessLogFormat.jsonWithStandardFields(),
            loggingLevel: api.MethodLoggingLevel.INFO,
            dataTraceEnabled: true,
            tracingEnabled: true
        },
        defaultMethodOptions: {
            authorizationType: api.AuthorizationType.IAM
        }
    };
}
/**
 * Provides the default set of properties for Edge/Global Lambda backed RestApi
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultGlobalLambdaRestApiProps(_existingLambdaObj, _logGroup) {
    const baseProps = DefaultRestApiProps([api.EndpointType.EDGE], _logGroup);
    const extraProps = {
        handler: _existingLambdaObj,
    };
    return Object.assign(baseProps, extraProps);
}
exports.DefaultGlobalLambdaRestApiProps = DefaultGlobalLambdaRestApiProps;
/**
 * Provides the default set of properties for Regional Lambda backed RestApi
 * @param scope - the construct to which the RestApi should be attached to.
 * @param _endpointType - endpoint type for Api Gateway e.g. Regional, Global, Private
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultRegionalLambdaRestApiProps(_existingLambdaObj, _logGroup) {
    const baseProps = DefaultRestApiProps([api.EndpointType.REGIONAL], _logGroup);
    const extraProps = {
        handler: _existingLambdaObj,
    };
    return Object.assign(baseProps, extraProps);
}
exports.DefaultRegionalLambdaRestApiProps = DefaultRegionalLambdaRestApiProps;
/**
 * Provides the default set of properties for Edge/Global RestApi
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultGlobalRestApiProps(_logGroup) {
    return DefaultRestApiProps([api.EndpointType.EDGE], _logGroup);
}
exports.DefaultGlobalRestApiProps = DefaultGlobalRestApiProps;
/**
 * Provides the default set of properties for Regional RestApi
 * @param _logGroup - CW Log group for Api Gateway access logging
 */
function DefaultRegionalRestApiProps(_logGroup) {
    return DefaultRestApiProps([api.EndpointType.REGIONAL], _logGroup);
}
exports.DefaultRegionalRestApiProps = DefaultRegionalRestApiProps;
//# sourceMappingURL=data:application/json;base64,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