"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultLogGroupProps = void 0;
const logs = require("@aws-cdk/aws-logs");
function DefaultLogGroupProps(_logGroupName = '') {
    if (_logGroupName !== '') {
        return {
            logGroupName: _logGroupName,
            retention: logs.RetentionDays.INFINITE
        };
    }
    else {
        return {
            retention: logs.RetentionDays.INFINITE
        };
    }
}
exports.DefaultLogGroupProps = DefaultLogGroupProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWR3YXRjaC1sb2ctZ3JvdXAtZGVmYXVsdHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZHdhdGNoLWxvZy1ncm91cC1kZWZhdWx0cy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7Ozs7Ozs7O0dBV0c7OztBQUVILDBDQUEwQztBQUUxQyxTQUFnQixvQkFBb0IsQ0FBQyxnQkFBd0IsRUFBRTtJQUM3RCxJQUFJLGFBQWEsS0FBSyxFQUFFLEVBQUU7UUFDeEIsT0FBTztZQUNMLFlBQVksRUFBRSxhQUFhO1lBQzNCLFNBQVMsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVE7U0FDakIsQ0FBQztLQUN6QjtTQUFNO1FBQ0wsT0FBTztZQUNMLFNBQVMsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVE7U0FDakIsQ0FBQztLQUN6QjtBQUNILENBQUM7QUFYRCxvREFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCAyMDIwIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5cbmV4cG9ydCBmdW5jdGlvbiBEZWZhdWx0TG9nR3JvdXBQcm9wcyhfbG9nR3JvdXBOYW1lOiBzdHJpbmcgPSAnJyk6IGxvZ3MuTG9nR3JvdXBQcm9wcyB7XG4gIGlmIChfbG9nR3JvdXBOYW1lICE9PSAnJykge1xuICAgIHJldHVybiB7XG4gICAgICBsb2dHcm91cE5hbWU6IF9sb2dHcm91cE5hbWUsXG4gICAgICByZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5JTkZJTklURVxuICAgIH0gYXMgbG9ncy5Mb2dHcm91cFByb3BzO1xuICB9IGVsc2Uge1xuICAgIHJldHVybiB7XG4gICAgICByZXRlbnRpb246IGxvZ3MuUmV0ZW50aW9uRGF5cy5JTkZJTklURVxuICAgIH0gYXMgbG9ncy5Mb2dHcm91cFByb3BzO1xuICB9XG59XG4iXX0=