"use strict";
/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildEncryptionKey = void 0;
const kms = require("@aws-cdk/aws-kms");
const kms_defaults_1 = require("./kms-defaults");
const utils_1 = require("./utils");
function buildEncryptionKey(scope, keyProps) {
    // Setup the key properties
    let encryptionKeyProps;
    if (keyProps) {
        // If property overrides have been provided, incorporate them and deploy
        encryptionKeyProps = utils_1.overrideProps(kms_defaults_1.DefaultEncryptionProps, keyProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        encryptionKeyProps = kms_defaults_1.DefaultEncryptionProps;
    }
    // Create the encryption key and return
    return new kms.Key(scope, 'EncryptionKey', encryptionKeyProps);
}
exports.buildEncryptionKey = buildEncryptionKey;
//# sourceMappingURL=data:application/json;base64,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