/**
 *  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as sagemaker from "@aws-cdk/aws-sagemaker";
import * as ec2 from "@aws-cdk/aws-ec2";
import * as cdk from "@aws-cdk/core";
import * as iam from '@aws-cdk/aws-iam';
export interface BuildSagemakerNotebookProps {
    /**
     * Optional user provided props for CfnNotebookInstanceProps.
     *
     * @default - Default props are used
     */
    readonly sagemakerNotebookProps?: sagemaker.CfnNotebookInstanceProps | any;
    /**
     * Optional user provided props to deploy inside vpc.
     *
     * @default - true
     */
    readonly deployInsideVpc?: boolean;
    /**
     * An optional, Existing instance of notebook object.
     *
     * If this is set then the sagemakerNotebookProps is ignored
     *
     * @default - None
     */
    readonly existingNotebookObj?: sagemaker.CfnNotebookInstance;
    /**
     * IAM Role Arn for SageMaker NoteBookInstance.
     *
     * @default - None
     */
    readonly role: iam.Role;
}
export declare function buildSagemakerNotebook(scope: cdk.Construct, props: BuildSagemakerNotebookProps): [sagemaker.CfnNotebookInstance, ec2.IVpc?, ec2.SecurityGroup?];
