# Contributing guidelines

### Contributing A Patch

1. Submit an issue describing your proposed change to the repo in question.
2. If your proposed change is accepted you can fork, develop and test your code changes.
3. If it's possible add unit-tests and e2e tests. Please check your code style by running
   ```
   flake8 kubernetes_asyncio/
   isort --diff kubernetes_asyncio/
   ```
4. Submit a pull request.

### Parts Generated By OpenAPI Generator ###

There are lot of files wich are generated by [OpenAPI Generator](https://github.com/OpenAPITools/openapi-generator) based on [Kubernetes API OpenAPI Spec](
https://github.com/kubernetes/kubernetes/tree/master/api/openapi-spec). You can determine generated files by reading a preamble of file, there is a notice that the file is auto-generated. If you need to change such file you will probably need to update the generator or the spec first. If it's not possible in your case you can create "patch" to apply in the generating script (scripts/update-client.sh).

### Adding Dependencies

If your patch depends on new packages, add those packages to [requirements.txt](requirements.txt) and [setup.py](setup.py).

### Rebuild Client

This client is built (as other Kubernetes clients) by scripts from [kubernetes-client/gen](https://github.com/kubernetes-client/gen).
These scripts prepare a docker image with preinstalled tools (eg. openapi-generator).
It's time consuming but finally this image is cached on your local machine and next regenerations will work smoothly.

To simplify set up the environment here is a script named `scripts/update-client.sh` which clones
[kubernetes-client/gen](https://github.com/kubernetes-client/gen) and launches regenerating process.
